## 禁用


### 渲染禁用

```
xmSelect.render({
	//...
	disabled: true
})
```

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	disabled: true,
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2},
		{name: '王五', value: 3, disabled: true},
	]
})
</script>
```
:::


### 动态启用禁用

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>
<button class="btn" id="demo21">禁用</button>
<button class="btn" id="demo22">启用</button>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2},
		{name: '王五', value: 3, disabled: true},
	]
})

document.getElementById('demo21').onclick = function(){
	demo2.update({ disabled: true });
}
document.getElementById('demo22').onclick = function(){
	demo2.update({ disabled: false });
}
</script>
```
:::


### 选完`张三`后禁用

:::demo 
```html
<div id="demo3" class="xm-select-demo"></div>
<button class="btn" id="demo3-disabled">启用</button>

<script>
var demo3 = xmSelect.render({
	el: '#demo3', 
	data: [
		{name: '张三', value: 1},
		{name: '李四', value: 2},
		{name: '王五', value: 3},
	],
	on({ arr, change, isAdd }){
		var hasZS = change.find(item => item.name === '张三');
		if(isAdd && hasZS){
			demo3.update({ disabled: true });
		}
	}
})

//没有做不到, 只有想不到, 把多选玩出花来吧
document.getElementById('demo3-disabled').onclick = function(){
	demo3.update({ disabled: false });
}
</script>
```
:::
