## 创建条目


### 搜索不存在则创建条目

```
//想创建就必须要开启本地搜索
xmSelect.render({
	//...
	filterable: true,
	create: function(val, arr){
		//返回一个创建成功的对象, val是搜索的数据, arr是搜索后的当前页面数据
		return {
			name: '创建-' + val,
			value: val
		}
	}
})
```

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	filterable: true,
	create: function(val, arr){
		if(arr.length === 0){
			return {
				name: '创建-' + val,
				value: val
			}
		}
	},
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2},
		{name: '王五', value: 3, disabled: true},
	]
})
</script>
```
:::


### 单选创建

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo2', 
	radio: true,
	clickClose: true,
	filterable: true,
	create: function(val, arr){
		if(arr.length === 0){
			return {
				name: '创建-' + val,
				value: val
			}
		}
	},
	model: {
		icon: 'hidden',
		label: {
			type: 'text',
		}
	},
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2},
		{name: '王五', value: 3},
	]
})
</script>
```
:::
