## 赋值与取值


### 给多选赋值

函数`setValue(array)`, 动态赋值多选选中的数据, array可以是value数组, 也可以是完整的object数组

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>
<br/><br/>
<button class="btn" id="demo1-test1">赋值张三</button>
<button class="btn" id="demo1-test2">赋值张三(value方式)</button>
<button class="btn" id="demo1-test3">追加赋值李四</button>
<br/><br/>
<button class="btn" id="demo1-test4">清除李四</button>
<button class="btn" id="demo1-test5">清空</button>
<pre id="demo1-result"></pre>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	data: [
		{name: '张三', value: 1},
		{name: '李四', value: 2},
		{name: '王五', value: 3},
	]
})

document.getElementById('demo1-test1').onclick = function(){
	demo1.setValue([
		{name: '张三', value: 1},
	])
};

document.getElementById('demo1-test2').onclick = function(){
	demo1.setValue([ 1 ])
};

document.getElementById('demo1-test3').onclick = function(){
	demo1.append([ 2 ]);
};

document.getElementById('demo1-test4').onclick = function(){
	demo1.delete([ 2 ])
};

document.getElementById('demo1-test5').onclick = function(){
	demo1.setValue([ ])
};

</script>
```
:::


### 取值

函数`getValue(type)`, type类型 name, nameStr, value, valueStr

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>
<button class="btn" id="demo2-getValue">获取选中值</button>

<br/><br/>

<button class="btn" id="name">获取name数组</button>
<button class="btn" id="nameStr">获取name字符串</button>
<button class="btn" id="value">获取value数组</button>
<button class="btn" id="valueStr">获取value字符串</button>

<pre id="demo2-value"></pre>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	data: [
		{name: '张三', value: 1},
		{name: '李四', value: 2},
		{name: '王五', value: 3},
	]
})

document.getElementById('demo2-getValue').onclick = function(){
	//获取当前多选选中的值
	var selectArr = demo2.getValue();
	document.getElementById('demo2-value').innerHTML = `\ndemo2.getValue()\n\n` + JSON.stringify(selectArr, null, 2);
}

var types = ['name', 'nameStr', 'value', 'valueStr'];
types.forEach(function(type){
	document.getElementById(type).onclick = function(){
		//获取当前多选选中的值
		var selectArr = demo2.getValue(type);
		document.getElementById('demo2-value').innerHTML = `\ndemo2.getValue('${type}')\n\n` + JSON.stringify(selectArr, null, 2);
	}
});


</script>

```
:::
