## 分页

### 启用分页

```
xmSelect.render({
	//...
	paging: true,
})
```

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	paging: true,
	data: [
		{name: '张三', value: 1},
		{name: '李四', value: 2},
		{name: '王五', value: 3},
		{name: '赵六', value: 4},
		{name: '苹果', value: 5},
		{name: '香蕉', value: 6},
		{name: '凤梨', value: 7},
		{name: '葡萄', value: 8},
		{name: '樱桃', value: 9},
		{name: '车厘子', value: 10},
		{name: '火龙果', value: 11},
	]
})
</script>
```
:::


### 自定义条数

每页3条

```
xmSelect.render({
	//...
	paging: true,
	pageSize: 3,
})
```

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	paging: true,
	pageSize: 3,
	data: [
		{name: '张三', value: 1},
		{name: '李四', value: 2},
		{name: '王五', value: 3},
		{name: '赵六', value: 4},
		{name: '苹果', value: 5},
		{name: '香蕉', value: 6},
		{name: '凤梨', value: 7},
		{name: '葡萄', value: 8},
		{name: '樱桃', value: 9},
		{name: '车厘子', value: 10},
		{name: '火龙果', value: 11},
	]
})
</script>
```
:::


### 搜索+分页

```
xmSelect.render({
	//...
	paging: true,
	pageSize: 5,
	filterable: true,
})
```

:::demo 
```html
<div id="demo3" class="xm-select-demo"></div>
<button class="btn" id="demo3-5">每页5条</button>
<button class="btn" id="demo3-10">每页10条</button>
<button class="btn" id="demo3-20">每页20条</button>

<script>
var data = [];
for(var i = 0 ; i < 100 ; i++ ){
	data.push({
		name: '测试数据' + i,
		value: i,
	})
}

var demo3 = xmSelect.render({
	el: '#demo3', 
	paging: true,
	pageSize: 5,
	filterable: true,
	data
})

document.getElementById('demo3-5').onclick = function(){
	demo3.update({
		pageSize: 5
	})
}

document.getElementById('demo3-10').onclick = function(){
	demo3.update({
		pageSize: 10
	})
}

document.getElementById('demo3-20').onclick = function(){
	demo3.update({
		pageSize: 20
	})
}

</script>
```
:::


### 搜索 + 分页 无数据 不展示分页

```
xmSelect.render({
	//...
	paging: true,
	pageSize: 3,
	filterable: true,
	pageEmptyShow: false,
})
```

:::demo 
```html
<div id="demo4" class="xm-select-demo"></div>

<script>
var demo4 = xmSelect.render({
	el: '#demo4', 
	paging: true,
	pageSize: 3,
	filterable: true,
	pageEmptyShow: false,
	data: [
		{name: '张三', value: 1},
		{name: '李四', value: 2},
		{name: '王五', value: 3},
		{name: '赵六', value: 4},
		{name: '苹果', value: 5},
		{name: '香蕉', value: 6},
		{name: '凤梨', value: 7},
		{name: '葡萄', value: 8},
		{name: '樱桃', value: 9},
		{name: '车厘子', value: 10},
		{name: '火龙果', value: 11},
	]
})
</script>
```
:::


###  远程分页

```
xmSelect.render({
    //...
	//开启分页
    paging: true,
	//远程分页
    pageRemote: true,
	//实现方法
    remoteMethod: function(val, cb, show, pageIndex),
})
```

:::demo `render`后, 就会进行一次回调, 用于渲染第一次数据
```html
<div id="demo5" class="xm-select-demo"></div>

<script>
var demo5 = xmSelect.render({
	el: '#demo5', 
	paging: true,
	pageRemote: true,
	remoteMethod: function(val, cb, show, pageIndex){
		//val: 搜索框的内容, 不开启搜索默认为空, cb: 回调函数, show: 当前下拉框是否展开, pageIndex: 当前第几页
		
		//这里的axios类似于ajax
		axios({
			method: 'get',
			url: 'https://www.fastmock.site/mock/98228b1f16b7e5112d6c0c87921eabc1/xmSelect/search',
			params: {
				keyword: val + '_' + pageIndex,
			}
		}).then(response => {
			//这里是success的处理
			var res = response.data;
			//回调需要两个参数, 第一个: 数据数组, 第二个: 总页码
			cb(res.data, 10)
		}).catch(err => {
			//这里是error的处理
			cb([], 0);
		});
	}
})
</script>
```
:::


###  搜索 + 远程分页

```
xmSelect.render({
    //...
	//开启分页
    paging: true,
	//远程分页
    pageRemote: true,
	//实现方法
    remoteMethod: function(val, cb, show, pageIndex),
})
```

:::demo `render`后, 就会进行一次回调, 用于渲染第一次数据
```html
<div id="demo6" class="xm-select-demo"></div>

<script>
var demo6 = xmSelect.render({
	el: '#demo6', 
	//配置搜索
	filterable: true,
	//配置远程分页
	paging: true,
	pageRemote: true,
	//数据处理
	remoteMethod: function(val, cb, show, pageIndex){
		//val: 搜索框的内容, 不开启搜索默认为空, cb: 回调函数, show: 当前下拉框是否展开, pageIndex: 当前第几页
		
		//这里的axios类似于ajax
		axios({
			method: 'get',
			url: 'https://www.fastmock.site/mock/98228b1f16b7e5112d6c0c87921eabc1/xmSelect/search',
			params: {
				keyword: val + '_' + pageIndex,
			}
		}).then(response => {
			//这里是success的处理
			var res = response.data;
			//回调需要两个参数, 第一个: 数据数组, 第二个: 总页码
			cb(res.data, 10)
		}).catch(err => {
			//这里是error的处理
			cb([], 0);
		});
	}
})
</script>
```
:::
