## 动态数据


### 本地数据动态赋值

:::demo 
```html
<div id="demo1" class="xm-select-demo"></div>

<script>
var demo1 = xmSelect.render({
	el: '#demo1', 
	data: []
})

demo1.update({
	data: [
		{name: '张三', value: 1, selected: true},
		{name: '李四', value: 2, selected: true},
		{name: '王五', value: 3, disabled: true},
	]
})

</script>
```
:::


### 远程数据动态赋值

:::demo 
```html
<div id="demo2" class="xm-select-demo"></div>

<script>
var demo2 = xmSelect.render({
	el: '#demo2', 
	toolbar: {show: true},
	data: []
})

axios({
	method: 'get',
	url: 'https://www.fastmock.site/mock/98228b1f16b7e5112d6c0c87921eabc1/xmSelect/search',
}).then(response => {
	var res = response.data;
	
	demo2.update({
		data: res.data,
		autoRow: true,
	})
});

</script>
```
:::


### 动态创建xm-select多选

:::demo 
```html
<table id="form-create" class="layui-table">
	<thead>
		<tr>
			<th style="width: 50px;">序号</th>
			<th>性别</th>
			<th>爱好</th>
			<th style="width: 150px;">操作</th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<td colspan="3">
				<span>这里呢, 演示一下动态添加多选的例子</span>
			</td>
			<td colspan="1">
				<div class="layui-btn-group">
					<button type="button" class="layui-btn add">增加</button>
				</div>
			</td>
		</tr>
	</tbody>
</table>

<script>
var $ = layui.jquery;
var index = 1;
				
$('.add').on('click', function(){
	var element = $([
		'<tr>',
			'<td>'+ index +'</td>',
			'<td class="gender"></td>',
			'<td class="hobby"></td>',
			'<td class="handler">',
				'<button type="button" class="layui-btn layui-btn-normal get">取值</button>',
				'<button type="button" class="layui-btn layui-btn-danger del">删除</button>',
			'</td>',
		'</tr>',
	].join(''))
	
	var hobby = element.find('.hobby')[0];
	var hobbySelect = xmSelect.render({
		el: hobby,
		data: function(){
			return [
				{name: '篮球' + index, value: 1},
				{name: '足球' + index, value: 2},
				{name: '乒乓球' + index, value: 3},
			]
		}
	})
	
	var gender = element.find('.gender')[0];
	xmSelect.render({
		el: gender,
		radio: true,
		clickClose: true,
		model: { label: { type: 'text' } },
		data: function(){
			return [
				{name: '男', value: 1},
				{name: '女', value: 2},
				{name: '保密', value: 3},
			]
		},
		on: function(data){
			var changeItem = data.change[0];
			if(data.isAdd && changeItem.value == 3){
				this.update({ disabled: true })
			}else{
				this.update({ disabled: false })
			}
		}.bind(hobbySelect),
	})
	
	element.find('.get').on('click', function(){
		alert('valueStr: ' + this.getValue('valueStr'));
	}.bind(hobbySelect))
	
	element.find('.del').on('click', function(){
		$(this).parents('tr').remove();
	})
	
	index++;
	
	$('#form-create tbody').append(element)
});
</script>
```
:::
