## 下拉折叠面板

### layui折叠面板

```
//css调整部分
xm-select .scroll-body{
	margin-top: -5px;
}
xm-select .xm-body{
	padding: 0;
	border: none;
	background-color: usnet;
	box-shadow: none;
}
```

:::demo 
```html

<div id="demo1" style="width: 500px;"></div>

<script>

var list = [
	{ name: '杜甫', selected: true, content: '杜甫的思想核心是儒家的仁政思想，他有“致君尧舜上，再使风俗淳”的宏伟抱负。杜甫虽然在世时名声并不显赫，但后来声名远播，对中国文学和日本文学都产生了深远的影响。杜甫共有约1500首诗歌被保留了下来，大多集于《杜工部集》。' },
	{ name: '李清照', content: '李清照出生于书香门第，早期生活优裕，其父李格非藏书甚富，她小时候就在良好的家庭环境中打下文学基础。出嫁后与夫赵明诚共同致力于书画金石的搜集整理。金兵入据中原时，流寓南方，境遇孤苦。所作词，前期多写其悠闲生活，后期多悲叹身世，情调感伤。形式上善用白描手法，自辟途径，语言清丽。' },
	{ name: '鲁迅', content: '鲁迅一生在文学创作、文学批评、思想研究、文学史研究、翻译、美术理论引进、基础科学介绍和古籍校勘与研究等多个领域具有重大贡献。他对于五四运动以后的中国社会思想文化发展具有重大影响，蜚声世界文坛，尤其在韩国、日本思想文化领域有极其重要的地位和影响，被誉为“二十世纪东亚文化地图上占最大领土的作家”。' },
]

var html = list.map(function(item){
	return `
		<div class="layui-colla-item">
			<h2 class="layui-colla-title" value="${item.name}">${ item.name }</h2>
			<div class="layui-colla-content ${ item.selected && 'layui-show' }">${ item.content }</div>
		</div>
	`
}).join('');

var demo1 = xmSelect.render({
	el: '#demo1', 
	content: `
		<div class="layui-collapse" lay-filter="collapse">
			${ html }
		</div>
	`,
	height: 'auto',
	autoRow: true,
	data: list,
	prop: { value: 'name' },
	on: function(data){
		if(!data.isAdd){
			var item = data.change[0];
			document.querySelector(`#demo1 .layui-collapse .layui-colla-title[value="${item.name}"]`).nextElementSibling.classList.remove('layui-show')
		}
	}
})

layui.element.init()

layui.element.on('collapse(collapse)', function(data){
	let value = data.title.attr('value');
	if(data.show){
		demo1.append([ value ])
	}else{
		demo1.delete([ value ])
	}
});

//这里仅仅提供一个演示, 更多的想法由你自己来创造

</script>
```
:::
