<?php
namespace addons\purchase_rebate\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function setting()
    {
        $configurationsModel = \Think\Db::name("purchase_rebate_setting");
        $configData = $configurationsModel->find();
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/setting");
    }
    public function submit()
    {
        $data = $this->request->post();
        $apiid = isset($data["apiid"]) ? $data["apiid"] : NULL;
        $apikey = isset($data["apikey"]) ? $data["apikey"] : NULL;
        $open = isset($data["open"]) ? $data["open"] : NULL;
        $agent = isset($data["agent"]) ? $data["agent"] : NULL;
        $webmasteremail = isset($data["webmasteremail"]) ? $data["webmasteremail"] : NULL;
        $webmasterqq = isset($data["webmasterqq"]) ? $data["webmasterqq"] : NULL;
        $authorize = isset($data["authorize"]) ? $data["authorize"] : NULL;
        $sitename = isset($data["sitename"]) ? $data["sitename"] : NULL;
        $dbConfig = ["apiid" => $apiid, "apikey" => $apikey, "open" => $open, "agent" => $agent, "sitename" => $sitename, "authorize" => $authorize, "webmasteremail" => $webmasteremail, "webmasterqq" => $webmasterqq, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \Think\Db::name("purchase_rebate_setting")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("purchase_rebate_setting")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("purchase_rebate_setting")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function index()
    {
        $products = \Think\Db::name("products")->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        $filteredProducts = [];
        foreach ($products as $key => $product) {
            $fanProducts = \Think\Db::name("purchase_rebate_rules")->where("productid", $product["id"])->find();
            $name = \Think\Db::name("products")->where("id", $product["id"])->find();
            $name1 = \Think\Db::name("products")->where(["id" => $product["id"], "api_type" => "zjmf_api"])->find();
            $zjmf_finance_api = \Think\Db::name("zjmf_finance_api")->where(["id" => $name1["server_group"]])->find();
            if (!$fanProducts) {
                $product["api_name"] = $zjmf_finance_api["name"];
                $product["hidden"] = $name["hidden"];
                $filteredProducts[] = $product;
            }
        }
        $this->assign("keproducts", $filteredProducts);
        $this->assign("Title", "添加产品");
        return $this->fetch("/index");
    }
    public function addsubmit()
    {
        $data = $this->request->post();
        $way = isset($data["way"]) ? $data["way"] : NULL;
        $renew = isset($data["renew"]) ? $data["renew"] : NULL;
        $productid = isset($data["selected_product"]) ? $data["selected_product"] : NULL;
        $type = isset($data["type"]) ? $data["type"] : NULL;
        $proportion = isset($data["proportion"]) ? $data["proportion"] : NULL;
        $start_time = isset($data["start_time"]) ? strtotime($data["start_time"]) : NULL;
        $end_time = isset($data["end_time"]) ? strtotime($data["end_time"]) : NULL;
        $productresult = \Think\Db::name("purchase_rebate_rules")->where(["productid" => $productid])->find();
        if ($productresult) {
            $response = ["code" => 400, "msg" => "选择产品已存在列表中，请重新选取"];
            return json($response);
        }
        if (empty($proportion)) {
            $response = ["code" => 400, "msg" => "优惠比例未设置"];
            return json($response);
        }
        if (empty($start_time) || empty($end_time)) {
            $response = ["code" => 400, "msg" => "活动开始时间或结束时间未设置"];
            return json($response);
        }
        if ($end_time < $start_time) {
            $response = ["code" => 400, "msg" => "活动开始时间不能晚于结束时间"];
            return json($response);
        }
        if (!empty($end_time) && $end_time < time()) {
            $response = ["code" => 400, "msg" => "活动结束时间不能早于当前时间"];
            return json($response);
        }
        $dbData = ["way" => $way, "renew" => $renew, "productid" => $productid, "type" => $type, "number" => $proportion, "start_time" => $start_time, "end_time" => $end_time];
        $dbData = array_filter($dbData, function ($value) {
            return $value !== NULL;
        });
        $result = \Think\Db::name("purchase_rebate_rules")->insert($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "活动配置添加成功。"];
        } else {
            $response = ["code" => 400, "msg" => "活动配置添加失败。"];
        }
        return json($response);
    }
    public function activitylist()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $lists = \Think\Db::name("purchase_rebate_rules")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $resultWithNames = [];
        foreach ($lists as $record) {
            $productid = $record["productid"];
            $hostid = $record["id"];
            $name = \Think\Db::name("products")->where("id", $productid)->find();
            $name1 = \Think\Db::name("products")->where(["id" => $productid, "api_type" => "zjmf_api"])->find();
            $zjmf_finance_api = \Think\Db::name("zjmf_finance_api")->where(["id" => $name1["server_group"]])->find();
            if ($name !== NULL) {
                $record["name"] = $name["name"];
                $record["hosttype"] = $name["type"];
                $record["hidden"] = $name["hidden"];
                $record["api_name"] = $zjmf_finance_api["name"];
                $resultWithNames[] = $record;
            }
        }
        $this->assign("Title", "活动列表");
        $this->assign("fen", $lists);
        return $this->fetch("/activitylist", ["data" => $resultWithNames]);
    }
    public function xiu()
    {
        $id = input("get.id");
        $configurationsModel = \Think\Db::name("purchase_rebate_rules");
        $configData = $configurationsModel->where("id", $id)->find();
        $productid = $configData["productid"];
        $products = \Think\Db::name("products")->where("p.id", $productid)->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        $this->assign("products", $products);
        $this->assign("Data", $configData);
        $this->assign("Title", "修改活动");
        return $this->fetch("/xiu");
    }
    public function xiusubmit()
    {
        $data = $this->request->post();
        $activityid = isset($data["id"]) ? $data["id"] : NULL;
        $productid = isset($data["selected_product"]) ? $data["selected_product"] : NULL;
        $way = isset($data["way"]) ? $data["way"] : NULL;
        $renew = isset($data["renew"]) ? $data["renew"] : NULL;
        $type = isset($data["type"]) ? $data["type"] : NULL;
        $proportion = isset($data["proportion"]) ? $data["proportion"] : NULL;
        $start_time = isset($data["start_time"]) ? strtotime($data["start_time"]) : NULL;
        $end_time = isset($data["end_time"]) ? strtotime($data["end_time"]) : NULL;
        $productresult = \Think\Db::name("purchase_rebate_rules")->where(["productid" => $productid])->find();
        if (empty($activityid)) {
            $response = ["code" => 400, "msg" => "当前活动不存在"];
            return json($response);
        }
        if (empty($proportion)) {
            $response = ["code" => 400, "msg" => "优惠面值未设置"];
            return json($response);
        }
        if (empty($start_time) || empty($end_time)) {
            $response = ["code" => 400, "msg" => "活动开始时间或结束时间未设置"];
            return json($response);
        }
        if ($end_time < $start_time) {
            $response = ["code" => 400, "msg" => "修改开始时间不能晚于结束时间"];
            return json($response);
        }
        if (!empty($end_time) && $end_time < time()) {
            $response = ["code" => 400, "msg" => "结束时间不能早于当前时间"];
            return json($response);
        }
        $dbData = ["way" => $way, "renew" => $renew, "productid" => $productid, "type" => $type, "number" => $proportion, "start_time" => $start_time, "end_time" => $end_time];
        $result = \Think\Db::name("purchase_rebate_rules")->where("id", $activityid)->update($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "活动配置修改成功。"];
        } else {
            $response = ["code" => 400, "msg" => "配置没有变化，修改失败。"];
        }
        return json($response);
    }
    public function records()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $records = \Think\Db::name("purchase_rebate_records")->alias("prr")->field("prr.*, i.status as invoice_status")->join("invoices i", "prr.recharge_id = i.id", "LEFT")->order("prr.id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("domain", $domain);
        $this->assign("data", $records);
        $this->assign("Title", "活动记录");
        return $this->fetch("/records");
    }
    public function deletelists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $result = \Think\Db::name("purchase_rebate_rules")->where("id", $id)->delete();
            if ($result !== false) {
                return json(["code" => 200, "msg" => "活动删除成功"]);
            }
            return json(["code" => 500, "msg" => "活动删除失败"]);
        }
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>