<?php
namespace addons\purchase_rebate;

class PurchaseRebatePlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "PurchaseRebate", "title" => "购买返利优惠", "description" => "购买返利适用于魔方财务，可设置指定商品活动时间内进行购买，可获得返现或立减，支持按百分比，固定金额返现或立减类型", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.0", "module" => "addons", "lang" => ["chinese" => "购买返利优惠", "chinese_tw" => "新購返利優惠", "english" => "Purchase Rebate"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "apiid", "type" => "varchar(500)"], ["name" => "apikey", "type" => "varchar(500)"], ["name" => "open", "type" => "varchar(500)"], ["name" => "agent", "type" => "varchar(500)"], ["name" => "weburl", "type" => "varchar(500)"], ["name" => "sitename", "type" => "varchar(500)"], ["name" => "authorize", "type" => "varchar(500)"], ["name" => "webmasteremail", "type" => "varchar(500)"], ["name" => "webmasterqq", "type" => "varchar(500)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "user_id", "type" => "VARCHAR(255)"], ["name" => "productid", "type" => "VARCHAR(255)"], ["name" => "hostid", "type" => "VARCHAR(255)"], ["name" => "amount", "type" => "DECIMAL(10, 2)"], ["name" => "type", "type" => "VARCHAR(255)"], ["name" => "bonus_type", "type" => "ENUM('fixed', 'percent')"], ["name" => "bonus", "type" => "VARCHAR(255)"], ["name" => "bonus_amount", "type" => "DECIMAL(10, 2)"], ["name" => "recharge_id", "type" => "VARCHAR(255)"], ["name" => "invoice_num", "type" => "VARCHAR(255)"], ["name" => "start_time", "type" => "VARCHAR(255)"], ["name" => "end_time", "type" => "VARCHAR(255)"], ["name" => "pay_time", "type" => "VARCHAR(255)"]];
        $fieldsToAddTable3 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "way", "type" => "VARCHAR(255)"], ["name" => "productid", "type" => "VARCHAR(255)"], ["name" => "renew", "type" => "VARCHAR(255)"], ["name" => "type", "type" => "ENUM('fixed', 'percent')"], ["name" => "number", "type" => "DECIMAL(10, 2)"], ["name" => "start_time", "type" => "VARCHAR(255)"], ["name" => "end_time", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $tableName1 = "shd_purchase_rebate_setting";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_purchase_rebate_records";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n                    CREATE TABLE " . $tableName2 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n                    );\n                ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                            ALTER TABLE " . $tableName2 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        $tableName3 = "shd_purchase_rebate_rules";
        $tableExists3 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName3 . "'");
        if (empty($tableExists3)) {
            $sql3 = "\n                    CREATE TABLE " . $tableName3 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable3)) . "\n                    );\n                ";
            \Think\Db::execute($sql3);
        } else {
            foreach ($fieldsToAddTable3 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName3 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql3 = "\n                            ALTER TABLE " . $tableName3 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql3);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function invoicePaid($params)
    {
        $client_ip = get_client_ip();
        $invoiceid = $params["invoiceid"];
        if (!empty($invoiceid)) {
            $orderid = \Think\Db::name("orders")->where("invoiceid", $invoiceid)->value("id");
            $config = \Think\Db::name("purchase_rebate_setting")->where("id", 1)->find();
            $Info = \Think\Db::name("invoices")->where("id", $invoiceid)->find();
            $groupid = \Think\Db::name("clients")->where("id", $Info["uid"])->value("groupid");
            $group_name = \Think\Db::name("client_groups")->where("id", $groupid)->value("group_name");
            $products = \Think\Db::name("host")->where("orderid", $orderid)->field("id, productid, firstpaymentamount, uid")->select();
            if ($config["open"] == 1 && $Info["type"] == "product") {
                foreach ($products as $product) {
                    $rebateRule = \Think\Db::name("purchase_rebate_rules")->where("productid", $product["productid"])->find();
                    $productname = \Think\Db::name("products")->where("id", $product["productid"])->find();
                    if ($rebateRule && $rebateRule && $rebateRule["start_time"] <= time() && time() <= $rebateRule["end_time"]) {
                        if ($rebateRule["way"] === "1") {
                            if ($config["agent"] == 1) {
                                if ($groupid == 0) {
                                    $amount = $product["firstpaymentamount"];
                                    if ($rebateRule["type"] == "percent") {
                                        $cashback_amount = $amount * $rebateRule["number"] / 100;
                                        $cashback_amount = number_format($cashback_amount, 2, ".", "");
                                    } else {
                                        $cashback_amount = $rebateRule["number"];
                                    }
                                    if ($rebateRule["type"] === "percent") {
                                        $bonus_type_text = "百分比";
                                    } else {
                                        $bonus_type_text = "固定金额";
                                    }
                                    if ($rebateRule["type"] === "percent") {
                                        $bonus_amounts = $cashback_amount . "元";
                                    } else {
                                        $bonus_amounts = number_format($cashback_amount, 2, ".", "") . "元";
                                    }
                                    if (0 < $bonus_amounts) {
                                        $pay_time = date("Y-m-d H:i:s", time());
                                        $user_id = $product["uid"];
                                        $clients = \Think\Db::name("clients")->where("id", $user_id)->find();
                                        $credit = $clients["credit"];
                                        $newcredit = $cashback_amount + $credit;
                                        $upnewcredit = \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                                        $data = ["uid" => $user_id, "create_time" => time(), "description" => "" . $clients["username"] . "【UID:" . $user_id . "】在【" . $pay_time . "】新购产品支付" . $amount . "元（商品：" . $productname["name"] . "--主机ID：" . $product["id"] . "），账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $rebateRule["start_time"]) . "至" . date("Y-m-d H:i:s", $rebateRule["end_time"]) . "，按" . $bonus_type_text . "返现" . $bonus_amounts . "", "amount" => $cashback_amount, "balance" => $newcredit];
                                        \Think\Db::name("credit")->insert($data);
                                        $datainvoices = ["uid" => $user_id, "create_time" => time(), "due_time" => time(), "paid_time" => time(), "update_time" => time(), "subtotal" => $cashback_amount, "total" => $cashback_amount, "payment" => "UserCustom", "status" => "Paid", "type" => "recharge"];
                                        \Think\Db::name("invoices")->insert($datainvoices);
                                        $insertedId = \Think\Db::name("invoices")->getLastInsID();
                                        $datainvoice_items = ["invoice_id" => $insertedId, "uid" => $user_id, "type" => "recharge", "due_time" => time(), "description" => "" . $clients["username"] . "【UID:" . $user_id . "】在【" . $pay_time . "】新购产品支付" . $amount . "元（商品：" . $productname["name"] . "--主机ID：" . $product["id"] . "），账单号：" . $invoiceid . "，按" . $bonus_type_text . "返现" . $bonus_amounts . "", "amount" => $cashback_amount];
                                        \Think\Db::name("invoice_items")->insert($datainvoice_items);
                                        $activity_log = ["uid" => $user_id, "description" => "【新购产品返现活动】" . $clients["username"] . "【UID:" . $user_id . "】在【" . $pay_time . "】新购产品支付" . $amount . "元（商品：" . $productname["name"] . "--主机ID：" . $product["id"] . "），账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $rebateRule["start_time"]) . "至" . date("Y-m-d H:i:s", $rebateRule["end_time"]) . "，按" . $bonus_type_text . "返现" . $bonus_amounts . "", "user" => "System", "port" => "", "create_time" => time(), "ipaddr" => "0.0.0.0", "type" => 0, "activeid" => 0, "usertype" => "System", "type_data_id" => ""];
                                        \Think\Db::name("activity_log")->insert($activity_log);
                                        $bonus_data = ["user_id" => $user_id, "productid" => $product["productid"], "hostid" => $product["id"], "amount" => $amount, "type" => $rebateRule["way"], "bonus_type" => $rebateRule["type"], "bonus_amount" => $cashback_amount, "bonus" => $rebateRule["number"], "recharge_id" => $invoiceid, "invoice_num" => $insertedId, "start_time" => $rebateRule["start_time"], "end_time" => $rebateRule["end_time"], "pay_time" => $pay_time];
                                        \Think\Db::name("purchase_rebate_records")->insert($bonus_data);
                                    }
                                } else {
                                    \Think\Db::name("purchase_rebate_records")->where("recharge_id", $invoiceid)->update(["pay_time" => date("Y-m-d H:i:s", time())]);
                                }
                            } else {
                                if ($config["agent"] == 0) {
                                    $amount = $product["firstpaymentamount"];
                                    if ($rebateRule["type"] == "percent") {
                                        $cashback_amount = $amount * $rebateRule["number"] / 100;
                                        $cashback_amount = number_format($cashback_amount, 2, ".", "");
                                    } else {
                                        $cashback_amount = $rebateRule["number"];
                                    }
                                    if ($rebateRule["type"] === "percent") {
                                        $bonus_type_text = "百分比";
                                    } else {
                                        $bonus_type_text = "固定金额";
                                    }
                                    if ($rebateRule["type"] === "percent") {
                                        $bonus_amounts = $cashback_amount . "元";
                                    } else {
                                        $bonus_amounts = number_format($cashback_amount, 2, ".", "") . "元";
                                    }
                                    if (0 < $bonus_amounts) {
                                        $pay_time = date("Y-m-d H:i:s", time());
                                        $user_id = $product["uid"];
                                        $clients = \Think\Db::name("clients")->where("id", $user_id)->find();
                                        $credit = $clients["credit"];
                                        $newcredit = $cashback_amount + $credit;
                                        $upnewcredit = \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                                        $data = ["uid" => $user_id, "create_time" => time(), "description" => "" . $clients["username"] . "【UID:" . $user_id . "】在【" . $pay_time . "】新购产品支付" . $amount . "元（商品：" . $productname["name"] . "--主机ID：" . $product["id"] . "），账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $rebateRule["start_time"]) . "至" . date("Y-m-d H:i:s", $rebateRule["end_time"]) . "，按" . $bonus_type_text . "返现" . $bonus_amounts . "", "amount" => $cashback_amount, "balance" => $newcredit];
                                        \Think\Db::name("credit")->insert($data);
                                        $datainvoices = ["uid" => $user_id, "create_time" => time(), "due_time" => time(), "paid_time" => time(), "update_time" => time(), "subtotal" => $cashback_amount, "total" => $cashback_amount, "payment" => "UserCustom", "status" => "Paid", "type" => "recharge"];
                                        \Think\Db::name("invoices")->insert($datainvoices);
                                        $insertedId = \Think\Db::name("invoices")->getLastInsID();
                                        $datainvoice_items = ["invoice_id" => $insertedId, "uid" => $user_id, "type" => "recharge", "due_time" => time(), "description" => "" . $clients["username"] . "【UID:" . $user_id . "】在【" . $pay_time . "】新购产品支付" . $amount . "元（商品：" . $productname["name"] . "--主机ID：" . $product["id"] . "），账单号：" . $invoiceid . "，按" . $bonus_type_text . "返现" . $bonus_amounts . "", "amount" => $cashback_amount];
                                        \Think\Db::name("invoice_items")->insert($datainvoice_items);
                                        $activity_log = ["uid" => $user_id, "description" => "【新购产品返现活动】" . $clients["username"] . "【UID:" . $user_id . "】在【" . $pay_time . "】新购产品支付" . $amount . "元（商品：" . $productname["name"] . "--主机ID：" . $product["id"] . "），账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $rebateRule["start_time"]) . "至" . date("Y-m-d H:i:s", $rebateRule["end_time"]) . "，按" . $bonus_type_text . "返现" . $bonus_amounts . "", "user" => "System", "port" => "", "create_time" => time(), "ipaddr" => "0.0.0.0", "type" => 0, "activeid" => 0, "usertype" => "System", "type_data_id" => ""];
                                        \Think\Db::name("activity_log")->insert($activity_log);
                                        $bonus_data = ["user_id" => $user_id, "productid" => $product["productid"], "hostid" => $product["id"], "amount" => $amount, "type" => $rebateRule["way"], "bonus_type" => $rebateRule["type"], "bonus_amount" => $cashback_amount, "bonus" => $rebateRule["number"], "recharge_id" => $invoiceid, "invoice_num" => $insertedId, "start_time" => $rebateRule["start_time"], "end_time" => $rebateRule["end_time"], "pay_time" => $pay_time];
                                        \Think\Db::name("purchase_rebate_records")->insert($bonus_data);
                                    }
                                }
                            }
                        } else {
                            \Think\Db::name("purchase_rebate_records")->where("recharge_id", $invoiceid)->update(["pay_time" => date("Y-m-d H:i:s", time())]);
                        }
                    }
                }
            }
        }
    }
    public function shoppingCartSettle($params)
    {
        $client_ip = get_client_ip();
        $invoiceid = $params["invoiceid"];
        $orderid = $params["orderid"];
        $total = $params["total"];
        $hostid = $params["hostid"][0];
        $config = \Think\Db::name("purchase_rebate_setting")->where("id", 1)->find();
        $Info = \Think\Db::name("invoices")->where("id", $invoiceid)->find();
        $groupid = \Think\Db::name("clients")->where("id", $Info["uid"])->value("groupid");
        $group_name = \Think\Db::name("client_groups")->where("id", $groupid)->value("group_name");
        $products = \Think\Db::name("host")->where("orderid", $orderid)->field("id, productid, firstpaymentamount, uid")->select();
        $total_firstpaymentamount = 0;
        foreach ($products as $product) {
            $total_firstpaymentamount += $product["firstpaymentamount"];
        }
        if ($config["open"] == 1 && $Info["type"] == "product") {
            $zong_preferential = 0;
            foreach ($products as $product) {
                $rebateRule = \Think\Db::name("purchase_rebate_rules")->where("productid", $product["productid"])->find();
                if ($rebateRule && $rebateRule && $rebateRule["start_time"] <= time() && time() <= $rebateRule["end_time"] && $rebateRule["way"] === "0") {
                    if ($config["agent"] == 1) {
                        if ($groupid == 0) {
                            if ($rebateRule["type"] == "percent") {
                                $hostamounts = $product["firstpaymentamount"] * (1 - $rebateRule["number"] / 100);
                                $hostamount = number_format($hostamounts, 2, ".", "");
                                \Think\Db::name("host")->where("id", $product["id"])->update(["firstpaymentamount" => $hostamount]);
                                if ($rebateRule["renew"] == 1) {
                                    \Think\Db::name("host")->where("id", $product["id"])->update(["amount" => $hostamount]);
                                }
                                $preferential = $product["firstpaymentamount"] - $hostamount;
                                $newDescription = "【新购产品折扣优惠 " . $preferential . " 元 】";
                                $data = ["invoice_id" => $invoiceid, "uid" => $product["uid"], "type" => "discount", "rel_id" => $product["id"], "description" => $newDescription, "description2" => $newDescription, "amount" => "-" . $preferential, "due_time" => time()];
                                \Think\Db::name("invoice_items")->insert($data);
                                $zong_preferential += $preferential;
                                $record = ["user_id" => $Info["uid"], "productid" => $product["productid"], "hostid" => $product["id"], "amount" => $product["firstpaymentamount"], "type" => $rebateRule["way"], "bonus_type" => $rebateRule["type"], "bonus" => $rebateRule["number"], "bonus_amount" => $preferential, "recharge_id" => $invoiceid, "start_time" => $rebateRule["start_time"], "end_time" => $rebateRule["end_time"]];
                                \Think\Db::name("purchase_rebate_records")->insert($record);
                            } else {
                                if ($product["type"] == "fixed") {
                                    $hostamounts = max($product["firstpaymentamount"] - $rebateRule["number"], 0);
                                    $hostamount = number_format($hostamounts, 2, ".", "");
                                    \Think\Db::name("host")->where("id", $product["id"])->update(["firstpaymentamount" => $hostamount]);
                                    if ($rebateRule["renew"] == 1) {
                                        \Think\Db::name("host")->where("id", $product["id"])->update(["amount" => $hostamount]);
                                    }
                                    $preferential = $product["firstpaymentamount"] - $hostamount;
                                    $newDescription = "【新购产品立减优惠 " . $preferential . " 元 】";
                                    $data = ["invoice_id" => $invoiceid, "uid" => $product["uid"], "type" => "discount", "rel_id" => $product["id"], "description" => $newDescription, "description2" => $newDescription, "amount" => "-" . $preferential, "due_time" => time()];
                                    \Think\Db::name("invoice_items")->insert($data);
                                    $zong_preferential += $preferential;
                                    $record = ["user_id" => $Info["uid"], "productid" => $product["productid"], "hostid" => $product["id"], "amount" => $product["firstpaymentamount"], "type" => $rebateRule["way"], "bonus_type" => $rebateRule["type"], "bonus" => $rebateRule["number"], "bonus_amount" => $preferential, "recharge_id" => $invoiceid, "start_time" => $rebateRule["start_time"], "end_time" => $rebateRule["end_time"]];
                                    \Think\Db::name("purchase_rebate_records")->insert($record);
                                }
                            }
                        }
                    } else {
                        if ($config["agent"] == 0) {
                            if ($rebateRule["type"] == "percent") {
                                $hostamounts = $product["firstpaymentamount"] * (1 - $rebateRule["number"] / 100);
                                $hostamount = number_format($hostamounts, 2, ".", "");
                                \Think\Db::name("host")->where("id", $product["id"])->update(["firstpaymentamount" => $hostamount]);
                                if ($rebateRule["renew"] == 1) {
                                    \Think\Db::name("host")->where("id", $product["id"])->update(["amount" => $hostamount]);
                                }
                                $preferential = $product["firstpaymentamount"] - $hostamount;
                                $newDescription = "【新购产品折扣优惠 " . $preferential . " 元 】";
                                $data = ["invoice_id" => $invoiceid, "uid" => $product["uid"], "type" => "discount", "rel_id" => $product["id"], "description" => $newDescription, "description2" => $newDescription, "amount" => "-" . $preferential, "due_time" => time()];
                                \Think\Db::name("invoice_items")->insert($data);
                                $zong_preferential += $preferential;
                                $record = ["user_id" => $Info["uid"], "productid" => $product["productid"], "hostid" => $product["id"], "amount" => $product["firstpaymentamount"], "type" => $rebateRule["way"], "bonus_type" => $rebateRule["type"], "bonus" => $rebateRule["number"], "bonus_amount" => $preferential, "recharge_id" => $invoiceid, "start_time" => $rebateRule["start_time"], "end_time" => $rebateRule["end_time"]];
                                \Think\Db::name("purchase_rebate_records")->insert($record);
                            } else {
                                if ($rebateRule["type"] == "fixed") {
                                    $hostamounts = max($product["firstpaymentamount"] - $rebateRule["number"], 0);
                                    $hostamount = number_format($hostamounts, 2, ".", "");
                                    \Think\Db::name("host")->where("id", $product["id"])->update(["firstpaymentamount" => $hostamount]);
                                    if ($rebateRule["renew"] == 1) {
                                        \Think\Db::name("host")->where("id", $product["id"])->update(["amount" => $hostamount]);
                                    }
                                    $preferential = $product["firstpaymentamount"] - $hostamount;
                                    $newDescription = "【新购产品立减优惠 " . $preferential . " 元 】";
                                    $data = ["invoice_id" => $invoiceid, "uid" => $product["uid"], "type" => "discount", "rel_id" => $product["id"], "description" => $newDescription, "description2" => $newDescription, "amount" => "-" . $preferential, "due_time" => time()];
                                    \Think\Db::name("invoice_items")->insert($data);
                                    $zong_preferential += $preferential;
                                    $record = ["user_id" => $Info["uid"], "productid" => $product["productid"], "hostid" => $product["id"], "amount" => $product["firstpaymentamount"], "type" => $rebateRule["way"], "bonus_type" => $rebateRule["type"], "bonus" => $rebateRule["number"], "bonus_amount" => $preferential, "recharge_id" => $invoiceid, "start_time" => $rebateRule["start_time"], "end_time" => $rebateRule["end_time"]];
                                    \Think\Db::name("purchase_rebate_records")->insert($record);
                                }
                            }
                        }
                    }
                }
            }
            $invoice_preferential = $total - $zong_preferential;
            \Think\Db::name("invoices")->where("id", $invoiceid)->update(["total" => $invoice_preferential, "subtotal" => $invoice_preferential]);
        }
    }
}

?>