
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12">
                            {foreach $PluginsAdminMenu as $v}
                                {if $v['custom']}
                                    <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                                {else/}
                                    <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                                {/if}
                            {/foreach}
                        </div>
                    </div>

                    <div class="tab-content mt-4">



                        <div style="height: 30px;line-height: 30px;">说明：官方折扣模式设置100默认为原价,80为8折，110官方价加价10%,0为使用下方设定价格</div>

                        <div class="table-body auto-login-content" style="margin-top: 10px;">
                            <table class="table table-bordered table-hover activity-table">
                                <caption>选中的项目：<input type="text" name="distributeusername" id="distributeusername" value="" placeholder="折扣"> <button type="button" class="btn btn-danger btn-sm update-files">批量更新</button></caption>
                                <thead class="thead-light">
                                <tr>
                                    <th class="checkbox">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" id="customCheckHead" name="headCheckbox">
                                            <label class="custom-control-label" for="customCheckHead">&nbsp;</label>
                                        </div>
                                    </th>
                                    <th data-name="name" data-type="text">后缀(不要带点)</th>
                                    <th data-name="annually" data-type="text">年付</th>
                                    <th data-name="biennially" data-type="text">两年付</th>
                                    <th data-name="triennially" data-type="text">三年付</th>
                                    <th data-name="fourly" data-type="text">四年付</th>
                                    <th data-name="fively" data-type="text">五年付</th>

                                </tr>
                                </thead>
                                <tbody>
                                {foreach $DomainList['data'] as $key=>$item}
                                    <tr>
                                        <td class="checkbox">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input row-checkbox" data-file='{$item|json_encode}' id="customCheck{$key}">
                                                <label class="custom-control-label" for="customCheck{$key}">&nbsp;</label>
                                            </div>
                                        </td>

                                        <td>{$key}</td>
                                        {foreach $item as $k=>$v}
                                        <td>{$v.price}/{$k}年</td>
                                        {/foreach}

                                    </tr>
                                {/foreach}
                                </tbody>
                            </table>
                            <div id="renewMsg" style="color: #ff0000;height: 30px;line-height: 30px;"></div>

                        </div>

                        <div class="table-body">文档说明：<a href="https://html5code.org/type/zjmf.html" target="_blank">https://html5code.org/type/zjmf.html</a> </div>


                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    let ProductGroups={$Groups|json_encode};
    $(function () {
        let queryToJson=function (hash){
            let str=hash?window.location.hash:window.location.search
            if( !str ) return { };
            if(str) str=str.substr(1);
            if( !str ) return { };
            let arr = str.split('&');
            let data={ };
            $.each( arr, function (k,v) {

                if(v.indexOf("=")>-1){
                    let d=v.indexOf("=");
                    data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

                }

            } );
            return data;
        }
        let jsonToQuery=function (json){
            return  Object.keys(json).map(function (key) {
                return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
            }).join("&");
        }
        let ajax=function (option){
            $.ajax({
                    dataType: "json",
                    type: option.type||"post",

                    headers: {
                        "X-Requested-With": "XMLHttpRequest",

                    },
                    url: option.url||"",
                    data:option.data,
                    async:true,
                    success: function (t) {



                        if( t.status==1 ){
                            if(option.success)  option.success(t.info);
                        }else{
                            if(option.error){
                                option.error(t.info)
                            }else{
                                $('#renewMsg').html(t.info);
                            }
                        }
                    },

                    error: function (request, status, errorThrown) {
                        if(option.error){ option.error("网络错误，请重试") }else{
                            $('#renewMsg').html("网络错误，请重试");
                        }
                    }
                }
            );
        }

        $('#customCheckHead').off("click").on('click',function () {
            let checked=$(this).prop("checked");
            $(this).closest('table').find('input[type="checkbox"]').prop("checked",checked);
        })
        $('.update-files').off("click").on("click",function (){
            $('#renewMsg').html('');
            let self=$(this),data=[],username=$('#distributeusername').val();
            if(!username){
                $('#renewMsg').html('请输入折扣');
                return false;
            }
            self.closest('table').find('input[data-file][type="checkbox"]:checked').each(function (item){
                let s= $(this).data("file");
                data.push(s);

            })

            if(data.length<1){
                $('#renewMsg').html('请选择要分配的域名');
                return false;
            }
            ajax({
                data:{
                    action:'set',
                    username:username,
                    domain:JSON.stringify(data)
                },
                success:function (r){
                    $('#renewMsg').html("全部更新完成");

                },error:function (r){
                    $('#renewMsg').html(r);

                }
            })

        })
    })
</script>