<?php
namespace addons\qcloud_dominbygzhx\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public $data;
    public function initialize()
    {
        parent::initialize();
        $this->data = $_POST;
    }
    public function success($arr)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $arr]);
        exit;
    }
    public function error($arr)
    {
        echo json_encode(["status" => 0, "info" => $arr]);
        exit;
    }
    public function index()
    {
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "":
                    $this->error("参数错误");
                    break;
                case "status":
                    \Think\Db::name("zjmf_finance_api")->where("id", "=", $this->data["id"])->update(["status" => intval($this->data["status"]) == 2 ? 2 : 1]);
                    $this->success("设置成功");
                    break;
                case "plugin":
                    $modulesPath = CMF_ROOT . "public/plugins/addons";
                    \addons\qcloud_dominbygzhx\DominbygzhxClass::DownloadFile("https://v.ximijia.cn/modules/dominbygzhx.zip", $modulesPath . "/dominbygzhx.zip");
                    $unSDK = \addons\qcloud_dominbygzhx\DominbygzhxClass::UnZip($modulesPath . "/dominbygzhx.zip", $modulesPath . "/");
                    if (!$unSDK) {
                        $this->error("安装SDK失败");
                    }
                    $this->success("设置成功");
                    break;
                case "sdk":
                    $modulesPath = \addons\qcloud_dominbygzhx\DominbygzhxClass::path();
                    \addons\qcloud_dominbygzhx\DominbygzhxClass::DownloadFile("https://v.ximijia.cn/modules/qcloud/sdk.zip", $modulesPath . "/qcloudsdk.zip");
                    $unSDK = \addons\qcloud_dominbygzhx\DominbygzhxClass::UnZip($modulesPath . "/qcloudsdk.zip", $modulesPath . "/");
                    if (!$unSDK) {
                        $this->error("安装SDK失败");
                    }
                    $this->success("设置成功");
                    break;
                default:
                    \Think\Db::startTrans();
                    try {
                        $this->data["data"]["hostname"] = "qcloud_dominbygzhx";
                        $this->data["data"]["type"] = "manual";
                        if (empty($this->data["data"]["name"]) || empty($this->data["data"]["username"])) {
                            $this->error("请填写名称和帐号");
                        }
                        if (empty($this->data["data"]["id"])) {
                            if (empty($this->data["data"]["password"]) || empty($this->data["data"]["username"])) {
                                $this->error("请填写密钥");
                            }
                            $this->data["data"]["password"] = bin2hex(openssl_encrypt($this->data["data"]["password"], "aes-128-cbc", mb_substr(md5("hjio^*(uihkjh"), 8, 16)));
                            $this->data["data"]["id"] = \Think\Db::name("zjmf_finance_api")->insertGetId($this->data["data"]);
                        } else {
                            if (empty($this->data["data"]["password"])) {
                                if (isset($this->data["data"]["password"])) {
                                    unset($this->data["data"]["password"]);
                                }
                            } else {
                                $this->data["data"]["password"] = bin2hex(openssl_encrypt($this->data["data"]["password"], "aes-128-cbc", mb_substr(md5("hjio^*(uihkjh"), 8, 16)));
                            }
                            \Think\Db::name("zjmf_finance_api")->where("id", "=", $this->data["data"]["id"])->update($this->data["data"]);
                            $this->data["data"]["status"] = \Think\Db::name("zjmf_finance_api")->where("id", "=", $this->data["data"]["id"])->value("status");
                        }
                        \Think\Db::commit();
                        $this->success($this->data["data"]);
                    } catch (\Think\Exception $e) {
                        \Think\Db::rollback();
                        $this->error("添加错误");
                    }
            }
        }
        $server_groups = \Think\Db::name("zjmf_finance_api")->where("hostname", "=", "qcloud_dominbygzhx")->select()->toArray();
        foreach ($server_groups as $key => $item) {
            $server_groups[$key]["password"] = "";
        }
        if (!file_exists(CMF_ROOT . "public/plugins/addons/dominbygzhx/DominbygzhxPlugin.php")) {
            $this->assign("sell_Plugin", false);
        } else {
            $PluginData = \Think\Db::name("plugin")->where("name", "=", "Dominbygzhx")->find();
            if (empty($PluginData)) {
                $this->assign("msg", "请先在插件中心安装GZHX域名销售(Dominbygzhx)插件");
                return $this->fetch("/error");
            }
            $PluginData = \Think\Db::name("plugin")->where("name", "=", "Dominbygzhx")->find();
            if (empty($PluginData)) {
                $this->assign("msg", "请先在插件中心安装GZHX域名销售(Dominbygzhx)插件");
                return $this->fetch("/error");
            }
            $DominbygzhxPlugin = new \addons\dominbygzhx\DominbygzhxPlugin();
            if (!method_exists($DominbygzhxPlugin, "versionCompare") || $DominbygzhxPlugin->versionCompare("1.1.7") < 0) {
                $PluginUpdateData = \Think\Db::name("plugin")->where("name", "=", "GzhxUpdate")->find();
                if (empty($PluginUpdateData)) {
                    if (file_exists(CMF_ROOT . "/public/plugins/addons/gzhx_update/GzhxUpdatePlugin.php")) {
                        $this->assign("msg", "<a href=\"./plugins?languagesys=CN\" target=\"_blank\">请先安装更新插件</a>");
                        return $this->fetch("/error");
                    }
                    $this->assign("msg", "<a href=\"https://market.idcsmart.com/shop/#/app-detail?id=540\" target=\"_blank\">GZHX域名销售(Dominbygzhx)插件版本太低，请先升级，点此安装更新插件然后升级</a>");
                    return $this->fetch("/error");
                }
                $this->assign("msg", "<a href=\"./addons?_plugin=gzhx_update&_controller=admin_index&_action=index&languagesys=CN\" target=\"_blank\">GZHX域名销售(Dominbygzhx)插件版本太低，请先升级，点此更新</a>");
                return $this->fetch("/error");
            }
            $this->assign("sell_Plugin", $DominbygzhxPlugin->info["version"]);
        }
        $this->assign("server_groups", $server_groups);
        $this->assign("sdk", \addons\qcloud_dominbygzhx\DominbygzhxClass::sdk());
        $this->assign("Title", "系统设置");
        return $this->fetch("/index");
    }
    public function domain()
    {
        $group = \Think\Db::name("product_groups")->where("zjfm_api_id", "=", $_GET["id"])->find();
        if (empty($group)) {
            $group = ["name" => "域名", "hidden" => 1, "gid" => 1, "zjfm_api_id" => $_GET["id"]];
            $group["id"] = \Think\Db::name("ProductGroups")->insertGetId($group);
        }
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "":
                    $this->error("参数错误");
                    break;
                case "setmenu":
                    \Think\Db::name("zjmf_finance_api")->where("id", "=", $_GET["id"])->update(["gzhx_domain_rebet" => intval($this->data["name"])]);
                    $this->success("设置成功");
                    break;
                case "delete_client_groups":
                    \Think\Db::name("gzhx_clients_groups")->where("gid", "=", $this->data["data"]["gid"])->where("pid", "=", $this->data["data"]["pid"])->delete();
                    $this->success("OK");
                    break;
                case "set_client_groups":
                    $find = \Think\Db::name("gzhx_clients_groups")->where("gid", "=", $this->data["data"]["gid"])->where("pid", "=", $this->data["data"]["pid"])->find();
                    if (empty($find)) {
                        \Think\Db::name("gzhx_clients_groups")->insert($this->data["data"]);
                    } else {
                        \Think\Db::name("gzhx_clients_groups")->where("id", "=", $find["id"])->update($this->data["data"]);
                    }
                    $this->success("OK");
                    break;
                case "client_groups":
                    $DbConfig = \Think\Db::getConfig();
                    $CacheDbName = $DbConfig["prefix"] . "gzhx_clients_groups";
                    $tableList = \Think\Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='" . $DbConfig["database"] . "'");
                    $tableList = array_column($tableList, "table_name");
                    if (!in_array($CacheDbName, $tableList)) {
                        \Think\Db::query("CREATE TABLE `" . $CacheDbName . "`  (`id` int NOT NULL AUTO_INCREMENT,`gid` int NULL,`pid` int NULL,`annually` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '年',`biennially` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '两年',`triennially` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '三年',`fourly` decimal(10, 2) NOT NULL DEFAULT 0.00,`fively` decimal(10, 2) NOT NULL DEFAULT 0.00,PRIMARY KEY (`id`));");
                    }
                    $list = \Think\Db::name("gzhx_clients_groups")->alias("a")->field("b.group_name,a.*")->join("client_groups b", "a.gid=b.id")->where("a.pid", "=", $this->data["pid"])->select()->toArray();
                    $groups = \Think\Db::name("client_groups")->field("id,group_name as name")->select()->toArray();
                    $this->success(["groups" => $groups, "data" => $list ?: []]);
                    break;
                case "status":
                    \Think\Db::name("products")->where("id", "=", $this->data["id"])->update(["hidden" => intval($this->data["status"]) == 2 ? 0 : 1]);
                    $this->success("设置成功");
                    break;
                default:
                    \Think\Db::startTrans();
                    try {
                        if (empty($this->data["data"]["id"])) {
                            $this->data["data"]["id"] = \Think\Db::name("products")->insertGetId(["name" => trim($this->data["data"]["name"]), "type" => "cloud", "gid" => $group["id"], "host" => "{\"show\":\"0\",\"modify\":0,\"prefix\":\"ser\",\"rule\":{\"upper\":\"0\",\"lower\":\"0\",\"num\":\"1\",\"len_num\":12}}", "password" => "{\"show\":\"0\",\"modify\":0,\"rule\":{\"len_num\":12,\"upper\":\"1\",\"lower\":\"1\",\"num\":\"1\",\"special\":\"0\"}}", "pay_type" => "{\"pay_type\":\"recurring\",\"pay_hour_cycle\":\"720\",\"pay_day_cycle\":\"30\",\"pay_ontrial_status\":0,\"pay_ontrial_cycle\":\"0\",\"pay_ontrial_num\":\"1\",\"pay_ontrial_condition\":[],\"pay_ontrial_cycle_type\":\"day\"}", "pay_method" => "prepayment", "config_option1" => $this->data["data"]["config_option1"] == "付款后自动" ? "payment" : "", "hidden" => empty($this->data["data"]["hidden"]) ? 0 : 1, "config_option2" => $this->data["data"]["config_option2"], "zjmf_api_id" => $_GET["id"], "upstream_pid" => $_GET["id"], "api_type" => "manual", "upper_reaches_id" => $_GET["id"]]);
                        } else {
                            $update = ["name" => $this->data["data"]["name"], "type" => "cloud", "gid" => $group["id"], "host" => "{\"show\":\"0\",\"modify\":0,\"prefix\":\"ser\",\"rule\":{\"upper\":\"0\",\"lower\":\"0\",\"num\":\"1\",\"len_num\":12}}", "password" => "{\"show\":\"0\",\"modify\":0,\"rule\":{\"len_num\":12,\"upper\":\"1\",\"lower\":\"1\",\"num\":\"1\",\"special\":\"0\"}}", "pay_type" => "{\"pay_type\":\"recurring\",\"pay_hour_cycle\":\"720\",\"pay_day_cycle\":\"30\",\"pay_ontrial_status\":0,\"pay_ontrial_cycle\":\"0\",\"pay_ontrial_num\":\"1\",\"pay_ontrial_condition\":[],\"pay_ontrial_cycle_type\":\"day\"}", "pay_method" => "prepayment", "config_option1" => $this->data["data"]["config_option1"] == "付款后自动" ? "payment" : "", "zjmf_api_id" => $_GET["id"], "hidden" => empty($this->data["data"]["hidden"]) ? 0 : 1, "config_option2" => $this->data["data"]["config_option2"], "upstream_pid" => $_GET["id"], "api_type" => "manual", "upper_reaches_id" => $_GET["id"], "server_group" => $_GET["id"]];
                            $r = \Think\Db::name("products")->where("id", "=", $this->data["data"]["id"])->update($update);
                        }
                        $price = \Think\Db::name("pricing")->where("relid", "=", $this->data["data"]["id"])->where("type", "=", "product")->find();
                        if (empty($price)) {
                            \Think\Db::name("pricing")->insert(["currency" => 1, "relid" => $this->data["data"]["id"], "type" => "product", "annually" => $this->data["data"]["annually"], "biennially" => $this->data["data"]["biennially"], "triennially" => $this->data["data"]["triennially"], "fourly" => $this->data["data"]["fourly"], "fively" => $this->data["data"]["fively"]]);
                        } else {
                            \Think\Db::name("pricing")->where("id", "=", $price["id"])->update(["annually" => $this->data["data"]["annually"], "biennially" => $this->data["data"]["biennially"], "triennially" => $this->data["data"]["triennially"], "fourly" => $this->data["data"]["fourly"], "fively" => $this->data["data"]["fively"]]);
                        }
                        \Think\Db::commit();
                        $this->success($this->data["data"]);
                    } catch (\Think\Exception $e) {
                        \Think\Db::rollback();
                        $this->error("添加错误" . var_export($e, true));
                    }
            }
        }
        $list = \Think\Db::name("products")->alias("a")->field("a.*,b.annually,b.biennially,b.triennially,b.fourly,b.fively")->leftJoin("pricing b", "a.id=b.relid")->where("b.type", "=", "product")->where("a.gid", "=", $group["id"])->select()->toArray();
        $update_list = [];
        foreach ($list as $k => $v) {
            if ($v["config_option1"] == "payment") {
                $list[$k]["config_option1"] = "付款后自动";
            } else {
                $list[$k]["config_option1"] = "手动开通";
            }
            if (empty($v["config_option2"])) {
                $list[$k]["config_option2"] = "英文域名";
            }
        }
        $DbConfig = \Think\Db::getConfig();
        $COLUMNS = \Think\Db::name("zjmf_finance_api")->getTableFields();
        if (!in_array("gzhx_domain_rebet", $COLUMNS)) {
            \Think\Db::query("ALTER TABLE `" . $DbConfig["prefix"] . "zjmf_finance_api` ADD COLUMN `gzhx_domain_rebet` int NULL DEFAULT 0;");
        }
        $Setting = \Think\Db::name("zjmf_finance_api")->where("id", "=", $_GET["id"])->find();
        $this->assign("list", $list);
        $this->assign("gzhx_domain_rebet", $Setting["gzhx_domain_rebet"]);
        $this->assign("Title", $Setting["name"]);
        return $this->fetch("/domain");
    }
    public function product()
    {
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "":
                    $this->error("参数错误");
                    break;
                default:
                    $User = \Think\Db::name("clients")->where("username", "=", $this->data["username"])->find();
                    if (empty($User)) {
                        $this->error("用户不存在");
                        exit;
                    }
                    $domain = json_decode($this->data["domain"], true);
                    $save = [];
                    foreach ($domain as $item) {
                        $d = \Think\Db::name("gzhx_domain")->where("vid", "=", $item["DomainId"])->where("api_id", "=", $_GET["id"])->find();
                        if (empty($d)) {
                            \Think\Db::name("gzhx_domain")->insert(["domain" => $item["DomainName"], "vid" => $item["DomainId"], "api_id" => $_GET["id"], "start_time" => $item["CreationDate"], "end_time" => $item["ExpirationDate"], "uid" => $User["id"]], true);
                        } else {
                            \Think\Db::name("gzhx_domain")->where("vid", "=", $item["DomainId"])->where("api_id", "=", $_GET["id"])->update(["domain" => $item["DomainName"], "vid" => $item["DomainId"], "api_id" => $_GET["id"], "start_time" => $item["CreationDate"], "end_time" => $item["ExpirationDate"], "uid" => $User["id"]]);
                        }
                    }
                    $this->success($this->data["data"]);
            }
        }
        $Page = isset($_GET["page"]) ? intval($_GET["page"]) : 1;
        if (!class_exists("qcloud_dominbygzhx_class")) {
            require_once \addons\qcloud_dominbygzhx\DominbygzhxClass::path() . "/qcloud_dominbygzhx_class.php";
        }
        $QCloud = new \qcloud_dominbygzhx_class();
        $server_groups = \Think\Db::name("zjmf_finance_api")->where("id", "=", $_GET["id"])->find();
        $config = ["aid" => $server_groups["username"], "ak" => openssl_decrypt(hex2bin($server_groups["password"]), "aes-128-cbc", mb_substr(md5("hjio^*(uihkjh"), 8, 16))];
        $QCloud->setConfig($config);
        $list = $QCloud->DescribeDomainNameList($Page - 1);
        if ($list["status"] == 0) {
            $this->assign("msg", $list["info"]);
            return $this->fetch("/error");
        }
        $data = [];
        $domains = array_column($list["info"]["DomainSet"], "DomainId");
        $DomainList = [];
        if (!empty($domains)) {
            $DomainList = \Think\Db::name("gzhx_domain")->alias("a")->field("b.username,a.*")->join("clients b", "a.uid=b.id")->where("a.api_id", "=", $_GET["id"])->where("a.vid", "IN", $domains)->select()->toArray();
            $DomainList = array_column($DomainList, NULL, "vid");
        }
        $this->assign("DomainList", $DomainList);
        $this->assign("List", $list["info"]["DomainSet"]);
        $this->assign("count", $list["info"]["TotalCount"]);
        $this->assign("Page", $Page);
        $this->assign("Title", "域名列表");
        return $this->fetch("/list");
    }
    public function TemplateList()
    {
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "":
                    $this->error("参数错误");
                    break;
                default:
                    $User = \Think\Db::name("clients")->where("username", "=", $this->data["username"])->find();
                    if (empty($User)) {
                        $this->error("用户不存在");
                        exit;
                    }
                    $domain = json_decode($this->data["domain"], true);
                    $save = [];
                    foreach ($domain as $item) {
                        $save[] = ["config" => serialize($item), "vid" => $item["TemplateId"], "api_id" => $_GET["id"], "organization_name" => $item["ZhRegistrantOrganization"], "certificate_type" => $item["IdentityCredentialType"], "uid" => $User["id"], "status" => $item["AuditStatus"]];
                    }
                    \Think\Db::startTrans();
                    try {
                        \Think\Db::name("gzhx_domain_template")->insertAll($save, true);
                        \Think\Db::commit();
                        $this->success($this->data["data"]);
                    } catch (\Think\Exception $e) {
                        \Think\Db::rollback();
                        $this->error("添加错误" . var_export($e, true));
                    }
            }
        }
        $Page = isset($_GET["page"]) ? intval($_GET["page"]) : 1;
        if (!class_exists("qcloud_dominbygzhx_class")) {
            require_once \addons\qcloud_dominbygzhx\DominbygzhxClass::path() . "/qcloud_dominbygzhx_class.php";
        }
        $QCloud = new \qcloud_dominbygzhx_class();
        $server_groups = \Think\Db::name("zjmf_finance_api")->where("id", "=", $_GET["id"])->find();
        $config = ["aid" => $server_groups["username"], "ak" => openssl_decrypt(hex2bin($server_groups["password"]), "aes-128-cbc", mb_substr(md5("hjio^*(uihkjh"), 8, 16))];
        $QCloud->setConfig($config);
        $list = $QCloud->DescribeTemplateList($Page - 1);
        if ($list["status"] == 0) {
            $this->assign("msg", $list["info"]);
            return $this->fetch("/error");
        }
        $data = [];
        $domains = array_column($list["info"]["TemplateSet"], "TemplateId");
        $DomainList = [];
        if (!empty($domains)) {
            $DomainList = \Think\Db::name("gzhx_domain_template")->alias("a")->field("b.username,a.*")->join("clients b", "a.uid=b.id")->where("a.api_id", "=", $_GET["id"])->where("a.vid", "IN", $domains)->select()->toArray();
            $DomainList = array_column($DomainList, NULL, "vid");
        }
        $this->assign("DomainList", $DomainList);
        $this->assign("List", $list["info"]["TemplateSet"]);
        $this->assign("count", $list["info"]["TotalCount"]);
        $this->assign("Page", $Page);
        $this->assign("Title", "域名信息模版列表");
        return $this->fetch("/template");
    }
    public function Suffix()
    {
        $server_groups = \Think\Db::name("zjmf_finance_api")->where("id", "=", $_GET["id"])->find();
        $group = \Think\Db::name("product_groups")->where("zjfm_api_id", "=", $_GET["id"])->find();
        if (empty($group)) {
            $group = ["name" => "域名", "hidden" => 1, "gid" => 1, "zjfm_api_id" => $_GET["id"]];
            $group["id"] = \Think\Db::name("ProductGroups")->insertGetId($group);
        }
        if (!empty($this->data)) {
            $action = $this->data["action"];
            if (empty($action)) {
                $action = "";
            }
            switch ($action) {
                case "set":
                    $domain = json_decode($this->data["domain"], true);
                    $data = [];
                    $Year = ["1" => "annually", "2" => "biennially", "3" => "triennially", "4" => "fourly", "5" => "fively"];
                    foreach ($domain as $item) {
                        $Suffix = mb_substr($item["Tld"], 1, NULL, "UTF-8");
                        foreach ($item as $k => $v) {
                            $data[$v["suffix"]][$Year[$v["year"]]] = ceil($v["price"] * $this->data["username"] / 100);
                        }
                    }
                    \Think\Db::startTrans();
                    try {
                        foreach ($data as $suffix => $v) {
                            $pricing = $v;
                            $list = \Think\Db::name("products")->alias("a")->field("a.*,b.id as pricing_id")->leftJoin("pricing b", "a.id=b.relid")->where("b.type", "=", "product")->where("a.gid", "=", $group["id"])->where("a.name", "=", $suffix)->find();
                            if (empty($list)) {
                                $id = \Think\Db::name("products")->insertGetId(["name" => trim($suffix), "type" => "cloud", "gid" => $group["id"], "host" => "{\"show\":\"0\",\"modify\":0,\"prefix\":\"ser\",\"rule\":{\"upper\":\"0\",\"lower\":\"0\",\"num\":\"1\",\"len_num\":12}}", "password" => "{\"show\":\"0\",\"modify\":0,\"rule\":{\"len_num\":12,\"upper\":\"1\",\"lower\":\"1\",\"num\":\"1\",\"special\":\"0\"}}", "pay_type" => "{\"pay_type\":\"recurring\",\"pay_hour_cycle\":\"720\",\"pay_day_cycle\":\"30\",\"pay_ontrial_status\":0,\"pay_ontrial_cycle\":\"0\",\"pay_ontrial_num\":\"1\",\"pay_ontrial_condition\":[],\"pay_ontrial_cycle_type\":\"day\"}", "pay_method" => "prepayment", "config_option1" => "payment", "zjmf_api_id" => $_GET["id"], "upstream_pid" => $_GET["id"], "api_type" => "manual", "upper_reaches_id" => $_GET["id"]]);
                                $pricing["currency"] = 1;
                                $pricing["relid"] = $id;
                                $pricing["type"] = "product";
                                \Think\Db::name("pricing")->insert($pricing);
                            } else {
                                \Think\Db::name("pricing")->where("id", "=", $list["pricing_id"])->update($pricing);
                            }
                        }
                        \Think\Db::commit();
                        $this->success("OK");
                    } catch (\Think\Exception $e) {
                        \Think\Db::rollback();
                        $this->error("添加错误");
                    }
                    break;
                default:
                    $this->error("参数错误");
            }
        }
        if (!class_exists("qcloud_dominbygzhx_class")) {
            require_once \addons\qcloud_dominbygzhx\DominbygzhxClass::path() . "/qcloud_dominbygzhx_class.php";
        }
        $QCloud = new \qcloud_dominbygzhx_class();
        $config = ["aid" => $server_groups["username"], "ak" => openssl_decrypt(hex2bin($server_groups["password"]), "aes-128-cbc", mb_substr(md5("hjio^*(uihkjh"), 8, 16))];
        $QCloud->setConfig($config);
        $list = $QCloud->DescribeDomainPriceList("new", [1, 2, 3, 4, 5]);
        if ($list["status"] != 1) {
            $this->assign("msg", $list["info"]);
            return $this->fetch("/error");
        }
        $this->assign("Title", $server_groups["name"] . "后缀获取");
        $this->assign("DomainList", $list["info"]);
        return $this->fetch("/suffix");
    }
}

?>