<?php
require_once "QCloud/TCloudAutoLoader.php";
class qcloud_dominbygzhx_class
{
    private $uid = "";
    private $APiKey = "";
    private $ApiUrl = "https://api.west.cn/api/v2";
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = $data["ak"];
    }
    public function get($action, $option = [])
    {
        try {
            $moduleName = "domain";
            $Version = "V20180808";
            $cred = new TencentCloud\Common\Credential($this->uid, $this->APiKey);
            $httpProfile = new TencentCloud\Common\Profile\HttpProfile();
            $httpProfile->setEndpoint($moduleName . ".tencentcloudapi.com");
            $httpProfile->setReqTimeout(30);
            $clientProfile = new TencentCloud\Common\Profile\ClientProfile();
            $clientProfile->setHttpProfile($httpProfile);
            $ClientName = "TencentCloud\\" . ucfirst($moduleName) . "\\" . $Version . "\\" . ucfirst($moduleName) . "Client";
            $client = new $ClientName($cred, "", $clientProfile);
            $appAction = "TencentCloud\\" . ucfirst($moduleName) . "\\" . $Version . "\\Models\\" . ucfirst($action) . "Request";
            $req = new $appAction();
            unset($option["Region"]);
            unset($option["Product"]);
            unset($option["Version"]);
            if (!empty($option)) {
                $params = json_encode($option);
            } else {
                $params = "{}";
            }
            $req->fromJsonString($params);
            $resp = $client->{$action}($req);
            $resp = json_decode(json_encode($resp), true);
            return ["status" => 1, "info" => $resp];
        } catch (TencentCloud\Common\Exception\TencentCloudSDKException $e) {
            return ["status" => 0, "info" => "错误信息：" . $e->getMessage() . "/RequestId:" . $e->getRequestId()];
        }
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = NULL)
    {
        return $this->{$Action}($query);
    }
    private function zhCheckDomain($query)
    {
        $Price = NULL;
        if (0 < intval($query["rebet"])) {
            $DescribeDomainPriceList = $this->DescribeDomainPriceList($query["Operation"], [1, 2, 3, 4, 5]);
            if ($DescribeDomainPriceList["status"] != 1) {
                return $DescribeDomainPriceList;
            }
            $suffix = mb_substr($query["suffix"], 1, NULL, "UTF-8");
            $Year = ["1" => "annually", "2" => "biennially", "3" => "triennially", "4" => "fourly", "5" => "fively"];
            $Price = [];
            foreach ($DescribeDomainPriceList["info"]["data"][$suffix] as $k => $v) {
                $Price[$Year[$k]] = ceil($v["price"] * $query["rebet"] / 100);
            }
            if ($query["price"]) {
                return ["status" => 1, "info" => ["Rebet" => "yes", "Price" => $Price]];
            }
        }
        $r = $this->get("CheckDomain", ["DomainName" => $query["DomainName"]]);
        if ($r["status"] == 1) {
            $r["info"]["Avail"] = $r["info"]["Available"] ? 1 : 0;
            $r["info"]["Price"] = $Price;
            if (0 < intval($query["rebet"])) {
                $r["info"]["Rebet"] = "yes";
            }
        }
        return $r;
    }
    private function CheckDomain($query)
    {
        $Price = NULL;
        if (0 < intval($query["rebet"])) {
            $DescribeDomainPriceList = $this->DescribeDomainPriceList($query["Operation"], [1, 2, 3, 4, 5]);
            if ($DescribeDomainPriceList["status"] != 1) {
                return $DescribeDomainPriceList;
            }
            $suffix = mb_substr($query["suffix"], 1, NULL, "UTF-8");
            $Year = ["1" => "annually", "2" => "biennially", "3" => "triennially", "4" => "fourly", "5" => "fively"];
            $Price = [];
            foreach ($DescribeDomainPriceList["info"]["data"][$suffix] as $k => $v) {
                $Price[$Year[$k]] = ceil($v["price"] * $query["rebet"] / 100);
            }
            if ($query["price"]) {
                return ["status" => 1, "info" => ["Rebet" => "yes", "Price" => $Price]];
            }
        }
        $r = $this->get("CheckDomain", ["DomainName" => $query["DomainName"]]);
        if ($r["status"] == 1) {
            $r["info"]["Avail"] = $r["info"]["Available"] ? 1 : 0;
            $r["info"]["Price"] = $Price;
            if (0 < intval($query["rebet"])) {
                $r["info"]["Rebet"] = "yes";
            }
        }
        return $r;
    }
    public function phoneSendMsg($query)
    {
        $rr = $this->get("SendPhoneEmailCode", ["Type" => 1, "Code" => $query]);
        return $rr;
    }
    public function phoneVerifyCode($query)
    {
        $rr = $this->get("CreatePhoneEmail", ["Type" => 1, "Code" => $query["data"], "VerifyCode" => $query["code"]]);
        return $rr;
    }
    public function emailSendMsg($query)
    {
        $rr = $this->get("SendPhoneEmailCode", ["Type" => 2, "Code" => $query]);
        return $rr;
    }
    public function emailVerifyCode($query)
    {
        $rr = $this->get("CreatePhoneEmail", ["Type" => 2, "Code" => $query["data"], "VerifyCode" => $query["code"]]);
        return $rr;
    }
    private function SaveRegistrantProfile($query)
    {
        $rr = $this->get("DescribePhoneEmailList", ["Type" => 1, "Code" => $query["Telephone"]]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        if ($rr["info"]["TotalCount"] == 0) {
            return ["status" => 0, "info" => "PhoneCheck"];
        }
        $rr = $this->get("DescribePhoneEmailList", ["Type" => 2, "Code" => $query["Email"]]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        if (count($rr["info"]["PhoneEmailList"]) == 0) {
            return ["status" => 0, "info" => "EmailCheck"];
        }
        if (!empty($query["RegistrantProfileId"])) {
            $rr = $this->get("DeleteTemplate", ["TemplateId" => $query["RegistrantProfileId"]]);
            if ($rr["status"] != 1) {
                return $rr;
            }
        }
        switch ($query["IdentityCredentialType"]) {
            case "XYDM":
                $f_type_org = "TYDMZ";
                break;
            default:
                $f_type_org = $query["IdentityCredentialType"];
                $rr = $this->get("UploadImage", ["ImageFile" => "data:image/jpeg;base64," . $query["RegistrantProfilePic"]]);
                if ($rr["status"] != 1) {
                    return $rr;
                }
                $post = ["ContactInfo" => ["RegistrantType" => $query["RegistrantType"] == 1 ? "I" : "E", "OrganizationNameCN" => $query["ZhRegistrantOrganization"], "OrganizationName" => $query["RegistrantOrganization"], "RegistrantNameCN" => $query["ZhRegistrantName"], "RegistrantName" => $query["RegistrantName"], "ProvinceCN" => $query["ZhProvince"], "CityCN" => $query["ZhCity"], "StreetCN" => $query["ZhAddress"], "Street" => $query["Address"], "ZipCode" => $query["PostalCode"], "CountryCN" => "中国", "Telephone" => $query["Telephone"], "Email" => $query["Email"], "Province" => $query["Province"], "City" => $query["City"], "Country" => "CN"], "CertificateInfo" => ["CertificateCode" => $query["IdentityCredentialNo"], "CertificateType" => $f_type_org, "ImgUrl" => $rr["info"]["AccessUrl"]]];
                $r = $this->get("CreateTemplate", $post);
                if ($r["status"] == 1) {
                    $r["info"]["RegistrantProfileId"] = $r["info"]["Template"]["TemplateId"];
                }
                return $r;
        }
    }
    private function QueryDomainList($query)
    {
        $r = $this->get("DescribeDomainBaseInfo", ["Domain" => $query["DomainName"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $result = ["status" => 1, "info" => ["Data" => ["Domain" => [["vid" => $r["info"]["DomainInfo"]["DomainId"], "DomainName" => $query["DomainName"], "ExpirationDate" => $r["info"]["DomainInfo"]["ExpirationDate"], "RegistrationDate" => $r["info"]["DomainInfo"]["CreationDate"]]]]]];
        return $result;
    }
    private function SaveSingleTaskForCreatingOrderActivate($query)
    {
        $arr = ["Domains" => [$query["DomainName"]], "Period" => intval($query["Period"]), "TemplateId" => $query["RegistrantProfileId"], "PayMode" => 1];
        if (!empty($query["Dns1"]) && !empty($query["Dns2"])) {
            $arr["dns_host1"] = $query["Dns1"];
            $arr["dns_host2"] = $query["Dns2"];
        }
        $r = $this->get("CreateDomainBatch", $arr);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["active"] = "注册中";
        $r["info"]["TaskNo"] = $r["info"]["LogId"];
        return $r;
    }
    private function QueryTaskDetailList($query)
    {
        $r = $this->get("DescribeBatchOperationLogDetails", ["LogId" => intval($query["TaskNo"])]);
        $Status = "执行中";
        switch ($r["info"]["DomainBatchDetailSet"][0]["Status"]) {
            case "doing":
                $Status = "执行中";
                break;
            case "failed":
                $Status = $r["info"]["DomainBatchDetailSet"][0]["Reason"];
                break;
            case "success":
                $Status = "执行成功";
                break;
            default:
                $Status = "等待执行";
                $result = ["status" => 1, "info" => $Status];
                return $result;
        }
    }
    public function DescribeDomainPriceList($Operation, $Year)
    {
        $cachePathDir = dirname(__FILE__) . "/suffix_cache/";
        if (!is_dir($cachePathDir)) {
            mkdir($cachePathDir, 493, true);
        }
        $cachePath = $cachePathDir . $Operation . "-" . implode("-", $Year);
        $cache = unserialize(file_get_contents($cachePath));
        if (!empty($cache) && time() - $cache["time"] < 86400) {
            $cache["info"]["cache"] = $cachePath;
            return $cache;
        }
        $r = $this->get("DescribeDomainPriceList", ["LogId" => $Operation, "Year" => $Year, "Operation" => [$Operation]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $data = [];
        foreach ($r["info"]["PriceList"] as $item) {
            $Suffix = mb_substr($item["Tld"], 1, NULL, "UTF-8");
            $data[$Suffix][$item["Year"]] = ["price" => $item["RealPrice"], "suffix" => $Suffix, "year" => $item["Year"]];
        }
        $result = ["status" => 1, "info" => ["data" => $data], "time" => time()];
        file_put_contents($cachePath, serialize($result));
        return $result;
    }
    public function SaveBatchTaskForModifyingDomainDns($query)
    {
        $arr = ["Domains" => [$query["DomainName.1"]]];
        if (!empty($query["DomainNameServer.1"]) && !empty($query["DomainNameServer.2"])) {
            $arr["Dns"] = [$query["DomainNameServer.1"], $query["DomainNameServer.2"]];
        } else {
            $arr["Dns"] = ["width.dnspod.net", "escape.dnspod.net"];
        }
        $r = $this->get("ModifyDomainDNSBatch", $arr);
        return $r;
    }
    public function DescribeDomainNs($query)
    {
        $r = $this->get("DescribeDomainBaseInfo", ["Domain" => $query["DomainName"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $Ns = $r["info"]["DomainInfo"]["NameServer"];
        return ["status" => 1, "info" => $Ns];
    }
    public function DescribeDomainNameList($Offset = 0)
    {
        $r = $this->get("DescribeDomainNameList", ["Offset" => $Offset * 100, "Limit" => 100]);
        return $r;
    }
    public function DescribeDomainBaseInfo($query)
    {
        $rr = $this->get("DescribeDomain", ["DomainId" => $query["DomainId"]]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $Info = $rr["info"]["DomainInfo"];
        $status = "未知";
        switch ($Info["RealNameAuditStatus"]) {
            case "NotUpload":
                $status = "未实名认证";
                break;
            case "InAudit":
                $status = "审核中";
                break;
            case "Approved":
                $status = "已实名认证";
                break;
            case "Reject":
                $status = $Info["RealNameAuditUnpassReason"];
                break;
            default:
                return ["status" => 1, "info" => ["域名" => $Info["DomainName"], "注册时间" => $Info["CreationDate"], "到期时间" => $Info["ExpirationDate"], "实名状态" => $status, "所有中（中文）" => $Info["ContactInfo"]["OrganizationNameCN"], "所有者（英文）" => $Info["ContactInfo"]["OrganizationName"], "电子邮箱" => $Info["ContactInfo"]["Email"], "手机号" => $Info["ContactInfo"]["Telephone"]]];
        }
    }
    private function TemplateData($data)
    {
        $status = "未知";
        switch ($data["AuditStatus"]) {
            case "NotUpload":
                $status = "未实名认证";
                break;
            case "InAudit":
                $status = "审核中";
                break;
            case "Approved":
                $status = "已实名认证";
                break;
            case "Reject":
                $status = $data["AuditReason"];
                break;
            default:
                return ["TemplateId" => $data["TemplateId"], "Email" => $data["ContactInfo"]["Email"], "RegistrantType" => $data["ContactInfo"]["RegistrantType"] == "E" ? 2 : 1, "ZhRegistrantOrganization" => $data["ContactInfo"]["OrganizationNameCN"], "ZhRegistrantName" => $data["ContactInfo"]["RegistrantNameCN"], "RegistrantOrganization" => $data["ContactInfo"]["OrganizationName"], "RegistrantName" => $data["ContactInfo"]["RegistrantName"], "Province" => "zhe jiang", "City" => "hang zhou shi", "Address" => "zhe jiang sheng hang zhou shi shang cheng qu 10001 hao", "Country" => "CN", "TelArea" => "86", "Telephone" => $data["ContactInfo"]["Telephone"], "TelExt" => "1234", "PostalCode" => "310024", "IdentityCredentialType" => $data["CertificateInfo"]["CertificateType"], "IdentityCredentialNo" => $data["CertificateInfo"]["CertificateCode"], "RegistrantProfilePic" => $data["CertificateInfo"]["ImgUrl"], "AuditStatus" => $status];
        }
    }
    public function DescribeTemplate($query)
    {
        $r = $this->get("DescribeTemplate", ["TemplateId" => $query["vid"]]);
        if ($r["status"] == 1) {
            $status = "未知";
            switch ($r["info"]["Template"]["AuditStatus"]) {
                case "NotUpload":
                    $status = "未实名认证";
                    break;
                case "InAudit":
                    $status = "审核中";
                    break;
                case "Approved":
                    $status = "已实名认证";
                    break;
                case "Reject":
                    $status = $r["info"]["Template"]["AuditReason"];
                    break;
                default:
                    $r["AuditStatus"] = $status;
                    return ["status" => 1, "AuditStatus" => $status, "info" => $this->TemplateData($r["info"]["Template"])];
            }
        } else {
            return $r;
        }
    }
    public function DescribeTemplateList($Offset)
    {
        $r = $this->get("DescribeTemplateList", ["Offset" => $Offset * 100, "Limit" => 100]);
        if ($r["status"] != 1) {
            return $r;
        }
        $info = ["status" => 1, "info" => ["TemplateSet" => [], "TotalCount" => $r["info"]["TotalCount"]]];
        foreach ($r["info"]["TemplateSet"] as $key => $value) {
            $info["info"]["TemplateSet"][] = $this->TemplateData($value);
        }
        return $info;
    }
    private function SaveBatchTaskForCreatingOrderRenew($query)
    {
        $QueryDomainList = $this->QueryDomainList(["DomainName" => $query["OrderRenewParam.1.DomainName"]]);
        if ($QueryDomainList["status"] != 1) {
            return $QueryDomainList;
        }
        $r = $this->get("RenewDomainBatch", ["Domains" => [$query["OrderRenewParam.1.DomainName"]], "Period" => intval($query["OrderRenewParam.1.SubscriptionDuration"]), "PayMode" => 1]);
        if ($r["status"] == 1) {
            $r["info"]["TaskNo"] = $r["info"]["LogId"];
            $r["info"]["expiredate"] = date("Y-m-d H:i:s", strtotime("+" . $query["OrderRenewParam.1.SubscriptionDuration"] . " year", strtotime($QueryDomainList["info"]["Data"]["Domain"][0]["ExpirationDate"])));
        }
        return $r;
    }
}

?>