<?php
namespace addons\qcloud_dominbygzhx;

use Exception;
use think\Db;

class DominbygzhxClass
{
    public static function DownloadFile($file, $destination)
    {
        set_time_limit(0);
        $fp = fopen((string) $destination, "w+");
        $ch = curl_init(str_replace(" ", "%20", $file));
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLOPT_FILE, $fp);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_exec($ch);
        curl_close($ch);
        fclose($fp);
    }
    public static function UnZip($file, $destination)
    {
        $zip = new \ZipArchive();
        if ($zip->open($file) === true) {
            try {
                $zip->extractTo($destination);
                $zip->close();
                return true;
            } catch (Exception $exception) {
                $zip->close();
                return false;
            }
        } else {
            return false;
        }
    }
    public static function error($str, $code = 0)
    {
        echo json_encode(["status" => $code, "info" => $str]);
        exit;
    }
    public static function outSuccess($data)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $data]);
        exit;
    }
    public static function success($data)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $data]);
        exit;
    }
    public static function ToDate($year)
    {
        $date = NULL;
        switch ($year) {
            case "annually":
                $date = "1年";
                break;
            case "biennially":
                $date = "2年";
                break;
            case "triennially":
                $date = "3年";
                break;
            case "fourly":
                $date = "4年";
                break;
            case "fively":
                $date = "5年";
                break;
            default:
                $date = NULL;
                return $date;
        }
    }
    public static function SavePrice($PayPrice, $HostId, $User, $description)
    {
        Db::startTrans();
        try {
            $InvoicesId = Db::name("Invoices")->insertGetId(["uid" => $User["id"], "invoice_num" => date("YmdHis") . mt_rand(10000, 999999), "create_time" => time(), "subtotal" => $PayPrice, "status" => "Paid", "credit" => $PayPrice, "payment" => "UserCustom", "type" => "product"]);
            $OrdersId = Db::name("Orders")->insertGetId(["uid" => $User["id"], "ordernum" => date("YmdHis") . mt_rand(10000, 999999), "status" => "Pending", "pay_time" => time(), "amount" => $PayPrice, "payment" => "UserCustom", "invoiceid" => $InvoicesId]);
            $InvoicesItemsId = Db::name("InvoiceItems")->insertGetId(["uid" => $User["id"], "invoice_id" => $InvoicesId, "description" => $description, "rel_id" => $HostId, "amount" => $PayPrice, "payment" => "UserCustom", "type" => "host"]);
            $CreditId = Db::name("Credit")->insertGetId(["uid" => $User["id"], "create_time" => time(), "description" => "Credit Applied to Invoice #" . $InvoicesId, "relid" => $InvoicesId, "amount" => $PayPrice]);
            $add = ["uid" => $User["id"], "type" => "normal", "relid" => $InvoicesItemsId, "new_cycle" => "monthly", "new_recurring_amount" => $PayPrice, "status" => "Pending", "paid" => "Y", "create_time" => time()];
            $HostId = Db::name("RenewCycle")->insertGetId($add);
            Db::name("Clients")->where("id", "EQ", $User["id"])->setDec("credit", $PayPrice);
            Db::commit();
            return $HostId;
        } catch (Exception $e) {
            Db::rollback();
            return false;
        }
    }
    public static function AliYunDeCode()
    {
        $encryptedData = $_POST;
        if (empty($encryptedData["iv"])) {
            $postdata = $encryptedData;
        } else {
            $edata = openssl_decrypt(base64_decode($encryptedData["data"]), "aes-128-cbc", "A89VB9PXBXJZ7812", true, $encryptedData["iv"]);
            $postdata = json_decode($edata, true);
        }
        if (empty($postdata)) {
            exit(json_encode(["status" => 0, "info" => "参数错误"]));
        }
        return $postdata;
    }
    public static function path()
    {
        return dirname(__FILE__);
    }
    public static function sdk()
    {
        $SDK = file_exists(dirname(__FILE__) . "/QCloud/TCloudAutoLoader.php");
        return $SDK;
    }
    public static function init()
    {
        if (!class_exists("qcloud_dominbygzhx_class")) {
            require_once dirname(__FILE__) . "/qcloud_dominbygzhx_class.php";
        }
        $QCloud = new QCloudDomain();
        return $QCloud;
    }
}

?>