<?php
define("QCLOUDAPI_ROOT_PATH", dirname(__FILE__) . "/QCloud/src/QcloudApi");
class qcloud_dominbygzhx_dns
{
    private $uid = "";
    private $APiKey = "";
    private $ApiUrl = "https://api.west.cn/api/v2";
    public $ttl = 600;
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = $data["ak"];
    }
    public function get($action, $option = [])
    {
        $moduleName = "cns";
        $moduleName = ucfirst($moduleName);
        $moduleClassFile = QCLOUDAPI_ROOT_PATH . "/Module/" . $moduleName . ".php";
        if (!file_exists($moduleClassFile)) {
            return ["status" => 0, "info" => $moduleClassFile . "不存在"];
        }
        require_once $moduleClassFile;
        $moduleClassName = "QcloudApi_Module_" . $moduleName;
        $moduleInstance = new $moduleClassName();
        $moduleInstance->setConfig(["SecretId" => $this->uid, "SecretKey" => $this->APiKey, "RequestMethod" => "GET"]);
        $result = $moduleInstance->{$action}($option);
        if ($result === false) {
            $error = $moduleInstance->getError();
            return ["status" => 0, "info" => "错误码：" . $error->getCode() . "，原因：" . $error->getMessage()];
        }
        return ["status" => 1, "info" => $result];
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data)
    {
        return $this->{$Action}($query);
    }
    public function GetRecords($DomainName, $page = 1)
    {
        $r = $this->get("RecordList", ["domain" => $DomainName, "offset" => ($page - 1) * 20, "length" => 20]);
        if ($r["status"] != 1) {
            return $r;
        }
        $result = ["status" => 1, "info" => ["records" => [], "count" => $r["info"]["data"]["info"]["record_total"]]];
        foreach ($r["info"]["data"]["records"] as $k => $v) {
            if (strtoupper($v["type"]) != "NS") {
                $result["info"]["records"][] = ["RR" => $v["name"], "Line" => $this->Line()[$v["line"]], "Type" => $v["type"], "Value" => $v["value"], "TTL" => $v["ttl"], "Status" => intval($v["enabled"]) == 1 ? "ENABLE" : "", "RecordId" => $v["id"], "Priority" => $v["mx"]];
            }
        }
        return $result;
    }
    public function Line()
    {
        return ["默认" => "默认", "电信" => "中国电信", "联通" => "中国联通", "移动" => "中国移动", "教育网" => "教育网", "搜索引擎" => "搜索引擎"];
    }
    public function recordType()
    {
        return ["A" => "A", "CNAME" => "CNAME", "MX" => "MX", "TXT" => "TXT"];
    }
    public function DescribeDomainRecords($query)
    {
        $r = $this->GetRecords($query["DomainName"]);
        if ($r["status"] != 1) {
            return $r;
        }
        $totalpages = $r["info"]["totalpages"];
        $Records = $r["info"];
        if (1 < $totalpages) {
            for ($i = 2; $i <= $totalpages; $i++) {
                $rr = $this->GetRecords($query["DomainName"], $i);
                if ($rr["status"] == 1) {
                    $Records = array_merge($Records, $rr["info"]);
                }
            }
        }
        return ["status" => 1, "info" => ["DomainRecords" => ["Record" => $Records]]];
    }
    public function AddDomainRecord($query)
    {
        $r = $this->get("RecordCreate", ["domain" => $query["DomainName"], "subDomain" => $query["RR"], "recordType" => $query["Type"], "value" => $query["Value"], "ttl" => $query["TTL"], "mx" => $query["Priority"], "recordLine" => $query["Line"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => ["RecordId" => $r["info"]["data"]["record"]["id"]]];
    }
    public function UpdateDomainRecord($query)
    {
        $r = $this->get("RecordModify", ["domain" => $query["DomainName"], "recordId" => $query["RecordId"], "subDomain" => $query["RR"], "recordType" => $query["Type"], "value" => $query["Value"], "ttl" => $query["TTL"], "mx" => $query["Priority"], "recordLine" => $query["Line"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => ["RecordId" => $query["RecordId"]]];
    }
    public function SetDomainRecordStatus($query)
    {
        $config = ["domain" => $query["DomainName"], "recordId" => $query["RecordId"], "status" => $query["Status"] == "Enable" ? "enable" : "disable"];
        $r = $this->get("RecordStatus", $config);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => "修改成功"];
    }
    public function DeleteDomainRecord($query)
    {
        $r = $this->get("RecordDelete", ["domain" => $query["DomainName"], "recordId" => $query["RecordId"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => "删除成功"];
    }
    public function DescribeDomainNs($query)
    {
    }
    private function AddDomain($query)
    {
        $r = $this->get("DomainCreate", ["domain" => $query["DomainName"]]);
        return $r;
    }
}

?>