<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Lighthouse\V20200324\Models;
use TencentCloud\Common\AbstractModel;

/**
 * CreateInstanceSnapshot请求参数结构体
 *
 * @method string getInstanceId() 获取需要创建快照的实例 ID。
 * @method void setInstanceId(string $InstanceId) 设置需要创建快照的实例 ID。
 * @method string getSnapshotName() 获取快照名称，最长为 60 个字符。
 * @method void setSnapshotName(string $SnapshotName) 设置快照名称，最长为 60 个字符。
 */
class CreateInstanceSnapshotRequest extends AbstractModel
{
    /**
     * @var string 需要创建快照的实例 ID。
     */
    public $InstanceId;

    /**
     * @var string 快照名称，最长为 60 个字符。
     */
    public $SnapshotName;

    /**
     * @param string $InstanceId 需要创建快照的实例 ID。
     * @param string $SnapshotName 快照名称，最长为 60 个字符。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("InstanceId",$param) and $param["InstanceId"] !== null) {
            $this->InstanceId = $param["InstanceId"];
        }

        if (array_key_exists("SnapshotName",$param) and $param["SnapshotName"] !== null) {
            $this->SnapshotName = $param["SnapshotName"];
        }
    }
}
