<?php
namespace addons\qing_ye_firewall\common;

class JinDun
{
    public function setCc($param)
    {
        $Cookie = $this->getCookie($param);
        if (!$Cookie["status"]) {
            return $Cookie;
        }
        $Cookie = $Cookie["Cookie"];
        $protect = $this->protect($param["ip"], $Cookie, $param["host"], true, $param["data"]["ignore"], $param["data"]["forbid"], $param["data"]["foreign"], $param["data"]["param_set"], $param["data"]["filter_set"], $param["data"]["set_udp"], $param["data"]["set_tcp"]);
        if (!$protect) {
            return ["status" => 0, "msg" => "CC策略添加失败"];
        }
        return ["status" => 1, "msg" => ""];
    }
    public function linknum($param)
    {
        $Cookie = $this->getCookie($param);
        if (!$Cookie["status"]) {
            return $Cookie;
        }
        $Cookie = $Cookie["Cookie"];
        $url = $param["host"] . "/cgi-bin/status_host.cgi?hostaddr=" . $param["ip"];
        $res = $this->urlGet($url, $Cookie);
        $xml_array = simplexml_load_string($res);
        foreach ($xml_array->host as $value) {
            if ($value->address == $param["ip"]) {
                $xml_ = $value;
            }
        }
        if (!empty($xml_)) {
            return ["status" => 1, "msg" => "", "data" => json_decode(json_encode($xml_), true)];
        }
        return ["status" => 0, "msg" => "查询失败！"];
    }
    public function rateview($param)
    {
        $Cookie = $this->getCookie($param);
        if (!$Cookie["status"]) {
            return $Cookie;
        }
        $Cookie = $Cookie["Cookie"];
        $level = "2";
        $width = "792";
        $height = "120";
        $url = $param["host"] . "/cgi-bin/rateview.cgi?level=" . $level . "&width=" . $width . "&height=" . $height . "&address=" . $param["ip"] . "&rand=" . rand();
        $res = $this->urlGet($url, $Cookie);
        return ["status" => 1, "msg" => "", "data" => $res];
    }
    public function ipWhite($param, $type)
    {
        $Cookie = $this->getCookie($param);
        if (!$Cookie["status"]) {
            return $Cookie;
        }
        $Cookie = $Cookie["Cookie"];
        $url = $param["host"] . "/cgi-bin/status_bwlist.cgi";
        if ($type == "submit") {
            $data = ["param_submit_type" => "submit", "param_address" => "+" . $param["web_ip"], "param_comments" => "uid:" . $param["uid"] . "ip:" . $param["ip"]];
        } else {
            $data = ["param_submit_type" => "delete", "param_address" => $param["web_ip"]];
        }
        $res = $this->post($url, $data, 0, $Cookie);
        $xml_array = simplexml_load_string($res);
        if (!empty($xml_array->delay) && $xml_array->delay == "1") {
            return ["status" => 1, "msg" => ""];
        }
        return ["status" => 0, "msg" => "IP白名单操作失败！"];
    }
    public function release($param)
    {
        $Cookie = $this->getCookie($param);
        if (!$Cookie["status"]) {
            return $Cookie;
        }
        $Cookie = $Cookie["Cookie"];
        $url = $param["host"] . "/cgi-bin/status_fblink.cgi";
        $data = ["param_submit_type" => "reset", "param_filter" => $param["ip"], "param_page" => 0];
        $res = $this->post($url, $data, 0, $Cookie);
        $xml_array = simplexml_load_string($res);
        if (!empty($xml_array->delay) && $xml_array->delay == "1") {
            return ["status" => 1, "msg" => ""];
        }
        return ["status" => 0, "msg" => "操作失败！"];
    }
    private function getCookie($param)
    {
        $firewallId = $param["firewallId"];
        $firewallName = $param["firewallName"];
        $host = $param["host"];
        $cacheName = $firewallId . "," . $firewallName . $host;
        $Cookie = cache($cacheName);
        if (!$Cookie) {
            $url = $host . "/cgi-bin/login.cgi";
            $data = ["param_type" => "login", "param_username" => $param["user"], "param_password" => $param["password"]];
            $res = $this->post($url, $data, 1, "language=zh-cn");
            if (!$res) {
                return ["status" => 0, "msg" => "防火墙状态码返回非200"];
            }
            $error = $this->get_between($res, "<info>", "</info>");
            if ($error) {
                return ["status" => 0, "msg" => $error];
            }
            preg_match("/.*?Set\\-Cookie: ([^\r\n]*)/i", $res, $matches);
            $Cookie = empty($matches[1]) ? [] : $matches[1] . ";language=zh-cn";
            if (empty($Cookie)) {
                return ["status" => 0, "msg" => "登录失败"];
            }
            cache($cacheName, $Cookie, 3600);
        }
        return ["status" => 1, "msg" => "", "Cookie" => $Cookie];
    }
    private function post($url, $param, $isShowHeader = 0, $cookie = "")
    {
        $oCurl = curl_init();
        if (stripos($url, "https://") !== false) {
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_SSLVERSION, 1);
        }
        if (is_string($param)) {
            $strPOST = $param;
        } else {
            $aPOST = [];
            foreach ($param as $key => $val) {
                $aPOST[] = $key . "=" . urlencode($val);
            }
            $strPOST = join("&", $aPOST);
        }
        curl_setopt($oCurl, CURLOPT_URL, $url);
        curl_setopt($oCurl, CURLOPT_HEADER, $isShowHeader);
        curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($oCurl, CURLOPT_POST, true);
        curl_setopt($oCurl, CURLOPT_POSTFIELDS, $strPOST);
        if ($cookie) {
            curl_setopt($oCurl, CURLOPT_COOKIE, $cookie);
        }
        $sContent = curl_exec($oCurl);
        $aStatus = curl_getinfo($oCurl);
        curl_close($oCurl);
        if (intval($aStatus["http_code"]) == 200) {
            return $sContent;
        }
        return false;
    }
    private function urlGet($url, $cookie = "")
    {
        $oCurl = curl_init();
        if (stripos($url, "https://") !== false) {
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_SSLVERSION, 1);
        }
        curl_setopt($oCurl, CURLOPT_URL, $url);
        curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
        if ($cookie) {
            curl_setopt($oCurl, CURLOPT_COOKIE, $cookie);
        }
        $sContent = curl_exec($oCurl);
        $aStatus = curl_getinfo($oCurl);
        curl_close($oCurl);
        if (intval($aStatus["http_code"]) == 200) {
            return $sContent;
        }
        return false;
    }
    private function get_between($input, $start, $end)
    {
        $substr = substr($input, strlen($start) + strpos($input, $start), (strlen($input) - strpos($input, $end)) * -1);
        return $substr;
    }
    private function protect($ip, $cookie, $Url, $protect = false, $ignore = false, $forbid = false, $foreign = 3, $param_set = "", $filter_set = "", $set_udp = "", $set_tcp = "")
    {
        $url = $Url . "/cgi-bin/status_hostset.cgi?hostaddr=" . $ip;
        $res = $this->urlGet($url, $cookie);
        $xml_array = simplexml_load_string($res);
        $xml_array = json_decode(json_encode($xml_array), true);
        $data = $this->param_data($xml_array);
        $data["param_setting_addr"] = $ip;
        $data["param_exist"] = "ON";
        if ($protect) {
            $data["param_force_protect"] = "ON";
        }
        if ($ignore) {
            $data["param_ignore"] = "ON";
        }
        if ($forbid) {
            $data["param_forbid"] = "ON";
        } else {
            $data["param_forbid"] = "";
        }
        if ($foreign == 1) {
            $data["param_reject_foreign_access"] = "ON";
        } else {
            if ($foreign == 0 && !empty($data["param_reject_foreign_access"])) {
                $data["param_reject_foreign_access"] = "";
            }
        }
        if (empty($data["param_flowlimit_incoming_bps"])) {
            $data["param_flowlimit_incoming_bps"] = "";
        }
        if (empty($data["param_flowlimit_incoming_pps"])) {
            $data["param_flowlimit_incoming_pps"] = "";
        }
        if (empty($data["param_flowlimit_outgoing_bps"])) {
            $data["param_flowlimit_outgoing_bps"] = "";
        }
        if (empty($data["param_flowlimit_outgoing_pps"])) {
            $data["param_flowlimit_outgoing_pps"] = "";
        }
        if ($param_set != "") {
            $data["param_param_set"] = $param_set;
        }
        if ($filter_set != "") {
            $data["param_filter_set"] = $filter_set;
        }
        if ($set_udp != "") {
            $data["param_portpro_set_udp"] = $set_udp;
        }
        if ($set_tcp != "") {
            $data["param_portpro_set_tcp"] = $set_tcp;
        }
        $url = $Url . "/cgi-bin/status_hostset.cgi";
        $res = $this->post($url, $data, 0, $cookie);
        $xml_array = simplexml_load_string($res);
        if (!empty($xml_array->delay) && $xml_array->delay == "1") {
            return true;
        }
        return false;
    }
    private function param_data($array)
    {
        $param = $array;
        $arr = [];
        foreach ($param as $k => $v) {
            if (!($k == "plugin" || $k == "captured_files" || $k == "setting_address" || $k == "address" || $k == "ignore")) {
                if ($v) {
                    switch ($k) {
                        case "flow_incoming_bps":
                            $k = "flowlimit_incoming_bps";
                            break;
                        case "flow_incoming_pps":
                            $k = "flowlimit_incoming_pps";
                            break;
                        case "flow_outgoing_bps":
                            $k = "flowlimit_outgoing_bps";
                            break;
                        case "flow_outgoing_pps":
                            $k = "flowlimit_outgoing_pps";
                            break;
                        case "reject_foreign":
                            $k = "reject_foreign_access";
                            break;
                        default:
                            if ($v == "checked") {
                                $v = "ON";
                            }
                            $arr["param_" . $k] = $v;
                    }
                }
            }
        }
        $param2 = $array["plugin"];
        foreach ($param2 as $kk => $vv) {
            if ($vv["enabled"]) {
                $arr["param_plugin_" . $vv["protocol"] . "_" . $vv["id"]] = "ON";
            }
        }
        return $arr;
    }
}

?>