<?php
namespace addons\qing_ye_firewall\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
    }
    public function ipWhite()
    {
        $param = $this->request->param();
        if ($this->request->isPost()) {
            $ip = $param["ip"];
            $web_ip = $param["web_ip"];
            if (empty($ip) || empty($web_ip)) {
                return json(["status" => 0, "msg" => "非法访问！"]);
            }
            $productId = \think\Db::name("host")->where(["domainstatus" => "Active"])->where("FIND_IN_SET('" . $ip . "',`assignedips`) OR  `dedicatedip`='" . $ip . "'")->field("productid,id,uid")->find();
            if (!$productId["productid"]) {
                return json(["status" => 0, "msg" => "非法访问！"]);
            }
            $firewall_m = \think\Db::name("qing_ye_firewall")->alias("a")->where("a.status", 1)->where("FIND_IN_SET('" . $productId["productid"] . "',a.range)")->field("a.id firewallId,a.name firewallName,a.host,a.user,a.password,a.brand,a.data firewallData")->select();
            if (!$firewall_m) {
                return json(["status" => 0, "msg" => "非法访问！"]);
            }
            $firewall_arr["host_id"] = $productId["id"];
            $firewall_arr["product_id"] = $productId["productid"];
            $firewall_arr["uid"] = $productId["uid"];
            $firewall_arr["data"] = $firewall_m;
            $i = 0;
            foreach ($firewall_arr["data"] as $k => $v) {
                $className = $this->getClassName($v["brand"]);
                $v["data"] = json_decode($v["data"], true);
                $v["firewallData"] = json_decode($v["firewallData"], true);
                $v["ip"] = $param["ip"];
                $v["web_ip"] = $param["web_ip"];
                $v["uid"] = $firewall_arr["uid"];
                $class = "\\addons\\qing_ye_firewall\\common\\" . ucfirst($className);
                $firewall = new $class();
                $setCc = $firewall->ipWhite($v, "submit");
                if ($setCc["status"]) {
                    $ipWhite = \think\Db::name("qing_ye_firewall_cc_ipwhite");
                    $where = ["ip" => $param["ip"], "web_ip" => $param["web_ip"], "uid" => $firewall_arr["uid"], "host_id" => $firewall_arr["host_id"], "firewall_id" => $v["firewallId"]];
                    if ($ipWhite->where($where)->count()) {
                        if ($ipWhite->where($where)->update(["update_time" => time(), "status" => 1])) {
                            $i++;
                        }
                    } else {
                        $where["status"] = 1;
                        $where["create_time"] = time();
                        $where["update_time"] = $where["create_time"];
                        if ($ipWhite->data($where)->insert()) {
                            $i++;
                        }
                    }
                }
            }
            $ret = ["status" => 0, "msg" => "非法访问！"];
            if (count($firewall_arr["data"]) == 1) {
                if ($i == count($firewall_arr["data"])) {
                    $ret = ["status" => 1, "msg" => "添加成功。"];
                } else {
                    $ret = ["status" => 0, "msg" => "添加失败！"];
                }
            } else {
                if (1 < count($firewall_arr["data"]) && 0 < $i) {
                    $count = count($firewall_arr["data"]);
                    $ret = ["status" => 1, "msg" => "成功添加 " . $i . " 个防火墙，次商品共有 " . $count . " 个防火墙"];
                }
            }
            return json($ret);
        } else {
            $page = !empty($param["page"]) ? intval($param["page"]) : 1;
            $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
            $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
            $list = \think\Db::name("qing_ye_firewall_cc_ipwhite")->alias("a")->join("host w", "a.host_id=w.id")->join("qing_ye_firewall f", "f.id=a.firewall_id")->where("w.domainstatus", "Active")->where("a.status", 1)->order("a.id", "desc")->where("a.firewall_id|a.uid|a.ip|web_ip", "like", "%" . $keywords . "%")->field("a.firewall_id,a.uid,a.ip,a.create_time,a.update_time,a.host_id,a.web_ip,a.id,f.name firewallName")->paginate($limit);
            $all = \think\Db::name("qing_ye_firewall_cc_ipwhite")->alias("a")->join("host w", "a.host_id=w.id")->where("w.domainstatus", "Active")->where("a.status", 1)->where("a.firewall_id|a.ip|web_ip", "like", "%" . $keywords . "%")->field("a.id")->all();
            $count = count($all);
            $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeFirewall://AdminIndex/ipWhite"));
            $this->assign("pages", $pages);
            $this->assign("keywords", $keywords);
            $this->assign("list", $list);
            $this->assign("selected_cc_ipWhite", "selected");
            $firewall = \think\Db::name("qing_ye_firewall")->where("status", 1)->field("range")->select();
            $range = "";
            foreach ($firewall as $k => $v) {
                $range .= $v["range"] . ",";
            }
            $range = substr($range, 0, strlen($range) - 1);
            $host_ip = \think\Db::name("host")->where(["domainstatus" => "Active"])->order("id", "desc")->where("productid", "in", $range)->field("dedicatedip,assignedips,id")->select();
            $this->assign("host_ip", $host_ip);
            return $this->fetch("/ipwhite");
        }
    }
    public function DeleteIpWhite()
    {
        $param = $this->request->param();
        $ipWhite = \think\Db::name("qing_ye_firewall_cc_ipwhite")->alias("a")->join("qing_ye_firewall w", "w.id=a.firewall_id")->where("a.status", 1)->where("w.status", 1)->where("a.id", $param["id"])->field("a.id,w.id firewallId,w.name firewallName,w.host,w.user,w.password,w.brand,w.data firewallData,a.web_ip,uid")->find();
        if (!$ipWhite) {
            return json(["status" => 0, "msg" => "非法访问！"]);
        }
        $ipWhite["data"] = json_decode($ipWhite["data"], true);
        $ipWhite["firewallData"] = json_decode($ipWhite["firewallData"], true);
        $className = $this->getClassName($ipWhite["brand"]);
        $class = "\\addons\\qing_ye_firewall\\common\\" . ucfirst($className);
        $firewall = new $class();
        $setCc = $firewall->ipWhite($ipWhite, "delete");
        if ($setCc["status"]) {
            if (\think\Db::name("qing_ye_firewall_cc_ipwhite")->where(["id" => $param["id"], "uid" => $ipWhite["uid"]])->update(["update_time" => time(), "status" => -1])) {
                $ret = json(["status" => 1, "msg" => "删除成功。"]);
            } else {
                $ret = json(["status" => 0, "msg" => "删除失败！"]);
            }
        } else {
            $ret = json(["status" => 0, "msg" => "系统错误！"]);
        }
        return $ret;
    }
    public function setting()
    {
        $params = $this->request->param();
        $page = !empty($params["page"]) ? intval($params["page"]) : 1;
        $limit = !empty($params["limit"]) ? intval($params["limit"]) : 10;
        $keywords = !empty($params["keywords"]) ? $params["keywords"] : "";
        $list = \think\Db::name("qing_ye_firewall")->where("status", "<>", -1)->order("id", "desc")->where("name|host", "like", "%" . $keywords . "%")->paginate($limit);
        $count = count(\think\Db::name("qing_ye_firewall")->where("status", "<>", -1)->where("name|host", "like", "%" . $keywords . "%")->all());
        $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeFirewall://AdminIndex/setting"));
        $this->assign("pages", $pages);
        $this->assign("keywords", $keywords);
        $this->assign("list", $list);
        $this->assign("selected_default", "selected");
        return $this->fetch("/setting");
    }
    public function addFirewall()
    {
        $id = intval($this->request->param("id"));
        if ($this->request->isPost()) {
            $param = $this->request->param();
            $data["name"] = $param["name"];
            $data["brand"] = intval($param["brand"]);
            $data["host"] = $param["host"];
            $data["user"] = $param["user"];
            $data["password"] = $param["password"];
            $data["range"] = implode(",", $param["range"]);
            $data["status"] = $param["status"] == "on" ? 1 : 0;
            $data["create_time"] = time();
            $data["update_time"] = $data["create_time"];
            if ($param["brand"] == 1) {
                $json["foreign"] = $param["foreign"] == "on" ? 1 : 0;
                $json["ignore"] = $param["ignore"] == "on" ? 1 : 0;
                $json["forbid"] = $param["forbid"] == "on" ? 1 : 0;
                $json["param_set"] = intval($param["param_set"]) . "";
                $json["filter_set"] = intval($param["filter_set"]) . "";
                $json["set_udp"] = intval($param["set_udp"]) . "";
                $json["set_tcp"] = intval($param["set_tcp"]) . "";
                $data["data"] = json_encode($json);
            }
            if ($id) {
                if (\think\Db::name("qing_ye_firewall")->where("status", "<>", -1)->where("id", $id)->update($data)) {
                    $this->assign("SuccessMsg", "修改成功。");
                    $this->assign("SuccessUrl", shd_addon_url("QingYeFirewall://AdminIndex/setting"));
                } else {
                    $this->assign("ErrorMsg", "修改失败！");
                }
            } else {
                if (\think\Db::name("qing_ye_firewall")->data($data)->insert()) {
                    $this->assign("SuccessMsg", "添加成功。");
                    $this->assign("SuccessUrl", shd_addon_url("QingYeFirewall://AdminIndex/setting"));
                } else {
                    $this->assign("ErrorMsg", "添加失败！");
                }
            }
        }
        if ($id) {
            $list = \think\Db::name("qing_ye_firewall")->where("status", "<>", -1)->where("id", $id)->find();
            $list["data"] = json_decode($list["data"], true);
            $list["range"] = explode(",", $list["range"]);
            $this->assign("data", $list);
        }
        $product_groups = \think\Db::name("product_groups")->field("id,name")->select()->toArray();
        $products = \think\Db::name("products")->field("id,name,gid")->select()->toArray();
        $res_products = [];
        foreach ($products as $k => $v) {
            $res_products[$v["gid"]][] = $v;
        }
        $this->assign("productgroups", $product_groups);
        $this->assign("res_products", $res_products);
        $this->assign("selected_default", "selected");
        return $this->fetch("/add_firewall");
    }
    public function delete()
    {
        $ret = ["msg" => "系统错误"];
        if ($this->request->isPost()) {
            $id = $this->request->param("id");
            $i = 0;
            if ($id) {
                foreach ($id as $v) {
                    $m = \think\Db::name("qing_ye_firewall")->where("id", $v)->update(["status" => -1]);
                    if ($m == 1) {
                        $i++;
                    }
                }
                $ret["status"] = 1;
                $ret["msg"] = "成功删除" . $i . "条数据";
            } else {
                $ret["msg"] = "请勾选需要删除的数据！";
            }
        }
        return json($ret);
    }
    public function setCc()
    {
        $param = $this->request->param();
        $page = !empty($param["page"]) ? intval($param["page"]) : 1;
        $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
        $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
        $id = intval($this->request->param("id"));
        if ($this->request->isPost()) {
            $data["name"] = $param["name"];
            $data["brand"] = intval($param["brand"]);
            $data["sortID"] = intval($param["sortID"]);
            $data["firewall"] = implode(",", $param["firewall"]);
            $data["status"] = $param["status"] == "on" ? 1 : 0;
            $data["create_time"] = time();
            $data["update_time"] = $data["create_time"];
            if ($param["brand"] == 1) {
                $json["foreign"] = $param["foreign"] == "on" ? 1 : 0;
                $json["ignore"] = $param["ignore"] == "on" ? 1 : 0;
                $json["forbid"] = $param["forbid"] == "on" ? 1 : 0;
                $json["param_set"] = intval($param["param_set"]) . "";
                $json["filter_set"] = intval($param["filter_set"]) . "";
                $json["set_udp"] = intval($param["set_udp"]) . "";
                $json["set_tcp"] = intval($param["set_tcp"]) . "";
                $data["data"] = json_encode($json);
            }
            if ($id) {
                unset($data["create_time"]);
                if (\think\Db::name("qing_ye_firewall_cc_list")->where("status", "<>", -1)->where("id", $id)->update($data)) {
                    return json(["status" => 1, "msg" => "修改成功。"]);
                }
                return json(["status" => 0, "msg" => "修改失败！"]);
            }
            if (\think\Db::name("qing_ye_firewall_cc_list")->data($data)->insert()) {
                return json(["status" => 1, "msg" => "添加成功。"]);
            }
            return json(["status" => 0, "msg" => "添加失败！"]);
        }
        $sort = \think\Db::name("qing_ye_firewall_cc_list")->where("status", "<>", -1)->field("id,name")->order("sortID asc,id asc")->select();
        $this->assign("sort", $sort);
        $firewall_list = \think\Db::name("qing_ye_firewall")->where("status", "<>", -1)->field("id,name")->select();
        if ($this->request->isAjax() && $this->request->isGet() && $id) {
            $list = \think\Db::name("qing_ye_firewall_cc_list")->where("status", "<>", -1)->where("id", $id)->find();
            $list["firewall_list"] = $firewall_list;
            $list["data"] = json_decode($list["data"], true);
            return json($list);
        }
        $list = \think\Db::name("qing_ye_firewall_cc_list")->where("status", "<>", -1)->order("id", "desc")->where("name|id", "like", "%" . $keywords . "%")->paginate($limit);
        $firewall = \think\Db::name("qing_ye_firewall")->select()->toarray();
        $firewall = array_column($firewall, NULL, "id");
        $this->assign("firewall", $firewall);
        $count = count(\think\Db::name("qing_ye_firewall_cc_list")->where("status", "<>", -1)->where("name|id", "like", "%" . $keywords . "%")->all());
        $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeFirewall://AdminIndex/setCc"));
        $this->assign("pages", $pages);
        $this->assign("keywords", $keywords);
        $this->assign("list", $list);
        $this->assign("firewall_list", $firewall_list);
        $this->assign("selected_cc", "selected");
        return $this->fetch("/set_cc");
    }
    public function sort()
    {
        $param = $this->request->param();
        $ids = explode(",", $param["ids"]);
        foreach ($ids as $key => $value) {
            $res = \think\Db::name("qing_ye_firewall_cc_list")->where(["id" => $value])->setField("sortID", $key + 1);
        }
        if ($res !== false) {
            return json(["status" => 1, "msg" => "排序成功。"]);
        }
        return json(["status" => 0, "msg" => "排序失败！"]);
    }
    public function ccDelete()
    {
        $ret = ["msg" => "系统错误"];
        if ($this->request->isPost()) {
            $id = $this->request->param("id");
            $i = 0;
            if ($id) {
                foreach ($id as $v) {
                    $m = \think\Db::name("qing_ye_firewall_cc_list")->where("id", $v)->update(["status" => -1]);
                    if ($m == 1) {
                        $i++;
                    }
                }
                $ret["status"] = 1;
                $ret["msg"] = "成功删除" . $i . "条数据";
            } else {
                $ret["msg"] = "请勾选需要删除的数据！";
            }
        }
        return json($ret);
    }
    public function ccList()
    {
        $param = $this->request->param();
        if ($this->request->isPost()) {
            $ip = $param["ip"];
            $cc = $param["cc"];
            if (empty($ip) || empty($cc)) {
                return json(["status" => 0, "msg" => "非法访问！"]);
            }
            $productId = \think\Db::name("host")->where(["domainstatus" => "Active"])->where("FIND_IN_SET('" . $ip . "',`assignedips`) OR  `dedicatedip`='" . $ip . "'")->field("productid,id,uid")->find();
            if (!$productId["productid"]) {
                return json(["status" => 0, "msg" => "非法访问！"]);
            }
            $firewall_m = \think\Db::name("qing_ye_firewall")->alias("a")->join("qing_ye_firewall_cc_list w", "FIND_IN_SET(a.id,w.firewall)")->where("a.status", 1)->where("w.status", 1)->where("FIND_IN_SET('" . $productId["productid"] . "',a.range)")->where("w.id", $cc)->field("w.id,w.name,w.data,a.id firewallId,a.name firewallName,a.host,a.user,a.password,a.brand,a.data firewallData")->select();
            if (!$firewall_m) {
                return json(["status" => 0, "msg" => "非法访问！"]);
            }
            $firewall_arr["host_id"] = $productId["id"];
            $firewall_arr["product_id"] = $productId["productid"];
            $firewall_arr["uid"] = $productId["uid"];
            $firewall_arr["data"] = $firewall_m;
            $i = 0;
            foreach ($firewall_arr["data"] as $k => $v) {
                $className = $this->getClassName($v["brand"]);
                $v["data"] = json_decode($v["data"], true);
                $v["firewallData"] = json_decode($v["firewallData"], true);
                $v["ip"] = $param["ip"];
                $class = "\\addons\\qing_ye_firewall\\common\\" . ucfirst($className);
                $firewall = new $class();
                $setCc = $firewall->setCc($v);
                if ($setCc["status"]) {
                    $record = \think\Db::name("qing_ye_firewall_cc_record");
                    $where = ["ip" => $param["ip"], "uid" => $firewall_arr["uid"], "host_id" => $firewall_arr["host_id"], "firewall_id" => $v["firewallId"]];
                    if ($record->where($where)->count()) {
                        if ($record->where($where)->update(["cc_list_id" => $v["id"], "cc_list_name" => $v["name"], "update_time" => time(), "status" => 1])) {
                            $i++;
                        }
                    } else {
                        $where["cc_list_id"] = $v["id"];
                        $where["cc_list_name"] = $v["name"];
                        $where["create_time"] = time();
                        $where["update_time"] = $where["create_time"];
                        $where["status"] = 1;
                        if ($record->data($where)->insert()) {
                            $i++;
                        }
                    }
                }
            }
            $ret = ["status" => 0, "msg" => "非法访问！"];
            if (count($firewall_arr["data"]) == 1) {
                if ($i == count($firewall_arr["data"])) {
                    $ret = ["status" => 1, "msg" => "添加成功。"];
                } else {
                    $ret = ["status" => 0, "msg" => "添加失败！"];
                }
            } else {
                if (1 < count($firewall_arr["data"]) && 0 < $i) {
                    $count = count($firewall_arr["data"]);
                    $ret = ["status" => 1, "msg" => "成功添加 " . $i . " 个防火墙，次商品共有 " . $count . " 个防火墙"];
                }
            }
            return json($ret);
        } else {
            $page = !empty($param["page"]) ? intval($param["page"]) : 1;
            $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
            $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
            $list = \think\Db::name("qing_ye_firewall_cc_record")->alias("a")->join("host w", "a.host_id=w.id")->where("w.domainstatus", "Active")->order("a.id", "desc")->where("a.firewall_id|a.uid|a.ip|a.cc_list_id|a.cc_list_name|a.host_id", "like", "%" . $keywords . "%")->field("a.firewall_id,a.uid,a.ip,a.cc_list_id,a.cc_list_name,a.create_time,a.update_time,a.host_id")->paginate($limit);
            $all = \think\Db::name("qing_ye_firewall_cc_record")->alias("a")->join("host w", "a.host_id=w.id")->where("w.domainstatus", "Active")->where("a.firewall_id|a.uid|a.ip|a.cc_list_id|a.cc_list_name|a.host_id", "like", "%" . $keywords . "%")->field("a.id")->all();
            $count = count($all);
            $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeFirewall://AdminIndex/ccList"));
            $this->assign("pages", $pages);
            $this->assign("keywords", $keywords);
            $this->assign("list", $list);
            $this->assign("selected_cc_list", "selected");
            $firewall = \think\Db::name("qing_ye_firewall")->where("status", 1)->field("range")->select();
            $range = "";
            foreach ($firewall as $k => $v) {
                $range .= $v["range"] . ",";
            }
            $range = substr($range, 0, strlen($range) - 1);
            $host_ip = \think\Db::name("host")->where(["domainstatus" => "Active"])->order("id", "desc")->where("productid", "in", $range)->field("dedicatedip,assignedips,id")->select();
            $this->assign("host_ip", $host_ip);
            return $this->fetch("/cc_list");
        }
    }
    public function GetCcType()
    {
        $param = $this->request->param();
        $ip = $param["ip"];
        $productId = \think\Db::name("host")->where(["domainstatus" => "Active"])->where("FIND_IN_SET('" . $ip . "',`assignedips`) OR  `dedicatedip`='" . $ip . "'")->field("productid")->find();
        if (!$productId["productid"]) {
            return false;
        }
        $firewall = \think\Db::name("qing_ye_firewall")->alias("a")->join("qing_ye_firewall_cc_list w", "FIND_IN_SET(a.id,w.firewall)")->where("a.status", 1)->where("w.status", 1)->where("FIND_IN_SET('" . $productId["productid"] . "',a.range)")->distinct(true)->field("w.id,w.name")->select();
        if (!$firewall) {
            return false;
        }
        return json($firewall);
    }
    public function log()
    {
        $param = $this->request->param();
        $page = !empty($param["page"]) ? intval($param["page"]) : 1;
        $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
        $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
        $list = \think\Db::name("qing_ye_firewall_log")->order("id", "desc")->where("id|uid|ip|port|data", "like", "%" . $keywords . "%")->paginate($limit);
        $count = count(\think\Db::name("qing_ye_firewall_log")->order("id", "desc")->where("id|uid|ip|port|data", "like", "%" . $keywords . "%")->all());
        $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeFirewall://AdminIndex/log"));
        $this->assign("pages", $pages);
        $this->assign("keywords", $keywords);
        $this->assign("list", $list);
        $this->assign("selected_log", "selected");
        return $this->fetch("/log");
    }
    private function pages($page, $count, $limit, $url, $listNum = 5)
    {
        $PageCount = ceil($count / $limit);
        if ($page == 1) {
            $prev = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">上一页</a></li>";
        } else {
            $prev = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . ($page - 1) . "&limit=" . $limit . "\">上一页</a></li>";
        }
        if ($page == $PageCount) {
            $next = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">下一页</a></li>";
        } else {
            $next = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . ($page + 1) . "&limit=" . $limit . "\">下一页</a></li>";
        }
        if ($page == 1) {
            $first = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">首 页</a></li>";
        } else {
            $first = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=1" . "&limit=" . $limit . "\">首 页</a></li>";
        }
        if ($page == $PageCount) {
            $last = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">尾 页</a></li>";
        } else {
            $last = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . $PageCount . "&limit=" . $limit . "\">尾 页</a></li>";
        }
        $html = "<div class=\"table-footer\"><div class=\"table-pagination\"> <span>共 " . $count . " 条</span> <div class=\"table-pageinfo\"><select class=\"form-control\" id=\"limitSel\">";
        $html .= $limit == 10 ? "<option value=\"10\" selected >10条/页</option>" : "<option value=\"10\">10条/页</option>";
        $html .= $limit == 15 ? "<option value=\"15\" selected >15条/页</option>" : " <option value=\"15\">15条/页</option>";
        $html .= $limit == 20 ? "<option value=\"20\" selected >20条/页</option>" : " <option value=\"20\">20条/页</option>";
        $html .= $limit == 25 ? "<option value=\"25\" selected >25条/页</option>" : " <option value=\"25\">25条/页</option>";
        $html .= $limit == 50 ? "<option value=\"50\" selected >50条/页</option>" : " <option value=\"50\">50条/页</option>";
        $html .= $limit == 100 ? "<option value=\"100\" selected >100条/页</option>" : "<option value=\"100\" >100条/页</option>";
        $html .= "</select></div><nav><ul class=\"pagination\">" . $first . $prev;
        $inum = floor($listNum / 2);
        for ($i = $page - $inum; $i <= $page + $inum; $i++) {
            if ($i > 0) {
                if ($PageCount >= $i) {
                    if ($i == $page) {
                        $html .= "<li class=\"page-item active\">";
                        $html .= "<a class=\"page-link\">" . $i . "</a>";
                        $html .= "</li>";
                    } else {
                        $html .= "<li class=\"page-item\">";
                        $html .= "<a class=\"page-link\" href=\"" . $url . "&page=" . $i . "&limit=" . $limit . "\">" . $i . "</a>";
                        $html .= "</li>";
                    }
                }
            }
        }
        $html .= $next . $last;
        $html .= "</ul></nav></div>";
        $html .= "<script>\$(function(){ \$('#limitSel').on('change', function () {location.href = '" . $url . "' + '&page=1&limit=' + \$('#limitSel').val();})});</script>";
        $html .= "</div>";
        return $html;
    }
    private function getClassName($brand)
    {
        switch ($brand) {
            case 1:
                $className = "JinDun";
                break;
            default:
                $className = "JinDun";
                return $className;
        }
    }
}

?>