<?php
namespace addons\qing_ye_firewall\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public function cc(\think\Request $request)
    {
        $param = $request->param();
        $hostId = $request->hostId;
        $uid = $request->uid;
        $page = !empty($param["page"]) ? intval($param["page"]) : 1;
        $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
        $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
        $list = \think\Db::name("qing_ye_firewall_cc_record")->alias("a")->join("host w", "a.host_id=w.id")->join("qing_ye_firewall f", "f.id=a.firewall_id")->where("w.domainstatus", "Active")->where("w.uid", $uid)->where("a.uid", $uid)->order("a.id", "desc")->where("a.firewall_id|a.ip|a.cc_list_name", "like", "%" . $keywords . "%")->field("a.firewall_id,a.ip,a.cc_list_name,a.create_time,a.update_time,a.host_id,f.name firewallName")->paginate($limit);
        $all = \think\Db::name("qing_ye_firewall_cc_record")->alias("a")->join("host w", "a.host_id=w.id")->join("qing_ye_firewall f", "f.id=a.firewall_id")->where("w.domainstatus", "Active")->where("w.uid", $uid)->where("a.uid", $uid)->where("a.firewall_id|a.ip|a.cc_list_name", "like", "%" . $keywords . "%")->field("a.id")->all();
        $count = count($all);
        $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeFirewall://Index/cc", [], true));
        $host_ip = $this->host_ip($uid, $hostId);
        if ($hostId && $host_ip) {
            $this->assign("dedicatedip", $host_ip[0]["dedicatedip"]);
        }
        $this->assign("pages", $pages);
        $this->assign("keywords", $keywords);
        $this->assign("YeList", $list);
        $this->assign("Title", "IP CC策略");
        $this->assign("host_ip", $host_ip);
        return $this->fetch("/cc");
    }
    public function ipWhite(\think\Request $request)
    {
        $uid = $request->uid;
        $hostId = $request->hostId;
        $param = $request->param();
        if ($request->isPost()) {
            $rule = ["ip|IP 地址" => "require|ip", "web_ip|白名单IP" => "require|ip"];
            $Validate = \think\facade\Validate::rule($rule);
            $res = \think\facade\Validate::check($param);
            if (true !== $res) {
                return json(["status" => 0, "msg" => $Validate->getError()]);
            }
            $firewall_arr = $this->get_firewall($param["ip"], $uid);
            if (!$firewall_arr) {
                $this->log($request, "添加IP白名单，添加IP:" . $param["ip"] . "，白名单IP：" . $param["web_ip"] . "，返回：" . json_encode(["status" => 0, "msg" => "非法访问！"], JSON_UNESCAPED_UNICODE));
                return json(["status" => 0, "msg" => "非法访问！"]);
            }
            $i = 0;
            foreach ($firewall_arr["data"] as $k => $v) {
                $className = $this->getClassName($v["brand"]);
                $v["data"] = json_decode($v["data"], true);
                $v["firewallData"] = json_decode($v["firewallData"], true);
                $v["ip"] = $param["ip"];
                $v["web_ip"] = $param["web_ip"];
                $v["uid"] = $uid;
                $class = "\\addons\\qing_ye_firewall\\common\\" . ucfirst($className);
                $firewall = new $class();
                $setCc = $firewall->ipWhite($v, "submit");
                if ($setCc["status"]) {
                    $ipWhite = \think\Db::name("qing_ye_firewall_cc_ipwhite");
                    $where = ["ip" => $param["ip"], "web_ip" => $param["web_ip"], "uid" => $uid, "host_id" => $firewall_arr["host_id"], "firewall_id" => $v["firewallId"]];
                    if ($ipWhite->where($where)->count()) {
                        if ($ipWhite->where($where)->update(["update_time" => time(), "status" => 1])) {
                            $i++;
                        }
                    } else {
                        $where["status"] = 1;
                        $where["create_time"] = time();
                        $where["update_time"] = $where["create_time"];
                        if ($ipWhite->data($where)->insert()) {
                            $i++;
                        }
                    }
                }
            }
            $ret = ["status" => 0, "msg" => "非法访问！"];
            if (count($firewall_arr["data"]) == 1) {
                if ($i == count($firewall_arr["data"])) {
                    $ret = ["status" => 1, "msg" => "添加成功。"];
                } else {
                    $ret = ["status" => 0, "msg" => "添加失败！"];
                }
            } else {
                if (1 < count($firewall_arr["data"]) && 0 < $i) {
                    $count = count($firewall_arr["data"]);
                    $ret = ["status" => 1, "msg" => "成功添加 " . $i . " 个防火墙，次商品共有 " . $count . " 个防火墙"];
                }
            }
            $this->log($request, "添加IP白名单，添加IP:" . $param["ip"] . "，白名单IP：" . $param["web_ip"] . "，返回：" . json_encode($ret, JSON_UNESCAPED_UNICODE));
            return $ret;
        } else {
            $page = !empty($param["page"]) ? intval($param["page"]) : 1;
            $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
            $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
            $list = \think\Db::name("qing_ye_firewall_cc_ipwhite")->alias("a")->join("host w", "a.host_id=w.id")->join("qing_ye_firewall f", "f.id=a.firewall_id")->where("w.domainstatus", "Active")->where("a.status", 1)->where("a.uid", $uid)->where("w.uid", $uid)->order("a.id", "desc")->where("a.firewall_id|a.ip|web_ip", "like", "%" . $keywords . "%")->field("a.firewall_id,a.ip,a.create_time,a.update_time,a.host_id,a.web_ip,a.id,f.name firewallName")->paginate($limit);
            $all = \think\Db::name("qing_ye_firewall_cc_ipwhite")->alias("a")->join("host w", "a.host_id=w.id")->where("w.domainstatus", "Active")->where("a.status", 1)->where("a.uid", $uid)->where("w.uid", $uid)->where("a.firewall_id|a.ip|web_ip", "like", "%" . $keywords . "%")->field("a.id")->all();
            $count = count($all);
            $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeFirewall://Index/cc", [], true));
            $this->assign("pages", $pages);
            $this->assign("keywords", $keywords);
            $this->assign("YeList", $list);
            $host_ip = $this->host_ip($uid, $hostId);
            if ($hostId && $host_ip) {
                $this->assign("dedicatedip", $host_ip[0]["dedicatedip"]);
            } else {
                if ($param["ip"]) {
                    $this->assign("dedicatedip", $param["ip"]);
                }
            }
            $this->assign("host_ip", $host_ip);
            $this->assign("Title", "IP 白名单");
            return $this->fetch("/ipwhite");
        }
    }
    public function DeleteIpWhite(\think\Request $request)
    {
        return json(["status" => 0, "msg" => "请联系客服删除！"]);
    }
    public function rid(\think\Request $request)
    {
        $uid = $request->uid;
        $hostId = $request->hostId;
        $param = $request->param();
        if ($request->isPost()) {
            $rule = ["ip" => "require|ip"];
            $Validate = \think\facade\Validate::rule($rule);
            $res = \think\facade\Validate::check($param);
            if (true !== $res) {
                return json(["status" => 0, "msg" => $Validate->getError()]);
            }
            $firewall_arr = $this->get_firewall($param["ip"], $uid);
            if (!$firewall_arr) {
                $this->log($request, "释放IP失败，IP:" . $param["ip"] . "，返回：" . json_encode(["status" => 0, "msg" => "非法访问！"], JSON_UNESCAPED_UNICODE));
                return json(["status" => 0, "msg" => "非法访问！"]);
            }
            $i = 0;
            foreach ($firewall_arr["data"] as $k => $v) {
                $className = $this->getClassName($v["brand"]);
                $v["data"] = json_decode($v["data"], true);
                $v["firewallData"] = json_decode($v["firewallData"], true);
                $v["ip"] = $param["ip"];
                $v["uid"] = $uid;
                $class = "\\addons\\qing_ye_firewall\\common\\" . ucfirst($className);
                $firewall = new $class();
                $setCc = $firewall->release($v);
                if ($setCc["status"]) {
                    $i++;
                }
            }
            $ret = ["status" => 0, "msg" => "非法访问！"];
            if (count($firewall_arr["data"]) == 1) {
                if ($i == count($firewall_arr["data"])) {
                    $ret = ["status" => 1, "msg" => "释放成功。"];
                } else {
                    $ret = ["status" => 0, "msg" => "释放失败！"];
                }
            } else {
                if (1 < count($firewall_arr["data"]) && 0 < $i) {
                    $count = count($firewall_arr["data"]);
                    $ret = ["status" => 1, "msg" => "成功释放 " . $i . " 个防火墙，次商品共有 " . $count . " 个防火墙"];
                }
            }
            $this->log($request, "释放IP，IP:" . $param["ip"] . "，返回：" . json_encode($ret, JSON_UNESCAPED_UNICODE));
            return $ret;
        } else {
            $host_ip = $this->host_ip($uid, $hostId);
            if ($hostId && $host_ip) {
                $this->assign("dedicatedip", $host_ip[0]["dedicatedip"]);
            }
            $this->assign("host_ip", $host_ip);
            $this->assign("Title", "IP 释放");
            return $this->fetch("/rid");
        }
    }
    public function linknum(\think\Request $request)
    {
        $uid = $request->uid;
        $hostId = $request->hostId;
        $param = $request->param();
        $host_ip = $this->host_ip($uid, $hostId);
        if ($hostId && $host_ip) {
            $this->assign("dedicatedip", $host_ip[0]["dedicatedip"]);
        } else {
            if ($param["ip"]) {
                $this->assign("dedicatedip", $param["ip"]);
            }
        }
        $this->assign("host_ip", $host_ip);
        $this->assign("Title", "IP 连接数");
        $rule = ["ip" => "require|ip"];
        $Validate = \think\facade\Validate::rule($rule);
        $res = \think\facade\Validate::check($param);
        if (true !== $res) {
            return $this->fetch("/linknum");
        }
        $firewall_arr = $this->get_firewall($param["ip"], $uid);
        if (!$firewall_arr) {
            $this->log($request, "IP 连接数查看，IP:" . $param["ip"] . "，违法查询！");
            $this->assign("YeList", []);
            return $this->fetch("/linknum");
        }
        $ret = [];
        foreach ($firewall_arr["data"] as $k => $v) {
            $className = $this->getClassName($v["brand"]);
            $v["data"] = json_decode($v["data"], true);
            $v["firewallData"] = json_decode($v["firewallData"], true);
            $v["ip"] = $param["ip"];
            $v["uid"] = $uid;
            $class = "\\addons\\qing_ye_firewall\\common\\" . ucfirst($className);
            $firewall = new $class();
            $setCc = $firewall->linknum($v);
            if ($setCc["status"]) {
                $setCc["data"]["firewallId"] = $v["firewallId"];
                $setCc["data"]["firewallName"] = $v["firewallName"];
                $ret[] = $setCc["data"];
            }
        }
        $this->log($request, "IP 连接数查看，IP:" . $param["ip"]);
        $this->assign("YeList", $ret);
        return $this->fetch("/linknum");
    }
    public function rateview(\think\Request $request)
    {
        $uid = $request->uid;
        $hostId = $request->hostId;
        $param = $request->param();
        $host_ip = $this->host_ip($uid, $hostId);
        if ($hostId && $host_ip) {
            $this->assign("dedicatedip", $host_ip[0]["dedicatedip"]);
        } else {
            if ($param["ip"]) {
                $this->assign("dedicatedip", $param["ip"]);
            }
        }
        $this->assign("host_ip", $host_ip);
        $this->assign("Title", "IP 流量图");
        $rule = ["ip" => "require|ip"];
        $Validate = \think\facade\Validate::rule($rule);
        $res = \think\facade\Validate::check($param);
        if (true !== $res) {
            return $this->fetch("/rateview");
        }
        $firewall_arr = $this->get_firewall($param["ip"], $uid);
        if (!$firewall_arr) {
            $this->log($request, "IP 流量图查看，IP:" . $param["ip"] . "，违法查询！");
            $this->assign("YeList", []);
            return $this->fetch("/rateview");
        }
        $ret = [];
        foreach ($firewall_arr["data"] as $k => $v) {
            $className = $this->getClassName($v["brand"]);
            $v["data"] = json_decode($v["data"], true);
            $v["firewallData"] = json_decode($v["firewallData"], true);
            $v["ip"] = $param["ip"];
            $v["uid"] = $uid;
            $class = "\\addons\\qing_ye_firewall\\common\\" . ucfirst($className);
            $firewall = new $class();
            $setCc = $firewall->rateview($v);
            if ($setCc["status"]) {
                $md5 = md5(time() . mt_rand(1, 1000000) . $v["ip"] . $v["uid"]);
                cache($md5, ["uid" => $uid, "data" => $setCc["data"]], 3600);
                $tmp = ["firewallId" => $v["firewallId"], "firewallName" => $v["firewallName"], "img" => shd_addon_url("QingYeFirewall://Index/getImg", ["name" => $md5], true)];
                $ret[] = $tmp;
            }
        }
        $this->log($request, "IP 流量图查看，IP:" . $param["ip"]);
        $this->assign("YeList", $ret);
        return $this->fetch("/rateview");
    }
    public function getImg(\think\Request $request)
    {
        $uid = $request->uid;
        $param = $request->param();
        $ret = cache($param["name"]);
        if ($ret["uid"] != $uid) {
            return "";
        }
        return response($ret["data"], 200, ["Content-Length" => strlen($ret["data"])])->contentType("image/png");
    }
    public function ccType(\think\Request $request)
    {
        $uid = $request->uid;
        $param = $request->param();
        $ip = $param["ip"];
        $rule = ["ip" => "require|ip"];
        \think\facade\Validate::rule($rule);
        $res = \think\facade\Validate::check($param);
        if (true !== $res) {
            return "";
        }
        $productId = \think\Db::name("host")->where(["uid" => $uid, "domainstatus" => "Active"])->where("FIND_IN_SET('" . $ip . "',`assignedips`) OR  `dedicatedip`='" . $ip . "'")->field("productid")->find();
        if (!$productId["productid"]) {
            return "";
        }
        $firewall = \think\Db::name("qing_ye_firewall")->alias("a")->join("qing_ye_firewall_cc_list w", "FIND_IN_SET(a.id,w.firewall)")->where("a.status", 1)->where("w.status", 1)->where("FIND_IN_SET('" . $productId["productid"] . "',a.range)")->order("w.sortID asc,w.id asc")->distinct(true)->field("w.id,w.name")->select();
        if (!$firewall) {
            return "";
        }
        return json($firewall);
    }
    public function setCc(\think\Request $request)
    {
        $uid = $request->uid;
        $param = $request->param();
        $rule = ["ip|IP 地址" => "require|ip", "cc|CC策略" => "require|integer"];
        $Validate = \think\facade\Validate::rule($rule);
        $Validate->message("cc", "非法提交！");
        $res = \think\facade\Validate::check($param);
        if (true !== $res) {
            return json(["status" => 0, "msg" => $Validate->getError()]);
        }
        $firewall_arr = $this->get_firewall($param["ip"], $uid, $param["cc"]);
        if (!$firewall_arr) {
            $this->log($request, "添加CC策略，添加IP:" . $param["ip"] . "，策略ID：" . $param["cc"] . "，返回：" . json_encode(["status" => 0, "msg" => "非法访问！"], JSON_UNESCAPED_UNICODE));
            return json(["status" => 0, "msg" => "非法访问！"]);
        }
        $i = 0;
        foreach ($firewall_arr["data"] as $k => $v) {
            $className = $this->getClassName($v["brand"]);
            $v["data"] = json_decode($v["data"], true);
            $v["firewallData"] = json_decode($v["firewallData"], true);
            $v["ip"] = $param["ip"];
            $class = "\\addons\\qing_ye_firewall\\common\\" . ucfirst($className);
            $firewall = new $class();
            $setCc = $firewall->setCc($v);
            if ($setCc["status"]) {
                $record = \think\Db::name("qing_ye_firewall_cc_record");
                $where = ["ip" => $param["ip"], "uid" => $uid, "host_id" => $firewall_arr["host_id"], "firewall_id" => $v["firewallId"]];
                if ($record->where($where)->count()) {
                    if ($record->where($where)->update(["cc_list_id" => $v["id"], "cc_list_name" => $v["name"], "update_time" => time(), "status" => 1])) {
                        $i++;
                    }
                } else {
                    $where["cc_list_id"] = $v["id"];
                    $where["cc_list_name"] = $v["name"];
                    $where["create_time"] = time();
                    $where["update_time"] = $where["create_time"];
                    $where["status"] = 1;
                    if ($record->data($where)->insert()) {
                        $i++;
                    }
                }
            }
        }
        $ret = ["status" => 0, "msg" => "非法访问！"];
        if (count($firewall_arr["data"]) == 1) {
            if ($i == count($firewall_arr["data"])) {
                $ret = ["status" => 1, "msg" => "添加成功。"];
            } else {
                $ret = ["status" => 0, "msg" => "添加失败！"];
            }
        } else {
            if (1 < count($firewall_arr["data"]) && 0 < $i) {
                $count = count($firewall_arr["data"]);
                $ret = ["status" => 1, "msg" => "成功添加 " . $i . " 个防火墙，次商品共有 " . $count . " 个防火墙"];
            }
        }
        $this->log($request, "添加CC策略，添加IP:" . $param["ip"] . "，策略ID：" . $param["cc"] . "，返回：" . json_encode($ret, JSON_UNESCAPED_UNICODE));
        return $ret;
    }
    private function host_ip($uid, $hostId = "")
    {
        $firewall = \think\Db::name("qing_ye_firewall")->where("status", "=", 1)->field("range")->select();
        $range = "";
        foreach ($firewall as $k => $v) {
            $range .= $v["range"] . ",";
        }
        $range = substr($range, 0, strlen($range) - 1);
        $host_ip = \think\Db::name("host")->where(["uid" => $uid, "domainstatus" => "Active"]);
        if ($hostId != "") {
            $host_ip->orderRaw("id=" . $hostId . " desc");
        }
        $host_ip = $host_ip->order("id", "desc")->where("productid", "in", $range)->field("dedicatedip,assignedips,id")->select();
        return $host_ip;
    }
    private function get_firewall($ip, $uid, $ccType = "")
    {
        $productId = \think\Db::name("host")->where(["uid" => $uid, "domainstatus" => "Active"])->where("FIND_IN_SET('" . $ip . "',`assignedips`) OR  `dedicatedip`='" . $ip . "'")->field("productid,id")->find();
        if (!$productId["productid"]) {
            return false;
        }
        if ($ccType == "") {
            $firewall_m = \think\Db::name("qing_ye_firewall")->where("status", 1)->where("FIND_IN_SET('" . $productId["productid"] . "',`range`)")->field("id firewallId,name firewallName,host,user,password,brand,data firewallData")->select();
        } else {
            $firewall_m = \think\Db::name("qing_ye_firewall")->alias("a")->join("qing_ye_firewall_cc_list w", "FIND_IN_SET(a.id,w.firewall)")->where("a.status", 1)->where("w.status", 1)->where("FIND_IN_SET('" . $productId["productid"] . "',a.range)")->where("w.id", $ccType)->field("w.id,w.name,w.data,a.id firewallId,a.name firewallName,a.host,a.user,a.password,a.brand,a.data firewallData")->select();
        }
        if (!$firewall_m) {
            return false;
        }
        $firewall["host_id"] = $productId["id"];
        $firewall["product_id"] = $productId["productid"];
        $firewall["data"] = $firewall_m;
        return $firewall;
    }
    private function log(\think\Request $request, $data)
    {
        $ip = $request->ip();
        $Port = $request->remotePort();
        $uid = $request->uid;
        $d = ["uid" => $uid, "ip" => $ip, "port" => $Port, "create_time" => time(), "data" => $data];
        \think\Db::name("qing_ye_firewall_log")->data($d)->insert();
    }
    private function getClassName($brand)
    {
        switch ($brand) {
            case 1:
                $className = "JinDun";
                break;
            default:
                $className = "JinDun";
                return $className;
        }
    }
    private function pages($page, $count, $limit, $url, $listNum = 5)
    {
        $PageCount = ceil($count / $limit);
        if ($page == 1) {
            $prev = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">«</a></li>";
        } else {
            $prev = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . ($page - 1) . "&limit=" . $limit . "\">«</a></li>";
        }
        if ($page == $PageCount) {
            $next = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">»</a></li>";
        } else {
            $next = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . ($page + 1) . "&limit=" . $limit . "\">»</a></li>";
        }
        if ($page == 1) {
            $first = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">首 页</a></li>";
        } else {
            $first = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=1" . "&limit=" . $limit . "\">首 页</a></li>";
        }
        if ($page == $PageCount) {
            $last = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">尾 页</a></li>";
        } else {
            $last = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . $PageCount . "&limit=" . $limit . "\">尾 页</a></li>";
        }
        $html = "<div class=\"table-footer\"> <div class=\"table-tools\"></div><div class=\"table-pagination\"> <span>共 " . $count . " 条</span> <div class=\"table-pageinfo mx-2\"><select class=\"form-control\" style=\"height:calc(1.5em + 0.94rem + -5px)\" id=\"limitSel\">";
        $html .= $limit == 10 ? "<option value=\"10\" selected >10条/页</option>" : "<option value=\"10\">10条/页</option>";
        $html .= $limit == 15 ? "<option value=\"15\" selected >15条/页</option>" : " <option value=\"15\">15条/页</option>";
        $html .= $limit == 20 ? "<option value=\"20\" selected >20条/页</option>" : " <option value=\"20\">20条/页</option>";
        $html .= $limit == 25 ? "<option value=\"25\" selected >25条/页</option>" : " <option value=\"25\">25条/页</option>";
        $html .= $limit == 50 ? "<option value=\"50\" selected >50条/页</option>" : " <option value=\"50\">50条/页</option>";
        $html .= $limit == 100 ? "<option value=\"100\" selected >100条/页</option>" : "<option value=\"100\" >100条/页</option>";
        $html .= "</select></div><nav><ul class=\"pagination pagination-sm\">" . $first . $prev;
        $inum = floor($listNum / 2);
        for ($i = $page - $inum; $i <= $page + $inum; $i++) {
            if ($i > 0) {
                if ($PageCount >= $i) {
                    if ($i == $page) {
                        $html .= "<li class=\"page-item active\">";
                        $html .= "<a class=\"page-link\">" . $i . "</a>";
                        $html .= "</li>";
                    } else {
                        $html .= "<li class=\"page-item\">";
                        $html .= "<a class=\"page-link\" href=\"" . $url . "&page=" . $i . "&limit=" . $limit . "\">" . $i . "</a>";
                        $html .= "</li>";
                    }
                }
            }
        }
        $html .= $next . $last;
        $html .= "</ul></nav></div>";
        $html .= "<script>\$(function(){ \$('#limitSel').on('change', function () {location.href = '" . $url . "' + '&page=1&limit=' + \$('#limitSel').val();})});</script>";
        $html .= "</div>";
        return $html;
    }
}

?>