{include file="admin/_header" }

<div class="tab-content mt-4">
    <!-- 搜索框 !-->
    <div class="table-header">
        <div class="table-tools">
            <a href="#" class="btn btn-success w-sm nohide" data-toggle="modal" onclick="exampleModal()" >
                <i class="fas fa-plus-circle"></i> 添加CC策略
            </a>

            <a href="#" class="btn btn-success w-sm nohide" data-toggle="modal" onclick="sortID()" >
                <i class="bi bi-chevron-contract"></i> 排序
            </a>

            <input type="text" id="keywords" class="form-control" placeholder="输入关键字" value="{$keywords}">
            <button class="btn btn-primary w-xs" id="searchInp" ><i class="fas fa-search"></i> 搜索</button>
        </div>
    </div>

    <!-- 列表 !-->
    <div class="table-body table-responsive">
        <table class="table table-bordered table-hover">
            <caption>选中的项目： <button type="button" class="btn btn-danger btn-sm"  id="delete" onclick="handleOperating()">批量删除</button></caption>
            <thead class="thead-light">
            <tr>
                <th class="checkbox">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input" id="selectAll">
                        <label class="custom-control-label" for="selectAll">&nbsp;</label>
                    </div>
                </th>

                <th class="center t1">ID</th>
                <th class="t4">CC策略名称</th>
                <th>支持防火墙</th>
                <th>类型</th>
                <th>排序ID</th>
                <th>添加时间</th>
                <th class="center">状态</th>
                <th class="center t5">操作</th>
            </tr>
            </thead>

            <tbody>

            {foreach $list as $v=>$k}
                <tr>
                    <td class="checkbox">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input row-checkbox" id="customCheck{$k.id}">
                            <label class="custom-control-label" for="customCheck{$k.id}">&nbsp;</label>
                        </div>
                    </td>
                    <td class="center">{$k.id}</td>
                    <td>{$k.name}</td>
                    <td>
                    {foreach :explode(',',$k.firewall) as $kk=>$vv}
                        <a href="{:shd_addon_url('QingYeFirewall://AdminIndex/addfirewall')}&id={$vv}">{$firewall[$vv][name]}
                        {if count(explode(',',$k.firewall)) != $kk+1},{/if}
                        </a>
                    {/foreach}
                    </td>
                    <td>
                        {if $k.brand==1}金盾{/if}
                    </td>
                    <td class="center">{$k.sortID}</td>
                    <td>{:date("Y-m-d H:i:s",$k.create_time)}</td>
                    <td class="center">
                        {if $k.status==1}
                            <i class="fa fa-check-circle text-success"></i>
                        {else}
                            <i class="fa fa-times text-danger"></i>
                        {/if}
                    </td>
                    <td>
                        <button type="button" class="btn btn-link" onclick="Update({$k.id}) "><i class="fas fa-edit"></i> 修改</button>
                        <button type="button" class="btn btn-link red"  onclick="handleOperating({$k.id})"><i class="fas fa-times"></i> 删除</button>
                    </td>
                </tr>

            {/foreach}


            </tbody>
        </table>
    </div>

    <!-- 分页 !-->
    {$pages|raw}

</div>




{include file="admin/_footer" }


<!-- 添加弹窗 -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">添加CC策略</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form class="form" id="form" autocomplete="off">

                    <input hidden="hidden" value="" name="id">

                    <div class="form-group row">
                        <label class="require">策略名称</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="name"  required>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="require">品牌
                            <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip"
                               data-placement="top" title="防火墙品牌，如没有您的防火墙品牌，请与青叶云联系，并提供相关文档或者测试防火墙">
                            </i>
                        </label>
                        <div class="col-sm-9">
                            <select class="form-control" name="brand">
                                <option value="1">金盾</option>
                            </select>
                        </div>
                    </div>


                    <div class="form-group row">
                        <label class="require">排序
                            <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip"
                               data-placement="top" title="用户端排序，越小越靠前">
                            </i>
                        </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="sortID"  required>
                        </div>
                    </div>


                    <div class="form-group row invalid">
                        <label class="require">支持防火墙</label>
                        <div class="col-sm-9">
                            <select class="form-control selectpicker" name="firewall[]" id="firewall" data-live-search="true" multiple>
                                {foreach $firewall_list as $v}
                                    <option  value="{$v.id}">{$v.name} </option>
                                {/foreach}
                            </select>
                        </div>
                    </div>


                    <div class="form-group row" >
                        <label class="require">防护参数集</label>
                        <div class="col-sm-9">
                            <input type="text" name="param_set" class="form-control" required value="">

                        </div>
                    </div>

                    <div class="form-group row" >
                        <label class="require">过滤规则</label>
                        <div class="col-sm-9">
                            <input type="text" name="filter_set" class="form-control" required value="">

                        </div>
                    </div>

                    <div class="form-group row" >
                        <label class="require">UDP 端口集</label>
                        <div class="col-sm-9">
                            <input type="text" name="set_udp" class="form-control" required value="">

                        </div>
                    </div>

                    <div class="form-group row" >
                        <label class="require">TCP 端口集</label>
                        <div class="col-sm-9">
                            <input type="text" name="set_tcp" class="form-control" required value="">

                        </div>
                    </div>


                    <div class="form-group row" >
                        <label>拒绝国外访问</label>
                        <div class="col-sm-9">
                            <div class="custom-control custom-switch" dir="ltr">
                                <input type="checkbox" class="custom-control-input" name="foreign" id="foreign" >
                                <label class="custom-control-label" for="foreign"></label>
                            </div>
                        </div>
                    </div>


                  <!--  <div class="form-group row" >
                        <label>是否开启防护</label>
                        <div class="col-sm-9">
                            <div class="custom-control custom-switch" dir="ltr">
                                <input type="checkbox" class="custom-control-input" name="protect" id="protect"   >
                                <label class="custom-control-label" for="protect"></label>
                            </div>
                        </div>
                    </div> -->

                    <div class="form-group row" >
                        <label>忽略所有流量</label>
                        <div class="col-sm-9">
                            <div class="custom-control custom-switch" dir="ltr">
                                <input type="checkbox" class="custom-control-input" name="ignore" id="ignore"  >
                                <label class="custom-control-label" for="ignore"></label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label>屏蔽所有流量</label>
                        <div class="col-sm-9">
                            <div class="custom-control custom-switch" dir="ltr">
                                <input type="checkbox" class="custom-control-input" name="forbid" id="forbid" >
                                <label class="custom-control-label" for="forbid"></label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label>是否启用</label>
                        <div class="col-sm-4">
                            <div class="custom-control custom-switch" dir="ltr">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" >
                                <label class="custom-control-label" for="status"></label>
                            </div>
                        </div>
                    </div>


                </form>

                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">关闭</button>
                    <button type="submit" id="submitBtn" class="btn btn-primary">保存</button>
                </div>


            </div>


        </div>
    </div>
</div>


<!-- 添加弹窗 -->
<div class="modal fade" id="sort" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

    <div class="modal-dialog " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">添加CC策略</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <form class="form" autocomplete="off">

                    <div class="form-group row">
                        <label>排序</label>
                        <div class="col-sm-9">
                            <select size="20" class="form-control select menu-rank" id="sort" style="">
                                {foreach $sort as $k=>$v}
                                    <option class="ids" title="{$v.name}" value="{$v.id}">{$v.name} </option>
                                {/foreach}
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label>操作</label>
                        <div class="col-sm-9">

                            <input type="button" class="btn btn-primary top" value="移至第一">
                            <input type="button" class="btn btn-primary up" value="↑ 上 移">
                            <input type="button" class="btn btn-primary down" value="↓ 下 移">
                            <input type="button" class="btn btn-primary bottom" value="移至最后">

                        </div>
                    </div>


                </form>

                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">关闭</button>
                    <button type="submit" id="sortBtn" class="btn btn-primary">保存</button>
                </div>

            </div>




        </div>
    </div>

</div>

<!-- <link href="https://cdn.bootcdn.net/ajax/libs/bootstrap-multiselect/1.1.0/css/bootstrap-multiselect.min.css" rel="stylesheet">
<script src="https://cdn.bootcdn.net/ajax/libs/bootstrap-multiselect/1.1.0/js/bootstrap-multiselect.min.js"></script> -->

<link rel="stylesheet" href="{$Themes}/assets/libs/bootstrap-select/css/bootstrap-select.min.css">
<script src="{$Themes}/assets/libs/bootstrap-select/js/bootstrap-select.min.js"></script>
<script src="{$Themes}/assets/libs/bootstrap-select/js/i18n/defaults-zh_CN.min.js"></script>

<script type="text/javascript">

    $(function(){
        sort();
        $(".top").click(function(){
            rest();
             $("#sort option:selected").prependTo("select");
            sort();
        })
        $(".bottom").click(function(){
            rest();
            $("#sort option:selected").appendTo("select");
            sort();
        })
        $(".up").click(function(){
            rest();
            $("#sort option:selected").after($("#sort option:selected").prev());
            sort();
        })
        $(".down").click(function(){
            rest();
            $("#sort option:selected").before($("#sort option:selected").next());
            sort();
        })
        function sort(){
            $('#sort option').text(function(){
                return ($(this).index()+1)+'、'+$(this).text()}
            );
        }

        //重置所有option文字。
        function rest(){
            $('#sort option').text(function(){
                return $(this).text().split('、')[1]
            });
        }
        //获取排序并提交
        $('#sortBtn').click(function(){
            var arr = new Array();
            $('#sort option').each(function(){
                arr.push($(this).val());
                // console.log($(this).val())
            });
            var e = this;
            $(e).attr("disabled", true);
            $.ajax({
                url: '{:shd_addon_url('QingYeFirewall://AdminIndex/sort')}',
                type: 'POST',
                data: {ids:arr.join(',')},
                success: function (data) {
                    if (data.status == 1) {
                        toastr.success(data.msg)
                        setTimeout(function () { window.location.reload(); }, 1000);
                    } else {
                        toastr.error(data.msg);
                        $(e).attr("disabled", false);
                    }
                }, error: function () {
                    toastr.error("系统错误！");
                    $(e).attr("disabled", false);
                }
            })
        });

        $('#exampleModal').on('hide.bs.modal', function () {
            //弹出窗关闭刷新页面
            window.location.reload();
        });

        $('#sort').on('hide.bs.modal', function () {
            //弹出窗关闭刷新页面
            window.location.reload();
        });
        $('#searchInp').click(function(){
            location.href = '{:shd_addon_url('QingYeFirewall://AdminIndex/setCc')}' +  '&keywords=' + $('#keywords').val();
        });
        var fields = {validators: {notEmpty: {message: '不能为空'},}};
        $('#form').bootstrapValidator({
            fields: {
                name: fields,
                'firewall[]': fields,
                param_set: fields,
                filter_set: fields,
                set_udp: fields,
                set_tcp: fields,
                sortID: fields,
            }
        });

        $("#submitBtn").click(function () {
            var form = $('#form');
            var bv = form.data('bootstrapValidator');
            bv.validate();
            if (bv.isValid()) {
                var e = this;
                $(e).attr("disabled", true);
                $.ajax({
                    url: '{:shd_addon_url('QingYeFirewall://AdminIndex/setCc')}',
                    type: 'POST',
                    data: form.serialize(),
                    success: function (data) {
                        if (data.status == 1) {
                            toastr.success(data.msg)
                            setTimeout(function () { window.location.reload(); }, 1000);
                        } else {
                            toastr.error(data.msg);
                            $(e).attr("disabled", false);
                        }
                    }, error: function () {
                        toastr.error("系统错误！");
                        $(e).attr("disabled", false);
                    }
                })
            }
        });


    })
    function sortID()
    {
        //打开弹出层
        $('#sort').modal({
            backdrop: 'static',
            //点击背景空白处不被关闭；
            keyboard: false
            //触发键盘esc事件时不关闭。
        });
    }

    function exampleModal()
    {
        //打开弹出层
        $('#exampleModal').modal({
            backdrop: 'static',
            //点击背景空白处不被关闭；
            keyboard: false
            //触发键盘esc事件时不关闭。
        });
    }
    function Update(id){
        $.ajax({
            url: '{:shd_addon_url('QingYeFirewall://AdminIndex/setCc')}',
            type: 'GET',
            data: 'id='+id,
            success: function (data) {
                if (data) {
                    $("[name='id']").val(id);
                    $("[name='name']").val(data.name);
                    $("[name='param_set']").val(data.data.param_set);
                    $("[name='filter_set']").val(data.data.filter_set);
                    $("[name='set_udp']").val(data.data.set_udp);
                    $("[name='set_tcp']").val(data.data.set_tcp);
                    $("[name='sortID']").val(data.sortID);
                    data.status==1 ? $("[name='status']").prop("checked",true) :$("[name='status']").prop("checked",false);
                    data.data.foreign==1 ? $("[name='foreign']").prop("checked",true) :$("[name='foreign']").prop("checked",false);
                    data.data.protect==1 ? $("[name='protect']").prop("checked",true) :$("[name='protect']").prop("checked",false);
                    data.data.ignore==1 ? $("[name='ignore']").prop("checked",true) :$("[name='ignore']").prop("checked",false);
                    data.data.forbid==1 ? $("[name='forbid']").prop("checked",true) :$("[name='forbid']").prop("checked",false);
                    var arr = data.firewall.split(",");
                    // for(var i =0 ;i<arr.length;i++){
                    //     $('#example-getting-started').multiselect('select', arr[i]);
                    // }
                    $("#firewall").val(arr);
                    $("#firewall").selectpicker('refresh');
                }
            }, error: function () {
                toastr.error("系统错误！")
            }
        })
        exampleModal();
    }


    function handleOperating(command) {
        // 批量操作 直接复制粘贴，用户端
        var batchObj = {id: []};
        batchObj.id.length = 0
        tableMul = getCheckbox()
        for (let i = 0; i < tableMul.length; i++) {
            const item = tableMul[i]
            batchObj.id.push(item)
        }
        if (command){
            batchObj = "id[]=" + command;
        }
        $.ajax({
            type: "post",
            url: '{:shd_addon_url('QingYeFirewall://AdminIndex/ccDelete')}',
            data: batchObj,
            success: function (data) {
                if (data.status == 1) {
                    toastr.success(data.msg)
                    setTimeout(function () { window.location.reload(); }, 1000);
                }else {
                    toastr.error(data.msg)
                }
            }
        });

    }

    // 获取所有勾选项的id
    var getCheckbox = function () {
        // 勾选的id
        const ids = []
        // 所有表格内的checkbox
        const allCheck = [...$('.row-checkbox:checked')]
        for (const key in allCheck) {
            if (Object.hasOwnProperty.call(allCheck, key)) {
                const item = allCheck[key];
                ids.push(item.id.substring(11))
            }
        }
        return ids
    };
</script>
