<section class="admin-main">

    <!-- 干掉溢出隐藏，解决 select被遮挡-->
    <style>
        .main-content {
            /*margin-left: 250px;*/
            overflow: visible;
        }
    </style>
    <div class="card">
        <div class="card-body">
            <div class="ticket-top">
                <p >建议关闭或者调整策略后，释放一次服务器IP</p>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <div class="table-Tab">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item waves-effect waves-light">
                        <a class="nav-link active"
                           href="{:shd_addon_url('QingYeFirewall://Index/cc',[],true)}"
                           role="tab">IP CC策略</a>
                    </li>
                    <li class="nav-item waves-effect waves-light">
                        <a class="nav-link "
                           href="{:shd_addon_url('QingYeFirewall://Index/ipWhite',[],true)}"
                           role="tab">IP 白名单</a>
                    </li>
                    <li class="nav-item waves-effect waves-light">
                        <a class="nav-link "
                           href="{:shd_addon_url('QingYeFirewall://Index/rid',[],true)}"
                           role="tab">IP 释放</a>
                    </li>
                    <li class="nav-item waves-effect waves-light">
                        <a class="nav-link "
                           href="{:shd_addon_url('QingYeFirewall://Index/linknum',[],true)}"
                           role="tab">IP 连接数</a>
                    </li>
                    <li class="nav-item waves-effect waves-light">
                        <a class="nav-link "
                           href="{:shd_addon_url('QingYeFirewall://Index/rateview',[],true)}"
                           role="tab">IP 流量图</a>
                    </li>

                    <!-- 预留一个钩子到时候客户定制功能直接加 -->
                    {php}$hooks=hook('template_firewall_nav_qing_ye_firewall');{/php}
                    {if $hooks}
                        {foreach $hooks as $item}
                            {foreach $item as $v}
                                <li class="nav-item waves-effect waves-light">
                                    <a class="nav-link {$v.active}"
                                       href="{$v.url}"
                                       role="tab">{$v.name}</a>
                                </li>
                            {/foreach}
                        {/foreach}
                    {/if}


                </ul>
            </div>


            <div class="table-header"></div>

            <form id="addFireWallForm"  class="form">
                <div class="form-row ">
                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label class="require">选择 IP 地址</label>
                        <select class="selectpicker show-tick form-control" id="IpSelect" data-live-search="true">
                            <option selected disabled style="display：none" value="">请选择 IP</option>
                            {foreach $host_ip as $p}
                                {if filter_var($p.dedicatedip, FILTER_VALIDATE_IP)}
                                    <option value="{$p.dedicatedip}">{$p.dedicatedip}</option>
                                {/if}
                                {foreach :explode(',',$p.assignedips) as $v}
                                    {if filter_var($v, FILTER_VALIDATE_IP)}
                                        <option value="{$v}">{$v}</option>
                                    {/if}
                                {/foreach}
                            {/foreach}

                        </select>
                    </div>
                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label>选择 CC 策略</label>
                        <select class="selectpicker show-tick form-control" id="CcSelect" data-live-search="true">
                            <option selected disabled style="display：none" value="">请先选择IP</option>
                        </select>
                    </div>

                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label>&nbsp;</label>
                        <button class="btn btn-primary form-control" id="button"   type="button">添加 CC 策略</button>
                    </div>
                </div>
            </form>

        </div>

    </div>



    <div class="card">
        <div class="card-body">

            <!-- 搜索框

            <ul class="navbar-nav ml-md-auto">
                <li class="nav-item dropdown">
                    <label>&nbsp;</label>
                    <div class="search-box">
                        <div class="position-relative">
                            <input type="text" class="form-control" id="searchInp" value="{$keywords}" placeholder="按关键字搜索">
                            <i class="bx bx-search-alt search-icon" id="searchIcon"></i>
                        </div>
                    </div>
                </li>
            </ul> -->



            <div class="table-header">

                <div class="page-title-box d-flex align-items-center justify-content-between">
                    <div style="display:flex;">
                        <h4 class="mb-0 font-size-18">CC策略记录</h4>
                    </div>
                </div>
                <div class="table-search">
                    <div class="row justify-content-end">
                        <div class="col-sm-6">
                            <div class="search-box">
                                <div class="position-relative">
                                    <input type="text" class="form-control" id="searchInp" value="{$keywords}" placeholder="按关键字搜索">
                                    <i class="bx bx-search-alt search-icon" id="searchIcon"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="table-body table-responsive">
                <table class="table table-bordered table-hover">

                    <thead class="thead-light">
                    <tr>
                        <th class="center t1">防火墙名称</th>
                        <th class="center t1">IP</th>
                        <th class="center t1">防护类型</th>
                        <th class="center">添加时间</th>
                        <th class="center">修改时间</th>
                    </tr>
                    </thead>
                    <tbody>
                    {foreach $YeList as $k}
                        <tr>
                            <td class="center">{$k.firewallName}</td>
                            <td><a href="/servicedetail?id={$k.host_id}">{$k.ip}</a></td>
                            <td>{$k.cc_list_name}</td>
                            <td>{:date("Y-m-d H:i:s",$k.create_time)}</td>
                            <td>{:date("Y-m-d H:i:s",$k.update_time)}</td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
            </div>

            {$pages|raw}

        </div>
    </div>








    <link rel="stylesheet" href="{$Setting.web_url}/themes/clientarea/default/assets/libs/bootstrap-select/css/bootstrap-select.min.css?v={$Ver}">
    <script src="{$Setting.web_url}/themes/clientarea/default/assets/libs/bootstrap-select/js/bootstrap-select.min.js?v={$Ver}"></script>
    <script src="{$Setting.web_url}/themes/clientarea/default/assets/libs/bootstrap-select/js/i18n/defaults-zh_CN.min.js"></script>

    <script>
        $(function() {
            var IpSelect =$("#IpSelect");
            IpSelect.selectpicker();
            $('#IpSelect').change(function() {
                var ip = $(this).val();
                $.ajax({
                    url: '{:shd_addon_url('QingYeFirewall://Index/ccType',[],true)}',
                    type: 'POST',
                    data: 'ip='+ip,
                    success: function (data) {
                        if (data) {
                            //var html ='';
                            var html ='<option selected disabled style="display：none" value="">选择 CC 策略</option>';							
                            for(var i =0 ;i<data.length;i++){
                                html+= '<option value="'+data[i].id+'">'+data[i].name+'</option>';
                            }
                            // console.log(html);
                            if (html !=''){
                                var CcSelect = $('#CcSelect');
                                CcSelect.html(html);
                                CcSelect.selectpicker('refresh');
                            }
                        }
                    }, error: function () {
                        toastr.error("系统错误！");
                    }
                })
            });

            {if $dedicatedip}
            IpSelect.val('{$dedicatedip}').change();
            IpSelect.selectpicker('refresh');
            {/if}



            $('#searchInp').on('keydown', function (e) {
                if (e.keyCode == 13) {
                    location.href = '{:shd_addon_url('QingYeFirewall://Index/cc',[],true)}'+ '&keywords=' + $('#searchInp').val() ;
                }
            });
            $('#searchIcon').on('click', function () {
                location.href = '{:shd_addon_url('QingYeFirewall://Index/cc',[],true)}'+ '&keywords=' + $('#searchInp').val() ;
            });

            $("#button").click(function(){
                var elem = this;
                var ip = $("#IpSelect").val();
                var cc = $("#CcSelect").val();
                if(ip == "" || $.trim(ip).length == 0){
                    toastr.error("请选择IP！");
                    return;
                }
                if(cc == "" || $.trim(cc).length == 0){
                    toastr.error("请选择CC策略！");
                    return;
                }
                BtnLoading(elem);
                $.ajax({
                    url: '{:shd_addon_url('QingYeFirewall://Index/setCc',[],true)}',
                    type: 'POST',
                    data: {ip:ip,cc:cc},
                    success: function (data) {
                        if (data.status) {
                            toastr.success(data.msg);
                            BtnReset(elem);
                            setTimeout(function () { window.location.reload(); }, 1000);
                        }else {
                            toastr.error(data.msg);
                            BtnReset(elem);
                        }
                    }, error: function () {
                        toastr.error("系统错误！");
                        BtnReset(elem);
                    }
                })
            });

        });


        function BtnLoading(elem) {
            $(elem).attr("data-original-text", $(elem).html());
            $(elem).prop("disabled", true);
            $(elem).html('<i class="spinner-border spinner-border-sm"></i> 加载中...');
            $(elem).css("background-color","#6064ff");
        }

        function BtnReset(elem) {
            $(elem).prop("disabled", false);
            $(elem).html($(elem).attr("data-original-text"));
            $(elem).css("background-color",'');
        }

    </script>

</section>

