<?php
namespace addons\qing_ye_firewall;

class QingYeFirewallPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "QingYeFirewall", "title" => "防火墙", "description" => "WEB防火墙插件，可实现用户自主管理防火墙。", "status" => 1, "author" => "青叶云", "version" => "1.0.2", "module" => "addons"];
    public function install()
    {
        $shd_qing_ye_firewall = ["DROP TABLE IF EXISTS `shd_qing_ye_firewall`", "CREATE TABLE `shd_qing_ye_firewall`  (  `id` int(11) NOT NULL AUTO_INCREMENT,  `name` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '防火墙名字',  `brand` int(2) NULL DEFAULT NULL COMMENT '防火墙品牌  1  金盾 2 上下级对接',  `host` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '防火墙地址',  `user` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '防火墙用户名',  `password` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '防火墙密码',  `range` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '使用范围',  `status` int(1) NULL DEFAULT NULL COMMENT '状态 0 禁用 1启用',  `create_time` int(11) NULL DEFAULT NULL COMMENT '添加时间戳',  `update_time` int(11) NULL DEFAULT NULL COMMENT '修改时间戳',  `data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '其他信息',  PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"];
        $shd_qing_ye_firewall_cc_ipwhite = ["DROP TABLE IF EXISTS `shd_qing_ye_firewall_cc_ipwhite`", "CREATE TABLE `shd_qing_ye_firewall_cc_ipwhite`  (  `id` int(11) NOT NULL AUTO_INCREMENT,  `firewall_id` int(11) NULL DEFAULT NULL,  `host_id` int(11) NULL DEFAULT NULL,  `uid` int(11) NULL DEFAULT NULL,  `ip` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `web_ip` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `create_time` int(11) NULL DEFAULT NULL,  `update_time` int(11) NULL DEFAULT NULL,  `status` int(1) NULL DEFAULT NULL,  PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"];
        $shd_qing_ye_firewall_cc_list = ["DROP TABLE IF EXISTS `shd_qing_ye_firewall_cc_list`", "CREATE TABLE `shd_qing_ye_firewall_cc_list`  (  `id` int(11) NOT NULL AUTO_INCREMENT,  `name` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `brand` int(2) NULL DEFAULT NULL COMMENT '防火墙品牌  1  金盾 2 上下级对接',  `status` int(1) NULL DEFAULT NULL COMMENT '状态 0 禁用 1启用 -1删除',  `create_time` int(11) NULL DEFAULT NULL,  `update_time` int(11) NULL DEFAULT NULL,  `data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '其他信息',  `firewall` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '支持的防火墙',  `sortID` smallint(5) NULL DEFAULT NULL COMMENT '排序数字(数值越小越靠前)',  PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"];
        $shd_qing_ye_firewall_cc_record = ["DROP TABLE IF EXISTS `shd_qing_ye_firewall_cc_record`", "CREATE TABLE `shd_qing_ye_firewall_cc_record`  (  `id` int(11) NOT NULL AUTO_INCREMENT,  `firewall_id` int(11) NULL DEFAULT NULL COMMENT '防火墙ID',  `host_id` int(11) NULL DEFAULT NULL COMMENT '产品ID',  `uid` int(11) NULL DEFAULT NULL,  `ip` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ip地址',  `cc_list_id` int(11) NULL DEFAULT NULL COMMENT '策略id',  `cc_list_name` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '策略名称',  `create_time` int(11) NULL DEFAULT NULL COMMENT '添加时间戳',  `update_time` int(11) NULL DEFAULT NULL COMMENT '修改时间戳',  `status` int(1) NULL DEFAULT NULL COMMENT '状态 这玩意可有可无啊',  `data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '其他信息',  PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"];
        $shd_qing_ye_firewall_log = ["DROP TABLE IF EXISTS `shd_qing_ye_firewall_log`", "CREATE TABLE `shd_qing_ye_firewall_log`  (  `id` int(11) NOT NULL AUTO_INCREMENT,  `uid` int(11) NULL DEFAULT NULL,  `ip` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'ip地址',  `port` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '端口号',  `create_time` int(11) NULL DEFAULT NULL COMMENT '添加时间戳',  `data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `status` int(1) NULL DEFAULT NULL,  PRIMARY KEY (`id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8mb4"];
        foreach ($shd_qing_ye_firewall as $v) {
            \think\Db::execute($v);
        }
        foreach ($shd_qing_ye_firewall_cc_ipwhite as $v) {
            \think\Db::execute($v);
        }
        foreach ($shd_qing_ye_firewall_cc_list as $v) {
            \think\Db::execute($v);
        }
        foreach ($shd_qing_ye_firewall_cc_record as $v) {
            \think\Db::execute($v);
        }
        foreach ($shd_qing_ye_firewall_log as $v) {
            \think\Db::execute($v);
        }
        return true;
    }
    public function uninstall()
    {
        $sql = "DROP TABLE IF EXISTS `shd_qing_ye_firewall`";
        \think\Db::execute($sql);
        $sql = "DROP TABLE IF EXISTS `shd_qing_ye_firewall_cc_ipwhite`";
        \think\Db::execute($sql);
        $sql = "DROP TABLE IF EXISTS `shd_qing_ye_firewall_cc_list`";
        \think\Db::execute($sql);
        $sql = "DROP TABLE IF EXISTS `shd_qing_ye_firewall_cc_record`";
        \think\Db::execute($sql);
        $sql = "DROP TABLE IF EXISTS `shd_qing_ye_firewall_log`";
        \think\Db::execute($sql);
        return true;
    }
    public function templateAfterServicedetailSuspended($param)
    {
        $firewall = \think\Db::name("qing_ye_firewall")->where("status", 1)->field("range")->select();
        $range = "";
        foreach ($firewall as $k => $v) {
            $range .= $v["range"] . ",";
        }
        $range = substr($range, 0, strlen($range) - 1);
        $hostid = intval($param["hostid"]);
        $tmp = \think\Db::name("host")->where("productid", "in", $range)->where("id", $hostid)->where("domainstatus", "Active")->find();
        if (empty($tmp)) {
            return "";
        }
        $urlCc = shd_addon_url("QingYeFirewall://Index/cc", ["hostId" => $hostid], true);
        $urlIpWhite = shd_addon_url("QingYeFirewall://Index/ipWhite", ["hostId" => $hostid], true);
        $urlRid = shd_addon_url("QingYeFirewall://Index/rid", ["hostId" => $hostid], true);
        $urlLinKnUm = shd_addon_url("QingYeFirewall://Index/linknum", ["hostId" => $hostid], true);
        $urlRateView = shd_addon_url("QingYeFirewall://Index/rateview", ["hostId" => $hostid], true);
        $html = "\r\n        <button type=\"button\" class=\"btn btn-primary h-100 custom-button text-QingYeFirewall\" data-toggle=\"dropdown\" aria-expanded=\"false\">\r\n            防火墙管理\r\n        </button>\r\n        <div class=\"dropdown-menu\">\r\n            <a class=\"dropdown-item\" href=\"" . $urlCc . "\">IP CC策略</a>\r\n            <a class=\"dropdown-item\" href=\"" . $urlIpWhite . "\">IP 白名单</a>\r\n            <a class=\"dropdown-item\" href=\"" . $urlRid . "\">IP 释放</a>\r\n            <a class=\"dropdown-item\" href=\"" . $urlLinKnUm . "\">IP 连接数</a>\r\n            <a class=\"dropdown-item\" href=\"" . $urlRateView . "\">IP 流量图</a>";
        $hooks = hook("template_servicedetail_qing_ye_firewall", ["hostId" => $hostid]);
        if ($hooks) {
            foreach ($hooks as $item) {
                foreach ($item as $v) {
                    $html .= "<a class=\"dropdown-item\" href=\"" . $v["url"] . "\">" . $v["name"] . "</a>";
                }
            }
        }
        $html .= "</div>";
        return $html;
    }
    public function afterModuleCreate($param)
    {
        $host_id = $param["params"]["hostid"];
        $product_id = $param["params"]["productid"];
        $uid = $param["params"]["uid"];
        $host = \think\Db::name("host")->where("id", $host_id)->where("uid", $uid)->find();
        $dedicatedip = $host["dedicatedip"];
        $assignedips = explode(",", $host["assignedips"]);
        array_push($assignedips, $dedicatedip);
        $firewall = \think\Db::name("qing_ye_firewall")->where("status", 1)->where("FIND_IN_SET('" . $product_id . "',`range`)")->select();
        foreach ($firewall as $k => $v) {
            foreach ($assignedips as $ip) {
                if (filter_var($ip, FILTER_VALIDATE_IP)) {
                    $className = $this->getClassName($v["brand"]);
                    $v["data"] = json_decode($v["data"], true);
                    $v["firewallId"] = $v["id"];
                    $v["firewallName"] = $v["name"];
                    $v["ip"] = $ip;
                    $class = "\\addons\\qing_ye_firewall\\common\\" . ucfirst($className);
                    $firewall = new $class();
                    $setCc = $firewall->setCc($v);
                }
            }
        }
    }
    private function getClassName($brand)
    {
        switch ($brand) {
            case 1:
                $className = "JinDun";
                break;
            default:
                $className = "JinDun";
                return $className;
        }
    }
}

?>