{include file="admin/_header" }

<div class="tab-content mt-4">
    <!-- 搜索框 !-->
    <div class="table-header">
        <div class="table-tools">
            <a href="#" class="btn btn-success w-sm nohide" data-toggle="modal" onclick="exampleModal()" >
                <i class="fas fa-plus-circle"></i> 添加
            </a>

            <input type="text" id="keywords" class="form-control" placeholder="输入关键字" value="{$keywords}">
            <button class="btn btn-primary w-xs" id="searchInp" ><i class="fas fa-search"></i> 搜索</button>
        </div>
    </div>


    <!-- 列表 !-->
    <div class="table-body table-responsive">
        <table class="table table-bordered table-hover">
            <thead class="thead-light">
            <tr>
                <th class="center t1">防火墙ID</th>
                <th class="center t1">用户UID</th>
                <th>产品 ID</th>
                <th>产品 IP</th>
                <th>防护类型</th>
                <th>策略集ID</th>
                <th class="center">添加时间</th>
                <th class="center">修改时间</th>
            </tr>
            </thead>
            <tbody>
            {foreach $list as $v=>$k}
                <tr>
                    <td class="center"><a href="{:shd_addon_url('QingYeFirewall://AdminIndex/addFirewall')}&id={$k.firewall_id}">{$k.firewall_id}</a></td>
                    <td><a href="/{:config('database.admin_application')}#/customer-view/abstract?id={$k.uid}">{$k.uid}</a></td>
                    <td><a href="/{:config('database.admin_application')}#/customer-view/product-innerpage?id={$k.uid}&hid={$k.host_id}">{$k.host_id}</a></td>
                    <td><a href="/{:config('database.admin_application')}#/customer-view/product-innerpage?id={$k.uid}&hid={$k.host_id}">{$k.ip}</a></td>
                    <td><a href="{:shd_addon_url('QingYeFirewall://AdminIndex/setCc')}&keywords={$k.cc_list_id}">{$k.cc_list_name}</a></td>
                    <td><a href="{:shd_addon_url('QingYeFirewall://AdminIndex/setCc')}&keywords={$k.cc_list_id}">{$k.cc_list_id}</a></td>
                    <td>{:date("Y-m-d H:i:s",$k.create_time)}</td>
                    <td>{:date("Y-m-d H:i:s",$k.update_time)}</td>
                </tr>
            {/foreach}
            </tbody>
        </table>
    </div>

    <!-- 分页 !-->
    {$pages|raw}

</div>




{include file="admin/_footer" }


<!-- 添加弹窗 -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">添加CC策略</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form class="form" id="form" autocomplete="off">

                    <div class="form-group row">
                        <label class="require">选择 IP 地址</label>
                        <div class="col-sm-9">
                            <select class="selectpicker show-tick form-control" id="IpSelect" data-live-search="true">
                                <option selected disabled style="display：none" value="">请选择 IP</option>
                                {foreach $host_ip as $p}
                                    {if filter_var($p.dedicatedip, FILTER_VALIDATE_IP)}
                                        <option value="{$p.dedicatedip}">{$p.dedicatedip}</option>
                                    {/if}
                                    {foreach :explode(',',$p.assignedips) as $v}
                                        {if filter_var($v, FILTER_VALIDATE_IP)}
                                            <option value="{$v}">{$v}</option>
                                        {/if}
                                    {/foreach}
                                {/foreach}

                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="require">选择 CC 策略</label>
                        <div class="col-sm-9">
                            <select class="selectpicker show-tick form-control" id="CcSelect" data-live-search="true">
                                <option selected disabled style="display：none" value="">请先选择IP</option>
                            </select>
                        </div>
                    </div>




                </form>

                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">关闭</button>
                    <button type="submit" id="submitBtn" class="btn btn-primary">保存</button>
                </div>


            </div>


        </div>
    </div>
</div>


<link rel="stylesheet" href="{$Themes}/assets/libs/bootstrap-select/css/bootstrap-select.min.css">
<script src="{$Themes}/assets/libs/bootstrap-select/js/bootstrap-select.min.js"></script>
<script src="{$Themes}/assets/libs/bootstrap-select/js/i18n/defaults-zh_CN.min.js"></script>

<script type="text/javascript">

    function exampleModal()
    {
        //打开弹出层
        $('#exampleModal').modal({
            backdrop: 'static',
            //点击背景空白处不被关闭；
            keyboard: false
            //触发键盘esc事件时不关闭。
        });
    }

    $(function() {
        $('#exampleModal').on('hide.bs.modal', function () {
            //弹出窗关闭刷新页面
            window.location.reload();
        });
        $('#searchInp').click(function(){
            location.href = '{:shd_addon_url('QingYeFirewall://AdminIndex/ccList')}' +  '&keywords=' + $('#keywords').val();
        });

        var IpSelect =$("#IpSelect");
        IpSelect.selectpicker();
        IpSelect.change(function() {
            var ip = $(this).val();
            $.ajax({
                url: '{:shd_addon_url('QingYeFirewall://AdminIndex/GetCcType')}',
                type: 'POST',
                data: 'ip='+ip,
                success: function (data) {
                    if (data) {
                        var html ='';
                        for(var i =0 ;i<data.length;i++){
                            html+= '<option value="'+data[i].id+'">'+data[i].name+'</option>';
                        }
                        // console.log(html);
                        if (html !=''){
                            var CcSelect = $('#CcSelect');
                            CcSelect.html(html);
                            CcSelect.selectpicker('refresh');
                        }
                    }
                }, error: function () {
                    toastr.error("系统错误！");
                }
            })
        });
        $("#submitBtn").click(function(){
            var ip = $("#IpSelect").val();
            var cc = $("#CcSelect").val();
            if(ip == "" || $.trim(ip).length == 0){
                toastr.error("请选择IP！");
                return;
            }
            if(cc == "" || $.trim(cc).length == 0){
                toastr.error("请选择CC策略！");
                return;
            }

            var e = this;
            $(e).attr("disabled", true);

            $.ajax({
                url: '{:shd_addon_url('QingYeFirewall://AdminIndex/ccList')}',
                type: 'POST',
                data: {ip:ip,cc:cc},
                success: function (data) {
                    if (data.status) {
                        toastr.success(data.msg)
                        setTimeout(function () { window.location.reload(); }, 1000);
                    }else {
                        toastr.error(data.msg);
                        $(e).attr("disabled", false);
                    }
                }, error: function () {
                    toastr.error("系统错误！");
                    $(e).attr("disabled", false);
                }
            })
        });
    });


</script>
