{include file="admin/_header" }

<div class="tab-content mt-4">
    <!-- 搜索框 !-->
    <div class="table-header">
        <div class="table-tools">
            <a href="{:shd_addon_url('QingYeFirewall://AdminIndex/addFirewall')}" class="btn btn-success w-sm nohide" >
                <i class="fas fa-plus-circle"></i> 添加防火墙
            </a>

            <input type="text" id="keywords" class="form-control" placeholder="输入关键字" value="{$keywords}">
            <button class="btn btn-primary w-xs" id="searchInp" ><i class="fas fa-search"></i> 搜索</button>
        </div>
    </div>

    <!-- 列表 !-->
    <div class="table-body table-responsive">
        <table class="table table-bordered table-hover">
            <caption>选中的项目： <button type="button" class="btn btn-danger btn-sm" onclick="handleOperating()">批量删除</button></caption>
            <thead class="thead-light">
            <tr>
                <th class="checkbox">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input" id="selectAll">
                        <label class="custom-control-label" for="selectAll">&nbsp;</label>
                    </div>
                </th>

                <th class="center t1">ID </th>
                <th class="t4">防火墙名称</th>
                <th class="t4">防火墙地址</th>
                <th>类型</th>
                <th>添加时间</th>
                <th class="center">状态</th>
                <th class="center t5">操作</th>
            </tr>
            </thead>

            <tbody>

            {foreach $list as $v=>$k}
                <tr>
                    <td class="checkbox">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input row-checkbox" id="customCheck{$k.id}">
                            <label class="custom-control-label" for="customCheck{$k.id}">&nbsp;</label>
                        </div>
                    </td>
                    <td class="center">{$k.id}</td>
                    <td>{$k.name}</td>
                    <td><a href="{$k.host}" target="_blank">{$k.host}</a></td>
                    <td>
                        {if $k.brand==1}金盾{/if}
                    </td>
                    <td>{:date("Y-m-d H:i:s",$k.create_time)}</td>
                    <td class="center">
                        {if $k.status==1}
                            <i class="fa fa-check-circle text-success"></i>
                        {else}
                            <i class="fa fa-times text-danger"></i>
                        {/if}
                    </td>
                    <td>
                        <button type="button" class="btn btn-link" onclick="javascript:location.href ='{:shd_addon_url('QingYeFirewall://AdminIndex/addFirewall')}' + '&id={$k.id}' "><i class="fas fa-edit"></i> 修改</button>
                        <button type="button" class="btn btn-link red"  onclick="handleOperating({$k.id})"><i class="fas fa-times"></i> 删除</button>
                    </td>
                </tr>

            {/foreach}


            </tbody>
        </table>
    </div>

    {$pages|raw}
</div>

<script>
    $(function(){

        $('#searchInp').click(function(){
            location.href = '{:shd_addon_url('QingYeFirewall://AdminIndex/setting')}' +  '&keywords=' + $('#keywords').val();
        });

    })

    function handleOperating(command) {
        // 批量操作 直接复制粘贴，用户端
        var batchObj = {id: []};
        batchObj.id.length = 0
        tableMul = getCheckbox()
        for (let i = 0; i < tableMul.length; i++) {
            const item = tableMul[i]
            batchObj.id.push(item)
        }
        if (command){
            batchObj = "id[]=" + command;
        }
        $.ajax({
            type: "post",
            url: '{:shd_addon_url('QingYeFirewall://AdminIndex/delete')}',
            data: batchObj,
            success: function (data) {
                if (data.status == 1) {
                    toastr.success(data.msg)
                    setTimeout(function () { window.location.reload(); }, 1000);
                }else {
                    toastr.error(data.msg)
                }
            }
        });
    }

    // 获取所有勾选项的id
    var getCheckbox = function () {
        // 勾选的id
        const ids = []
        // 所有表格内的checkbox
        const allCheck = [...$('.row-checkbox:checked')]
        for (const key in allCheck) {
            if (Object.hasOwnProperty.call(allCheck, key)) {
                const item = allCheck[key];
                ids.push(item.id.substring(11))
            }
        }
        return ids
    };

</script>


{include file="admin/_footer" }
