<?php
namespace addons\qing_ye_icp;

class QingYeIcpPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "QingYeIcp", "title" => "域名白名单", "description" => "域名白名单插件", "status" => 1, "author" => "青叶云", "version" => "1.1.0", "module" => "addons"];
    public function install()
    {
        $shd_qing_ye_icp = ["DROP TABLE IF EXISTS `shd_qing_ye_icp`", "CREATE TABLE `shd_qing_ye_icp`  (  `id` int(11) NOT NULL AUTO_INCREMENT,  `name` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `username` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `password` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `num` int(11) NULL DEFAULT NULL COMMENT '白名单数量 0 不限制',  `type` int(1) NULL DEFAULT NULL COMMENT '通道类型 1 宿迁 2宁波',  `range` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '产品范围',  `data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '其他数据',  `create_time` int(11) NULL DEFAULT NULL,  `update_time` int(11) NULL DEFAULT NULL,  `status` int(1) NULL DEFAULT NULL COMMENT '0 提交失败 1提交成功 -1 删除成功 -2等待管理员手动删除',  `blacklist` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '域名黑名单',  `white_list` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '域名白名单',  `isDelete` int(1) NULL DEFAULT NULL COMMENT '是否支持删除',  `isAi` int(1) NULL DEFAULT NULL COMMENT '删除域名自动化',  PRIMARY KEY (`id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8mb4"];
        $shd_qing_ye_icp_record = ["DROP TABLE IF EXISTS `shd_qing_ye_icp_record`", "CREATE TABLE `shd_qing_ye_icp_record`  (  `id` int(11) NOT NULL AUTO_INCREMENT,  `uid` int(11) NULL DEFAULT NULL COMMENT '对应的uid',  `host_id` int(11) NULL DEFAULT NULL COMMENT '产品ID',  `domain` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '域名',  `ip` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '对应的ip',  `main_id` int(11) NULL DEFAULT NULL COMMENT '通道ID把',  `create_time` int(11) NULL DEFAULT NULL,  `status` int(1) NULL DEFAULT NULL,  `data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `icp` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备案号',  PRIMARY KEY (`id`) ) ENGINE = InnoDB DEFAULT CHARSET=utf8mb4"];
        $shd_qing_ye_icp_log = ["DROP TABLE IF EXISTS `shd_qing_ye_icp_log`", "CREATE TABLE `shd_qing_ye_icp_log`  (  `id` int(11) NOT NULL AUTO_INCREMENT,  `uid` int(11) NULL DEFAULT NULL,  `ip` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `port` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,  `create_time` int(11) NULL DEFAULT NULL,  `data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `status` int(1) NULL DEFAULT NULL,  `domain` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `host_ip` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,  `host_id` int(11) NULL DEFAULT NULL,  `type` int(1) NULL DEFAULT NULL COMMENT '0  删除  1添加',  `main_id` int(11) NULL DEFAULT NULL,  PRIMARY KEY (`id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8mb4"];
        foreach ($shd_qing_ye_icp as $v) {
            \think\Db::execute($v);
        }
        foreach ($shd_qing_ye_icp_record as $v) {
            \think\Db::execute($v);
        }
        foreach ($shd_qing_ye_icp_log as $v) {
            \think\Db::execute($v);
        }
        return true;
    }
    public function uninstall()
    {
        $sql = "DROP TABLE IF EXISTS `shd_qing_ye_icp`";
        \think\Db::execute($sql);
        $sql = "DROP TABLE IF EXISTS `shd_qing_ye_icp_record`";
        \think\Db::execute($sql);
        $sql = "DROP TABLE IF EXISTS `shd_qing_ye_icp_log`";
        \think\Db::execute($sql);
        return true;
    }
    public function afterModuleTerminate($param)
    {
        $host_id = $param["params"]["hostid"];
        $product_id = $param["params"]["productid"];
        $uid = $param["params"]["uid"];
        $icp_arr = \think\Db::name("qing_ye_icp_record")->alias("a")->join("qing_ye_icp w", "w.id=a.main_id")->where("a.host_id", $host_id)->where("a.uid", $uid)->field("a.id,a.domain,w.id main_id,w.isAi,w.name mainName,w.num,w.white_list,w.isDelete,w.username,w.password,w.password,w.type,w.data,a.domain,a.ip,a.uid,a.host_id")->select();
        foreach ($icp_arr as $k => $v) {
            $domain = $v["domain"];
            $v["web_domain"] = $domain;
            $m = ["data" => "删除" . $domain . "成功", "create_time" => time(), "status" => 1, "domain" => $domain, "host_ip" => $v["ip"], "host_id" => $host_id, "type" => 0, "main_id" => $v["main_id"]];
            if ($v["isAi"] == 1) {
                $v["data"] = json_decode($v["data"], true);
                switch ($v["type"]) {
                    case 1:
                        $className = "SuQian";
                        break;
                    case 2:
                        $className = "AoDun";
                        break;
                    case 3:
                        $className = "Pgy";
                        break;
                    case 4:
                        $className = "SuLian";
                        break;
                    default:
                        $className = NULL;
                        $ret = ["status" => 0, "msg" => "非法访问！"];
                        if ($className) {
                            $class = "\\addons\\qing_ye_icp\\common\\" . ucfirst($className);
                            $firewall = new $class();
                            $ret = $firewall->delDomainWhiteList($v);
                        }
                        if ($ret["status"] == 1) {
                            if (\think\Db::name("qing_ye_icp_record")->where("id", $v["id"])->update(["status" => -1])) {
                                echo "删除" . $domain . "成功" . PHP_EOL;
                                \think\Db::name("qing_ye_icp_log")->data($m)->insert();
                            }
                        } else {
                            if ($ret["status"] == 0) {
                                echo "删除" . $domain . "失败，接口返回：" . $ret["msg"] . PHP_EOL;
                                $m["status"] = 0;
                                $m["data"] = "删除" . $domain . "失败，接口返回：" . $ret["msg"];
                                \think\Db::name("qing_ye_icp_log")->data($m)->insert();
                            }
                        }
                }
            } else {
                if (\think\Db::name("qing_ye_icp_record")->where("id", $v["id"])->update(["status" => -2, "data" => "等待删除"])) {
                    echo "删除" . $domain . "，等待管理员手动删除" . PHP_EOL;
                    $m["data"] = "删除" . $domain . "，等待管理员手动删除";
                    \think\Db::name("qing_ye_icp_log")->data($m)->insert();
                }
            }
        }
    }
    public function templateAfterServicedetailSuspended($param)
    {
        $firewall = \think\Db::name("qing_ye_icp")->where("status", 1)->field("range")->select();
        $range = "";
        foreach ($firewall as $k => $v) {
            $range .= $v["range"] . ",";
        }
        $range = substr($range, 0, strlen($range) - 1);
        $hostid = intval($param["hostid"]);
        $tmp = \think\Db::name("host")->where("productid", "in", $range)->where("id", $hostid)->where("domainstatus", "Active")->find();
        if (empty($tmp)) {
            return "";
        }
        $url = shd_addon_url("QingYeIcp://Index/icp", ["hostId" => $hostid], true);
        return "<a href=\"" . $url . "\" class=\"btn btn-primary h-100 custom-button text-qing_ye-white\" >域名白名单</a>";
    }
    public function beforeCron()
    {
        $PgyCode = new common\PgyCode();
        $PgyCode->beforeCron();
    }
}

?>