<section class="admin-main">
    <!-- 干掉溢出隐藏，解决 select被遮挡-->
    <style>.main-content { overflow: visible;}</style>

    <div class="card">
        <div class="card-body">
            <div class="ticket-top">
                <p>1、域名只需要提交顶级域名，系统会在提交后5分钟内审核完毕，多个IP的只要提交主IP即可；</p>
                <p>2、如果提交后5分钟还处于拦截状态，请查询域名是否备案号被取消；<a href="https://beian.miit.gov.cn/" target="_blank">点击查询备案号</a></p>
                <p>3、如果您的网站未备案，则有可能将您的网站域名拉入黑名单，请勿尝试。</p>
            </div>
        </div>
    </div>


    <div class="card">
        <div class="card-body">
            <form id="addFireWallForm"  class="form">
                <div class="form-row ">
                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label class="require">选择 IP 地址</label>
                        <select class="selectpicker show-tick form-control" id="IpSelect" data-live-search="true">
                            <option selected disabled style="display：none" value="">请选择 IP</option>
                            {foreach $host_ip as $p}
                                {if filter_var($p.dedicatedip, FILTER_VALIDATE_IP)}
                                    <option value="{$p.dedicatedip}">{$p.dedicatedip}</option>
                                {/if}
                                {foreach :explode(',',$p.assignedips) as $v}
                                    {if filter_var($v, FILTER_VALIDATE_IP)}
                                        <option value="{$v}">{$v}</option>
                                    {/if}
                                {/foreach}
                            {/foreach}

                        </select>
                    </div>
                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label>白名单 域名</label>
                        <input type="text" class="form-control" id="web_domain" placeholder="请输入域名">
                    </div>

                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label>&nbsp;</label>
                        <button class="btn btn-primary form-control" id="button" type="button">添加 域名 白名单</button>
                    </div>
                </div>
            </form>

        </div>
    </div>


    <div class="card">
        <div class="card-body">
            <div class="table-header">

                <div class="page-title-box d-flex align-items-center justify-content-between">
                    <div style="display:flex;">
                        <h4 class="mb-0 font-size-18">域名 白名单列表</h4>
                    </div>
                </div>
                <div class="table-search">
                    <div class="row justify-content-end">
                        <div class="col-sm-6">
                            <div class="search-box">
                                <div class="position-relative">
                                    <input type="text" class="form-control" id="searchInp" value="{$keywords}" placeholder="按关键字搜索">
                                    <i class="bx bx-search-alt search-icon" id="searchIcon"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="table-body table-responsive">
                <table class="table table-bordered table-hover">

                    <thead class="thead-light">
                    <tr>
                        <th class="center t1">白名单通道名称</th>
                        <th class="center t1">产品 IP</th>
                        <th class="center t1">白名单域名</th>
                        <th class="center t1">ICP备案号</th>
                        <th>添加时间</th>
                        <th >操作</th>
                    </tr>
                    </thead>
                    <tbody>
                    {foreach $YeList as $k}
                        <tr>
                            <td class="center">{$k.icpName}</td>
                            <td><a href="/servicedetail?id={$k.host_id}">{$k.ip}</a></td>
                            <td>{$k.domain}</td>
                            <td>{$k.icp}</td>
                            <td>{:date("Y-m-d H:i:s",$k.create_time)}</td>
                            <!-- <td>
                                <a href="javascript:Delete({$k.id});">删除</a>
                                <a href="javascript:Delete({$k.id});">删除</a>
                            </td> -->
                            <td>
                                <button type="button" class="btn btn-link" onclick="Update({$k.id});"> 重新添加</button>
                                <button type="button" class="btn btn-link red" onclick="Delete({$k.id});">删除</button>
                            </td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
            </div>

            {$pages|raw}

        </div>
    </div>


    <link rel="stylesheet" href="{$Setting.web_url}/themes/clientarea/default/assets/libs/bootstrap-select/css/bootstrap-select.min.css?v={$Ver}">
    <script src="{$Setting.web_url}/themes/clientarea/default/assets/libs/bootstrap-select/js/bootstrap-select.min.js?v={$Ver}"></script>
    <script src="{$Setting.web_url}/themes/clientarea/default/assets/libs/bootstrap-select/js/i18n/defaults-zh_CN.min.js"></script>


    <script>


        function Update(id){
            if(!/^\d+$/.test(id)){
                toastr.error('非法提交！');
                return;
            }
            $.ajax({
                type: "post",
                url: '{:shd_addon_url('QingYeIcp://Index/UpdateIcp',[],true)}',
                data: {id:id},
                success: function (data) {
                    if (data.status == 1) {
                        toastr.success(data.msg)
                        setTimeout(function () { window.location.reload(); }, 1000);
                    }else {
                        toastr.error(data.msg)
                    }
                }, error: function () {
                    toastr.error("系统错误！");
                }
            });
        }


        function Delete(id)
        {
            if(!/^\d+$/.test(id)){
                toastr.error('非法提交！');
                return;
            }
            $.ajax({
                type: "post",
                url: '{:shd_addon_url('QingYeIcp://Index/DeleteIcp',[],true)}',
                data: {id:id},
                success: function (data) {
                    if (data.status == 1) {
                        toastr.success(data.msg)
                        setTimeout(function () { window.location.reload(); }, 1000);
                    }else {
                        toastr.error(data.msg)
                    }
                }, error: function () {
                    toastr.error("系统错误！");
                }
            });
        }


        $(function() {

            $("#button").click(function(){
                var elem = this;
                var ip = $("#IpSelect").val();
                var web_domain = $("#web_domain").val();
                if(ip == "" || $.trim(ip).length == 0){
                    toastr.error("请选择IP！");
                    return;
                }
                if(web_domain == "" || $.trim(web_domain).length == 0){
                    toastr.error("请填写白名单IP！");
                    return;
                }
                BtnLoading(elem);
                $.ajax({
                    url: '{:shd_addon_url('QingYeIcp://Index/addIcp',[],true)}',
                    type: 'POST',
                    data: {ip:ip,web_domain:web_domain},
                    success: function (data) {
                        if (data.status==1) {
                            toastr.success(data.msg);
                            BtnReset(elem);

                            setTimeout(function () { location.href = '{:shd_addon_url('QingYeIcp://Index/icp',[],true)}'+ '&ip=' + ip; }, 1000);
                        }else {
                            toastr.error(data.msg);
                            BtnReset(elem);
                        }
                    }, error: function () {
                        toastr.error("系统错误！");
                        BtnReset(elem);
                    }
                })
            });

            var IpSelect =$("#IpSelect");
            IpSelect.selectpicker();
            {if $dedicatedip}
            IpSelect.val('{$dedicatedip}').change();
            IpSelect.selectpicker('refresh');
            {/if}

            $('#searchInp').on('keydown', function (e) {
                if (e.keyCode == 13) {
                    location.href = '{:shd_addon_url('QingYeIcp://Index/icp',[],true)}'+ '&keywords=' + $('#searchInp').val() ;
                }
            });
            $('#searchIcon').on('click', function () {
                location.href = '{:shd_addon_url('QingYeIcp://Index/icp',[],true)}'+ '&keywords=' + $('#searchInp').val() ;
            });

        });

        function BtnLoading(elem) {
            $(elem).attr("data-original-text", $(elem).html());
            $(elem).prop("disabled", true);
            $(elem).html('<i class="spinner-border spinner-border-sm"></i> 加载中...');
            $(elem).css("background-color","#6064ff");
        }

        function BtnReset(elem) {
            $(elem).prop("disabled", false);
            $(elem).html($(elem).attr("data-original-text"));
            $(elem).css("background-color",'');
        }


    </script>

</section>