<?php
namespace addons\qing_ye_icp\common;

class SuLian
{
    public function addDomainWhiteList($param)
    {
        $url = "http://api.white.idc002.com/whitelist/add";
        $parameter = ["domain" => $param["web_domain"], "idc" => $param["data"]["idc_id"], "ip" => $param["ip"], "token" => $this->token($param["id"], $param["username"], $param["password"])];
        $data = $this->post($url, $parameter);
        $json = json_decode($data, true);
        if ($json["status"] == 1) {
            return ["status" => 1, "msg" => "添加成功。"];
        }
        return ["status" => 0, "msg" => $json["msg"]];
    }
    public function delDomainWhiteList($param)
    {
        $Id = $param["id"];
        if (!empty($param["main_id"])) {
            $Id = $param["main_id"];
        }
        $url = "http://api.white.idc002.com/whitelist/del";
        $parameter = ["domain" => $param["domain"], "idc" => $param["data"]["idc_id"], "token" => $this->token($Id, $param["username"], $param["password"])];
        $data = $this->post($url, $parameter);
        $json = json_decode($data, true);
        if ($json["status"] == 1) {
            return ["status" => 1, "msg" => "删除成功"];
        }
        return ["status" => 0, "msg" => $json["msg"]];
    }
    private function token($id, $uname, $upass)
    {
        $token = cache($id . "api.white.idc002.com_white_token");
        if ($token) {
            $time = time() + 60;
            if ($time <= $token["expiry_time"]) {
                return $token["token"];
            }
        }
        $url = "http://api.white.idc002.com/account/login";
        $parameter = ["uname" => $uname, "upass" => $upass];
        $data = $this->post($url, $parameter);
        $json = json_decode($data, true);
        if ($json["status"] == 1) {
            cache($id . "api.white.idc002.com_white_token", $json["data"]);
            return $json["data"]["token"];
        }
        return "";
    }
    private function post($url, $param, $post_file = false)
    {
        $oCurl = curl_init();
        if (stripos($url, "https://") !== false) {
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_SSLVERSION, 1);
        }
        if (is_string($param) || $post_file) {
            $strPOST = $param;
        } else {
            $aPOST = [];
            foreach ($param as $key => $val) {
                $aPOST[] = $key . "=" . urlencode($val);
            }
            $strPOST = join("&", $aPOST);
        }
        curl_setopt($oCurl, CURLOPT_URL, $url);
        curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($oCurl, CURLOPT_POST, true);
        curl_setopt($oCurl, CURLOPT_POSTFIELDS, $strPOST);
        $sContent = curl_exec($oCurl);
        $aStatus = curl_getinfo($oCurl);
        curl_close($oCurl);
        if (intval($aStatus["http_code"]) == 200) {
            return $sContent;
        }
        return false;
    }
}

?>