<?php
namespace addons\qing_ye_icp\common;

class SuQian
{
    public function addDomainWhiteList($param)
    {
        $username = $param["username"];
        $code = $param["password"];
        $web_domain = $param["web_domain"];
        $ip = $param["ip"];
        if (!$username || !$code) {
            return ["status" => 0, "msg" => "配置错误！"];
        }
        $person = $this->get_person($param["uid"]);
        $encrypt = md5($username . $code);
        $url = "https://user.pgyidc.com/apihr/wl?requestname=" . $username . "&domain=" . $web_domain . "&ip=" . $ip . "&code=" . $code . "&encrypt=" . $encrypt . "&username=" . $param["uid"] . ":" . $person["auth_real_name"] . "&phone=" . $person["phonenumber"] . "&idcard=" . $person["auth_card_number"];
        $res = $this->get($url);
        if (!$res) {
            return ["status" => 0, "msg" => "接口异常！"];
        }
        $json = json_decode($res, true);
        if ($json["status"] == 0) {
            return ["status" => 1, "msg" => "添加成功。"];
        }
        return ["status" => 0, "msg" => "添加失败，接口返回状态码：" . $json["status"]];
    }
    public function delDomainWhiteList($param)
    {
        return ["status" => -2, "msg" => "请手动删除。"];
    }
    private function get_person($uid)
    {
        $person = \think\Db::name("clients")->alias("a")->join("certifi_company w", "w.auth_user_id=a.id")->where("a.id", $uid)->where("w.auth_user_id", $uid)->where("w.status", 1)->field("a.phonenumber,a.email,w.company_name auth_real_name,w.company_organ_code auth_card_number")->find();
        if (!$person) {
            $person = \think\Db::name("clients")->alias("a")->join("certifi_person w", "w.auth_user_id=a.id")->where("a.id", $uid)->where("w.auth_user_id", $uid)->where("w.status", 1)->field("a.phonenumber,a.email,w.auth_real_name,w.auth_card_number")->find();
        }
        return $person;
    }
    private function get($url)
    {
        $oCurl = curl_init();
        if (stripos($url, "https://") !== false) {
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_SSLVERSION, 1);
        }
        curl_setopt($oCurl, CURLOPT_URL, $url);
        curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
        $sContent = curl_exec($oCurl);
        $aStatus = curl_getinfo($oCurl);
        curl_close($oCurl);
        if (intval($aStatus["http_code"]) == 200) {
            return $sContent;
        }
        return false;
    }
    private function post($url, $param, $post_file = false)
    {
        $oCurl = curl_init();
        if (stripos($url, "https://") !== false) {
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_SSLVERSION, 1);
        }
        if (is_string($param) || $post_file) {
            $strPOST = $param;
        } else {
            $aPOST = [];
            foreach ($param as $key => $val) {
                $aPOST[] = $key . "=" . urlencode($val);
            }
            $strPOST = join("&", $aPOST);
        }
        curl_setopt($oCurl, CURLOPT_URL, $url);
        curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($oCurl, CURLOPT_POST, true);
        curl_setopt($oCurl, CURLOPT_POSTFIELDS, $strPOST);
        $sContent = curl_exec($oCurl);
        $aStatus = curl_getinfo($oCurl);
        curl_close($oCurl);
        if (intval($aStatus["http_code"]) == 200) {
            return $sContent;
        }
        return false;
    }
    private function sign($params, $secret)
    {
        $sign = $signstr = "";
        if (!empty($params)) {
            ksort($params);
            reset($params);
            foreach ($params as $key => $val) {
                if ($key != "sign") {
                    if ($signstr != "") {
                        $signstr .= "&";
                    }
                    $signstr .= $key . "=" . $val;
                }
            }
            $sign = md5($signstr . $secret);
        }
        return $sign;
    }
}

?>