<?php
namespace addons\qing_ye_icp\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public function icp(\think\Request $request)
    {
        $uid = $request->uid;
        $hostId = $request->hostId;
        $param = $request->param();
        $page = !empty($param["page"]) ? intval($param["page"]) : 1;
        $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
        $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
        $list = \think\Db::name("qing_ye_icp_record")->alias("a")->join("host w", "a.host_id=w.id")->join("qing_ye_icp f", "f.id=a.main_id")->where("w.domainstatus", "Active")->where("a.status", 1)->where("a.uid", $uid)->where("w.uid", $uid)->order("a.id", "desc")->where("a.main_id|f.name|a.ip|a.domain", "like", "%" . $keywords . "%")->field("a.main_id,a.ip,a.icp,a.create_time,a.host_id,a.domain,a.id,f.name icpName")->paginate($limit);
        $all = \think\Db::name("qing_ye_icp_record")->alias("a")->join("host w", "a.host_id=w.id")->join("qing_ye_icp f", "f.id=a.main_id")->where("w.domainstatus", "Active")->where("a.status", 1)->where("a.uid", $uid)->where("w.uid", $uid)->where("a.main_id|f.name|a.ip|a.domain", "like", "%" . $keywords . "%")->field("a.id")->all();
        $count = count($all);
        $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeIcp://Index/icp", [], true), $keywords);
        $this->assign("pages", $pages);
        $this->assign("keywords", $keywords);
        $this->assign("YeList", $list);
        $host_ip = $this->host_ip($uid, $hostId);
        if ($hostId && $host_ip) {
            $this->assign("dedicatedip", $host_ip[0]["dedicatedip"]);
        } else {
            if ($param["ip"]) {
                $this->assign("dedicatedip", $param["ip"]);
            }
        }
        $this->assign("host_ip", $host_ip);
        $this->assign("Title", "域名白名单");
        return $this->fetch("/icp");
    }
    public function addIcp(\think\Request $request)
    {
        $param = $request->param();
        $uid = $request->uid;
        $rule = ["ip|IP 地址" => "require|ip", "web_domain|白名单域名" => "require"];
        $Validate = \think\facade\Validate::rule($rule);
        $res = \think\facade\Validate::check($param);
        if (true !== $res) {
            return json(["status" => 0, "msg" => $Validate->getError()]);
        }
        $domain = $param["web_domain"];
        $domain = $this->getDoMain($domain);
        if (!$this->isValidDomain($domain)) {
            return json(["status" => 0, "msg" => "域名格式不正确！"]);
        }
        $icp_arr = $this->get_icp($param["ip"], $uid);
        if (!$icp_arr) {
            return json(["status" => 0, "msg" => "非法访问！"]);
        }
        $record = \think\Db::name("qing_ye_icp_record")->where(["uid" => $uid, "domain" => $domain, "ip" => $param["ip"], "status" => 1])->count();
        if ($record) {
            return json(["status" => 0, "msg" => "请勿重复添加！"]);
        }
        $url = "https://www.icpapi.com/api/v1.1";
        $params = $domain;
        $appId = "mfyicp";
        $key = "5b37f435fb798b80278b1182c8080bb7a7bd9600";
        $data = ["appid" => $appId, "params" => $params, "timestamp" => time()];
        $data["sign"] = $this->sign($data, $key);
        $res = $this->post($url, $data);
        $json = json_decode($res, true);
        if ($json["code"] == 1) {
            if ($json["status"] != 1) {
                return json(["status" => 0, "msg" => "自动审核，未备案。"]);
            }
            $icp = $json["params"][0]["serviceLicence"];
            $i = 0;
            foreach ($icp_arr["data"] as $k => $v) {
                $v["data"] = json_decode($v["data"], true);
                $v["ip"] = $param["ip"];
                $v["uid"] = $uid;
                $v["web_domain"] = $domain;
                $blacklist = explode(",", $v["blacklist"]);
                $white_list = explode(",", $v["white_list"]);
                $all = \think\Db::name("qing_ye_icp_record")->where(["ip" => $param["ip"], "host_id" => $icp_arr["host_id"], "uid" => $uid, "main_id" => $v["id"], "status" => 1])->all();
                $count = count($all);
                if (0 < $v["num"] && $v["num"] <= $count) {
                    $ret = ["status" => -1, "msg" => "提交上限，每个产品IP只能提交" . $v["num"] . "个主域名！"];
                } else {
                    if (in_array($domain, $blacklist)) {
                        $ret = ["status" => -1, "msg" => "该域名为违规域名请联系机房管理员！"];
                    } else {
                        if (in_array($domain, $white_list)) {
                            $ret = ["status" => -1, "msg" => "该域名非本人域名请勿提交！"];
                        } else {
                            switch ($v["type"]) {
                                case 1:
                                    $className = "SuQian";
                                    break;
                                case 2:
                                    $className = "AoDun";
                                    break;
                                case 3:
                                    $className = "Pgy";
                                    break;
                                case 4:
                                    $className = "SuLian";
                                    break;
                                case 5:
                                    $className = "PgyCode";
                                    break;
                                default:
                                    $className = NULL;
                                    $ret = ["status" => 0, "msg" => "非法访问！"];
                                    if ($className) {
                                        $class = "\\addons\\qing_ye_icp\\common\\" . ucfirst($className);
                                        $firewall = new $class();
                                        $ret = $firewall->addDomainWhiteList($v);
                                    }
                            }
                        }
                    }
                }
                $m = ["uid" => $uid, "host_id" => $icp_arr["host_id"], "domain" => $domain, "ip" => $param["ip"], "main_id" => $v["id"], "status" => 1, "create_time" => time(), "data" => "添加成功。"];
                $l = ["status" => 1, "domain" => $domain, "host_ip" => $param["ip"], "host_id" => $icp_arr["host_id"], "main_id" => $v["id"], "type" => 1];
                if ($ret["status"] == 1) {
                    $m["icp"] = $icp;
                    if (\think\Db::name("qing_ye_icp_record")->data($m)->insert()) {
                        $i++;
                    }
                    $this->log($request, $l, "添加成功");
                } else {
                    $l["status"] = 0;
                    $this->log($request, $l, $ret["msg"]);
                }
            }
            if (count($icp_arr["data"]) == 1) {
                if ($i == count($icp_arr["data"])) {
                    $ret = ["status" => 1, "msg" => "添加成功。"];
                }
            } else {
                if (1 < count($icp_arr["data"]) && 0 < $i) {
                    $count = count($icp_arr["data"]);
                    $ret = ["status" => 1, "msg" => "成功添加 " . $i . " 个白名单接口，次商品共有 " . $count . " 个白名单接口"];
                }
            }
            return json($ret);
        } else {
            return json(["status" => 0, "msg" => "服务器错误！"]);
        }
    }
    public function DeleteIcp(\think\Request $request)
    {
        $param = $request->param();
        $uid = $request->uid;
        $rule = ["id" => "require|integer"];
        $Validate = \think\facade\Validate::rule($rule);
        $Validate->message("id", "非法提交！");
        $res = \think\facade\Validate::check($param);
        if (true !== $res) {
            return json(["status" => 0, "msg" => $Validate->getError()]);
        }
        $icp = \think\Db::name("qing_ye_icp_record")->alias("a")->join("qing_ye_icp w", "w.id=a.main_id")->where("a.status", 1)->where("w.status", 1)->where("a.id", $param["id"])->where("a.uid", $uid)->field("a.id,w.id main_id,w.isAi,w.name mainName,w.num,w.white_list,w.isDelete,w.username,w.password,w.password,w.type,w.data,a.domain,a.ip,a.uid,a.host_id")->find();
        if (!$icp) {
            return json(["status" => 0, "msg" => "非法访问！"]);
        }
        if ($icp["isDelete"] != 1) {
            return json(["status" => 0, "msg" => "不支持删除此域名！"]);
        }
        $white_list = explode(",", $icp["white_list"]);
        $blacklist = explode(",", $icp["blacklist"]);
        if (in_array($icp["domain"], $white_list)) {
            return json(["status" => 0, "msg" => "该域名非本人域名请勿删除！"]);
        }
        if (in_array($icp["domain"], $blacklist)) {
            return json(["status" => 0, "msg" => "该域名为违规域名请联系机房管理员！"]);
        }
        $l = ["status" => 1, "domain" => $icp["domain"], "host_ip" => $icp["ip"], "host_id" => $icp["host_id"], "main_id" => $icp["main_id"], "type" => 0];
        if ($icp["isAi"] == 1) {
            $icp["data"] = json_decode($icp["data"], true);
            switch ($icp["type"]) {
                case 1:
                    $className = "SuQian";
                    break;
                case 2:
                    $className = "AoDun";
                    break;
                case 3:
                    $className = "Pgy";
                    break;
                case 4:
                    $className = "SuLian";
                    break;
                case 5:
                    $className = "PgyCode";
                    break;
                default:
                    $className = NULL;
                    $ret = ["status" => 0, "msg" => "非法访问！"];
                    if ($className) {
                        $class = "\\addons\\qing_ye_icp\\common\\" . ucfirst($className);
                        $firewall = new $class();
                        $ret = $firewall->delDomainWhiteList($icp);
                    }
                    if ($ret["status"] == 1) {
                        if (\think\Db::name("qing_ye_icp_record")->where("id", $param["id"])->update(["status" => -1])) {
                            $this->log($request, $l, "删除成功");
                            return json(["status" => 1, "msg" => "删除成功！"]);
                        }
                    } else {
                        if ($ret["status"] == 0) {
                            $l["status"] = 0;
                            $this->log($request, $l, $ret["msg"]);
                            return json($ret);
                        }
                    }
            }
        }
        if (\think\Db::name("qing_ye_icp_record")->where("id", $param["id"])->update(["status" => -2, "data" => "等待删除"])) {
            $this->log($request, $l, "需要管理员手动删除");
            return json(["status" => 1, "msg" => "删除成功！"]);
        }
        $l["status"] = 0;
        $this->log($request, $l, "更改数据失败！");
        return json(["status" => 0, "msg" => "删除失败！"]);
    }
    public function UpdateIcp(\think\Request $request)
    {
        $param = $request->param();
        $uid = $request->uid;
        $rule = ["id" => "require|integer"];
        $Validate = \think\facade\Validate::rule($rule);
        $Validate->message("id", "非法提交！");
        $res = \think\facade\Validate::check($param);
        if (true !== $res) {
            return json(["status" => 0, "msg" => $Validate->getError()]);
        }
        $icp = \think\Db::name("qing_ye_icp_record")->alias("a")->join("qing_ye_icp w", "w.id=a.main_id")->where("a.status", 1)->where("w.status", 1)->where("a.id", $param["id"])->where("a.uid", $uid)->field("a.id,w.id main_id,w.isAi,w.name mainName,w.num,w.white_list,w.isDelete,w.username,w.password,w.password,w.type,w.data,a.domain,a.ip,a.uid,a.host_id")->find();
        if (!$icp) {
            return json(["status" => 0, "msg" => "非法访问！"]);
        }
        $url = "https://www.icpapi.com/api/v1.1";
        $params = $icp["domain"];
        $appId = "mfyicp";
        $key = "5b37f435fb798b80278b1182c8080bb7a7bd9600";
        $data = ["appid" => $appId, "params" => $params, "timestamp" => time()];
        $data["sign"] = $this->sign($data, $key);
        $res = $this->post($url, $data);
        $json = json_decode($res, true);
        if ($json["code"] == 1) {
            if ($json["status"] != 1) {
                \think\Db::name("qing_ye_icp_record")->where("id", $param["id"])->update(["status" => -1]);
                return json(["status" => 0, "msg" => "域名未备案,系统将自动删除白名单！"]);
            }
            $icp_ = $json["params"][0]["serviceLicence"];
            $l = ["status" => 1, "domain" => $icp["domain"], "host_ip" => $icp["ip"], "host_id" => $icp["host_id"], "main_id" => $icp["main_id"], "type" => 2];
            $icp["data"] = json_decode($icp["data"], true);
            switch ($icp["type"]) {
                case 1:
                    $className = "SuQian";
                    break;
                case 2:
                    $className = "AoDun";
                    break;
                case 3:
                    $className = "Pgy";
                    break;
                case 4:
                    $className = "SuLian";
                    break;
                case 5:
                    $className = "PgyCode";
                    break;
                default:
                    $className = NULL;
                    $ret = ["status" => 0, "msg" => "非法访问！"];
                    if ($className) {
                        $class = "\\addons\\qing_ye_icp\\common\\" . ucfirst($className);
                        $firewall = new $class();
                        $icp["web_domain"] = $icp["domain"];
                        $ret = $firewall->addDomainWhiteList($icp);
                    }
                    if ($ret["status"] == 1) {
                        \think\Db::name("qing_ye_icp_record")->where("id", $param["id"])->update(["icp" => $icp_]);
                        $this->log($request, $l, "重新添加成功");
                        return json(["status" => 1, "msg" => "重新添加成功！"]);
                    }
                    $l["status"] = 0;
                    $this->log($request, $l, $ret["msg"]);
                    return json($ret);
            }
        } else {
            return json(["status" => 0, "msg" => "服务器错误！"]);
        }
    }
    private function get_icp($ip, $uid)
    {
        $productId = \think\Db::name("host")->where(["uid" => $uid, "domainstatus" => "Active"])->where("FIND_IN_SET('" . $ip . "',`assignedips`) OR  `dedicatedip`='" . $ip . "'")->field("productid,id")->find();
        if (!$productId["productid"]) {
            return false;
        }
        $icp = \think\Db::name("qing_ye_icp")->where("status", 1)->where("FIND_IN_SET('" . $productId["productid"] . "',`range`)")->select();
        if (!$icp) {
            return false;
        }
        $firewall["host_id"] = $productId["id"];
        $firewall["product_id"] = $productId["productid"];
        $firewall["data"] = $icp;
        return $firewall;
    }
    private function host_ip($uid, $hostId = "")
    {
        $icp = \think\Db::name("qing_ye_icp")->where("status", 1)->field("range")->select();
        $range = "";
        foreach ($icp as $k => $v) {
            $range .= $v["range"] . ",";
        }
        $range = substr($range, 0, strlen($range) - 1);
        $host_ip = \think\Db::name("host")->where(["uid" => $uid, "domainstatus" => "Active"]);
        if ($hostId != "") {
            $host_ip->orderRaw("id=" . $hostId . " desc");
        }
        $host_ip = $host_ip->order("id", "desc")->where("productid", "in", $range)->field("dedicatedip,assignedips,id")->select();
        return $host_ip;
    }
    private function log(\think\Request $request, $param, $data)
    {
        $ip = $request->ip();
        $Port = $request->remotePort();
        $uid = $request->uid;
        $d = ["uid" => $uid, "ip" => $ip, "port" => $Port, "create_time" => time(), "data" => $data, "status" => $param["status"], "domain" => $param["domain"], "host_ip" => $param["host_ip"], "host_id" => $param["host_id"], "type" => $param["type"], "main_id" => $param["main_id"]];
        \think\Db::name("qing_ye_icp_log")->data($d)->insert();
    }
    private function pages($page, $count, $limit, $url, $keywords, $listNum = 5)
    {
        $url = $url . "&keywords=" . $keywords;
        $PageCount = ceil($count / $limit);
        if ($page == 1) {
            $prev = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">«</a></li>";
        } else {
            $prev = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . ($page - 1) . "&limit=" . $limit . "\">«</a></li>";
        }
        if ($page == $PageCount) {
            $next = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">»</a></li>";
        } else {
            $next = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . ($page + 1) . "&limit=" . $limit . "\">»</a></li>";
        }
        if ($page == 1) {
            $first = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">首 页</a></li>";
        } else {
            $first = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=1" . "&limit=" . $limit . "\">首 页</a></li>";
        }
        if ($page == $PageCount) {
            $last = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">尾 页</a></li>";
        } else {
            $last = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . $PageCount . "&limit=" . $limit . "\">尾 页</a></li>";
        }
        $html = "<div class=\"table-footer\"> <div class=\"table-tools\"></div><div class=\"table-pagination\"> <span>共 " . $count . " 条</span> <div class=\"table-pageinfo mx-2\"><select class=\"form-control\" style=\"height:calc(1.5em + 0.94rem + -5px)\" id=\"limitSel\">";
        $html .= $limit == 10 ? "<option value=\"10\" selected >10条/页</option>" : "<option value=\"10\">10条/页</option>";
        $html .= $limit == 15 ? "<option value=\"15\" selected >15条/页</option>" : " <option value=\"15\">15条/页</option>";
        $html .= $limit == 20 ? "<option value=\"20\" selected >20条/页</option>" : " <option value=\"20\">20条/页</option>";
        $html .= $limit == 25 ? "<option value=\"25\" selected >25条/页</option>" : " <option value=\"25\">25条/页</option>";
        $html .= $limit == 50 ? "<option value=\"50\" selected >50条/页</option>" : " <option value=\"50\">50条/页</option>";
        $html .= $limit == 100 ? "<option value=\"100\" selected >100条/页</option>" : "<option value=\"100\" >100条/页</option>";
        $html .= "</select></div><nav><ul class=\"pagination pagination-sm\">" . $first . $prev;
        $inum = floor($listNum / 2);
        for ($i = $page - $inum; $i <= $page + $inum; $i++) {
            if ($i > 0) {
                if ($PageCount >= $i) {
                    if ($i == $page) {
                        $html .= "<li class=\"page-item active\">";
                        $html .= "<a class=\"page-link\">" . $i . "</a>";
                        $html .= "</li>";
                    } else {
                        $html .= "<li class=\"page-item\">";
                        $html .= "<a class=\"page-link\" href=\"" . $url . "&page=" . $i . "&limit=" . $limit . "\">" . $i . "</a>";
                        $html .= "</li>";
                    }
                }
            }
        }
        $html .= $next . $last;
        $html .= "</ul></nav></div>";
        $html .= "<script>\$(function(){ \$('#limitSel').on('change', function () {location.href = '" . $url . "' + '&page=1&limit=' + \$('#limitSel').val();})});</script>";
        $html .= "</div>";
        return $html;
    }
    private function isValidDomain($domain)
    {
        if (strpos($domain, ".") === false) {
            return false;
        }
        $explode = explode(".", $domain);
        $strlenAll = 0;
        foreach ($explode as $k => $v) {
            if (empty($v)) {
                return false;
            }
            $rule = "/^(?!-)+[a-zA-Z0-9-]*\$/";
            $match = preg_match($rule, $v);
            if ($match === (int) 0) {
                return false;
            }
            $strlen = strlen($v);
            if ((int) 0 < $k) {
                $strlenAll = $strlen + $strlenAll;
            }
            if ($strlen < (int) 1 || (int) 63 < $strlen) {
                return false;
            }
            if ((int) 255 < $strlenAll) {
                return false;
            }
        }
        return true;
    }
    private function getDoMain($url)
    {
        if (empty($url)) {
            return "";
        }
        if (strpos($url, "http://") !== false) {
            $url = str_replace("http://", "", $url);
        }
        if (strpos($url, "https://") !== false) {
            $url = str_replace("https://", "", $url);
        }
        $n = 0;
        for ($i = 1; $i <= 3; $i++) {
            $n = strpos($url, "/", $n);
            $i != 3 && $n++;
        }
        $nn = strpos($url, "?");
        $mix_num = min($n, $nn);
        if (0 < $mix_num || !empty($mix_num)) {
            $url = mb_substr($url, 0, $mix_num);
        }
        $data = explode(".", $url);
        $co_ta = count($data);
        $no_tow = true;
        $host_cn = ["ac.cn", "com.cn", "edu.cn", "gov.cn", "mil.cn", "net.cn", "org.cn", "bj.cn", "sh.cn", "tj.cn", "cq.cn", "he.cn", "sx.cn", "nm.cn", "ln.cn", "jl.cn", "hl.cn", "js.cn", "zj.cn", "ah.cn", "fj.cn", "jx.cn", "sd.cn", "ha.cn", "hb.cn", "hn.cn", "gd.cn", "gx.cn", "hi.cn", "sc.cn", "gz.cn", "yn.cn", "xz.cn", "sn.cn", "gs.cn", "qh.cn", "nx.cn", "xj.cn", "tw.cn", "hk.cn", "mo.cn", "com.af", "net.af", "org.af", "com.ag", "net.ag", "org.ag", "co.at", "or.at", "com.bi", "edu.bi", "info.bi", "mo.bi", "or.bi", "org.bi", "com.br", "net.br", "org.br", "co.bz", "com.bz", "net.bz", "org.bz", "co.cm", "com.cm", "net.cm", "com.co", "net.co", "nom.co", "ar.com", "br.com", "cn.com", "de.com", "eu.com", "gb.com", "gr.com", "hu.com", "jpn.com", "kr.com", "no.com", "ru.com", "se.com", "uk.com", "us.com", "za.com", "com.de", "co.dm", "com.ec", "fin.ec", "info.ec", "med.ec", "net.ec", "pro.ec", "com.es", "nom.es", "org.es", "co.gg", "net.gg", "org.gg", "co.gl", "com.gl", "edu.gl", "net.gl", "org.gl", "com.gr", "co.gy", "com.gy", "net.gy", "com.hk", "edu.hk", "gov.hk", "idv.hk", "net.hk", "org.hk", "com.hn", "net.hn", "org.hn", "adult.ht", "com.ht", "info.ht", "net.ht", "org.ht", "org.il", "co.in", "firm.in", "gen.in", "ind.in", "net.in", "org.in", "bz.it", "co.it", "co.je", "net.je", "org.je", "com.ki", "net.ki", "org.ki", "co.kr", "ne.kr", "or.kr", "pe.kr", "re.kr", "seoul.kr", "com.lc", "net.lc", "org.lc", "co.mg", "com.mg", "net.mg", "org.mg", "ac.mu", "co.mu", "com.mu", "net.mu", "org.mu", "com.mx", "gb.net", "hu.net", "jp.net", "se.net", "uk.net", "com.nf", "net.nf", "org.nf", "co.nl", "net.nz", "org.nz", "ae.org", "us.org", "com.pe", "net.pe", "org.pe", "com.ph", "com.pk", "net.pk", "org.pk", "biz.pl", "com.pl", "info.pl", "net.pl", "org.pl", "waw.pl", "aaa.pro", "aca.pro", "acct.pro", "avocat.pro", "bar.pro", "cpa.pro", "eng.pro", "jur.pro", "law.pro", "med.pro", "recht.pro", "com.ps", "net.ps", "org.ps", "com.pt", "edu.pt", "org.pt", "com.ru", "net.sb", "org.sb", "com.sc", "net.sc", "org.sc", "com.sg", "com.so", "net.so", "org.so", "club.tw", "com.tw", "ebiz.tw", "game.tw", "idv.tw", "org.tw", "me.uk", "org.uk", "co.uz", "com.uz", "com.vc", "net.vc", "org.vc", "ac.vn", "biz.vn", "com.vn", "edu.vn", "gov.vn", "health.vn", "info.vn", "int.vn", "name.vn", "net.vn", "org.vn", "pro.vn", "co.jp", "co.nz", "co.uk", "co.ve", "co.za", "com.au", "com.ve", "info.ve", "net.au", "net.ph", "net.ru", "net.ve", "nom.pe", "org.au", "org.ph", "org.ru", "org.ve", "web.ve"];
        foreach ($host_cn as $val) {
            if (strpos($url, "." . $val)) {
                $no_tow = false;
            }
        }
        $del = strpos($data[$co_ta - 1], "/");
        if (0 < $del || !empty($del)) {
            $data[$co_ta - 1] = mb_substr($data[$co_ta - 1], 0, $del);
        }
        if ($no_tow) {
            $host = $data[$co_ta - 2] . "." . $data[$co_ta - 1];
        } else {
            $host = $data[$co_ta - 3] . "." . $data[$co_ta - 2] . "." . $data[$co_ta - 1];
        }
        return $host;
    }
    private function sign($params, $secret)
    {
        $sign = $signstr = "";
        if (!empty($params)) {
            ksort($params);
            reset($params);
            foreach ($params as $key => $val) {
                if ($key != "sign") {
                    if ($signstr != "") {
                        $signstr .= "&";
                    }
                    $signstr .= $key . "=" . $val;
                }
            }
            $sign = md5($signstr . $secret);
        }
        return $sign;
    }
    private function post($url, $param, $post_file = false)
    {
        $oCurl = curl_init();
        if (stripos($url, "https://") !== false) {
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_SSLVERSION, 1);
        }
        if (is_string($param) || $post_file) {
            $strPOST = $param;
        } else {
            $aPOST = [];
            foreach ($param as $key => $val) {
                $aPOST[] = $key . "=" . urlencode($val);
            }
            $strPOST = join("&", $aPOST);
        }
        curl_setopt($oCurl, CURLOPT_URL, $url);
        curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($oCurl, CURLOPT_POST, true);
        curl_setopt($oCurl, CURLOPT_POSTFIELDS, $strPOST);
        $sContent = curl_exec($oCurl);
        $aStatus = curl_getinfo($oCurl);
        curl_close($oCurl);
        if (intval($aStatus["http_code"]) == 200) {
            return $sContent;
        }
        return false;
    }
}

?>