<?php
namespace addons\qing_ye_icp\common;

class AoDun
{
    public function addDomainWhiteList($param)
    {
        $header = $this->getCookie($param);
        if (!$header["status"]) {
            return $header;
        }
        $header = $header["header"];
        $web_domain = $param["web_domain"];
        $url = $param["data"]["host"] . "/v1.0/firewall/addDomainWhiteList";
        $data = ["domain" => ["*." . $web_domain]];
        $res = $this->post($url, json_encode($data), array_merge($header, ["Content-Type: application/json"]));
        if (!$res) {
            return ["status" => 0, "msg" => "防火墙状态码返回非200"];
        }
        $json = json_decode($res, true);
        if ($json["err"] != 0) {
            return ["status" => 0, "msg" => $json["msg"]];
        }
        return ["status" => 1, "msg" => ""];
    }
    public function delDomainWhiteList($param)
    {
        $header = $this->getCookie($param);
        if (!$header["status"]) {
            return $header;
        }
        $header = $header["header"];
        $web_domain = $param["domain"];
        $url = $param["data"]["host"] . "/v1.0/firewall/delDomainWhiteList";
        $data = ["Type" => 1, "domain" => ["*." . $web_domain]];
        $res = $this->post($url, json_encode($data), array_merge($header, ["Content-Type: application/json"]));
        if (!$res) {
            return ["status" => 0, "msg" => "防火墙状态码返回非200"];
        }
        $json = json_decode($res, true);
        if ($json["err"] != 0) {
            return ["status" => 0, "msg" => $json["msg"]];
        }
        return ["status" => 1, "msg" => "删除成功"];
    }
    private function getCookie($param)
    {
        $Id = $param["id"];
        if (!empty($param["main_id"])) {
            $Id = $param["main_id"];
        }
        $host = $param["data"]["host"];
        $cacheName = $Id . "," . $host;
        $header = cache($cacheName);
        if (!$header) {
            $url = $host . "/oauth/token";
            $data = ["client_id" => $param["data"]["client_id"], "username" => $param["username"], "grant_type" => $param["password"], "password" => $param["password"]];
            $res = $this->post($url, json_encode($data), ["Content-Type: application/json"]);
            $json = json_decode($res, true);
            if (!$res) {
                return ["status" => 0, "msg" => "防火墙状态码返回非200"];
            }
            if ($json["code"] != 0) {
                return ["status" => 0, "msg" => "fail"];
            }
            if (empty($json["access_token"])) {
                return ["status" => 0, "msg" => "fail"];
            }
            $header = ["Authorization: " . $json["token_type"] . " " . $json["access_token"]];
            cache($cacheName, $header, 3500);
        }
        return ["status" => 1, "msg" => "", "header" => $header];
    }
    private function post($url, $param, $header = NULL)
    {
        $oCurl = curl_init();
        if (stripos($url, "https://") !== false) {
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_SSLVERSION, 1);
        }
        if (is_string($param)) {
            $strPOST = $param;
        } else {
            $aPOST = [];
            foreach ($param as $key => $val) {
                $aPOST[] = $key . "=" . urlencode($val);
            }
            $strPOST = join("&", $aPOST);
        }
        if (!empty($header)) {
            curl_setopt($oCurl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($oCurl, CURLOPT_HEADER, 0);
        }
        curl_setopt($oCurl, CURLOPT_URL, $url);
        curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($oCurl, CURLOPT_POST, true);
        curl_setopt($oCurl, CURLOPT_POSTFIELDS, $strPOST);
        $sContent = curl_exec($oCurl);
        $aStatus = curl_getinfo($oCurl);
        curl_close($oCurl);
        if (intval($aStatus["http_code"]) == 200) {
            return $sContent;
        }
        return false;
    }
}

?>