<?php
namespace addons\qing_ye_icp\common;

class Pgy
{
    public function addDomainWhiteList($param)
    {
        $header = $this->getCookie($param);
        if (!$header["status"]) {
            return $header;
        }
        $userid = $header["header"]["userid"];
        $header = $header["header"]["token"];
        $url = "http://api.pgyidc.com/api/web/whitelist";
        $data = ["ip" => $param["ip"], "domain" => $param["web_domain"], "userid" => $userid];
        $res = $this->post($url, $data, $header);
        $json = json_decode($res, true);
        if ($json["status"] != 0) {
            return ["status" => 0, "msg" => $json["data"]];
        }
        return ["status" => 1, "msg" => ""];
    }
    public function delDomainWhiteList($param)
    {
        return ["status" => -2, "msg" => "请手动删除。"];
    }
    private function getCookie($param)
    {
        $cacheName = $param["id"] . "," . $param["username"];
        $header = cache($cacheName);
        if (!$header) {
            $url = "http://api.pgyidc.com/api/user/login";
            $data = ["username" => $param["username"], "password" => $param["password"]];
            $res = $this->post($url, $data);
            $json = json_decode($res, true);
            if (!$res) {
                return ["status" => 0, "msg" => "接口状态码返回非200"];
            }
            if ($json["code"] != 200) {
                return ["status" => 0, "msg" => $json["error"]];
            }
            if (empty($json["data"]["token"])) {
                return ["status" => 0, "msg" => "empty token"];
            }
            $header = ["token" => ["Authorization:Bearer " . $json["data"]["token"]], "userid" => $json["data"]["userid"]];
            cache($cacheName, $header, 3600);
        }
        return ["status" => 1, "msg" => "", "header" => $header];
    }
    private function post($url, $param, $header = NULL)
    {
        $oCurl = curl_init();
        if (stripos($url, "https://") !== false) {
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_SSLVERSION, 1);
        }
        if (is_string($param)) {
            $strPOST = $param;
        } else {
            $aPOST = [];
            foreach ($param as $key => $val) {
                $aPOST[] = $key . "=" . urlencode($val);
            }
            $strPOST = join("&", $aPOST);
        }
        if (!empty($header)) {
            curl_setopt($oCurl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($oCurl, CURLOPT_HEADER, 0);
        }
        curl_setopt($oCurl, CURLOPT_URL, $url);
        curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($oCurl, CURLOPT_POST, true);
        curl_setopt($oCurl, CURLOPT_POSTFIELDS, $strPOST);
        $sContent = curl_exec($oCurl);
        $aStatus = curl_getinfo($oCurl);
        curl_close($oCurl);
        if (intval($aStatus["http_code"]) == 200) {
            return $sContent;
        }
        return false;
    }
}

?>