<?php
namespace addons\qing_ye_icp\common;

class PgyCode
{
    public function delDomainWhiteList($param)
    {
        return ["status" => -2, "msg" => "请手动删除。"];
    }
    public function addDomainWhiteList($param)
    {
        $url = "https://user.pgyidc.com/template/addlist";
        $data = ["addr" => $param["web_domain"], "ip" => $param["ip"]];
        $res = $this->curl_post($url, $data, ["X-Requested-With: XMLHttpRequest"], $param["id"]);
        switch ($res) {
            case 0:
                return ["status" => 1, "msg" => "添加成功"];
                break;
            case 1:
                return ["status" => 0, "msg" => "该IP不存在"];
                break;
            case 2:
                return ["status" => 0, "msg" => "token过期，请重新登录"];
                break;
            case 3:
                return ["status" => 0, "msg" => "系统出错"];
                break;
            case 4:
                return ["status" => 0, "msg" => "当天域名超上限，请联系客服处理"];
                break;
            case 5:
                return ["status" => 0, "msg" => "IP输入有误"];
                break;
            case 6:
                return ["status" => 0, "msg" => "该域名已被加入黑名单，无法操作"];
                break;
            case 8:
                return ["status" => 0, "msg" => "该IP不属于你"];
                break;
            default:
                return ["status" => 0, "msg" => "未知错误"];
        }
    }
    public function beforeCron()
    {
        $icps = \think\Db::name("qing_ye_icp")->where("status", 1)->where("type", 5)->select();
        foreach ($icps as $icp) {
            $this->heartbeat($icp["id"], $icp["username"], $icp["password"]);
        }
    }
    private function heartbeat($id, $username, $password)
    {
        $url = "https://user.pgyidc.com/template/userinfo";
        $res = $this->curl_get($url, $id);
        if ($res == "<script>window.location.href='/login/login';</script>" || $res == "") {
            if ($this->Login($id, $username, $password)) {
                echo "域名白名单：心跳失败.已重新登录" . PHP_EOL;
            } else {
                echo "域名白名单：心跳失败.重新登录失败" . PHP_EOL;
            }
        } else {
            echo "域名白名单：心跳成功" . PHP_EOL;
        }
    }
    private function Login($id, $username, $password)
    {
        $code = $this->getCode();
        if (!$code) {
            return false;
        }
        $url = "https://user.pgyidc.com/login/loginin";
        $data = ["username" => $username, "password" => $password, "captcha" => $code["code"], "cb" => "on", "igcd" => $code["igcd"]];
        $res = $this->curl_post($url, $data, ["X-Requested-With: XMLHttpRequest"], $id, true);
        if ($res == "0") {
            return true;
        }
        return false;
    }
    private function getCode()
    {
        $url = "https://user.pgyidc.com/login/codechange";
        $ret = $this->curl_post($url, []);
        $ret = json_decode($ret, true);
        if (!$ret) {
            return false;
        }
        if (empty($ret["imgcode"]) || empty($ret["captchaImageUrl"])) {
            return false;
        }
        $igcd = $ret["imgcode"];
        $captchaImageUrl = "https://user.pgyidc.com/img/captcha/" . $ret["captchaImageUrl"];
        $code = $this->Ocr($captchaImageUrl);
        if (!$code) {
            return false;
        }
        return ["igcd" => $igcd, "code" => $code];
    }
    private function Ocr($image_url)
    {
        $image = file_get_contents($image_url);
        $image = "data:image/png;base64," . base64_encode($image);
        $url = "https://cloud.baidu.com/aidemo";
        $data = ["image" => $image, "type" => "https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic", "detect_direction" => "false", "language_type" => "CHN_ENG"];
        $ret = $this->curl_post($url, $data, ["Origin: https://cloud.baidu.com", "Referer: https://cloud.baidu.com/product/ocr/general?"]);
        $ret = json_decode($ret, true);
        if ($ret["errno"] == 0 && isset($ret["data"]["words_result"][0]["words"])) {
            return $ret["data"]["words_result"][0]["words"];
        }
        return false;
    }
    private function curl_post($url, $data, $header = ["X-Requested-With: XMLHttpRequest"], $id = 0, $isCk = false)
    {
        if (is_array($data)) {
            $data = http_build_query($data);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        if ($header) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        }
        if ($isCk) {
            curl_setopt($ch, CURLOPT_COOKIEJAR, CMF_DATA . "/qing_ye_icp_pgy_" . $id . ".cookie");
        } else {
            curl_setopt($ch, CURLOPT_COOKIEFILE, CMF_DATA . "/qing_ye_icp_pgy_" . $id . ".cookie");
        }
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }
    private function curl_get($url, $id)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEFILE, CMF_DATA . "/qing_ye_icp_pgy_" . $id . ".cookie");
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }
}

?>