<?php
namespace addons\qing_ye_icp\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function setting()
    {
        $param = $this->request->param();
        $page = !empty($param["page"]) ? intval($param["page"]) : 1;
        $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
        $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
        $id = intval($param["id"]);
        if ($this->request->isPost()) {
            $data["type"] = intval($param["type"]);
            $data["name"] = $param["name"];
            $data["username"] = $param["username"];
            $data["password"] = $param["password"];
            $data["num"] = intval($param["num"]);
            $data["range"] = implode(",", $param["range"]);
            $data["blacklist"] = $param["blacklist"];
            $data["white_list"] = $param["white_list"];
            $idc_id = $param["idc_id"];
            $client_id = $param["client_id"];
            $host = $param["host"];
            $data["data"] = json_encode(["client_id" => $client_id, "host" => $host, "idc_id" => $idc_id]);
            $data["status"] = $param["status"] == "on" ? 1 : 0;
            $data["isDelete"] = $param["isDelete"] == "on" ? 1 : 0;
            $data["isAi"] = $param["isAi"] == "on" ? 1 : 0;
            $data["create_time"] = time();
            $data["update_time"] = $data["create_time"];
            if ($id) {
                unset($data["create_time"]);
                if (\think\Db::name("qing_ye_icp")->where("status", "<>", -1)->where("id", $id)->update($data)) {
                    return json(["status" => 1, "msg" => "修改成功。"]);
                }
                return json(["status" => 0, "msg" => "修改失败！"]);
            }
            if (\think\Db::name("qing_ye_icp")->data($data)->insert()) {
                return json(["status" => 1, "msg" => "添加成功。"]);
            }
            return json(["status" => 0, "msg" => "添加失败！"]);
        }
        if ($this->request->isAjax() && $this->request->isGet() && $id) {
            $list = \think\Db::name("qing_ye_icp")->where("status", "<>", -1)->where("id", $id)->find();
            $list["data"] = json_decode($list["data"], true);
            return json($list);
        }
        $product_groups = \think\Db::name("product_groups")->field("id,name")->select()->toArray();
        $products = \think\Db::name("products")->field("id,name,gid")->select()->toArray();
        $res_products = [];
        foreach ($products as $k => $v) {
            $res_products[$v["gid"]][] = $v;
        }
        $this->assign("productgroups", $product_groups);
        $this->assign("res_products", $res_products);
        $list = \think\Db::name("qing_ye_icp")->where("status", "<>", -1)->order("id", "desc")->where("name|id", "like", "%" . $keywords . "%")->paginate($limit);
        $count = count(\think\Db::name("qing_ye_icp")->where("status", "<>", -1)->where("name|id", "like", "%" . $keywords . "%")->all());
        $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeIcp://AdminIndex/setting"), $keywords);
        $this->assign("pages", $pages);
        $this->assign("keywords", $keywords);
        $this->assign("list", $list);
        return $this->fetch("/setting");
    }
    public function deleteIcp()
    {
        $ret = ["msg" => "系统错误"];
        if ($this->request->isPost()) {
            $id = $this->request->param("id");
            $i = 0;
            if ($id) {
                foreach ($id as $v) {
                    $m = \think\Db::name("qing_ye_icp")->where("id", $v)->update(["status" => -1]);
                    if ($m == 1) {
                        $i++;
                    }
                }
                $ret["status"] = 1;
                $ret["msg"] = "成功删除" . $i . "条数据";
            } else {
                $ret["msg"] = "请勾选需要删除的数据！";
            }
        }
        return json($ret);
    }
    public function icp()
    {
        $param = $this->request->param();
        $page = !empty($param["page"]) ? intval($param["page"]) : 1;
        $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
        $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
        if ($this->request->isPost()) {
            $icp = \think\Db::name("qing_ye_icp_record")->alias("a")->join("qing_ye_icp w", "w.id=a.main_id")->where("a.status", 1)->where("w.status", 1)->where("a.id", $param["id"])->field("a.id,w.id main_id,w.isAi,w.name mainName,w.num,w.white_list,w.isDelete,w.username,w.password,w.password,w.type,w.data,a.domain,a.ip,a.uid,a.host_id")->find();
            if (!$icp) {
                return json(["status" => 0, "msg" => "非法访问！"]);
            }
            $l = ["status" => 1, "domain" => $icp["domain"], "host_ip" => $icp["ip"], "host_id" => $icp["host_id"], "main_id" => $icp["main_id"], "type" => 0];
            if ($icp["isAi"] == 1) {
                $icp["data"] = json_decode($icp["data"], true);
                switch ($icp["type"]) {
                    case 1:
                        $className = "SuQian";
                        break;
                    case 2:
                        $className = "AoDun";
                        break;
                    case 3:
                        $className = "Pgy";
                        break;
                    case 4:
                        $className = "SuLian";
                        break;
                    default:
                        $className = NULL;
                        $ret = ["status" => 0, "msg" => "非法访问！"];
                        if ($className) {
                            $class = "\\addons\\qing_ye_icp\\common\\" . ucfirst($className);
                            $firewall = new $class();
                            $ret = $firewall->delDomainWhiteList($icp);
                        }
                        if ($ret["status"] == 1) {
                            if (\think\Db::name("qing_ye_icp_record")->where("id", $param["id"])->update(["status" => -1])) {
                                $this->log_($l, "删除成功");
                                return json(["status" => 1, "msg" => "删除成功！"]);
                            }
                        } else {
                            if ($ret["status"] == 0) {
                                $l["status"] = 0;
                                $this->log_($l, $ret["msg"]);
                                return json($ret);
                            }
                        }
                }
            }
            if (\think\Db::name("qing_ye_icp_record")->where("id", $param["id"])->update(["status" => -2, "data" => "等待删除"])) {
                $this->log_($l, "需要管理员手动删除");
                return json(["status" => 1, "msg" => "删除成功！"]);
            }
            $l["status"] = 0;
            $this->log_($l, "更改数据失败!");
            return json(["status" => 0, "msg" => "删除失败！"]);
        }
        $list = \think\Db::name("qing_ye_icp_record")->alias("a")->join("host w", "a.host_id=w.id")->join("qing_ye_icp f", "f.id=a.main_id")->where("a.status", 1)->order("a.id", "desc")->where("a.main_id|f.name|a.ip|a.domain|a.icp", "like", "%" . $keywords . "%")->field("a.main_id,a.ip,a.icp,a.create_time,a.host_id,a.domain,a.id,f.name icpName,a.uid")->paginate($limit);
        $all = \think\Db::name("qing_ye_icp_record")->alias("a")->join("host w", "a.host_id=w.id")->join("qing_ye_icp f", "f.id=a.main_id")->where("a.status", 1)->where("a.main_id|f.name|a.ip|a.domain|a.icp", "like", "%" . $keywords . "%")->field("a.id")->all();
        $count = count($all);
        $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeIcp://AdminIndex/icp"), $keywords);
        $this->assign("pages", $pages);
        $this->assign("keywords", $keywords);
        $this->assign("list", $list);
        return $this->fetch("/icp");
    }
    public function deleteList()
    {
        $param = $this->request->param();
        $page = !empty($param["page"]) ? intval($param["page"]) : 1;
        $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
        $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
        if ($this->request->isPost()) {
            $icp = \think\Db::name("qing_ye_icp_record")->alias("a")->join("qing_ye_icp w", "w.id=a.main_id")->where("a.status", -2)->where("w.status", 1)->where("a.id", $param["id"])->field("a.id,w.id main_id,w.isAi,w.name mainName,w.num,w.white_list,w.isDelete,w.password,w.password,w.type,w.data mainData,a.domain,a.ip,a.uid,a.host_id")->find();
            if (!$icp) {
                return json(["status" => 0, "msg" => "无需确认！"]);
            }
            if (\think\Db::name("qing_ye_icp_record")->where("id", $param["id"])->update(["status" => -1, "data" => "删除成功！"])) {
                return json(["status" => 1, "msg" => "删除成功！"]);
            }
            return json(["status" => 1, "msg" => "删除失败！"]);
        }
        $list = \think\Db::name("qing_ye_icp_record")->where("status", "in", [-1, -2])->order("status asc,id desc")->where("domain|ip|main_id", "like", "%" . $keywords . "%")->paginate($limit);
        $all = \think\Db::name("qing_ye_icp_record")->where("status", "in", [-1, -2])->order("status asc,id desc")->where("domain|ip|main_id", "like", "%" . $keywords . "%")->all();
        $count = count($all);
        $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeIcp://AdminIndex/deleteList"), $keywords);
        $this->assign("pages", $pages);
        $this->assign("keywords", $keywords);
        $this->assign("list", $list);
        $this->assign("list", $list);
        return $this->fetch("/delete_list");
    }
    public function log()
    {
        $param = $this->request->param();
        $page = !empty($param["page"]) ? intval($param["page"]) : 1;
        $limit = !empty($param["limit"]) ? intval($param["limit"]) : 10;
        $keywords = !empty($param["keywords"]) ? $param["keywords"] : "";
        $list = \think\Db::name("qing_ye_icp_log")->where("id|uid|ip|port|data|status|domain|host_ip", "like", "%" . $keywords . "%")->order("id desc")->paginate($limit);
        $all = \think\Db::name("qing_ye_icp_log")->where("id|uid|ip|port|data|status|domain|host_ip", "like", "%" . $keywords . "%")->all();
        $count = count($all);
        $pages = $this->pages($page, $count, $limit, shd_addon_url("QingYeIcp://AdminIndex/log"), $keywords);
        $this->assign("pages", $pages);
        $this->assign("keywords", $keywords);
        $this->assign("list", $list);
        return $this->fetch("/log");
    }
    private function pages($page, $count, $limit, $url, $keywords, $listNum = 5)
    {
        $url = $url . "&keywords=" . $keywords;
        $PageCount = ceil($count / $limit);
        if ($page == 1) {
            $prev = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">上一页</a></li>";
        } else {
            $prev = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . ($page - 1) . "&limit=" . $limit . "\">上一页</a></li>";
        }
        if ($page == $PageCount) {
            $next = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">下一页</a></li>";
        } else {
            $next = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . ($page + 1) . "&limit=" . $limit . "\">下一页</a></li>";
        }
        if ($page == 1) {
            $first = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">首 页</a></li>";
        } else {
            $first = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=1" . "&limit=" . $limit . "\">首 页</a></li>";
        }
        if ($page == $PageCount) {
            $last = "<li class=\"page-item disabled\"><a class=\"page-link\" href=\"#\">尾 页</a></li>";
        } else {
            $last = "<li class=\"page-item\"><a class=\"page-link\" href=\"" . $url . "&page=" . $PageCount . "&limit=" . $limit . "\">尾 页</a></li>";
        }
        $html = "<div class=\"table-footer\"><div class=\"table-pagination\"> <span>共 " . $count . " 条</span> <div class=\"table-pageinfo\"><select class=\"form-control\" id=\"limitSel\">";
        $html .= $limit == 10 ? "<option value=\"10\" selected >10条/页</option>" : "<option value=\"10\">10条/页</option>";
        $html .= $limit == 15 ? "<option value=\"15\" selected >15条/页</option>" : " <option value=\"15\">15条/页</option>";
        $html .= $limit == 20 ? "<option value=\"20\" selected >20条/页</option>" : " <option value=\"20\">20条/页</option>";
        $html .= $limit == 25 ? "<option value=\"25\" selected >25条/页</option>" : " <option value=\"25\">25条/页</option>";
        $html .= $limit == 50 ? "<option value=\"50\" selected >50条/页</option>" : " <option value=\"50\">50条/页</option>";
        $html .= $limit == 100 ? "<option value=\"100\" selected >100条/页</option>" : "<option value=\"100\" >100条/页</option>";
        $html .= "</select></div><nav><ul class=\"pagination\">" . $first . $prev;
        $inum = floor($listNum / 2);
        for ($i = $page - $inum; $i <= $page + $inum; $i++) {
            if ($i > 0) {
                if ($PageCount >= $i) {
                    if ($i == $page) {
                        $html .= "<li class=\"page-item active\">";
                        $html .= "<a class=\"page-link\">" . $i . "</a>";
                        $html .= "</li>";
                    } else {
                        $html .= "<li class=\"page-item\">";
                        $html .= "<a class=\"page-link\" href=\"" . $url . "&page=" . $i . "&limit=" . $limit . "\">" . $i . "</a>";
                        $html .= "</li>";
                    }
                }
            }
        }
        $html .= $next . $last;
        $html .= "</ul></nav></div>";
        $html .= "<script>\$(function(){ \$('#limitSel').on('change', function () {location.href = '" . $url . "' + '&page=1&limit=' + \$('#limitSel').val();})});</script>";
        $html .= "</div>";
        return $html;
    }
    private function log_($param, $data)
    {
        $request = $this->request;
        $ip = $request->ip();
        $Port = $request->remotePort();
        $d = ["ip" => $ip, "port" => $Port, "create_time" => time(), "data" => $data, "status" => $param["status"], "domain" => $param["domain"], "host_ip" => $param["host_ip"], "host_id" => $param["host_id"], "type" => $param["type"], "main_id" => $param["main_id"]];
        \think\Db::name("qing_ye_icp_log")->data($d)->insert();
    }
}

?>