<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <div class="tabs">
                        <div class="tab-item selected"><a style="color:#333333" href="{:shd_addon_url('QingYeIcp://AdminIndex/setting')}">通道添加</a> </div>
                        <div class="tab-item {$selected_cc}"><a style="color:#333333" href="{:shd_addon_url('QingYeIcp://AdminIndex/icp')}">白名单列表</a> </div>
                        <div class="tab-item"><a style="color:#333333" href="{:shd_addon_url('QingYeIcp://AdminIndex/deleteList')}">删除列表</a> </div>
                        <div class="tab-item"><a style="color:#333333" href="{:shd_addon_url('QingYeIcp://AdminIndex/log')}">操作日志</a> </div>
                    </div>


                    <div class="tab-content mt-4">
                        <!-- 搜索框 !-->
                        <div class="table-header">
                            <div class="table-tools">
                                <a href="javascript:;" onclick="Add()" class="btn btn-success w-sm nohide" >
                                    <i class="fas fa-plus-circle"></i> 添加
                                </a>

                                <input type="text" id="keywords" class="form-control" placeholder="输入关键字" value="{$keywords}">
                                <button class="btn btn-primary w-xs" id="searchInp" ><i class="fas fa-search"></i> 搜索</button>
                            </div>
                        </div>

                        <!-- 列表 !-->
                        <div class="table-body table-responsive">
                            <table class="table table-bordered table-hover">
                                <caption>选中的项目： <button type="button" class="btn btn-danger btn-sm" onclick="handleOperating()">批量删除</button></caption>
                                <thead class="thead-light">
                                <tr>
                                    <th class="checkbox">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" id="selectAll">
                                            <label class="custom-control-label" for="selectAll">&nbsp;</label>
                                        </div>
                                    </th>

                                    <th class="center t1">ID </th>
                                    <th>通道名称</th>
                                    <th>白名限制单数量</th>
                                    <th>类型</th>
                                    <th>添加时间</th>
                                    <th class="center">状态</th>
                                    <th class="center t5">操作</th>
                                </tr>
                                </thead>

                                <tbody>

                                {foreach $list as $v=>$k}
                                    <tr>
                                        <td class="checkbox">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input row-checkbox" id="customCheck{$k.id}">
                                                <label class="custom-control-label" for="customCheck{$k.id}">&nbsp;</label>
                                            </div>
                                        </td>
                                        <td class="center">{$k.id}</td>
                                        <td>{$k.name}</td>
                                        <td>{$k.num}</td>
                                        <td>
                                            {if $k.type==1}宿迁昊锐云接口{/if}
                                            {if $k.type==2}傲盾防火墙接口{/if}
                                            {if $k.type==3}宿迁蒲公英接口{/if}
                                            {if $k.type==4}速联科技接口{/if}
                                            {if $k.type==5}蒲公英(免API权限){/if}
                                        </td>
                                        <td>{:date("Y-m-d H:i:s",$k.create_time)}</td>
                                        <td class="center">
                                            {if $k.status==1}
                                                <i class="fa fa-check-circle text-success"></i>
                                            {else}
                                                <i class="fa fa-times text-danger"></i>
                                            {/if}
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-link" onclick="Update({$k.id})"><i class="fas fa-edit"></i> 修改</button>
                                            <button type="button" class="btn btn-link red"  onclick="handleOperating({$k.id})"><i class="fas fa-times"></i> 删除</button>
                                        </td>
                                    </tr>

                                {/foreach}


                                </tbody>
                            </table>
                        </div>

                        {$pages|raw}
                    </div>



                </div>
            </div>
        </div>
    </div>


    <!-- 添加弹窗 -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog " role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">添加域名白名单通道</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form class="form" id="form" autocomplete="off">

                        <input hidden="hidden" value="" name="id">

                        <div class="form-group row">
                            <label class="require">选择通道类型</label>
                            <div class="col-sm-9">
                                <select class="selectpicker show-tick form-control" id="type" name="type" data-live-search="true">
                                    <option selected disabled style="display：none" value="">请选择</option>
                                    <option value="1">宿迁昊锐云接口</option>
                                    <option value="2">傲盾防火墙接口</option>
                                    <option value="3">宿迁蒲公英接口</option>
                                    <option value="4">速联科技接口</option>
                                    <option value="5">蒲公英(免API权限)</option>

                                </select>
                            </div>
                        </div>


                        <div class="form-group row">
                            <label class="require">通道名称</label>
                            <div class="col-sm-9">
                                <input type="text" name="name" class="form-control" placeholder="输入通道名称" value="">
                            </div>
                        </div>

                        <div class="form-group row" style="display:none;" id="url">
                            <label class="require">防火墙地址</label>
                            <div class="col-sm-9">
                                <input type="text" name="host" class="form-control" placeholder="输入防火墙地址" value="">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="require">用户名</label>
                            <div class="col-sm-9">
                                <input type="text" name="username" class="form-control" placeholder="输入通道用户名" value="">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="require">密码</label>
                            <div class="col-sm-9">
                                <input type="text" name="password" class="form-control" placeholder="输入通道密码" value="">
                            </div>
                        </div>


                        <div class="form-group row" style="display:none;" id="aid">
                            <label class="require">傲盾客户端ID</label>
                            <div class="col-sm-9">
                                <input type="text" name="client_id" class="form-control" placeholder="输入傲盾客户端ID" value="">
                            </div>
                        </div>

                        <div class="form-group row" style="display:none;" id="idc_id">
                            <label class="require">机房ID
                                <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip"
                                   data-placement="top" title="台州BGP：55，绍兴BGP：71，绍兴电信：75，嘉兴BGP：202。具体ID请询问速联科技">
                                </i>
                            </label>
                            <div class="col-sm-9">
                                <input type="text" name="idc_id" class="form-control" placeholder="输入机房ID" value="">
                            </div>
                        </div>


                        <!--
                        <div class="form-group row">
                            <label >icpAppId
                                <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="对接www.icpapi.com实时备案查询接口，留空不启用域名备案审核。">
                                </i>
                            </label>
                            <div class="col-sm-9">
                                <input type="text" name="icpAppId" class="form-control" placeholder="输入icpAppId" value="">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label >icpAppKey
                                <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="对接www.icpapi.com实时备案查询接口，留空不启用域名备案审核。">
                                </i>
                            </label>
                            <div class="col-sm-9">
                                <input type="text" name="icpAppKey" class="form-control" placeholder="输入icpAppKey" value="">
                            </div>
                        </div>
                        -->



                        <div class="form-group row">
                            <label class="require">白名单数量

                                <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="每个IP可用于添加域名白名单的数量“0”为不限制">
                                </i>

                            </label>
                            <div class="col-sm-9">
                                <input type="text" name="num" class="form-control" placeholder="输入白名单数量" value="">
                            </div>
                        </div>



                        <div class="form-group row">
                            <label class="require">产品范围
                                <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip"
                                   data-placement="top" title="可以多个通道同时绑定一个产品">
                                </i>
                            </label>

                            <div class="col-sm-9">
                                <select class="form-control selectpicker" name="range[]" id="range" data-live-search="true" multiple>
                                    {foreach $productgroups as $group}
                                        <optgroup label="{$group.name}">
                                            {foreach $res_products[$group.id] as $product}
                                                <option  value="{$product.id}">{$product.name} </option>
                                            {/foreach}
                                        </optgroup>
                                    {/foreach}
                                </select>
                            </div>
                        </div>


                        <div class="form-group row">
                            <label >域名白名单
                                <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="请填写重要域名，可防止客户恶意提交，用小写逗号分割">
                                </i>
                            </label>
                            <div class="col-sm-9">
                                <textarea rows="5" class="form-control" name="white_list"></textarea>
                            </div>
                        </div>


                        <div class="form-group row">
                            <label >域名黑名单
                                <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="请填写违规域名，禁止客户向机房提交该域名，用小写逗号分割">
                                </i>
                            </label>
                            <div class="col-sm-9">
                                <textarea rows="5" class="form-control" name="blacklist"></textarea>
                            </div>
                        </div>



                        <div class="form-group row">
                            <label>支持客户删除
                                <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="客户端是否支持删除域名功能。">
                                </i>
                            </label>
                            <div class="col-sm-4">
                                <div class="custom-control custom-switch" dir="ltr">
                                    <input type="checkbox" class="custom-control-input" name="isDelete" id="isDelete" >
                                    <label class="custom-control-label" for="isDelete"></label>
                                </div>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label>自动删除域名
                                <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="是否使用接口自动删除，否则提示管理员手动删除。">
                                </i>
                            </label>
                            <div class="col-sm-4">
                                <div class="custom-control custom-switch" dir="ltr">
                                    <input type="checkbox" class="custom-control-input" name="isAi" id="isAi" >
                                    <label class="custom-control-label" for="isAi"></label>
                                </div>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label>是否启用</label>
                            <div class="col-sm-4">
                                <div class="custom-control custom-switch" dir="ltr">
                                    <input type="checkbox" class="custom-control-input" name="status" id="status" >
                                    <label class="custom-control-label" for="status"></label>
                                </div>
                            </div>
                        </div>


                    </form>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">关闭</button>
                        <button type="submit" id="submitBtn" class="btn btn-primary">保存</button>
                    </div>


                </div>


            </div>
        </div>
    </div>


    <!--  v1.14.0-beta 有bug-->
    <script src="https://cdn.staticfile.org/bootstrap-select/1.13.14/js/bootstrap-select.min.js"></script>
    <link rel="stylesheet" href="{$Themes}/assets/libs/bootstrap-select/css/bootstrap-select.min.css">
   <!-- <script src="{$Themes}/assets/libs/bootstrap-select/js/bootstrap-select.min.js"></script> -->
    <script src="{$Themes}/assets/libs/bootstrap-select/js/i18n/defaults-zh_CN.min.js"></script>

    <script>
        $(function(){


            $("#type").change(function(){
                Selected();
            });

            $('#searchInp').click(function(){
                location.href = '{:shd_addon_url('QingYeIcp://AdminIndex/setting')}' +  '&keywords=' + $('#keywords').val();
            });
            var fields = {validators: {notEmpty: {message: '不能为空'},}};
            $('#form').bootstrapValidator({
                fields: {
                    client_id :fields,
                    idc_id :fields,
                    host :fields,
                    type: fields,
                    name: fields,
                    username: fields,
                    password: fields,
                    num: fields,
                    'range[]': fields,
                }
            });


            $('#exampleModal').on('hide.bs.modal', function () {
                //弹出窗关闭刷新页面
                window.location.reload();
            });

            $("#submitBtn").click(function(){
                var form = $('#form');
                var bv = form.data('bootstrapValidator');
                var type = $("#type").val();
                bv.validate();
                if (bv.isValid()) {
                    // 弹窗提示
                    if (type == 5){
                        window.alert("设置好后，请运行一次计划任务。");
                    }
                    var e = this;
                    $(e).attr("disabled", true);
                    $.ajax({
                        url: '{:shd_addon_url('QingYeIcp://AdminIndex/setting')}',
                        type: 'POST',
                        data: form.serialize(),
                        success: function (data) {
                            if (data.status == 1) {
                                toastr.success(data.msg)
                                setTimeout(function () { window.location.reload(); }, 1000);
                            } else {
                                toastr.error(data.msg);
                                $(e).attr("disabled", false);
                            }
                        }, error: function () {
                            toastr.error("系统错误！");
                            $(e).attr("disabled", false);
                        }
                    })
                }
            });

            // 监控 select 选择
            $('#type').on('changed.bs.select', function () {
                var type = $(this).val();
                if(type == 5){
                    toastr.info('提示，请确保计划任务已经开启，否则无法使用此功能。如已开启，请忽略此提示。');
                }
            });


        });

        function Update(id){
            $.ajax({
                url: '{:shd_addon_url('QingYeIcp://AdminIndex/setting')}',
                type: 'GET',
                data: 'id='+id,
                success: function (data) {
                    if (data) {
                        $("[name='id']").val(id);
                        var type = $("[name='type']");type.val(data.type);type.selectpicker('refresh');
                        $("[name='name']").val(data.name);
                        $("[name='username']").val(data.username);
                        $("[name='password']").val(data.password);
                        $("[name='num']").val(data.num);
                        $("[name='blacklist']").val(data.blacklist);
                        $("[name='white_list']").val(data.white_list);
                        // $("[name='icpAppId']").val(data.data.icpAppId);
                        // $("[name='icpAppKey']").val(data.data.icpAppKey);
                        data.status==1 ? $("[name='status']").prop("checked",true) :$("[name='status']").prop("checked",false);
                        data.isDelete==1 ? $("[name='isDelete']").prop("checked",true) :$("[name='isDelete']").prop("checked",false);
                        data.isAi==1 ? $("[name='isAi']").prop("checked",true) :$("[name='isAi']").prop("checked",false);

                        $("[name='host']").val(data.data.host);
                        $("[name='client_id']").val(data.data.client_id);

                        $("[name='idc_id']").val(data.data.idc_id);

                        var arr = data.range.split(","),range  = $("#range");
                        range.val(arr);range.selectpicker('refresh');
                        $("#exampleModalLabel").text("修改域名白名单通道");
                        Add();
                        Selected();
                    }
                }, error: function () {
                    toastr.error("系统错误！")
                }
            });
        }

        function Add()
        {
            //打开弹出层
            $('#exampleModal').modal({
                backdrop: 'static',
                //点击背景空白处不被关闭；
                keyboard: false
                //触发键盘esc事件时不关闭。
            });
        }

        function handleOperating(command) {
            // 批量操作 直接复制粘贴，用户端
            var batchObj = {id: []};
            batchObj.id.length = 0
            tableMul = getCheckbox()
            for (let i = 0; i < tableMul.length; i++) {
                const item = tableMul[i]
                batchObj.id.push(item)
            }
            if (command){
                batchObj = "id[]=" + command;
            }

            $.ajax({
                type: "post",
                url: '{:shd_addon_url('QingYeIcp://AdminIndex/deleteIcp')}',
                data: batchObj,
                success: function (data) {
                    if (data.status == 1) {
                        toastr.success(data.msg)
                        setTimeout(function () { window.location.reload(); }, 1000);
                    }else {
                        toastr.error(data.msg)
                    }
                }
            });


        }

        // 获取所有勾选项的id
        var getCheckbox = function () {
            // 勾选的id
            const ids = []
            // 所有表格内的checkbox
            const allCheck = [...$('.row-checkbox:checked')]
            for (const key in allCheck) {
                if (Object.hasOwnProperty.call(allCheck, key)) {
                    const item = allCheck[key];
                    ids.push(item.id.substring(11))
                }
            }
            return ids
        };

        function Selected(){
            var selected=$("#type").children('option:selected').val();
            if(selected==1){
                $("#aid").hide();
                $("#url").hide();
                $("#idc_id").hide();
            } else if (selected==2){
                $("#aid").show();
                $("#url").show();
                $("#idc_id").hide();
            } else if (selected==3){
                $("#aid").hide();
                $("#url").hide();
                $("#idc_id").hide();
            } else if (selected==4){
                $("#aid").hide();
                $("#url").hide();
                $("#idc_id").show();

            }
        }

    </script>


</section>
