<?php
namespace addons\qing_ye_pgyidc;

class Common
{
    private $uid;
    public function __construct($uid)
    {
        $this->uid = $uid;
    }
    public function get_cc_list()
    {
        $url = "https://user.pgyidc.com/template/goldenshield";
        $res = $this->curl_get($url, []);
        $res = explode("<table class=\"ny-table margin-bottom-20\">", $res);
        if ($res) {
            $res = explode("</table>", $res[1]);
            if ($res) {
                $res = $res[0];
                $res = explode("<tr>", $res);
                if ($res) {
                    $res = array_slice($res, 1);
                    if ($res) {
                        $data = [];
                        foreach ($res as $k => $v) {
                            if ($k != 0) {
                                $v = explode("</td>", $v);
                                $v = array_map(function ($v) {
                                    $v = explode(">", $v);
                                    return $v[1];
                                }, $v);
                                if (!filter_var($v[0], FILTER_VALIDATE_IP)) {
                                } else {
                                    if (!$this->is_ip($this->uid, $v[0])) {
                                    } else {
                                        $data[] = ["ip" => $v[0], "cc_list_name" => $v[1], "create_time" => $v[2], "release_time" => $v[3]];
                                    }
                                }
                            }
                        }
                        return $data;
                    } else {
                        return [];
                    }
                } else {
                    return [];
                }
            } else {
                return [];
            }
        } else {
            return [];
        }
    }
    public function add_cc($ip, $mode, $time)
    {
        $url = "https://user.pgyidc.com/Template/goldfighting";
        $data = ["address" => $ip, "mode" => $mode, "releasetime" => $time];
        $res = $this->curl_post($url, $data);
        if ($res != "60") {
            return false;
        }
        return true;
    }
    public function rid($ip)
    {
        $url = "https://user.pgyidc.com/Template/blacklistoperate";
        $data = ["ipaddr" => $ip];
        $res = $this->curl_post($url, $data);
        if ($res != "60") {
            return false;
        }
        return true;
    }
    public function attack($ip)
    {
        $url = "https://user.pgyidc.com/template/attackrecord?key=" . $ip;
        $res = $this->curl_get($url);
        $res = explode("<table class=\"ny-table margin-bottom-20\">", $res);
        if ($res) {
            $res = explode("</table>", $res[1]);
            if ($res) {
                $res = $res[0];
                $res = explode("<tr style=\"\">", $res);
                if ($res) {
                    $res = array_slice($res, 1);
                    if ($res) {
                        $data = [];
                        foreach ($res as $k => $v) {
                            if ($k != 0) {
                                $v = explode("</td>", $v);
                                $v = array_map(function ($v) {
                                    $v = explode(">", $v);
                                    return $v[1];
                                }, $v);
                                if (!$this->is_ip($this->uid, $v[0])) {
                                } else {
                                    $data[] = ["ip" => $v[0], "type" => $v[2], "bps" => $v[3], "pps" => $v[4], "package" => $v[5], "status" => $v[6], "create_time" => $v[7], "end_time" => $v[8]];
                                }
                            }
                        }
                        return $data;
                    } else {
                        return [];
                    }
                } else {
                    return [];
                }
            } else {
                return [];
            }
        } else {
            return [];
        }
    }
    public function zt($ip, $pgy_id)
    {
        if ($pgy_id == 0) {
            $url = "https://user.pgyidc.com/Template/ztadd";
            $data = ["address" => $ip, "releasetime" => 30];
            $res = $this->curl_post($url, $data);
            if ($res != "60") {
            } else {
                return $this->getId($ip);
            }
        } else {
            $url = "https://user.pgyidc.com/Template/ztdel";
            $data = ["recordid" => $pgy_id];
            $res = $this->curl_post($url, $data);
            if ($res != "60") {
            } else {
                return 1;
            }
        }
        return 0;
    }
    private function getId($ip)
    {
        $url = "https://user.pgyidc.com/template/ipzt";
        $res = $this->curl_get($url);
        $preg = "/<td>" . $ip . "<\\/td>[\\s\\S]*?<td>([\\s\\S]*?)<\\/td>[\\s\\S]*?<td>([\\s\\S]*?)<\\/td>[\\s\\S]*?<td><a href=\"javascript:void\\(0\\);\" onclick=\"restoring\\(([\\s\\S]*?)\\)\" style=\"text-decoration:underline;color:#FF0000;\">取消直通<\\/a><\\/td>/";
        preg_match_all($preg, $res, $match);
        if (!isset($match[3][0])) {
            return 0;
        }
        return $match[3][0];
    }
    public function heartbeat($username, $password)
    {
        $url = "https://user.pgyidc.com/template/userinfo";
        $res = $this->curl_get($url, false);
        if ($res == "<script>window.location.href='/login/login';</script>" || $res == "") {
            if ($this->Login($username, $password)) {
                echo "心跳失败.已重新登录";
            } else {
                echo "心跳失败.重新登录失败";
            }
        } else {
            echo "心跳成功";
        }
    }
    public function Login($username, $password)
    {
        $code = $this->getCode();
        if ($code) {
            $url = "https://user.pgyidc.com/login/loginin";
            $data = ["username" => $username, "password" => $password, "captcha" => $code["code"], "cb" => "on", "igcd" => $code["igcd"]];
            $res = $this->curl_post($url, $data, ["X-Requested-With: XMLHttpRequest"], true);
            if ($res != "0") {
                return false;
            }
            return true;
        }
        return false;
    }
    private function getCode()
    {
        $url = "https://user.pgyidc.com/login/codechange";
        $ret = $this->curl_post($url, []);
        $ret = json_decode($ret, true);
        if ($ret) {
            if (!(empty($ret["imgcode"]) || empty($ret["captchaImageUrl"]))) {
                $igcd = $ret["imgcode"];
                $captchaImageUrl = "https://user.pgyidc.com/img/captcha/" . $ret["captchaImageUrl"];
                $code = $this->Ocr($captchaImageUrl);
                if ($code) {
                    return ["igcd" => $igcd, "code" => $code];
                }
                return false;
            }
            return false;
        }
        return false;
    }
    private function Ocr($image_url)
    {
        $image = file_get_contents($image_url);
        $image = "data:image/png;base64," . base64_encode($image);
        $url = "https://cloud.baidu.com/aidemo";
        $data = ["image" => $image, "type" => "https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic", "detect_direction" => "false", "language_type" => "CHN_ENG"];
        $ret = $this->curl_post($url, $data, ["Origin: https://cloud.baidu.com", "Referer: https://cloud.baidu.com/product/ocr/general?"]);
        $ret = json_decode($ret, true);
        if ($ret["errno"] == 0) {
            if (!isset($ret["data"]["words_result"][0]["words"])) {
            } else {
                return $ret["data"]["words_result"][0]["words"];
            }
        }
        return false;
    }
    public function curl_post($url, $data, $header = ["X-Requested-With: XMLHttpRequest"], $isCk = false)
    {
        if (is_array($data)) {
            $data = http_build_query($data);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        if ($header) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        }
        if ($isCk) {
            curl_setopt($ch, CURLOPT_COOKIEJAR, CMF_DATA . "/qing_ye_pgyidc.cookie");
        } else {
            curl_setopt($ch, CURLOPT_COOKIEFILE, CMF_DATA . "/qing_ye_pgyidc.cookie");
        }
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }
    public function curl_get($url, $header = ["X-Requested-With: XMLHttpRequest"])
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        if ($header) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        }
        curl_setopt($ch, CURLOPT_COOKIEFILE, CMF_DATA . "/qing_ye_pgyidc.cookie");
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }
    private function is_ip($uid, $ip = "")
    {
        $is = \think\Db::name("host")->where(["uid" => $uid, "domainstatus" => "Active"])->where("FIND_IN_SET('" . $ip . "',`assignedips`) OR  `dedicatedip`='" . $ip . "'")->find();
        if (!$is) {
            return false;
        }
        return true;
    }
}

?>