<?php
namespace addons\qing_ye_pgyidc\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    private $common;
    public function initialize()
    {
        parent::initialize();
        $this->common = new \addons\qing_ye_pgyidc\Common(request()->uid);
    }
    public function cc(\think\Request $request)
    {
        $param = $request->param();
        if (!$request->isPost()) {
            $hostId = $request->hostId;
            $uid = $request->uid;
            $host_ip = $this->host_ip($uid, $hostId);
            if ($hostId && $host_ip) {
                $this->assign("dedicatedip", $host_ip[0]["dedicatedip"]);
            } else {
                if ($param["ip"]) {
                    $this->assign("dedicatedip", $param["ip"]);
                }
            }
            $this->assign("host_ip", $host_ip);
            $this->assign("Title", "IP CC策略");
            $YeList = $this->common->get_cc_list();
            $this->assign("YeList", $YeList);
            return $this->fetch("/cc");
        }
        $validate = \think\facade\Validate::make(["ip" => "require|ip", "cc" => "require|number", "releasetime" => "require|number"]);
        if ($validate->check($param)) {
            if ($this->is_ip($param["ip"])) {
                $file = file_get_contents(CMF_DATA . "/qing_ye_pgyidc_cc_time.log");
                if ($file) {
                    if (time() - $file < 180) {
                        return json(["status" => 0, "msg" => "正在排队中，请稍后再试"]);
                    }
                }
                if (!$this->common->add_cc($param["ip"], $param["cc"], $param["releasetime"])) {
                    return json(["status" => 0, "msg" => "添加失败"]);
                }
                file_put_contents(CMF_DATA . "/qing_ye_pgyidc_cc_time.log", time());
                return json(["status" => 1, "msg" => "添加成功"]);
            }
            return json(["status" => 0, "msg" => "非法提交"]);
        }
        return json(["status" => 0, "msg" => $validate->getError()]);
    }
    public function rid(\think\Request $request)
    {
        $param = $request->param();
        if (!$request->isPost()) {
            $hostId = $request->hostId;
            $uid = $request->uid;
            $host_ip = $this->host_ip($uid, $hostId);
            if ($hostId && $host_ip) {
                $this->assign("dedicatedip", $host_ip[0]["dedicatedip"]);
            } else {
                if ($param["ip"]) {
                    $this->assign("dedicatedip", $param["ip"]);
                }
            }
            $this->assign("host_ip", $host_ip);
            $this->assign("Title", "IP 释放");
            return $this->fetch("/rid");
        }
        $rule = ["ip" => "require|ip"];
        $Validate = \think\facade\Validate::rule($rule);
        $res = \think\facade\Validate::check($param);
        if (true === $res) {
            if ($this->is_ip($param["ip"])) {
                $file = file_get_contents(CMF_DATA . "/qing_ye_pgyidc_rid_time.log");
                if ($file) {
                    if (time() - $file < 180) {
                        return json(["status" => 0, "msg" => "正在排队中，请稍后再试"]);
                    }
                }
                if (!$this->common->rid($param["ip"])) {
                    return json(["status" => 0, "msg" => "释放失败"]);
                }
                file_put_contents(CMF_DATA . "/qing_ye_pgyidc_rid_time.log", time());
                return json(["status" => 1, "msg" => "释放成功"]);
            }
            return json(["status" => 0, "msg" => "IP地址不存在！"]);
        }
        return json(["status" => 0, "msg" => $Validate->getError()]);
    }
    public function attack(\think\Request $request)
    {
        $param = $request->param();
        $ip = "";
        if (!empty($param["ip"])) {
            if ($this->is_ip($param["ip"])) {
                $ip = $param["ip"];
                $YeList = $this->common->attack($ip);
                $this->assign("YeList", $YeList);
            }
        }
        $hostId = $request->hostId;
        $uid = $request->uid;
        $host_ip = $this->host_ip($uid, $hostId);
        if ($hostId && $host_ip) {
            $this->assign("dedicatedip", $host_ip[0]["dedicatedip"]);
        } else {
            if ($param["ip"]) {
                $this->assign("dedicatedip", $param["ip"]);
            }
        }
        $this->assign("host_ip", $host_ip);
        $this->assign("Title", "IP 攻击记录查看");
        if ($ip) {
            $attack = $this->common->attack($ip);
            $this->assign("attack", $attack);
        }
        return $this->fetch("/acklog");
    }
    public function zt(\think\Request $request)
    {
        $param = $request->param();
        if (!$request->isPost()) {
            $hostId = $request->hostId;
            $uid = $request->uid;
            $host_ip = $this->host_ip($uid, $hostId);
            if ($hostId && $host_ip) {
                $this->assign("dedicatedip", $host_ip[0]["dedicatedip"]);
            } else {
                if ($param["ip"]) {
                    $this->assign("dedicatedip", $param["ip"]);
                }
            }
            $this->assign("host_ip", $host_ip);
            $this->assign("Title", "IP 直通");
            return $this->fetch("/zt");
        }
        $rule = ["ip" => "require|ip", "type" => "require|number|in:1,2"];
        $Validate = \think\facade\Validate::rule($rule);
        $res = \think\facade\Validate::check($param);
        if (true === $res) {
            if ($this->is_ip($param["ip"])) {
                $uid = request()->uid;
                $ip = $param["ip"];
                $productId = \think\Db::name("host")->where(["uid" => $uid, "domainstatus" => "Active"])->where("FIND_IN_SET('" . $ip . "',`assignedips`) OR  `dedicatedip`='" . $ip . "'")->field("productid,id,create_time")->find();
                $recordid = 0;
                $m = \think\Db::name("qing_ye_pgyidc_ipzt")->where("ip", $param["ip"])->where("uid", $uid)->where("add_time", ">=", $productId["create_time"])->where("end_time", ">", time())->find();
                if (!($m && $param["type"] == 1)) {
                    if ($param["type"] == 2) {
                        if ($m) {
                            $recordid = $m["pgy_id"];
                        } else {
                            return json(["status" => 0, "msg" => "请先添加！"]);
                        }
                    }
                    $pgy_id = $this->common->zt($param["ip"], $recordid);
                    if (0 >= $pgy_id) {
                        return json(["status" => 0, "msg" => "调整失败"]);
                    }
                    if ($param["type"] == 1) {
                        $data = ["uid" => $uid, "ip" => $param["ip"], "pgy_id" => $pgy_id, "add_time" => time(), "end_time" => time() + 2592000];
                        \think\Db::name("qing_ye_pgyidc_ipzt")->insert($data);
                    } else {
                        \think\Db::name("qing_ye_pgyidc_ipzt")->where("ip", $param["ip"])->where("uid", $uid)->delete();
                    }
                    return json(["status" => 1, "msg" => "调整成功"]);
                }
                return json(["status" => 0, "msg" => "请勿重复添加！"]);
            }
            return json(["status" => 0, "msg" => "IP地址不存在！"]);
        }
        return json(["status" => 0, "msg" => $Validate->getError()]);
    }
    private function host_ip($uid, $hostId = "", $ip = "")
    {
        $res = \think\Db::name("plugin")->where("name", "QingYePgyidc")->find();
        $system = json_decode($res["config"], true);
        $range = $system["range"];
        $host_ip = \think\Db::name("host")->where(["uid" => $uid, "domainstatus" => "Active"]);
        if ($hostId != "") {
            $host_ip->orderRaw("id=" . $hostId . " desc");
        }
        if ($ip != "") {
            $host_ip->where("FIND_IN_SET('" . $ip . "',`assignedips`) OR  `dedicatedip`='" . $ip . "'");
        }
        $host_ip = $host_ip->order("id", "desc")->where("productid", "in", $range)->where("dedicatedip", "<>", "")->field("dedicatedip,assignedips,id")->select();
        return $host_ip;
    }
    private function is_ip($ip)
    {
        $uid = request()->uid;
        $is = \think\Db::name("host")->where(["uid" => $uid, "domainstatus" => "Active"])->where("FIND_IN_SET('" . $ip . "',`assignedips`) OR  `dedicatedip`='" . $ip . "'")->find();
        if (!$is) {
            return false;
        }
        return true;
    }
}

?>