<section class="admin-main">

    <!-- 干掉溢出隐藏，解决 select被遮挡-->
    <style>
        .main-content {
            /*margin-left: 250px;*/
            overflow: visible;
        }
    </style>

    <div class="card">
        <div class="card-body">
            <div class="ticket-top">
                <p>金盾网页CC： 分为三个级别：低、中、高，主要防护端口为TCP协议：80端口，防御严格程度依次增加。</p>
                <p style="margin-top:1em;color:#FF0000">金盾游戏CC： 分为三个级别：低、中、高，主要防护端口为TCP协议：25565、7000至9000等游戏端口，防御严格程度依次增加。</p>
                <p style="margin-top:1em;color:#FF0000">金盾游戏CC： 若加了防护在没有攻击的情况下，不影响正常业务</p>
                <p style="margin-top:1em;color:#FF0000">金盾游戏CC：支持防护预设</p>
                <p style="margin-top:1em;color:#FF0000">每次使用需要等待180秒</p>
            </div>
        </div>
    </div>


    <div class="card">
        <div class="card-body" >

            <div class="table-Tab">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item waves-effect waves-light">
                        <a class="nav-link active"
                           href="{:shd_addon_url('QingYePgyidc://Index/cc',[],true)}"
                           role="tab">IP CC策略</a>
                    </li>

                    <li class="nav-item waves-effect waves-light">
                        <a class="nav-link"
                           href="{:shd_addon_url('QingYePgyidc://Index/rid',[],true)}"
                           role="tab">IP 释放</a>
                    </li>

                    <li class="nav-item waves-effect waves-light">
                        <a class="nav-link"
                           href="{:shd_addon_url('QingYePgyidc://Index/attack',[],true)}"
                           role="tab">IP 攻击记录</a>
                    </li>

                    <li class="nav-item waves-effect waves-light">
                        <a class="nav-link"
                           href="{:shd_addon_url('QingYePgyidc://Index/zt',[],true)}"
                           role="tab">IP 直通</a>
                    </li>



                </ul>
            </div>


            <div class="table-header"></div>

            <form id="addFireWallForm"  class="form">
                <div class="form-row ">
                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label class="require">选择 IP 地址</label>
                        <select class="selectpicker show-tick form-control" id="IpSelect" data-live-search="true">
                            <option selected disabled style="display：none" value="">请选择 IP</option>
                            {foreach $host_ip as $p}
                                {if filter_var($p.dedicatedip, FILTER_VALIDATE_IP)}
                                    <option value="{$p.dedicatedip}">{$p.dedicatedip}</option>
                                {/if}
                                {foreach :explode(',',$p.assignedips) as $v}
                                    {if filter_var($v, FILTER_VALIDATE_IP)}
                                        <option value="{$v}">{$v}</option>
                                    {/if}
                                {/foreach}
                            {/foreach}
                        </select>
                    </div>

                    <div class="form-group col-lg-3 col-md-3 col-sm-4">
                        <label>选择 CC 策略</label>
                        <select class="selectpicker show-tick form-control" id="CcSelect" data-live-search="true">
                            <option selected disabled style="display：none" value="">请选择 策略</option>
                            <option value="1">默认无策略</option>
                            <option value="20">阻断UDP</option>
                            <option value="19">服务器禁止Ping</option>
                            <option value="2">Web防护低</option>
                            <option value="3">Web防护中</option>
                            <option value="4">Web防护高</option>
                            <option value="16">WEB CC最新防御（预设规则）</option>
                            <option value="18">WEB CC最新防御（正在被攻击）</option>
                            <option value="12">Web防护中（xml/txt频率）</option>
                            <option value="11">Web防护中（xml/txt频率及代理攻击）</option>
                            <option value="5">Game防护低（传奇类）</option>
                            <option value="17">Game防护中（预设规则）</option>
                            <option value="6">Game防护中（正在被攻击）</option>
                            <option value="7">Game防护高（传奇类）</option>
                            <option value="10">Game防护（DNF+MC）</option>
                        </select>
                    </div>

                    <div class="form-group col-lg-1 col-md-3 col-sm-4">
                        <label>释放天数</label>
                        <input type="text" class="form-control" id="releasetime" placeholder="释放时间">
                    </div>

                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label>&nbsp;</label>
                        <button class="btn btn-primary form-control" id="button" type="button">添加 CC 策略</button>
                    </div>

                </div>
            </form>


        </div>
    </div>




    <div class="card">
        <div class="card-body">

            <div class="table-header">

                <div class="page-title-box d-flex align-items-center justify-content-between">
                    <div style="display:flex;">
                        <h4 class="mb-0 font-size-18">CC策略记录</h4>
                    </div>
                </div>

            </div>

            <div class="table-body table-responsive">
                <table class="table table-bordered table-hover">

                    <thead class="thead-light">
                    <tr>
                        <th class="center t1">IP</th>
                        <th class="center t1">防护类型</th>
                        <th class="center">防护时间</th>
                        <th class="center">释放时间</th>
                    </tr>
                    </thead>
                    <tbody>
                    {foreach $YeList as $k}
                        <tr>
                            <td>{$k.ip}</td>
                            <td>{$k.cc_list_name}</td>
                            <td>{$k.create_time}</td>
                            <td>{$k.release_time}</td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
            </div>


        </div>
    </div>



    <link rel="stylesheet" href="{$Setting.web_url}/themes/clientarea/default/assets/libs/bootstrap-select/css/bootstrap-select.min.css?v={$Ver}">
    <script src="{$Setting.web_url}/themes/clientarea/default/assets/libs/bootstrap-select/js/bootstrap-select.min.js?v={$Ver}"></script>
    <script src="{$Setting.web_url}/themes/clientarea/default/assets/libs/bootstrap-select/js/i18n/defaults-zh_CN.min.js"></script>


    <script>
        $(function() {
            var IpSelect = $("#IpSelect");
            IpSelect.selectpicker();
            {if $dedicatedip}
            IpSelect.val('{$dedicatedip}').change();
            IpSelect.selectpicker('refresh');
            {/if}

            $("#button").click(function(){
                var elem = this;
                var ip = $("#IpSelect").val();
                var cc = $("#CcSelect").val();
                var releasetime = $("#releasetime").val();
                if(ip == "" || $.trim(ip).length == 0){
                    toastr.error("请选择IP！");
                    return;
                }
                if(cc == "" || $.trim(cc).length == 0){
                    toastr.error("请选择CC策略！");
                    return;
                }
                if(releasetime == "" || $.trim(releasetime).length == 0){
                    toastr.error("请输入释放时间！");
                    return;
                }
                if(releasetime < 1){
                    toastr.error("释放时间不能小于1天！");
                    return;
                }
                BtnLoading(elem);
                $.ajax({
                    url: '{:shd_addon_url('QingYePgyidc://Index/cc',[],true)}',
                    type: 'POST',
                    data: {ip:ip,cc:cc,releasetime:releasetime},
                    success: function (data) {
                        if (data.status) {
                            toastr.success(data.msg);
                            BtnReset(elem);
                            setTimeout(function () { window.location.reload(); }, 1000);
                        }else {
                            toastr.error(data.msg);
                            BtnReset(elem);
                        }
                    }, error: function () {
                        toastr.error("系统错误！");
                        BtnReset(elem);
                    }
                })
            });

            $("#side-menu li ").each(function(){
                var a = $(this).find('a').attr('href');
                if (a.indexOf("&_controller=index&_action=cc") !== -1 ){
                    $(this).addClass("mm-active");
                    $(this).find('a').addClass("active");
                }
            });
        });

        function BtnLoading(elem) {
            $(elem).attr("data-original-text", $(elem).html());
            $(elem).prop("disabled", true);
            $(elem).html('<i class="spinner-border spinner-border-sm"></i> 加载中...');
            $(elem).css("background-color","#6064ff");
        }

        function BtnReset(elem) {
            $(elem).prop("disabled", false);
            $(elem).html($(elem).attr("data-original-text"));
            $(elem).css("background-color",'');
        }
    </script>


</section>