<?php
namespace addons\queue_tasks;

class QueueTasksPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "QueueTasks", "title" => "队列任务失败通知【机器人版】", "description" => "队列任务失败通知，对接上游开通失败，暂时失败，解除暂停失败，续费失败，删除失败，升降级失败时通知", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.3", "module" => "addons"];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "apiid", "type" => "VARCHAR(255)"], ["name" => "apikey", "type" => "VARCHAR(255)"], ["name" => "webname", "type" => "VARCHAR(255)"], ["name" => "zzqq", "type" => "VARCHAR(255)"], ["name" => "zzemail", "type" => "VARCHAR(255)"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "mfauth", "type" => "VARCHAR(255)"], ["name" => "feishuswitch", "type" => "VARCHAR(255)"], ["name" => "dingswitch", "type" => "VARCHAR(255)"], ["name" => "wechatswitch", "type" => "VARCHAR(255)"], ["name" => "tgswitch", "type" => "VARCHAR(255)"], ["name" => "feishuurl", "type" => "VARCHAR(255)"], ["name" => "dingurl", "type" => "VARCHAR(255)"], ["name" => "wechaturl", "type" => "VARCHAR(255)"], ["name" => "tgtoken", "type" => "VARCHAR(255)"], ["name" => "tgchatid", "type" => "VARCHAR(255)"], ["name" => "from_type", "type" => "VARCHAR(255)"], ["name" => "types", "type" => "TEXT"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "notified_id", "type" => "VARCHAR(255)"], ["name" => "times", "type" => "VARCHAR(255)"], ["name" => "user_id", "type" => "VARCHAR(255)"], ["name" => "user", "type" => "VARCHAR(255)"], ["name" => "host_id", "type" => "VARCHAR(255)"], ["name" => "last_execute_time", "type" => "VARCHAR(255)"], ["name" => "from_type", "type" => "VARCHAR(255)"], ["name" => "active_type", "type" => "VARCHAR(255)"], ["name" => "message", "type" => "VARCHAR(255)"], ["name" => "dingtalk", "type" => "VARCHAR(255)"], ["name" => "wechat", "type" => "VARCHAR(255)"], ["name" => "feishu", "type" => "VARCHAR(255)"]];
        $tableName1 = "shd_queue_tasks_config";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n            CREATE TABLE " . $tableName1 . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n            );\n        ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                    ALTER TABLE " . $tableName1 . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_queue_tasks_list";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n            CREATE TABLE " . $tableName2 . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n            );\n        ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                    ALTER TABLE " . $tableName2 . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function afterCron()
    {
        $notifiedIds = \Think\Db::name("queue_tasks_list")->where("times", ">", time() - 86400)->column("notified_id");
        $lastTenIds = \Think\Db::name("run_maping")->where("create_time", ">", time() - 86400)->where("status", 0)->whereNotIn("id", $notifiedIds)->order("id", "desc")->column("id");
        $queuetasks = \Think\Db::name("queue_tasks_config")->where("id", 1)->find();
        if (!empty($lastTenIds)) {
            $data = \Think\Db::name("run_maping")->whereIn("from_type", $queuetasks["from_type"])->whereIn("active_type", $queuetasks["types"])->whereIn("id", $lastTenIds)->select();
            if (!empty($data)) {
                foreach ($data as $row) {
                    $messageContent = $row["description"];
                    $id = $row["id"];
                    $user_id = $row["user_id"];
                    $user = $row["user"];
                    $host_id = $row["host_id"];
                    $create_time = $row["create_time"];
                    $last_execute_time = $row["last_execute_time"];
                    $createtime = date("Y-m-d H:i:s", $row["create_time"]);
                    $last_executetime = date("Y-m-d H:i:s", $row["last_execute_time"]);
                    $tz_time = date("Y-m-d H:i:s", time());
                    $current_time = time();
                    $webname = $queuetasks["webname"];
                    $from_type = $row["from_type"];
                    switch ($from_type) {
                        case 100:
                            $from_typeText = "定时任务";
                            break;
                        case 200:
                            $from_typeText = "手动任务";
                            break;
                        case 300:
                            $from_typeText = "订单任务";
                            break;
                        case 400:
                            $from_typeText = "对接上游";
                            break;
                        case 500:
                            $from_typeText = "下游发起";
                            break;
                        default:
                            $from_typeText = "未知来源";
                            $active_type = $row["active_type"];
                            switch ($active_type) {
                                case 1:
                                    $activeTypeText = "开通";
                                    break;
                                case 2:
                                    $activeTypeText = "暂停";
                                    break;
                                case 3:
                                    $activeTypeText = "解除暂停";
                                    break;
                                case 4:
                                    $activeTypeText = "删除";
                                    break;
                                case 5:
                                    $activeTypeText = "续费";
                                    break;
                                case 6:
                                    $activeTypeText = "升降级";
                                    break;
                                default:
                                    $activeTypeText = "未知类型";
                                    if ($queuetasks["dingswitch"] == 1) {
                                        $dingdingUrl = $queuetasks["dingurl"];
                                        $dingdingMessage = ["msgtype" => "text", "text" => ["content" => "【" . $from_typeText . " " . $activeTypeText . " 失败通知】 \n用户编号：" . $user_id . " \n用户名称：" . $user . " \n产品编号：" . $host_id . " \n来源类型：" . $from_typeText . " \n失败类型：" . $activeTypeText . " \n创建时间：" . $createtime . " \n最后执行：" . $last_executetime . " \n通知时间：" . $tz_time . " \n失败详情：" . $messageContent . "\n\n信息来源【 " . $webname . " 】队列任务失败通知"]];
                                        $dingdingData = json_encode($dingdingMessage);
                                        $dingdingHeaders = ["Content-Type: application/json;charset=utf-8"];
                                        $dingdingCh = curl_init($dingdingUrl);
                                        curl_setopt($dingdingCh, CURLOPT_CUSTOMREQUEST, "POST");
                                        curl_setopt($dingdingCh, CURLOPT_POSTFIELDS, $dingdingData);
                                        curl_setopt($dingdingCh, CURLOPT_RETURNTRANSFER, true);
                                        curl_setopt($dingdingCh, CURLOPT_HTTPHEADER, $dingdingHeaders);
                                        $dingdingResult = curl_exec($dingdingCh);
                                        curl_close($dingdingCh);
                                        if ($dingdingResult !== false) {
                                        }
                                    }
                                    if ($queuetasks["feishuswitch"] == 1) {
                                        $feishuWebhook = $queuetasks["feishuurl"];
                                        $feishuMessage = ["msg_type" => "text", "content" => ["text" => "【" . $from_typeText . " " . $activeTypeText . " 失败通知】 \n用户编号：" . $user_id . " \n用户名称：" . $user . " \n产品编号：" . $host_id . " \n来源类型：" . $from_typeText . " \n失败类型：" . $activeTypeText . " \n创建时间：" . $createtime . " \n最后执行：" . $last_executetime . " \n通知时间：" . $tz_time . " \n失败详情：" . $messageContent . "\n\n信息来源【 " . $webname . " 】队列任务失败通知"]];
                                        $feishuData = json_encode($feishuMessage);
                                        $feishuHeaders = ["Content-Type: application/json;charset=utf-8"];
                                        $feishuCh = curl_init($feishuWebhook);
                                        curl_setopt($feishuCh, CURLOPT_CUSTOMREQUEST, "POST");
                                        curl_setopt($feishuCh, CURLOPT_POSTFIELDS, $feishuData);
                                        curl_setopt($feishuCh, CURLOPT_RETURNTRANSFER, true);
                                        curl_setopt($feishuCh, CURLOPT_HTTPHEADER, $feishuHeaders);
                                        $feishuResult = curl_exec($feishuCh);
                                        curl_close($feishuCh);
                                        if ($feishuResult === false) {
                                            echo "发送飞书消息失败";
                                        } else {
                                            echo "飞书消息发送成功";
                                        }
                                    }
                                    if ($queuetasks["wechatswitch"] == 1) {
                                        $wechatWebhook = $queuetasks["wechaturl"];
                                        $wechatMessage = ["msgtype" => "text", "text" => ["content" => "【" . $from_typeText . " " . $activeTypeText . " 失败通知】 \n用户编号：" . $user_id . " \n用户名称：" . $user . " \n产品编号：" . $host_id . " \n来源类型：" . $from_typeText . " \n失败类型：" . $activeTypeText . " \n创建时间：" . $createtime . " \n最后执行：" . $last_executetime . " \n通知时间：" . $tz_time . " \n失败详情：" . $messageContent . "\n\n信息来源【 " . $webname . " 】队列任务失败通知"]];
                                        $wechatData = json_encode($wechatMessage);
                                        $wechatHeaders = ["Content-Type: application/json;charset=utf-8"];
                                        $wechatCh = curl_init($wechatWebhook);
                                        curl_setopt($wechatCh, CURLOPT_CUSTOMREQUEST, "POST");
                                        curl_setopt($wechatCh, CURLOPT_POSTFIELDS, $wechatData);
                                        curl_setopt($wechatCh, CURLOPT_RETURNTRANSFER, true);
                                        curl_setopt($wechatCh, CURLOPT_HTTPHEADER, $wechatHeaders);
                                        $wechatResult = curl_exec($wechatCh);
                                        curl_close($wechatCh);
                                        if ($wechatResult !== false) {
                                        }
                                    }
                                    if ($queuetasks["tgswitch"] == 1) {
                                        $telegramBotToken = $queuetasks["tgtoken"];
                                        $telegramChatId = $queuetasks["tgchatid"];
                                        $telegramMessage = "【" . $from_typeText . " " . $activeTypeText . " 失败通知】 \n用户编号：" . $user_id . " \n用户名称：" . $user . " \n产品编号：" . $host_id . " \n来源类型：" . $from_typeText . " \n失败类型：" . $activeTypeText . " \n创建时间：" . $createtime . " \n最后执行：" . $last_executetime . " \n通知时间：" . $tz_time . " \n失败详情：" . $messageContent . "\n\n信息来源【 " . $webname . " 】队列任务失败通知";
                                        $telegramApiUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage";
                                        $telegramParams = ["chat_id" => $telegramChatId, "text" => $telegramMessage];
                                        $telegramCh = curl_init($telegramApiUrl);
                                        curl_setopt($telegramCh, CURLOPT_POST, true);
                                        curl_setopt($telegramCh, CURLOPT_POSTFIELDS, $telegramParams);
                                        curl_setopt($telegramCh, CURLOPT_RETURNTRANSFER, true);
                                        $telegramResult = curl_exec($telegramCh);
                                        curl_close($telegramCh);
                                        if ($telegramResult !== false) {
                                        }
                                    }
                                    \Think\Db::name("queue_tasks_list")->insert(["notified_id" => $id, "times" => $current_time, "user_id" => $user_id, "user" => $user, "host_id" => $host_id, "last_execute_time" => $last_execute_time, "from_type" => $from_type, "active_type" => $active_type, "message" => $messageContent, "dingtalk" => $dingdingResult, "wechat" => $wechatResult, "feishu" => $feishuResult]);
                        }
                    }
                }
            }
        }
    }
}

?>