<?php
namespace addons\recharge_marketing;

class RechargeMarketingPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "RechargeMarketing", "title" => "充值赠送", "description" => "充值赠送活动，支持账户充值赠送金额，按固定值赠送，按比例赠送", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.5", "module" => "addons", "lang" => ["chinese" => "充值赠送", "chinese_tw" => "充值贈送", "english" => "Recharge Marketing"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "apiid", "type" => "varchar(500)"], ["name" => "apikey", "type" => "varchar(500)"], ["name" => "agent", "type" => "varchar(500)"], ["name" => "weburl", "type" => "varchar(500)"], ["name" => "sitename", "type" => "varchar(500)"], ["name" => "authorize", "type" => "varchar(500)"], ["name" => "webmasteremail", "type" => "varchar(500)"], ["name" => "webmasterqq", "type" => "varchar(500)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "user_id", "type" => "VARCHAR(255)"], ["name" => "amount", "type" => "DECIMAL(10, 2)"], ["name" => "bonus_type", "type" => "ENUM('fixed', 'percent')"], ["name" => "bonus", "type" => "VARCHAR(255)"], ["name" => "bonus_amount", "type" => "DECIMAL(10, 2)"], ["name" => "bonus_rule_id", "type" => "VARCHAR(255)"], ["name" => "recharge_id", "type" => "VARCHAR(255)"], ["name" => "invoice_num", "type" => "VARCHAR(255)"], ["name" => "recharge_date", "type" => "VARCHAR(255)"]];
        $fieldsToAddTable3 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "activityname", "type" => "VARCHAR(255)"], ["name" => "min_recharge_amount", "type" => "DECIMAL(10, 2)"], ["name" => "start_date", "type" => "VARCHAR(255)"], ["name" => "end_date", "type" => "VARCHAR(255)"], ["name" => "bonus_type", "type" => "ENUM('fixed', 'percent')"], ["name" => "bonus_amount", "type" => "DECIMAL(10, 2)"], ["name" => "max_participation", "type" => "VARCHAR(255)"]];
        $tableName1 = "shd_recharge_setting";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_recharge_records";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n                    CREATE TABLE " . $tableName2 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n                    );\n                ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                            ALTER TABLE " . $tableName2 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        $tableName3 = "shd_recharge_bonus_rules";
        $tableExists3 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName3 . "'");
        if (empty($tableExists3)) {
            $sql3 = "\n                    CREATE TABLE " . $tableName3 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable3)) . "\n                    );\n                ";
            \Think\Db::execute($sql3);
        } else {
            foreach ($fieldsToAddTable3 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName3 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql3 = "\n                            ALTER TABLE " . $tableName3 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql3);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function invoicePaid($params)
    {
        $invoiceid = $params["invoiceid"];
        $Info = \Think\Db::name("recharge_setting")->where("id", 1)->find();
        if (!empty($invoiceid)) {
            $invoicesInfo = \Think\Db::name("invoices")->where("id", $invoiceid)->find();
            $groupid = \Think\Db::name("clients")->where("id", $invoicesInfo["uid"])->value("groupid");
            if ($Info["agent"] == 1) {
                if ($groupid == 0 && $invoicesInfo["type"] === "recharge") {
                    $user_id = $invoicesInfo["uid"];
                    $type = $invoicesInfo["type"];
                    $amount = $invoicesInfo["total"];
                    $current_date = time();
                    $rules = \Think\Db::name("recharge_bonus_rules")->where("min_recharge_amount", "<=", $amount)->where("start_date", "<=", $current_date)->where("end_date", ">=", $current_date)->order("bonus_amount", "desc")->select();
                    $max_bonus_amount = 0;
                    $used_rule_id = NULL;
                    foreach ($rules as $rule) {
                        $participation_count = \Think\Db::name("recharge_records")->where("user_id", $user_id)->where("bonus_rule_id", $rule["id"])->count();
                        if ($participation_count < $rule["max_participation"]) {
                            if ($rule["bonus_type"] === "percent") {
                                $bonus_amount = $amount * $rule["bonus_amount"] / 100;
                                $bonus_amount = number_format($bonus_amount, 2, ".", "");
                            } else {
                                $bonus_amount = $rule["bonus_amount"];
                            }
                            if ($max_bonus_amount < $bonus_amount) {
                                $max_bonus_amount = $bonus_amount;
                                $used_rule_id = $rule["id"];
                                $start_date = $rule["start_date"];
                                $end_date = $rule["end_date"];
                                $min_recharge_amount = $rule["min_recharge_amount"];
                                $bonus_type = $rule["bonus_type"];
                                $bonus_amount_value = $rule["bonus_amount"];
                                $max_participation = $rule["max_participation"];
                                if ($bonus_type === "percent") {
                                    $bonus_type_text = "百分比";
                                } else {
                                    $bonus_type_text = "固定金额";
                                }
                                if ($bonus_type === "percent") {
                                    $bonus_amounts = $bonus_amount_value . "%";
                                } else {
                                    $bonus_amounts = number_format($bonus_amount_value, 2, ".", "") . "元";
                                }
                            }
                        }
                    }
                    if (0 < $max_bonus_amount && $used_rule_id !== NULL) {
                        $clients = \Think\Db::name("clients")->where("id", $user_id)->find();
                        $credit = $clients["credit"];
                        $newcredit = $max_bonus_amount + $credit;
                        $upnewcredit = \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                        $data = ["uid" => $user_id, "create_time" => time(), "description" => "用户-[UID" . $user_id . "]在【" . date("Y-m-d H:i:s") . "】成功充值" . $amount . "元，符合充值赠送活动赠送" . $max_bonus_amount . "元，充值账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $start_date) . "至" . date("Y-m-d H:i:s", $end_date) . "，符合规则ID：" . $used_rule_id . "，单笔充值满" . $min_recharge_amount . "元，按" . $bonus_type_text . "赠送" . $bonus_amounts . "", "amount" => $max_bonus_amount, "balance" => $newcredit];
                        \Think\Db::name("credit")->insert($data);
                        $datainvoices = ["uid" => $user_id, "create_time" => time(), "due_time" => time(), "paid_time" => time(), "update_time" => time(), "subtotal" => $max_bonus_amount, "total" => $max_bonus_amount, "payment" => "UserCustom", "status" => "Paid", "type" => "recharge"];
                        \Think\Db::name("invoices")->insert($datainvoices);
                        $insertedId = \Think\Db::name("invoices")->getLastInsID();
                        $datainvoice_items = ["invoice_id" => $insertedId, "uid" => $user_id, "type" => "recharge", "due_time" => time(), "description" => "用户-[UID" . $user_id . "]在【" . date("Y-m-d H:i:s") . "】成功充值" . $amount . "元，符合充值赠送活动赠送" . $max_bonus_amount . "元，充值账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $start_date) . "至" . date("Y-m-d H:i:s", $end_date) . "，符合规则ID：" . $used_rule_id . "", "amount" => $max_bonus_amount];
                        \Think\Db::name("invoice_items")->insert($datainvoice_items);
                        $activity_log = ["uid" => $user_id, "description" => "【充值赠送活动】用户-[UID" . $user_id . "]在【" . date("Y-m-d H:i:s") . "】成功充值" . $amount . "元，符合充值赠送活动赠送" . $max_bonus_amount . "元，充值账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $start_date) . "至" . date("Y-m-d H:i:s", $end_date) . "，符合规则ID：" . $used_rule_id . "，单笔充值满" . $min_recharge_amount . "元，按" . $bonus_type_text . "赠送" . $bonus_amounts . "", "user" => "System", "port" => "", "create_time" => time(), "ipaddr" => "0.0.0.0", "type" => 0, "activeid" => 0, "usertype" => "System", "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($activity_log);
                        $bonus_data = ["user_id" => $user_id, "amount" => $amount, "bonus_type" => $bonus_type, "bonus_amount" => $max_bonus_amount, "bonus" => $bonus_amount_value, "bonus_rule_id" => $used_rule_id, "recharge_id" => $invoiceid, "invoice_num" => $insertedId, "recharge_date" => time()];
                        \Think\Db::name("recharge_records")->insert($bonus_data);
                    }
                }
            } else {
                if ($invoicesInfo["type"] === "recharge") {
                    $user_id = $invoicesInfo["uid"];
                    $type = $invoicesInfo["type"];
                    $amount = $invoicesInfo["total"];
                    $current_date = time();
                    $rules = \Think\Db::name("recharge_bonus_rules")->where("min_recharge_amount", "<=", $amount)->where("start_date", "<=", $current_date)->where("end_date", ">=", $current_date)->order("bonus_amount", "desc")->select();
                    $max_bonus_amount = 0;
                    $used_rule_id = NULL;
                    foreach ($rules as $rule) {
                        $participation_count = \Think\Db::name("recharge_records")->where("user_id", $user_id)->where("bonus_rule_id", $rule["id"])->count();
                        if ($participation_count < $rule["max_participation"]) {
                            if ($rule["bonus_type"] === "percent") {
                                $bonus_amount = $amount * $rule["bonus_amount"] / 100;
                                $bonus_amount = number_format($bonus_amount, 2, ".", "");
                            } else {
                                $bonus_amount = $rule["bonus_amount"];
                            }
                            if ($max_bonus_amount < $bonus_amount) {
                                $max_bonus_amount = $bonus_amount;
                                $used_rule_id = $rule["id"];
                                $start_date = $rule["start_date"];
                                $end_date = $rule["end_date"];
                                $min_recharge_amount = $rule["min_recharge_amount"];
                                $bonus_type = $rule["bonus_type"];
                                $bonus_amount_value = $rule["bonus_amount"];
                                $max_participation = $rule["max_participation"];
                                if ($bonus_type === "percent") {
                                    $bonus_type_text = "百分比";
                                } else {
                                    $bonus_type_text = "固定金额";
                                }
                                if ($bonus_type === "percent") {
                                    $bonus_amounts = $bonus_amount_value . "%";
                                } else {
                                    $bonus_amounts = number_format($bonus_amount_value, 2, ".", "") . "元";
                                }
                            }
                        }
                    }
                    if (0 < $max_bonus_amount && $used_rule_id !== NULL) {
                        $clients = \Think\Db::name("clients")->where("id", $user_id)->find();
                        $credit = $clients["credit"];
                        $newcredit = $max_bonus_amount + $credit;
                        $upnewcredit = \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                        $data = ["uid" => $user_id, "create_time" => time(), "description" => "用户-[UID" . $user_id . "]在【" . date("Y-m-d H:i:s") . "】成功充值" . $amount . "元，符合充值赠送活动赠送" . $max_bonus_amount . "元，充值账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $start_date) . "至" . date("Y-m-d H:i:s", $end_date) . "，符合规则ID：" . $used_rule_id . "，单笔充值满" . $min_recharge_amount . "元，按" . $bonus_type_text . "赠送" . $bonus_amounts . "", "amount" => $max_bonus_amount, "balance" => $newcredit];
                        \Think\Db::name("credit")->insert($data);
                        $datainvoices = ["uid" => $user_id, "create_time" => time(), "due_time" => time(), "paid_time" => time(), "update_time" => time(), "subtotal" => $max_bonus_amount, "total" => $max_bonus_amount, "payment" => "UserCustom", "status" => "Paid", "type" => "recharge"];
                        \Think\Db::name("invoices")->insert($datainvoices);
                        $insertedId = \Think\Db::name("invoices")->getLastInsID();
                        $datainvoice_items = ["invoice_id" => $insertedId, "uid" => $user_id, "type" => "recharge", "due_time" => time(), "description" => "用户-[UID" . $user_id . "]在【" . date("Y-m-d H:i:s") . "】成功充值" . $amount . "元，符合充值赠送活动赠送" . $max_bonus_amount . "元，充值账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $start_date) . "至" . date("Y-m-d H:i:s", $end_date) . "，符合规则ID：" . $used_rule_id . "", "amount" => $max_bonus_amount];
                        \Think\Db::name("invoice_items")->insert($datainvoice_items);
                        $activity_log = ["uid" => $user_id, "description" => "【充值赠送活动】用户-[UID" . $user_id . "]在【" . date("Y-m-d H:i:s") . "】成功充值" . $amount . "元，符合充值赠送活动赠送" . $max_bonus_amount . "元，充值账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $start_date) . "至" . date("Y-m-d H:i:s", $end_date) . "，符合规则ID：" . $used_rule_id . "，单笔充值满" . $min_recharge_amount . "元，按" . $bonus_type_text . "赠送" . $bonus_amounts . "", "user" => "System", "port" => "", "create_time" => time(), "ipaddr" => "0.0.0.0", "type" => 0, "activeid" => 0, "usertype" => "System", "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($activity_log);
                        $bonus_data = ["user_id" => $user_id, "amount" => $amount, "bonus_type" => $bonus_type, "bonus_amount" => $max_bonus_amount, "bonus" => $bonus_amount_value, "bonus_rule_id" => $used_rule_id, "recharge_id" => $invoiceid, "invoice_num" => $insertedId, "recharge_date" => time()];
                        \Think\Db::name("recharge_records")->insert($bonus_data);
                    }
                }
            }
        }
    }
}

?>