<?php
namespace addons\recharge_marketing\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function setting()
    {
        $configurationsModel = \Think\Db::name("recharge_setting");
        $configData = $configurationsModel->find();
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/setting");
    }
    public function submit()
    {
        $data = $this->request->post();
        $webmasteremail = isset($data["webmasteremail"]) ? $data["webmasteremail"] : NULL;
        $webmasterqq = isset($data["webmasterqq"]) ? $data["webmasterqq"] : NULL;
        $authorize = isset($data["authorize"]) ? $data["authorize"] : NULL;
        $agent = isset($data["agent"]) ? $data["agent"] : NULL;
        $dbConfig = ["webmasteremail" => $webmasteremail, "webmasterqq" => $webmasterqq, "authorize" => $authorize, "agent" => $agent, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \Think\Db::name("recharge_setting")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("recharge_setting")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("recharge_setting")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function addactivity()
    {
        $this->assign("Title", "添加活动");
        return $this->fetch("/addactivity");
    }
    public function addactivitys()
    {
        $data = $this->request->post();
        $activityname = isset($data["activityname"]) ? $data["activityname"] : NULL;
        $amount = isset($data["amount"]) ? $data["amount"] : NULL;
        $start_time = isset($data["start_time"]) ? strtotime($data["start_time"]) : NULL;
        $end_time = isset($data["end_time"]) ? strtotime($data["end_time"]) : NULL;
        $max_participation = isset($data["max_participation"]) ? $data["max_participation"] : NULL;
        $bonus_type = isset($data["bonus_type"]) ? $data["bonus_type"] : NULL;
        $bonus_amount = isset($data["bonus_amount"]) ? $data["bonus_amount"] : NULL;
        if (empty($data["activityname"])) {
            $response = ["code" => 400, "msg" => "活动名称是必填的"];
            return json($response);
        }
        if (empty($data["start_time"])) {
            $response = ["code" => 400, "msg" => "活动开始时间是必填的。"];
            return json($response);
        }
        if (empty($data["end_time"])) {
            $response = ["code" => 400, "msg" => "活动结束时间是必填的。"];
            return json($response);
        }
        if (empty($data["amount"])) {
            $response = ["code" => 400, "msg" => "充值金额必填。"];
            return json($response);
        }
        if (!preg_match("/^\\d+(\\.\\d{1,2})?\$/", $data["amount"])) {
            $response = ["code" => 400, "msg" => "请输入有效的充值金额，最多两位小数。"];
            return json($response);
        }
        if (empty($data["max_participation"])) {
            $response = ["code" => 400, "msg" => "最大参与次数必填。"];
            return json($response);
        }
        if (empty($data["bonus_type"])) {
            $response = ["code" => 400, "msg" => "赠送类型必选。"];
            return json($response);
        }
        if (empty($data["bonus_amount"])) {
            $response = ["code" => 400, "msg" => "赠送面值必填。"];
            return json($response);
        }
        if (!preg_match("/^\\d+(\\.\\d{1,2})?\$/", $data["bonus_amount"])) {
            $response = ["code" => 400, "msg" => "请输入有效的赠送面值，最多两位小数。"];
            return json($response);
        }
        $dbData = ["activityname" => $activityname, "min_recharge_amount" => $amount, "start_date" => $start_time, "end_date" => $end_time, "max_participation" => $max_participation, "bonus_type" => $bonus_type, "bonus_amount" => $bonus_amount];
        $dbData = array_filter($dbData, function ($value) {
            return $value !== NULL;
        });
        $result = \Think\Db::name("recharge_bonus_rules")->insert($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "活动配置添加成功。"];
        } else {
            $response = ["code" => 400, "msg" => "活动配置添加失败。"];
        }
        return json($response);
    }
    public function activitylist()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $rules = \Think\Db::name("recharge_bonus_rules")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $bonusAmounts = [];
        foreach ($rules as $rule) {
            $bonusRuleId = $rule["id"];
            $totalBonusAmount = \Think\Db::name("recharge_records")->where("bonus_rule_id", $bonusRuleId)->sum("bonus_amount");
            $bonusAmounts[$bonusRuleId] = $totalBonusAmount;
        }
        $amount = [];
        foreach ($rules as $rule) {
            $bonusRuleId = $rule["id"];
            $totalamount = \Think\Db::name("recharge_records")->where("bonus_rule_id", $bonusRuleId)->sum("amount");
            $amount[$bonusRuleId] = $totalamount;
        }
        $participantsCount = [];
        $peopleCount = [];
        foreach ($rules as $rule) {
            $bonusRuleId = $rule["id"];
            $participants = \Think\Db::name("recharge_records")->where("bonus_rule_id", $bonusRuleId)->count();
            $people = \Think\Db::name("recharge_records")->where("bonus_rule_id", $bonusRuleId)->group("user_id")->count();
            $participantsCount[$bonusRuleId] = $participants;
            $peopleCount[$bonusRuleId] = $people;
        }
        $this->assign("BonusAmounts", $bonusAmounts);
        $this->assign("Amount", $amount);
        $this->assign("domain", $domain);
        $this->assign("List", $rules);
        $this->assign("ParticipantsCount", $participantsCount);
        $this->assign("peopleCount", $peopleCount);
        $this->assign("Title", "活动列表");
        return $this->fetch("/activitylist");
    }
    public function deletelists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $result = \Think\Db::name("recharge_bonus_rules")->where("id", $id)->delete();
            if ($result !== false) {
                return json(["code" => 200, "msg" => "活动删除成功"]);
            }
            return json(["code" => 500, "msg" => "活动删除失败"]);
        }
    }
    public function records()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $records = \Think\Db::name("recharge_records")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("domain", $domain);
        $this->assign("data", $records);
        $this->assign("Title", "充值记录");
        return $this->fetch("/records");
    }
    public function addhelp()
    {
        if ($this->lang == "chinese") {
            $title = "Demo样式1";
        } else {
            if ($this->lang == "english") {
                $title = "Demo Style 1";
            } else {
                if ($this->lang == "chinese_tw") {
                    $title = "Demo樣式1";
                }
            }
        }
        $this->assign("Title", $title);
        return $this->fetch("/addhelp");
    }
    public function customerdetail1()
    {
        $this->assign("Title", "Demo样式2");
        return $this->fetch("/customerdetail1");
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>