<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>充值活动</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
    }

    .card-container {
      display: flex;
      flex-wrap: wrap;
      justify-content: flex-start;
      align-items: center;
      gap: 20px;
      padding: 20px;
    }
    .card {
      width: 370px;
      height: 310px;
      background-color: #fff;
      box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
      border-radius: 10px;
      padding: 20px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      border: 1px solid #ccc;
    }

    .card-title {
      font-size: 24px;
      font-weight: bold;
      margin-bottom: 10px;
    }

    .card-description {
      font-size: 16px;
      margin-bottom: 20px;
    }
    .card-content {
      font-size: 1rem;
      line-height: 1.5rem;
    }
    .card-button00 {
      width: 100%;
      padding: 10px 20px;
      background-color: #007bff;
      color: #fff;
      border: none;
      border-radius: 5px;
      cursor: pointer;
    }
    .card-status00 {
      position: absolute;
      top: 10px;
      right: 10px;
      padding: 5px 10px;
      background-color: #f8f9fa;
      color: #333;
      border: 1px solid #ccc;
      border-radius: 5px;
      font-size: 12px;
    }

  .card-status {
    position: absolute;
    top: 10px;
    right: 10px;
    padding: 5px 10px;
    border-radius: 5px;
    font-size: 12px;
    color: #fff;
  }

  .status-ongoing {
    background-color: #4caf50;
  }

  .status-ended {
    background-color: #f44336;
  }

  .status-upcoming {
    background-color: #6064ff;
  }
  
  
.card-button-wrapper {
  text-align: center;
}

.card-button-disabled {
  color: #999;
  cursor: not-allowed;
}

.card-button {
  width: 100%;
  padding: 10px 20px;
  background-color: #007bff;
  color: #fff;
  border: none;
  border-radius: 5px;
  cursor: pointer;
}

.card-button-wrapper a {
  background-color: #007bff;
  color: #fff;
  padding: 10px 20px;
  border-radius: 5px;
  text-decoration: none;
}

.card-button-wrapper a:hover {
  background-color: #0069d9;
}




</style>

</head>

<body>
  <div class="card-container">
    <!-- 使用volist循环输出活动列表 -->
    <?php foreach ($data as $activity): ?>
      <div class="card">
      <!--
      <div class="card-status"> <?php $now = time(); if ($activity['start_date'] <= $now && $activity['end_date'] >= $now) { echo '<span class="status-ongoing">进行中</span>'; } elseif ($activity['end_date'] < $now) { echo '<span class="status-ended">已结束</span>'; } else { echo '<span class="status-upcoming">即将开始</span>'; } ?> </div> 
      -->
      
        
        <div class="card-status">
          <?php
          $now = time();
          if ($activity['start_date'] <= $now && $activity['end_date'] >= $now) {
            echo '<span class="status-ongoing text-green-500 font-bold bg-green-100 px-2 py-1 rounded-full mr-2">进行中</span>';
          } elseif ($activity['end_date'] < $now) {
            echo '<span class="status-ended text-red-500 font-bold bg-red-100 px-2 py-1 rounded-full mr-2">已结束</span>';
          } else {
            echo '<span class="status-upcoming text-yellow-500 font-bold bg-yellow-100 px-2 py-1 rounded-full mr-2">即将开始</span>';
          }
          ?>
        </div>

        
        <div class="card-title"><?php echo $activity['activityname']; ?></div>
        <div class="card-content">
          <p>充值金额：<?php echo $activity['min_recharge_amount']; ?>元</p>
          <p>赠送金额： <?php if ($activity['bonus_type'] == 'fixed') { echo $activity['bonus_amount'] . '元'; } else if ($activity['bonus_type'] == 'percent') { echo $activity['bonus_amount'] . '%'; } ?> </p>
          <p>每人限制：<?php echo $activity['max_participation']; ?>次</p>
          <p>开始时间：<?php echo date('Y-m-d H:i:s', $activity['start_date']); ?></p>
          <p>结束时间：<?php echo date('Y-m-d H:i:s', $activity['end_date']); ?></p>
          <!--
          <button class="card-button">立即充值</button>
          -->
          
          <!--
          <div class="card-button-wrapper">
            <?php
            $now = time();
            if ($activity['start_date'] > $now) {
              echo '<span class="card-button-disabled">活动尚未开始</span>';
            } else {
              echo '<a href="/addfunds" class="card-button">立即充值</a>';
            }
            ?>
          </div>
          -->
          
          
          <div class="card-button-wrapper">
          <?php
          $now = time();
          if ($activity['start_date'] > $now) {
            echo '<span class="card-button-disabled">活动尚未开始</span>';
          } elseif ($activity['end_date'] < $now) {
            echo '<span class="card-button-disabled">活动已结束</span>';
          } else {
            echo '<a href="/addfunds" class="card-button">立即充值</a>';
          }
          ?>
          </div>

          
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</body>

</html>
