<?php
namespace addons\renew_cashback;

class RenewCashbackPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "RenewCashback", "title" => "续费返现优惠", "description" => "续费返现适用于魔方财务，可设置指定商品活动时间内进行续费，可获得返现或者立减，支持按百分比返现，固定金额返现或立减类型", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.1", "module" => "addons", "lang" => ["chinese" => "续费返现", "chinese_tw" => "續訂返現", "english" => "Renew Cashback"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "apiid", "type" => "varchar(500)"], ["name" => "apikey", "type" => "varchar(500)"], ["name" => "weburl", "type" => "varchar(500)"], ["name" => "sitename", "type" => "varchar(500)"], ["name" => "authorize", "type" => "varchar(500)"], ["name" => "webmasteremail", "type" => "varchar(500)"], ["name" => "webmasterqq", "type" => "varchar(500)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "user_id", "type" => "VARCHAR(255)"], ["name" => "productid", "type" => "VARCHAR(255)"], ["name" => "hostid", "type" => "VARCHAR(255)"], ["name" => "amount", "type" => "DECIMAL(10, 2)"], ["name" => "type", "type" => "VARCHAR(255)"], ["name" => "bonus_type", "type" => "ENUM('fixed', 'percent')"], ["name" => "bonus", "type" => "VARCHAR(255)"], ["name" => "bonus_amount", "type" => "DECIMAL(10, 2)"], ["name" => "recharge_id", "type" => "VARCHAR(255)"], ["name" => "invoice_num", "type" => "VARCHAR(255)"], ["name" => "start_time", "type" => "VARCHAR(255)"], ["name" => "end_time", "type" => "VARCHAR(255)"], ["name" => "pay_time", "type" => "VARCHAR(255)"]];
        $fieldsToAddTable3 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "open", "type" => "VARCHAR(255)"], ["name" => "name", "type" => "VARCHAR(255)"], ["name" => "productid", "type" => "VARCHAR(255)"], ["name" => "type", "type" => "ENUM('fixed', 'percent')"], ["name" => "number", "type" => "DECIMAL(10, 2)"], ["name" => "start_time", "type" => "VARCHAR(255)"], ["name" => "end_time", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $tableName1 = "shd_renew_cashback_setting";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_renew_cashback_records";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n                    CREATE TABLE " . $tableName2 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n                    );\n                ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                            ALTER TABLE " . $tableName2 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        $tableName3 = "shd_renew_cashback_rules";
        $tableExists3 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName3 . "'");
        if (empty($tableExists3)) {
            $sql3 = "\n                    CREATE TABLE " . $tableName3 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable3)) . "\n                    );\n                ";
            \Think\Db::execute($sql3);
        } else {
            foreach ($fieldsToAddTable3 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName3 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql3 = "\n                            ALTER TABLE " . $tableName3 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql3);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function invoicePaid($params)
    {
        $invoiceid = $params["invoiceid"];
        if (!empty($invoiceid)) {
            $invoicesInfo = \Think\Db::name("invoices")->where("id", $invoiceid)->find();
            $invoicestem = \Think\Db::name("invoice_items")->where("invoice_id", $invoiceid)->find();
            $host = \Think\Db::name("host")->where("id", $invoicestem["rel_id"])->find();
            $products = \Think\Db::name("products")->where("id", $host["productid"])->find();
            $product = \Think\Db::name("renew_cashback_rules")->where("productid", $host["productid"])->find();
            if ($invoicesInfo["type"] === "renew" && $product && $product["start_time"] <= time() && time() <= $product["end_time"]) {
                if ($product["open"] == 1) {
                    $amount = $invoicesInfo["subtotal"];
                    if ($product["type"] === "percent") {
                        $cashback_amount = $amount * $product["number"] / 100;
                        $cashback_amount = number_format($cashback_amount, 2, ".", "");
                    } else {
                        $cashback_amount = $product["number"];
                    }
                    if ($product["type"] === "percent") {
                        $bonus_type_text = "百分比";
                    } else {
                        $bonus_type_text = "固定金额";
                    }
                    if ($product["type"] === "percent") {
                        $bonus_amounts = $cashback_amount . "元";
                    } else {
                        $bonus_amounts = number_format($cashback_amount, 2, ".", "") . "元";
                    }
                    $pay_time = date("Y-m-d H:i:s", time());
                    $user_id = $invoicesInfo["uid"];
                    $clients = \Think\Db::name("clients")->where("id", $user_id)->find();
                    $credit = $clients["credit"];
                    $newcredit = $cashback_amount + $credit;
                    $upnewcredit = \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                    $data = ["uid" => $user_id, "create_time" => time(), "description" => "" . $clients["username"] . "【UID:" . $user_id . "】在【" . $pay_time . "】续费支付" . $amount . "元（商品：" . $products["name"] . "--主机ID：" . $invoicestem["rel_id"] . "），续费账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $product["start_time"]) . "至" . date("Y-m-d H:i:s", $product["end_time"]) . "，按" . $bonus_type_text . "返现" . $bonus_amounts . "", "amount" => $cashback_amount, "balance" => $newcredit];
                    \Think\Db::name("credit")->insert($data);
                    $datainvoices = ["uid" => $user_id, "create_time" => time(), "due_time" => time(), "paid_time" => time(), "update_time" => time(), "subtotal" => $cashback_amount, "total" => $cashback_amount, "payment" => "UserCustom", "status" => "Paid", "type" => "recharge"];
                    \Think\Db::name("invoices")->insert($datainvoices);
                    $insertedId = \Think\Db::name("invoices")->getLastInsID();
                    $datainvoice_items = ["invoice_id" => $insertedId, "uid" => $user_id, "type" => "recharge", "due_time" => time(), "description" => "" . $clients["username"] . "【UID:" . $user_id . "】在【" . $pay_time . "】续费支付" . $amount . "元（商品：" . $products["name"] . "--主机ID：" . $invoicestem["rel_id"] . "），续费账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $product["start_time"]) . "至" . date("Y-m-d H:i:s", $product["end_time"]) . "，按" . $bonus_type_text . "返现" . $bonus_amounts . "", "amount" => $cashback_amount];
                    \Think\Db::name("invoice_items")->insert($datainvoice_items);
                    $activity_log = ["uid" => $user_id, "description" => "【续费返现活动】" . $clients["username"] . "【UID:" . $user_id . "】在【" . $pay_time . "】续费支付" . $amount . "元（商品：" . $products["name"] . "--主机ID：" . $invoicestem["rel_id"] . "），续费账单号：" . $invoiceid . "，活动时间：" . date("Y-m-d H:i:s", $product["start_time"]) . "至" . date("Y-m-d H:i:s", $product["end_time"]) . "，按" . $bonus_type_text . "返现" . $bonus_amounts . "", "user" => "System", "port" => "", "create_time" => time(), "ipaddr" => "0.0.0.0", "type" => 0, "activeid" => 0, "usertype" => "System", "type_data_id" => ""];
                    \Think\Db::name("activity_log")->insert($activity_log);
                    $bonus_data = ["user_id" => $user_id, "productid" => $product["productid"], "hostid" => $invoicestem["rel_id"], "amount" => $amount, "type" => $product["open"], "bonus_type" => $product["type"], "bonus_amount" => $cashback_amount, "bonus" => $product["number"], "recharge_id" => $invoiceid, "invoice_num" => $insertedId, "start_time" => $product["start_time"], "end_time" => $product["end_time"], "pay_time" => $pay_time];
                    \Think\Db::name("renew_cashback_records")->insert($bonus_data);
                } else {
                    if ($product["open"] == 0) {
                        $amount = $invoicesInfo["subtotal"];
                        if ($product["type"] === "percent") {
                            $cashback_amount = $amount / (1 - $product["number"] / 100);
                            $cashback_amount = number_format($cashback_amount, 2, ".", "");
                        } else {
                            $cashback_amount = $amount + $product["number"];
                        }
                        if ($product["type"] === "percent") {
                            $bonus_type_text = "百分比";
                        } else {
                            $bonus_type_text = "固定金额";
                        }
                        if ($product["type"] === "percent") {
                            $bonus_amounts = $cashback_amount . "元";
                        } else {
                            $bonus_amounts = number_format($cashback_amount, 2, ".", "") . "元";
                        }
                        $pay_time = date("Y-m-d H:i:s", time());
                        $bonus_data = ["user_id" => $invoicesInfo["uid"], "productid" => $product["productid"], "hostid" => $invoicestem["rel_id"], "amount" => $cashback_amount, "type" => $product["open"], "bonus_type" => $product["type"], "bonus_amount" => $cashback_amount - $amount, "bonus" => $product["number"], "recharge_id" => $invoiceid, "start_time" => $product["start_time"], "end_time" => $product["end_time"], "pay_time" => $pay_time];
                        \Think\Db::name("renew_cashback_records")->insert($bonus_data);
                    }
                }
            }
        }
    }
    public function logActivity($vars)
    {
        $string = $vars["description"];
        if (strpos($string, "生成续费账单成功") !== false) {
            preg_match("/User ID:(\\d+) - Host ID:(\\d+) - Invoice ID:(\\d+)/", $string, $matches);
            list($user_id, $host_id, $invoiceid) = $matches;
            $invoicesInfo = \Think\Db::name("invoices")->where("id", $invoiceid)->find();
            if ($invoicesInfo["type"] === "renew") {
                $invoicestem = \Think\Db::name("invoice_items")->where("invoice_id", $invoiceid)->find();
                $host = \Think\Db::name("host")->where("id", $invoicestem["rel_id"])->find();
                $products = \Think\Db::name("products")->where("id", $host["productid"])->find();
                $product = \Think\Db::name("renew_cashback_rules")->where("productid", $host["productid"])->find();
                if ($product && $product["start_time"] <= time() && time() <= $product["end_time"] && $product["open"] == 0) {
                    $amount = $invoicesInfo["subtotal"];
                    if ($product["type"] === "percent") {
                        $cashback_amount = $amount * (1 - $product["number"] / 100);
                        $cashback_amount = number_format($cashback_amount, 2, ".", "");
                    } else {
                        $cashback_amount = $amount - $product["number"];
                    }
                    if ($product["type"] === "percent") {
                        $bonus_type_text = "百分比";
                    } else {
                        $bonus_type_text = "固定金额";
                    }
                    if ($product["type"] === "percent") {
                        $bonus_amounts = $cashback_amount . "元";
                    } else {
                        $bonus_amounts = number_format($cashback_amount, 2, ".", "") . "元";
                    }
                    $pay_time = date("Y-m-d H:i:s", time());
                    $invoice_items = \Think\Db::name("invoice_items")->where("invoice_id", $invoiceid)->find();
                    $description = $invoice_items["description"];
                    $newDescription = "【本次续费优惠" . ($amount - $cashback_amount) . "元】";
                    $newDescription = $description . $newDescription;
                    \Think\Db::name("invoice_items")->where("invoice_id", $invoiceid)->where("type", "renew")->update(["description" => $newDescription]);
                    \Think\Db::name("invoices")->where("id", $invoiceid)->update(["subtotal" => $cashback_amount]);
                }
            }
        }
    }
    public function afterCron()
    {
    }
}

?>