<?php
namespace addons\robot_not\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function index()
    {
        $data["ding"] = \think\Db::name("configuration")->where("setting", "robot_ding")->value("value");
        $data["wechat"] = \think\Db::name("configuration")->where("setting", "robot_wechat")->value("value");
        $this->assign("Data", $data);
        $this->assign("Title", "机器人设置");
        return $this->fetch("/index");
    }
    public function submit()
    {
        $data = $_POST;
        foreach ($data as $setting => $value) {
            \think\Db::name("configuration")->where("setting", "robot_" . $setting)->update(["value" => $value]);
        }
        exit(json_encode(["code" => 200, "msg" => "修改成功"]));
    }
}

?>