<?php
namespace addons\robot_not;

class RobotNotPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "RobotNot", "title" => "机器人通知", "description" => "支持钉钉机器人，微信机器人通知", "status" => 1, "author" => "Think", "version" => "1.2", "module" => "addons", "lang" => ["chinese" => "机器人通知", "chinese_tw" => "机器人通知", "english" => "机器人通知"]];
    public function DingCurl($remote_server, $post_string)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $remote_server);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json;charset=utf-8"]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $data = curl_exec($ch);
        curl_close($ch);
        return $data;
    }
    public function install()
    {
        $sql = ["INSERT INTO shd_configuration (setting, value) VALUES ('robot_ding','');", "INSERT INTO shd_configuration (setting, value) VALUES ('robot_wechat','');"];
        foreach ($sql as $v) {
            \think\Db::query($v);
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function clientAdd($params)
    {
        $ding = \think\Db::name("configuration")->where("setting", "robot_ding")->find();
        $wechat = \think\Db::name("configuration")->where("setting", "robot_wechat")->find();
        if ($ding["value"]) {
            $message = "### 新用户注册通知\n- 类型：<font color=\"warning\">新用户注册</font>\n- 会员名：" . $params["username"] . "\n- 注册时间：" . date("Y-m-d H:i:s", time());
            $data = ["msgtype" => "markdown", "markdown" => ["title" => "新用户注册通知", "text" => $message]];
            $data_string = json_encode($data);
            $this->DingCurl($ding["value"], $data_string);
        }
        if ($wechat["value"]) {
            $message = "### 新用户注册通知\n> 类型：<font color=\"warning\">新用户注册</font>\n> 会员名：" . $params["username"] . "\n> 注册时间：" . date("Y-m-d H:i:s", time());
            $data = ["msgtype" => "markdown", "markdown" => ["title" => "新用户注册通知", "content" => $message]];
            $data_string = json_encode($data);
            $this->DingCurl($wechat["value"], $data_string);
        }
    }
    public function ticketOpen($params)
    {
        $ding = \think\Db::name("configuration")->where("setting", "robot_ding")->find();
        $wechat = \think\Db::name("configuration")->where("setting", "robot_wechat")->find();
        if ($ding["value"]) {
            $user = \think\Db::name("clients")->find($params["uid"]);
            $message = "### 新工单创建通知\n- 类型：<font color=\"warning\">创建新工单</font>\n- 会员名：" . $user["username"] . "\n- 工单标题：" . $params["title"] . "\n- 提交部门：" . $params["dptname"] . "\n- 工单内容：" . $params["content"];
            $data = ["msgtype" => "markdown", "markdown" => ["title" => "用户创建新工单", "text" => $message]];
            $data_string = json_encode($data);
            $this->DingCurl($ding["value"], $data_string);
        }
        if ($wechat["value"]) {
            $user = \think\Db::name("clients")->find($params["uid"]);
            $message = "### 新工单创建通知\n> 类型：<font color=\"warning\">创建新工单</font>\n> 会员名：" . $user["username"] . "\n> 工单标题：" . $params["title"] . "\n> 提交部门：" . $params["dptname"] . "\n> 工单内容：" . $params["content"];
            $data = ["msgtype" => "markdown", "markdown" => ["title" => "用户创建新工单", "content" => $message]];
            $data_string = json_encode($data);
            $this->DingCurl($wechat["value"], $data_string);
        }
    }
    public function ticketUserReply($params)
    {
        $ding = \think\Db::name("configuration")->where("setting", "robot_ding")->find();
        $wechat = \think\Db::name("configuration")->where("setting", "robot_wechat")->find();
        if ($ding["value"]) {
            $ding = \think\Db::name("configuration")->where("setting", "robot_ding")->find();
            $wechat = \think\Db::name("configuration")->where("setting", "robot_wechat")->find();
            $user = \think\Db::name("clients")->find($params["uid"]);
            $message = "### 工单回复通知\n- 类型：<font color=\"warning\">客户回复</font>\n- 会员名：" . $user["username"] . "\n- 工单标题：" . $params["title"] . "\n- 工单部门：" . $params["dptname"] . "\n- 回复内容：" . $params["content"];
            $data = ["msgtype" => "markdown", "markdown" => ["title" => "用户回复工单", "text" => $message]];
            $data_string = json_encode($data);
            $this->DingCurl($ding["value"], $data_string);
        }
        if ($wechat["value"]) {
            $ding = \think\Db::name("configuration")->where("setting", "robot_ding")->find();
            $wechat = \think\Db::name("configuration")->where("setting", "robot_wechat")->find();
            $user = \think\Db::name("clients")->find($params["uid"]);
            $message = "### 工单回复通知\n> 类型：<font color=\"warning\">客户回复</font>\n> 会员名：" . $user["username"] . "\n> 工单标题：" . $params["title"] . "\n> 工单部门：" . $params["dptname"] . "\n> 回复内容：" . $params["content"];
            $data = ["msgtype" => "markdown", "markdown" => ["title" => "用户回复工单", "content" => $message]];
            $data_string = json_encode($data);
            $this->DingCurl($wechat["value"], $data_string);
        }
    }
    public function invoicePaidBeforeEmail($params)
    {
        $ding = \think\Db::name("configuration")->where("setting", "robot_ding")->find();
        $wechat = \think\Db::name("configuration")->where("setting", "robot_wechat")->find();
        if ($ding["value"]) {
            $invoice = \think\Db::name("invoices")->find($params["invoiceid"]);
            if ($invoice["type"] == "recharge") {
                $type = "充值";
                $descripiton = "用户充值余额";
            } else {
                if ($invoice["type"] == "renew") {
                    $type = "续费";
                    $info = \think\Db::name("invoice_items")->where("invoice_id", $params["invoiceid"])->where("type", "renew")->find();
                    $descripiton = $info["description"];
                } else {
                    $info = \think\Db::name("invoice_items")->where("invoice_id", $params["invoiceid"])->where("type", "host")->find();
                    $type = "产品";
                    if (empty($info)) {
                        $info = \think\Db::name("invoice_items")->where("invoice_id", $params["invoiceid"])->where("type", "upgrade")->find();
                    } else {
                        $info = \think\Db::name("invoice_items")->where("invoice_id", $params["invoiceid"])->find();
                    }
                    $descripiton = $info["description"];
                }
            }
            if ($invoice["payment"]) {
                $pay_type = \think\Db::name("plugin")->where("name", $invoice["payment"])->value("title");
            } else {
                $pay_type = "余额";
            }
            $user = \think\Db::name("clients")->find($invoice["uid"]);
            $message = "### 用户账单支付成功\n- 类型：<font color=\"warning\">" . $type . "</font>\n- 会员名：" . $user["username"] . "\n- 支付方式：" . $pay_type . "\n- 支付金额：" . $invoice["subtotal"] . "\n- 描述：" . $descripiton . "\n- 支付时间：" . date("Y-m-d H:i:s", $invoice["paid_time"]);
            $data = ["msgtype" => "markdown", "markdown" => ["title" => "用户账单支付成功", "text" => $message]];
            $data_string = json_encode($data);
            $this->DingCurl($ding["value"], $data_string);
        }
        if ($wechat["value"]) {
            $invoice = \think\Db::name("invoices")->find($params["invoiceid"]);
            if ($invoice["type"] == "recharge") {
                $type = "充值";
                $descripiton = "用户充值余额";
            } else {
                if ($invoice["type"] == "renew") {
                    $type = "续费";
                    $info = \think\Db::name("invoice_items")->where("invoice_id", $params["invoiceid"])->where("type", "renew")->find();
                    $descripiton = $info["description"];
                } else {
                    $info = \think\Db::name("invoice_items")->where("invoice_id", $params["invoiceid"])->where("type", "host")->find();
                    $type = "产品";
                    if (empty($info)) {
                        $info = \think\Db::name("invoice_items")->where("invoice_id", $params["invoiceid"])->where("type", "upgrade")->find();
                    } else {
                        $info = \think\Db::name("invoice_items")->where("invoice_id", $params["invoiceid"])->find();
                    }
                    $descripiton = $info["description"];
                }
            }
            if ($invoice["payment"]) {
                $pay_type = \think\Db::name("plugin")->where("name", $invoice["payment"])->value("title");
            } else {
                $pay_type = "余额";
            }
            $user = \think\Db::name("clients")->find($invoice["uid"]);
            $message = "### 用户账单支付成功\n> 类型：<font color=\"warning\">" . $type . "</font>\n> 会员名：" . $user["username"] . "\n> 支付方式：" . $pay_type . "\n> 支付金额：" . $invoice["subtotal"] . "\n> 描述：" . $descripiton . "\n> 支付时间：" . date("Y-m-d H:i:s", $invoice["paid_time"]);
            $data = ["msgtype" => "markdown", "markdown" => ["title" => "用户账单支付成功", "content" => $message]];
            $data_string = json_encode($data);
            $this->DingCurl($wechat["value"], $data_string);
        }
    }
    public function afterModuleCreateFailed($params)
    {
        $ding = \think\Db::name("configuration")->where("setting", "robot_ding")->find();
        $wechat = \think\Db::name("configuration")->where("setting", "robot_wechat")->find();
        $name = \think\Db::name("products")->where("id", $params["params"]["productid"])->value("name");
        if ($ding["value"]) {
            $message = "### 产品开通失败\n- 类型：<font color=\"warning\">产品开通失败</font>\n- 会员名：" . $params["params"]["user_info"]["username"] . "\n- 产品名称：" . $name . "\n- 错误信息：" . $params["msg"] . "\n- 开通时间：" . date("Y-m-d H:i:s", $params["params"]["regdate"]);
            $data = ["msgtype" => "markdown", "markdown" => ["title" => "用户账单支付成功", "text" => $message]];
            $data_string = json_encode($data);
            $this->DingCurl($ding["value"], $data_string);
        }
        if ($wechat["value"]) {
            $message = "### 产品开通失败\n> 类型：<font color=\"warning\">产品开通失败</font>\n> 会员名：" . $params["params"]["user_info"]["username"] . "\n> 产品名称：" . $name . "\n> 错误信息：" . $params["msg"] . "\n> 开通时间：" . date("Y-m-d H:i:s", $params["params"]["regdate"]);
            $data = ["msgtype" => "markdown", "markdown" => ["title" => "用户账单支付成功", "content" => $message]];
            $data_string = json_encode($data);
            $this->DingCurl($wechat["value"], $data_string);
        }
    }
}

?>