<?php
namespace addons\self_refund\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public function index()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $user_id = input("uid");
        $setting = \Think\Db::name("product_refund_setting")->where("id", 1)->find();
        $results = \Think\Db::name("host")->where("uid", $user_id)->where("nextduedate", ">", time() - $setting["displaytime"] * 86400)->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $resultWithNames = [];
        foreach ($results as $record) {
            $productid = $record["productid"];
            $hostid = $record["id"];
            $name = \Think\Db::name("products")->where("id", $productid)->value("name");
            $product = \Think\Db::name("product_refund_list")->where("hostid", $hostid)->order("id", "desc")->find();
            $products = \Think\Db::name("product_refund")->where("productid", $productid)->find();
            $record["name"] = $name;
            $record["created_time"] = $product["created_time"];
            $record["audittime"] = $product["audittime"];
            $record["status"] = $product["status"];
            $record["reason"] = $product["reason"];
            $record["request"] = $products["request"];
            $record["within"] = $products["within"];
            $record["rules"] = $products["rules"];
            $resultWithNames[] = $record;
        }
        $this->assign("data", $resultWithNames);
        $this->assign("fen", $results);
        $this->assign("Title", "产品列表");
        return $this->fetch("/index");
    }
    public function cancellation()
    {
        if (request()->isPost()) {
            $productid = input("post.productid");
            $orderid = input("post.orderid");
            $id = input("post.id");
            $user_id = request()->uid;
            if (empty($user_id)) {
                $response = ["code" => 400, "msg" => "您未登录或登录已失效，请刷新页面"];
                return json($response);
            }
            $result = \Think\Db::name("product_refund_list")->where("hostid", $id)->where("status", 1)->update(["status" => 4, "reason" => date("Y-m-d H:i:s") . " 取消申请"]);
            $list = \Think\Db::name("product_refund_list")->where("hostid", $id)->find();
            $clients = \Think\Db::name("clients")->where("id", $user_id)->find();
            $status = \Think\Db::name("product_refund_list")->where("hostid", $id)->value("status");
            if ($result !== false && 0 < $result) {
                $Switch = \Think\Db::name("product_refund_setting")->where(["id" => 1])->find();
                $sendToDingTalk = $Switch["dingswitch"] == 1;
                $sendToFeishu = $Switch["feishuswitch"] == 1;
                $sendToWeChat = $Switch["wechatswitch"] == 1;
                $tgswitch = $Switch["tgswitch"] == 1;
                $time = date("Y-m-d H:i:s", time());
                $message = "【取消退款申请】通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $list["productname"] . "  \n订单编号：" . $list["orderid"] . "  \n主机编号：" . $id . " \n\n通知时间：" . $time . "  \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                if ($sendToFeishu) {
                    $feishuWebhookUrl = $Switch["feishuurl"];
                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                    $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                }
                if ($sendToDingTalk) {
                    $dingtalkWebhookUrl = $Switch["dingurl"];
                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                }
                if ($sendToWeChat) {
                    $wechatWebhookUrl = $Switch["wechaturl"];
                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                    $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                }
                if ($tgswitch) {
                    $telegramBotToken = $Switch["tgtoken"];
                    $telegramChatId = $Switch["tgchatid"];
                    $telegramMessage = urlencode($message);
                    $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                    $this->sendTelegramNotification($telegramUrl);
                }
                return json(["code" => 200, "msg" => "取消成功"]);
            }
            $statusMsg = "";
            switch ($status) {
                case 2:
                    $statusMsg = "取消失败，原因：已退款成功";
                    break;
                case 3:
                    $statusMsg = "取消失败，原因：申请已驳回";
                    break;
                default:
                    $statusMsg = "取消失败";
                    return json(["code" => 500, "msg" => $statusMsg]);
            }
        }
    }
    public function check()
    {
        if (request()->isPost()) {
            $productid = input("post.productid");
            $orderid = input("post.orderid");
            $reasonrefund = input("post.reason");
            $id = input("post.id");
            $user_id = input("uid");
            $product = \Think\Db::name("product_refund")->where("productid", $productid)->find();
            $productsid = \Think\Db::name("host")->where("id", $id)->find();
            $orderidsid = \Think\Db::name("orders")->where("id", $productsid["orderid"])->find();
            $invoices = \Think\Db::name("invoices")->where("id", $orderidsid["invoiceid"])->find();
            $clients = \Think\Db::name("clients")->where("id", $user_id)->find();
            $resultinvoice = \Think\Db::name("invoice_items")->where(["rel_id" => $id, "type" => "renew"])->find();
            $shengjiangji = \Think\Db::name("invoice_items")->where(["rel_id" => $id, "type" => "upgrade"])->find();
            if (empty($user_id)) {
                $response = ["code" => 400, "msg" => "您未登录或登录已失效，请刷新页面"];
                return json($response);
            }
            $resultlist = \Think\Db::name("product_refund_list")->where("hostid", $id)->find();
            $firstpaymentamount = \Think\Db::name("host")->where("id", $id)->value("firstpaymentamount");
            $amount = \Think\Db::name("host")->where("id", $id)->value("amount");
            $productstype = \Think\Db::name("products")->where("id", $productid)->find();
            if (!$product) {
                $response = ["code" => 400, "msg" => "当前产品不支持退款"];
                return json($response);
            }
            if ($invoices["status"] === "Unpaid") {
                $response = ["code" => 400, "msg" => "当前产品订单未支付状态，不支持申请"];
                return json($response);
            }
            if ($resultlist && $resultlist["status"] != 0 && $resultlist["status"] != 4) {
                $response = ["code" => 400, "msg" => "当前订单已经申请过退款，请勿重复再次申请"];
                return json($response);
            }
            if ($currentTimestamp = $productsid["nextduedate"] < time()) {
                $response = ["code" => 400, "msg" => "当前产品已到期，不支持申请退款"];
                return json($response);
            }
            if ($productsid["domainstatus"] != "Active") {
                $response = ["code" => 400, "msg" => "当前产品主机状态为非已激活状态，不支持申请"];
                return json($response);
            }
            if ($resultinvoice) {
                $response = ["code" => 400, "msg" => "已续费的产品不支持自助申请退款"];
                return json($response);
            }
            if ($firstpaymentamount === "0.00") {
                $response = ["code" => 400, "msg" => "当前订单为免费订单，不支持退款申请"];
                return json($response);
            }
            if ($shengjiangji) {
                $response = ["code" => 400, "msg" => "产品升级或降级过，不支持自助申请退款"];
                return json($response);
            }
            if (!$product) {
                $response = ["code" => 400, "msg" => "当前产品不支持退款"];
                return json($response);
            }
            $type = $product["type"];
            $request = $product["request"];
            $rules = $product["rules"];
            $days = $product["within"] / 24;
            $client_ip = $_SERVER["REMOTE_ADDR"];
            $client_port = $_SERVER["REMOTE_PORT"];
            $Switch = \Think\Db::name("product_refund_setting")->where(["id" => 1])->find();
            $sendToDingTalk = $Switch["dingswitch"] == 1;
            $sendToFeishu = $Switch["feishuswitch"] == 1;
            $sendToWeChat = $Switch["wechatswitch"] == 1;
            $tgswitch = $Switch["tgswitch"] == 1;
            if ($type == 1) {
                if ($request == 1) {
                    if ($rules == 1) {
                        $regdate = $productsid["regdate"];
                        $withinHours = $product["within"];
                        $days = $Switch["day"];
                        $clientsGroup = $clients["groupid"];
                        if ($clientsGroup == 0) {
                            $withinInSeconds = $withinHours * 3600;
                        } else {
                            $withinInSeconds = ($withinHours + $days * 24) * 3600;
                        }
                        $newTimestamp = $regdate + $withinInSeconds;
                        $currentTimestamp = time();
                        if ($newTimestamp < $currentTimestamp) {
                            $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                            return json($response);
                        }
                        $setting = \Think\Db::name("product_refund_setting")->where("id", 1)->find();
                        if ($clientsGroup == "0" || $setting["agent"] != 1) {
                            $resultlist = \Think\Db::name("product_refund_list")->where("user_id", $user_id)->where("productid", $productid)->where("status", "in", [1, 2, 3])->find();
                            if ($resultlist) {
                                $response = ["code" => 400, "msg" => $productstype["name"] . "产品每人仅限首次申请退款，您已申请过"];
                                return json($response);
                            }
                        }
                        $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                        $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                        $usagetime = $currentTimestamp - $productsid["regdate"];
                        $paymentamount = $paymenttime * $usagetime;
                        $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                        if ($refundamount <= 0) {
                            $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                            return json($response);
                        }
                        $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "status" => "1"];
                        \Think\Db::name("product_refund_list")->insert($datalist);
                        $dataupdatetime = ["create_time" => time(), "description" => "【待审核】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，申请时间：" . date("Y-m-d H:i:s", $currentTimestamp) . " ，来源：人工审核产品首次按时长退款", "user" => $clients["username"], "uid" => $user_id, "ipaddr" => $client_ip, "type" => "6", "activeid" => $user_id, "usertype" => "System", "port" => $client_port, "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($dataupdatetime);
                        $producttype = "产品退款";
                        if ($product["type"] == "1") {
                            $producttype = "人工审核";
                        } else {
                            if ($product["type"] == "2") {
                                $producttype = "自动退款";
                            } else {
                                $producttype = "未知类型";
                            }
                        }
                        $productrequest = "退款要求";
                        if ($product["request"] == "1") {
                            $productrequest = "产品首次";
                        } else {
                            if ($product["request"] == "2") {
                                $productrequest = "同类产品首次";
                            } else {
                                if ($product["request"] == "3") {
                                    $productrequest = "指定时间内";
                                } else {
                                    $productrequest = "未知类型";
                                }
                            }
                        }
                        $productrules = "退款规则";
                        if ($product["rules"] == "1") {
                            $productrules = "按时长退";
                        } else {
                            if ($product["rules"] == "2") {
                                $productrules = "按月退";
                            } else {
                                if ($product["rules"] == "3") {
                                    $productrules = "全额退";
                                } else {
                                    $productrules = "未知退款规则";
                                }
                            }
                        }
                        $time = date("Y-m-d H:i:s", time());
                        $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                        if ($sendToFeishu) {
                            $feishuWebhookUrl = $Switch["feishuurl"];
                            $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                            $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                        }
                        if ($sendToDingTalk) {
                            $dingtalkWebhookUrl = $Switch["dingurl"];
                            $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                            $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                        }
                        if ($sendToWeChat) {
                            $wechatWebhookUrl = $Switch["wechaturl"];
                            $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                            $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                        }
                        if ($tgswitch) {
                            $telegramBotToken = $Switch["tgtoken"];
                            $telegramChatId = $Switch["tgchatid"];
                            $telegramMessage = urlencode($message);
                            $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                            $this->sendTelegramNotification($telegramUrl);
                        }
                        $response = ["code" => 200, "msg" => "申请成功，等待审核。"];
                    } else {
                        if ($rules == 2) {
                            $regdate = $productsid["regdate"];
                            $withinHours = $product["within"];
                            $days = $Switch["day"];
                            $clientsGroup = $clients["groupid"];
                            if ($clientsGroup == 0) {
                                $withinInSeconds = $withinHours * 3600;
                            } else {
                                $withinInSeconds = ($withinHours + $days * 24) * 3600;
                            }
                            $newTimestamp = $regdate + $withinInSeconds;
                            $currentTimestamp = time();
                            if ($newTimestamp < $currentTimestamp) {
                                $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                return json($response);
                            }
                            $setting = \Think\Db::name("product_refund_setting")->where("id", 1)->find();
                            if ($clientsGroup == "0" || $setting["agent"] != 1) {
                                $resultlist = \Think\Db::name("product_refund_list")->where("user_id", $user_id)->where("productid", $productid)->where("status", "in", [1, 2, 3])->find();
                                if ($resultlist) {
                                    $response = ["code" => 400, "msg" => $productstype["name"] . "产品每人仅限首次申请退款，您已申请过"];
                                    return json($response);
                                }
                            }
                            $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                            $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                            $usagetime = $currentTimestamp - $productsid["regdate"];
                            $monthpayment = $paymenttime * 2592000;
                            $monthsUsed = ceil($usagetime / 2592000);
                            $paymentamount = $monthpayment * $monthsUsed;
                            $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                            if ($refundamount <= 0) {
                                $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                return json($response);
                            }
                            $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "status" => "1"];
                            \Think\Db::name("product_refund_list")->insert($datalist);
                            $dataupdatetime = ["create_time" => time(), "description" => "【待审核】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，申请时间：" . date("Y-m-d H:i:s", $currentTimestamp) . " ，来源：人工审核产品首次按月退款", "user" => $clients["username"], "uid" => $user_id, "ipaddr" => $client_ip, "type" => "6", "activeid" => $user_id, "usertype" => "System", "port" => $client_port, "type_data_id" => ""];
                            \Think\Db::name("activity_log")->insert($dataupdatetime);
                            $producttype = "产品退款";
                            if ($product["type"] == "1") {
                                $producttype = "人工审核";
                            } else {
                                if ($product["type"] == "2") {
                                    $producttype = "自动退款";
                                } else {
                                    $producttype = "未知类型";
                                }
                            }
                            $productrequest = "退款要求";
                            if ($product["request"] == "1") {
                                $productrequest = "产品首次";
                            } else {
                                if ($product["request"] == "2") {
                                    $productrequest = "同类产品首次";
                                } else {
                                    if ($product["request"] == "3") {
                                        $productrequest = "指定时间内";
                                    } else {
                                        $productrequest = "未知类型";
                                    }
                                }
                            }
                            $productrules = "退款规则";
                            if ($product["rules"] == "1") {
                                $productrules = "按时长退";
                            } else {
                                if ($product["rules"] == "2") {
                                    $productrules = "按月退";
                                } else {
                                    if ($product["rules"] == "3") {
                                        $productrules = "全额退";
                                    } else {
                                        $productrules = "未知退款规则";
                                    }
                                }
                            }
                            $time = date("Y-m-d H:i:s", time());
                            $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                            if ($sendToFeishu) {
                                $feishuWebhookUrl = $Switch["feishuurl"];
                                $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                            }
                            if ($sendToDingTalk) {
                                $dingtalkWebhookUrl = $Switch["dingurl"];
                                $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                            }
                            if ($sendToWeChat) {
                                $wechatWebhookUrl = $Switch["wechaturl"];
                                $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                            }
                            if ($tgswitch) {
                                $telegramBotToken = $Switch["tgtoken"];
                                $telegramChatId = $Switch["tgchatid"];
                                $telegramMessage = urlencode($message);
                                $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                $this->sendTelegramNotification($telegramUrl);
                            }
                            $response = ["code" => 200, "msg" => "申请成功，等待审核。"];
                        } else {
                            if ($rules == 3) {
                                $regdate = $productsid["regdate"];
                                $withinHours = $product["within"];
                                $days = $Switch["day"];
                                $clientsGroup = $clients["groupid"];
                                if ($clientsGroup == 0) {
                                    $withinInSeconds = $withinHours * 3600;
                                } else {
                                    $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                }
                                $newTimestamp = $regdate + $withinInSeconds;
                                $currentTimestamp = time();
                                if ($newTimestamp < $currentTimestamp) {
                                    $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                    return json($response);
                                }
                                $setting = \Think\Db::name("product_refund_setting")->where("id", 1)->find();
                                if ($clientsGroup == "0" || $setting["agent"] != 1) {
                                    $resultlist = \Think\Db::name("product_refund_list")->where("user_id", $user_id)->where("productid", $productid)->where("status", "in", [1, 2, 3])->find();
                                    if ($resultlist) {
                                        $response = ["code" => 400, "msg" => $productstype["name"] . "产品每人仅限首次申请退款，您已申请过"];
                                        return json($response);
                                    }
                                }
                                $refundamount = $productsid["firstpaymentamount"];
                                $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "status" => "1"];
                                \Think\Db::name("product_refund_list")->insert($datalist);
                                $dataupdatetime = ["create_time" => time(), "description" => "【待审核】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，申请时间：" . date("Y-m-d H:i:s", $currentTimestamp) . " ，来源：人工审核产品首次按全额退款", "user" => $clients["username"], "uid" => $user_id, "ipaddr" => $client_ip, "type" => "6", "activeid" => $user_id, "usertype" => "System", "port" => $client_port, "type_data_id" => ""];
                                \Think\Db::name("activity_log")->insert($dataupdatetime);
                                $producttype = "产品退款";
                                if ($product["type"] == "1") {
                                    $producttype = "人工审核";
                                } else {
                                    if ($product["type"] == "2") {
                                        $producttype = "自动退款";
                                    } else {
                                        $producttype = "未知类型";
                                    }
                                }
                                $productrequest = "退款要求";
                                if ($product["request"] == "1") {
                                    $productrequest = "产品首次";
                                } else {
                                    if ($product["request"] == "2") {
                                        $productrequest = "同类产品首次";
                                    } else {
                                        if ($product["request"] == "3") {
                                            $productrequest = "指定时间内";
                                        } else {
                                            $productrequest = "未知类型";
                                        }
                                    }
                                }
                                $productrules = "退款规则";
                                if ($product["rules"] == "1") {
                                    $productrules = "按时长退";
                                } else {
                                    if ($product["rules"] == "2") {
                                        $productrules = "按月退";
                                    } else {
                                        if ($product["rules"] == "3") {
                                            $productrules = "全额退";
                                        } else {
                                            $productrules = "未知退款规则";
                                        }
                                    }
                                }
                                $time = date("Y-m-d H:i:s", time());
                                $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                if ($sendToFeishu) {
                                    $feishuWebhookUrl = $Switch["feishuurl"];
                                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                    $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                }
                                if ($sendToDingTalk) {
                                    $dingtalkWebhookUrl = $Switch["dingurl"];
                                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                }
                                if ($sendToWeChat) {
                                    $wechatWebhookUrl = $Switch["wechaturl"];
                                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                }
                                if ($tgswitch) {
                                    $telegramBotToken = $Switch["tgtoken"];
                                    $telegramChatId = $Switch["tgchatid"];
                                    $telegramMessage = urlencode($message);
                                    $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                    $this->sendTelegramNotification($telegramUrl);
                                }
                                $response = ["code" => 200, "msg" => "申请成功，等待审核。"];
                            } else {
                                $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                            }
                        }
                    }
                } else {
                    if ($request == 2) {
                        if ($rules == 1) {
                            $regdate = $productsid["regdate"];
                            $withinHours = $product["within"];
                            $days = $Switch["day"];
                            $clientsGroup = $clients["groupid"];
                            if ($clientsGroup == 0) {
                                $withinInSeconds = $withinHours * 3600;
                            } else {
                                $withinInSeconds = ($withinHours + $days * 24) * 3600;
                            }
                            $newTimestamp = $regdate + $withinInSeconds;
                            $currentTimestamp = time();
                            if ($newTimestamp < $currentTimestamp) {
                                $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                return json($response);
                            }
                            $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                            $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                            $usagetime = $currentTimestamp - $productsid["regdate"];
                            $paymentamount = $paymenttime * $usagetime;
                            $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                            if ($refundamount <= 0) {
                                $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                return json($response);
                            }
                            $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "status" => "1"];
                            \Think\Db::name("product_refund_list")->insert($datalist);
                            $dataupdatetime = ["create_time" => time(), "description" => "【待审核】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，申请时间：" . date("Y-m-d H:i:s", $currentTimestamp) . " ，来源：人工审核同类产品首次按时长退款", "user" => $clients["username"], "uid" => $user_id, "ipaddr" => $client_ip, "type" => "6", "activeid" => $user_id, "usertype" => "System", "port" => $client_port, "type_data_id" => ""];
                            \Think\Db::name("activity_log")->insert($dataupdatetime);
                            $producttype = "产品退款";
                            if ($product["type"] == "1") {
                                $producttype = "人工审核";
                            } else {
                                if ($product["type"] == "2") {
                                    $producttype = "自动退款";
                                } else {
                                    $producttype = "未知类型";
                                }
                            }
                            $productrequest = "退款要求";
                            if ($product["request"] == "1") {
                                $productrequest = "产品首次";
                            } else {
                                if ($product["request"] == "2") {
                                    $productrequest = "同类产品首次";
                                } else {
                                    if ($product["request"] == "3") {
                                        $productrequest = "指定时间内";
                                    } else {
                                        $productrequest = "未知类型";
                                    }
                                }
                            }
                            $productrules = "退款规则";
                            if ($product["rules"] == "1") {
                                $productrules = "按时长退";
                            } else {
                                if ($product["rules"] == "2") {
                                    $productrules = "按月退";
                                } else {
                                    if ($product["rules"] == "3") {
                                        $productrules = "全额退";
                                    } else {
                                        $productrules = "未知退款规则";
                                    }
                                }
                            }
                            $time = date("Y-m-d H:i:s", time());
                            $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                            if ($sendToFeishu) {
                                $feishuWebhookUrl = $Switch["feishuurl"];
                                $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                            }
                            if ($sendToDingTalk) {
                                $dingtalkWebhookUrl = $Switch["dingurl"];
                                $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                            }
                            if ($sendToWeChat) {
                                $wechatWebhookUrl = $Switch["wechaturl"];
                                $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                            }
                            if ($tgswitch) {
                                $telegramBotToken = $Switch["tgtoken"];
                                $telegramChatId = $Switch["tgchatid"];
                                $telegramMessage = urlencode($message);
                                $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                $this->sendTelegramNotification($telegramUrl);
                            }
                            $response = ["code" => 200, "msg" => "申请成功，等待审核。"];
                        } else {
                            if ($rules == 2) {
                                $regdate = $productsid["regdate"];
                                $withinHours = $product["within"];
                                $days = $Switch["day"];
                                $clientsGroup = $clients["groupid"];
                                if ($clientsGroup == 0) {
                                    $withinInSeconds = $withinHours * 3600;
                                } else {
                                    $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                }
                                $newTimestamp = $regdate + $withinInSeconds;
                                $currentTimestamp = time();
                                if ($newTimestamp < $currentTimestamp) {
                                    $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                    return json($response);
                                }
                                $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                                $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                                $usagetime = $currentTimestamp - $productsid["regdate"];
                                $monthpayment = $paymenttime * 2592000;
                                $monthsUsed = ceil($usagetime / 2592000);
                                $paymentamount = $monthpayment * $monthsUsed;
                                $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                                if ($refundamount <= 0) {
                                    $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                    return json($response);
                                }
                                $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "status" => "1"];
                                \Think\Db::name("product_refund_list")->insert($datalist);
                                $dataupdatetime = ["create_time" => time(), "description" => "【待审核】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，申请时间：" . date("Y-m-d H:i:s", $currentTimestamp) . " ，来源：人工审核同类产品首次按月退款", "user" => $clients["username"], "uid" => $user_id, "ipaddr" => $client_ip, "type" => "6", "activeid" => $user_id, "usertype" => "System", "port" => $client_port, "type_data_id" => ""];
                                \Think\Db::name("activity_log")->insert($dataupdatetime);
                                $producttype = "产品退款";
                                if ($product["type"] == "1") {
                                    $producttype = "人工审核";
                                } else {
                                    if ($product["type"] == "2") {
                                        $producttype = "自动退款";
                                    } else {
                                        $producttype = "未知类型";
                                    }
                                }
                                $productrequest = "退款要求";
                                if ($product["request"] == "1") {
                                    $productrequest = "产品首次";
                                } else {
                                    if ($product["request"] == "2") {
                                        $productrequest = "同类产品首次";
                                    } else {
                                        if ($product["request"] == "3") {
                                            $productrequest = "指定时间内";
                                        } else {
                                            $productrequest = "未知类型";
                                        }
                                    }
                                }
                                $productrules = "退款规则";
                                if ($product["rules"] == "1") {
                                    $productrules = "按时长退";
                                } else {
                                    if ($product["rules"] == "2") {
                                        $productrules = "按月退";
                                    } else {
                                        if ($product["rules"] == "3") {
                                            $productrules = "全额退";
                                        } else {
                                            $productrules = "未知退款规则";
                                        }
                                    }
                                }
                                $time = date("Y-m-d H:i:s", time());
                                $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                if ($sendToFeishu) {
                                    $feishuWebhookUrl = $Switch["feishuurl"];
                                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                    $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                }
                                if ($sendToDingTalk) {
                                    $dingtalkWebhookUrl = $Switch["dingurl"];
                                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                }
                                if ($sendToWeChat) {
                                    $wechatWebhookUrl = $Switch["wechaturl"];
                                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                }
                                if ($tgswitch) {
                                    $telegramBotToken = $Switch["tgtoken"];
                                    $telegramChatId = $Switch["tgchatid"];
                                    $telegramMessage = urlencode($message);
                                    $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                    $this->sendTelegramNotification($telegramUrl);
                                }
                                $response = ["code" => 200, "msg" => "申请成功，等待审核。"];
                            } else {
                                if ($rules == 3) {
                                    $regdate = $productsid["regdate"];
                                    $withinHours = $product["within"];
                                    $days = $Switch["day"];
                                    $clientsGroup = $clients["groupid"];
                                    if ($clientsGroup == 0) {
                                        $withinInSeconds = $withinHours * 3600;
                                    } else {
                                        $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                    }
                                    $newTimestamp = $regdate + $withinInSeconds;
                                    $currentTimestamp = time();
                                    if ($newTimestamp < $currentTimestamp) {
                                        $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                        return json($response);
                                    }
                                    $refundamount = $productsid["firstpaymentamount"];
                                    $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "status" => "1"];
                                    \Think\Db::name("product_refund_list")->insert($datalist);
                                    $dataupdatetime = ["create_time" => time(), "description" => "【待审核】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，申请时间：" . date("Y-m-d H:i:s", $currentTimestamp) . " ，来源：人工审核同类产品首次按全额退款", "user" => $clients["username"], "uid" => $user_id, "ipaddr" => $client_ip, "type" => "6", "activeid" => $user_id, "usertype" => "System", "port" => $client_port, "type_data_id" => ""];
                                    \Think\Db::name("activity_log")->insert($dataupdatetime);
                                    $producttype = "产品退款";
                                    if ($product["type"] == "1") {
                                        $producttype = "人工审核";
                                    } else {
                                        if ($product["type"] == "2") {
                                            $producttype = "自动退款";
                                        } else {
                                            $producttype = "未知类型";
                                        }
                                    }
                                    $productrequest = "退款要求";
                                    if ($product["request"] == "1") {
                                        $productrequest = "产品首次";
                                    } else {
                                        if ($product["request"] == "2") {
                                            $productrequest = "同类产品首次";
                                        } else {
                                            if ($product["request"] == "3") {
                                                $productrequest = "指定时间内";
                                            } else {
                                                $productrequest = "未知类型";
                                            }
                                        }
                                    }
                                    $productrules = "退款规则";
                                    if ($product["rules"] == "1") {
                                        $productrules = "按时长退";
                                    } else {
                                        if ($product["rules"] == "2") {
                                            $productrules = "按月退";
                                        } else {
                                            if ($product["rules"] == "3") {
                                                $productrules = "全额退";
                                            } else {
                                                $productrules = "未知退款规则";
                                            }
                                        }
                                    }
                                    $time = date("Y-m-d H:i:s", time());
                                    $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                    if ($sendToFeishu) {
                                        $feishuWebhookUrl = $Switch["feishuurl"];
                                        $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                        $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                    }
                                    if ($sendToDingTalk) {
                                        $dingtalkWebhookUrl = $Switch["dingurl"];
                                        $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                    }
                                    if ($sendToWeChat) {
                                        $wechatWebhookUrl = $Switch["wechaturl"];
                                        $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                    }
                                    if ($tgswitch) {
                                        $telegramBotToken = $Switch["tgtoken"];
                                        $telegramChatId = $Switch["tgchatid"];
                                        $telegramMessage = urlencode($message);
                                        $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                        $this->sendTelegramNotification($telegramUrl);
                                    }
                                    $response = ["code" => 200, "msg" => "申请成功，等待审核。"];
                                } else {
                                    $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                                }
                            }
                        }
                    } else {
                        if ($request == 3) {
                            if ($rules == 1) {
                                $regdate = $productsid["regdate"];
                                $withinHours = $product["within"];
                                $days = $Switch["day"];
                                $clientsGroup = $clients["groupid"];
                                if ($clientsGroup == 0) {
                                    $withinInSeconds = $withinHours * 3600;
                                } else {
                                    $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                }
                                $newTimestamp = $regdate + $withinInSeconds;
                                $currentTimestamp = time();
                                if ($newTimestamp < $currentTimestamp) {
                                    $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                    return json($response);
                                }
                                $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                                $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                                $usagetime = $currentTimestamp - $productsid["regdate"];
                                $paymentamount = $paymenttime * $usagetime;
                                $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                                if ($refundamount <= 0) {
                                    $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                    return json($response);
                                }
                                $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "status" => "1"];
                                \Think\Db::name("product_refund_list")->insert($datalist);
                                $dataupdatetime = ["create_time" => time(), "description" => "【待审核】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，申请时间：" . date("Y-m-d H:i:s", $currentTimestamp) . " ，来源：人工审核" . $product["within"] . "小时内按时长退款", "user" => $clients["username"], "uid" => $user_id, "ipaddr" => $client_ip, "type" => "6", "activeid" => $user_id, "usertype" => "System", "port" => $client_port, "type_data_id" => ""];
                                \Think\Db::name("activity_log")->insert($dataupdatetime);
                                $producttype = "产品退款";
                                if ($product["type"] == "1") {
                                    $producttype = "人工审核";
                                } else {
                                    if ($product["type"] == "2") {
                                        $producttype = "自动退款";
                                    } else {
                                        $producttype = "未知类型";
                                    }
                                }
                                $productrequest = "退款要求";
                                if ($product["request"] == "1") {
                                    $productrequest = "产品首次";
                                } else {
                                    if ($product["request"] == "2") {
                                        $productrequest = "同类产品首次";
                                    } else {
                                        if ($product["request"] == "3") {
                                            $productrequest = "指定时间内";
                                        } else {
                                            $productrequest = "未知类型";
                                        }
                                    }
                                }
                                $productrules = "退款规则";
                                if ($product["rules"] == "1") {
                                    $productrules = "按时长退";
                                } else {
                                    if ($product["rules"] == "2") {
                                        $productrules = "按月退";
                                    } else {
                                        if ($product["rules"] == "3") {
                                            $productrules = "全额退";
                                        } else {
                                            $productrules = "未知退款规则";
                                        }
                                    }
                                }
                                $time = date("Y-m-d H:i:s", time());
                                $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                if ($sendToFeishu) {
                                    $feishuWebhookUrl = $Switch["feishuurl"];
                                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                    $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                }
                                if ($sendToDingTalk) {
                                    $dingtalkWebhookUrl = $Switch["dingurl"];
                                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                }
                                if ($sendToWeChat) {
                                    $wechatWebhookUrl = $Switch["wechaturl"];
                                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                }
                                if ($tgswitch) {
                                    $telegramBotToken = $Switch["tgtoken"];
                                    $telegramChatId = $Switch["tgchatid"];
                                    $telegramMessage = urlencode($message);
                                    $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                    $this->sendTelegramNotification($telegramUrl);
                                }
                                $response = ["code" => 200, "msg" => "申请成功，等待审核。"];
                            } else {
                                if ($rules == 2) {
                                    $regdate = $productsid["regdate"];
                                    $withinHours = $product["within"];
                                    $days = $Switch["day"];
                                    $clientsGroup = $clients["groupid"];
                                    if ($clientsGroup == 0) {
                                        $withinInSeconds = $withinHours * 3600;
                                    } else {
                                        $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                    }
                                    $newTimestamp = $regdate + $withinInSeconds;
                                    $currentTimestamp = time();
                                    if ($newTimestamp < $currentTimestamp) {
                                        $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                        return json($response);
                                    }
                                    $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                                    $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                                    $usagetime = $currentTimestamp - $productsid["regdate"];
                                    $monthpayment = $paymenttime * 2592000;
                                    $monthsUsed = ceil($usagetime / 2592000);
                                    $paymentamount = $monthpayment * $monthsUsed;
                                    $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                                    if ($refundamount <= 0) {
                                        $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                        return json($response);
                                    }
                                    $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "status" => "1"];
                                    \Think\Db::name("product_refund_list")->insert($datalist);
                                    $dataupdatetime = ["create_time" => time(), "description" => "【待审核】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，申请时间：" . date("Y-m-d H:i:s", $currentTimestamp) . " ，来源：人工审核" . $product["within"] . "小时内按月退款", "user" => $clients["username"], "uid" => $user_id, "ipaddr" => $client_ip, "type" => "6", "activeid" => $user_id, "usertype" => "System", "port" => $client_port, "type_data_id" => ""];
                                    \Think\Db::name("activity_log")->insert($dataupdatetime);
                                    $producttype = "产品退款";
                                    if ($product["type"] == "1") {
                                        $producttype = "人工审核";
                                    } else {
                                        if ($product["type"] == "2") {
                                            $producttype = "自动退款";
                                        } else {
                                            $producttype = "未知类型";
                                        }
                                    }
                                    $productrequest = "退款要求";
                                    if ($product["request"] == "1") {
                                        $productrequest = "产品首次";
                                    } else {
                                        if ($product["request"] == "2") {
                                            $productrequest = "同类产品首次";
                                        } else {
                                            if ($product["request"] == "3") {
                                                $productrequest = "指定时间内";
                                            } else {
                                                $productrequest = "未知类型";
                                            }
                                        }
                                    }
                                    $productrules = "退款规则";
                                    if ($product["rules"] == "1") {
                                        $productrules = "按时长退";
                                    } else {
                                        if ($product["rules"] == "2") {
                                            $productrules = "按月退";
                                        } else {
                                            if ($product["rules"] == "3") {
                                                $productrules = "全额退";
                                            } else {
                                                $productrules = "未知退款规则";
                                            }
                                        }
                                    }
                                    $time = date("Y-m-d H:i:s", time());
                                    $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                    if ($sendToFeishu) {
                                        $feishuWebhookUrl = $Switch["feishuurl"];
                                        $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                        $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                    }
                                    if ($sendToDingTalk) {
                                        $dingtalkWebhookUrl = $Switch["dingurl"];
                                        $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                    }
                                    if ($sendToWeChat) {
                                        $wechatWebhookUrl = $Switch["wechaturl"];
                                        $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                    }
                                    if ($tgswitch) {
                                        $telegramBotToken = $Switch["tgtoken"];
                                        $telegramChatId = $Switch["tgchatid"];
                                        $telegramMessage = urlencode($message);
                                        $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                        $this->sendTelegramNotification($telegramUrl);
                                    }
                                    $response = ["code" => 200, "msg" => "申请成功，等待审核。"];
                                } else {
                                    if ($rules == 3) {
                                        $regdate = $productsid["regdate"];
                                        $withinHours = $product["within"];
                                        $days = $Switch["day"];
                                        $clientsGroup = $clients["groupid"];
                                        if ($clientsGroup == 0) {
                                            $withinInSeconds = $withinHours * 3600;
                                        } else {
                                            $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                        }
                                        $newTimestamp = $regdate + $withinInSeconds;
                                        $currentTimestamp = time();
                                        if ($newTimestamp < $currentTimestamp) {
                                            $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                            return json($response);
                                        }
                                        $refundamount = $productsid["firstpaymentamount"];
                                        $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "status" => "1"];
                                        \Think\Db::name("product_refund_list")->insert($datalist);
                                        $dataupdatetime = ["create_time" => time(), "description" => "【待审核】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，申请时间：" . date("Y-m-d H:i:s", $currentTimestamp) . " ，来源：人工审核" . $product["within"] . "小时内按全额退款", "user" => $clients["username"], "uid" => $user_id, "ipaddr" => $client_ip, "type" => "6", "activeid" => $user_id, "usertype" => "System", "port" => $client_port, "type_data_id" => ""];
                                        \Think\Db::name("activity_log")->insert($dataupdatetime);
                                        $producttype = "产品退款";
                                        if ($product["type"] == "1") {
                                            $producttype = "人工审核";
                                        } else {
                                            if ($product["type"] == "2") {
                                                $producttype = "自动退款";
                                            } else {
                                                $producttype = "未知类型";
                                            }
                                        }
                                        $productrequest = "退款要求";
                                        if ($product["request"] == "1") {
                                            $productrequest = "产品首次";
                                        } else {
                                            if ($product["request"] == "2") {
                                                $productrequest = "同类产品首次";
                                            } else {
                                                if ($product["request"] == "3") {
                                                    $productrequest = "指定时间内";
                                                } else {
                                                    $productrequest = "未知类型";
                                                }
                                            }
                                        }
                                        $productrules = "退款规则";
                                        if ($product["rules"] == "1") {
                                            $productrules = "按时长退";
                                        } else {
                                            if ($product["rules"] == "2") {
                                                $productrules = "按月退";
                                            } else {
                                                if ($product["rules"] == "3") {
                                                    $productrules = "全额退";
                                                } else {
                                                    $productrules = "未知退款规则";
                                                }
                                            }
                                        }
                                        $time = date("Y-m-d H:i:s", time());
                                        $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                        if ($sendToFeishu) {
                                            $feishuWebhookUrl = $Switch["feishuurl"];
                                            $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                            $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                        }
                                        if ($sendToDingTalk) {
                                            $dingtalkWebhookUrl = $Switch["dingurl"];
                                            $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                            $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                        }
                                        if ($sendToWeChat) {
                                            $wechatWebhookUrl = $Switch["wechaturl"];
                                            $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                            $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                        }
                                        if ($tgswitch) {
                                            $telegramBotToken = $Switch["tgtoken"];
                                            $telegramChatId = $Switch["tgchatid"];
                                            $telegramMessage = urlencode($message);
                                            $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                            $this->sendTelegramNotification($telegramUrl);
                                        }
                                        $response = ["code" => 200, "msg" => "申请成功，等待审核。"];
                                    } else {
                                        $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                                    }
                                }
                            }
                        } else {
                            $response = ["code" => 400, "msg" => "不支持的请求类型。"];
                        }
                    }
                }
            } else {
                if ($type == 2) {
                    if ($request == 1) {
                        if ($rules == 1) {
                            $currentTimestamp = time();
                            $regdate = $productsid["regdate"];
                            $withinHours = $product["within"];
                            $days = $Switch["day"];
                            $clientsGroup = $clients["groupid"];
                            if ($clientsGroup == 0) {
                                $withinInSeconds = $withinHours * 3600;
                            } else {
                                $withinInSeconds = ($withinHours + $days * 24) * 3600;
                            }
                            $newTimestamp = $regdate + $withinInSeconds;
                            $currentTimestamp = time();
                            if ($newTimestamp < $currentTimestamp) {
                                $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                return json($response);
                            }
                            $setting = \Think\Db::name("product_refund_setting")->where("id", 1)->find();
                            if ($clientsGroup == "0" || $setting["agent"] != 1) {
                                $resultlist = \Think\Db::name("product_refund_list")->where("user_id", $user_id)->where("productid", $productid)->where("status", "in", [1, 2, 3])->find();
                                if ($resultlist) {
                                    $response = ["code" => 400, "msg" => $productstype["name"] . "产品每人仅限首次申请退款，您已申请过"];
                                    return json($response);
                                }
                            }
                            $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                            $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                            $usagetime = $currentTimestamp - $productsid["regdate"];
                            $paymentamount = $paymenttime * $usagetime;
                            $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                            $newcredit = $clients["credit"] + $refundamount;
                            if ($refundamount <= 0) {
                                $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                return json($response);
                            }
                            $hours = floor($usagetime / 3600);
                            $minutes = floor($usagetime % 3600 / 60);
                            $seconds = $usagetime % 60;
                            $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                            $dataaccounts = ["uid" => $user_id, "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $id . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【产品首次自动按时长退款】订单号：" . $orderid . ", 主机ID：" . $id . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $orderidsid["invoiceid"]];
                            \Think\Db::name("accounts")->insert($dataaccounts);
                            $datacredit = ["uid" => $user_id, "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $orderidsid["invoiceid"], "amount" => $refundamount, "notes" => "订单号：" . $orderidsid["invoiceid"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，产品首次自动按时长退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                            \Think\Db::name("credit")->insert($datacredit);
                            \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                            $datainvoices = ["status" => "Refunded"];
                            \Think\Db::name("invoices")->where("id", $orderidsid["invoiceid"])->update($datainvoices);
                            $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $user_id . " - Invoice ID:" . $orderidsid["invoiceid"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，来源：产品首次自动按时长退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => $orderidsid["invoiceid"]];
                            \Think\Db::name("activity_log")->insert($dataactivity_log);
                            $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "audittime" => time(), "adminid" => "System", "reviewed" => "System", "status" => "2", "reason" => "自动审核通过"];
                            \Think\Db::name("product_refund_list")->insert($datalist);
                            $updatetime = time();
                            \Think\Db::name("host")->where("id", $id)->update(["nextduedate" => $updatetime]);
                            $dataupdatetime = ["create_time" => time(), "description" => "【自动退】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：产品首次自动按时长退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => ""];
                            \Think\Db::name("activity_log")->insert($dataupdatetime);
                            $producttype = "产品退款";
                            if ($product["type"] == "1") {
                                $producttype = "人工审核";
                            } else {
                                if ($product["type"] == "2") {
                                    $producttype = "自动退款";
                                } else {
                                    $producttype = "未知类型";
                                }
                            }
                            $productrequest = "退款要求";
                            if ($product["request"] == "1") {
                                $productrequest = "产品首次";
                            } else {
                                if ($product["request"] == "2") {
                                    $productrequest = "同类产品首次";
                                } else {
                                    if ($product["request"] == "3") {
                                        $productrequest = "指定时间内";
                                    } else {
                                        $productrequest = "未知类型";
                                    }
                                }
                            }
                            $productrules = "退款规则";
                            if ($product["rules"] == "1") {
                                $productrules = "按时长退";
                            } else {
                                if ($product["rules"] == "2") {
                                    $productrules = "按月退";
                                } else {
                                    if ($product["rules"] == "3") {
                                        $productrules = "全额退";
                                    } else {
                                        $productrules = "未知退款规则";
                                    }
                                }
                            }
                            $time = date("Y-m-d H:i:s", time());
                            $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                            if ($sendToFeishu) {
                                $feishuWebhookUrl = $Switch["feishuurl"];
                                $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                            }
                            if ($sendToDingTalk) {
                                $dingtalkWebhookUrl = $Switch["dingurl"];
                                $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                            }
                            if ($sendToWeChat) {
                                $wechatWebhookUrl = $Switch["wechaturl"];
                                $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                            }
                            if ($tgswitch) {
                                $telegramBotToken = $Switch["tgtoken"];
                                $telegramChatId = $Switch["tgchatid"];
                                $telegramMessage = urlencode($message);
                                $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                $this->sendTelegramNotification($telegramUrl);
                            }
                            $originalData = \Think\Db::name("host")->where("id", $id)->find();
                            $newNotes = "自动按天退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                            $originalNotes = $originalData["notes"] ?? "";
                            $updatedNotes = $originalNotes . "\n" . $newNotes;
                            $datahost = ["notes" => $updatedNotes];
                            \Think\Db::name("host")->where("id", $id)->update($datahost);
                            $response = ["code" => 200, "msg" => "申请成功，系统审核中。"];
                        } else {
                            if ($rules == 2) {
                                $regdate = $productsid["regdate"];
                                $withinHours = $product["within"];
                                $days = $Switch["day"];
                                $clientsGroup = $clients["groupid"];
                                if ($clientsGroup == 0) {
                                    $withinInSeconds = $withinHours * 3600;
                                } else {
                                    $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                }
                                $newTimestamp = $regdate + $withinInSeconds;
                                $currentTimestamp = time();
                                if ($newTimestamp < $currentTimestamp) {
                                    $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                    return json($response);
                                }
                                $setting = \Think\Db::name("product_refund_setting")->where("id", 1)->find();
                                if ($clientsGroup == "0" || $setting["agent"] != 1) {
                                    $resultlist = \Think\Db::name("product_refund_list")->where("user_id", $user_id)->where("productid", $productid)->where("status", "in", [1, 2, 3])->find();
                                    if ($resultlist) {
                                        $response = ["code" => 400, "msg" => $productstype["name"] . "产品每人仅限首次申请退款，您已申请过"];
                                        return json($response);
                                    }
                                }
                                $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                                $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                                $usagetime = $currentTimestamp - $productsid["regdate"];
                                $monthpayment = $paymenttime * 2592000;
                                $monthsUsed = ceil($usagetime / 2592000);
                                $paymentamount = $monthpayment * $monthsUsed;
                                $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                                $newcredit = $clients["credit"] + $refundamount;
                                if ($refundamount <= 0) {
                                    $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                    return json($response);
                                }
                                $hours = floor($usagetime / 3600);
                                $minutes = floor($usagetime % 3600 / 60);
                                $seconds = $usagetime % 60;
                                $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                                $dataaccounts = ["uid" => $user_id, "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $id . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【产品首次自动按月退款】订单号：" . $orderid . ", 主机ID：" . $id . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $orderidsid["invoiceid"]];
                                \Think\Db::name("accounts")->insert($dataaccounts);
                                $datacredit = ["uid" => $user_id, "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $orderidsid["invoiceid"], "amount" => $refundamount, "notes" => "订单号：" . $orderidsid["invoiceid"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，产品首次自动按月退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                                \Think\Db::name("credit")->insert($datacredit);
                                \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                                $datainvoices = ["status" => "Refunded"];
                                \Think\Db::name("invoices")->where("id", $orderidsid["invoiceid"])->update($datainvoices);
                                $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $user_id . " - Invoice ID:" . $orderidsid["invoiceid"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，来源：产品首次自动按月退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => $orderidsid["invoiceid"]];
                                \Think\Db::name("activity_log")->insert($dataactivity_log);
                                $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "audittime" => time(), "adminid" => "System", "reviewed" => "System", "status" => "2", "reason" => "自动审核通过"];
                                \Think\Db::name("product_refund_list")->insert($datalist);
                                $updatetime = time();
                                \Think\Db::name("host")->where("id", $id)->update(["nextduedate" => $updatetime]);
                                $dataupdatetime = ["create_time" => time(), "description" => "【自动退】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：产品首次自动按月退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => ""];
                                \Think\Db::name("activity_log")->insert($dataupdatetime);
                                $producttype = "产品退款";
                                if ($product["type"] == "1") {
                                    $producttype = "人工审核";
                                } else {
                                    if ($product["type"] == "2") {
                                        $producttype = "自动退款";
                                    } else {
                                        $producttype = "未知类型";
                                    }
                                }
                                $productrequest = "退款要求";
                                if ($product["request"] == "1") {
                                    $productrequest = "产品首次";
                                } else {
                                    if ($product["request"] == "2") {
                                        $productrequest = "同类产品首次";
                                    } else {
                                        if ($product["request"] == "3") {
                                            $productrequest = "指定时间内";
                                        } else {
                                            $productrequest = "未知类型";
                                        }
                                    }
                                }
                                $productrules = "退款规则";
                                if ($product["rules"] == "1") {
                                    $productrules = "按时长退";
                                } else {
                                    if ($product["rules"] == "2") {
                                        $productrules = "按月退";
                                    } else {
                                        if ($product["rules"] == "3") {
                                            $productrules = "全额退";
                                        } else {
                                            $productrules = "未知退款规则";
                                        }
                                    }
                                }
                                $time = date("Y-m-d H:i:s", time());
                                $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                if ($sendToFeishu) {
                                    $feishuWebhookUrl = $Switch["feishuurl"];
                                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                    $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                }
                                if ($sendToDingTalk) {
                                    $dingtalkWebhookUrl = $Switch["dingurl"];
                                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                }
                                if ($sendToWeChat) {
                                    $wechatWebhookUrl = $Switch["wechaturl"];
                                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                }
                                if ($tgswitch) {
                                    $telegramBotToken = $Switch["tgtoken"];
                                    $telegramChatId = $Switch["tgchatid"];
                                    $telegramMessage = urlencode($message);
                                    $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                    $this->sendTelegramNotification($telegramUrl);
                                }
                                $originalData = \Think\Db::name("host")->where("id", $id)->find();
                                $newNotes = "自动月退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                                $originalNotes = $originalData["notes"] ?? "";
                                $updatedNotes = $originalNotes . "\n" . $newNotes;
                                $datahost = ["notes" => $updatedNotes];
                                \Think\Db::name("host")->where("id", $id)->update($datahost);
                                $response = ["code" => 200, "msg" => "申请成功，系统审核中。"];
                            } else {
                                if ($rules == 3) {
                                    $regdate = $productsid["regdate"];
                                    $withinHours = $product["within"];
                                    $days = $Switch["day"];
                                    $clientsGroup = $clients["groupid"];
                                    if ($clientsGroup == 0) {
                                        $withinInSeconds = $withinHours * 3600;
                                    } else {
                                        $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                    }
                                    $newTimestamp = $regdate + $withinInSeconds;
                                    $currentTimestamp = time();
                                    if ($newTimestamp < $currentTimestamp) {
                                        $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                        return json($response);
                                    }
                                    $setting = \Think\Db::name("product_refund_setting")->where("id", 1)->find();
                                    if ($clientsGroup == "0" || $setting["agent"] != 1) {
                                        $resultlist = \Think\Db::name("product_refund_list")->where("user_id", $user_id)->where("productid", $productid)->where("status", "in", [1, 2, 3])->find();
                                        if ($resultlist) {
                                            $response = ["code" => 400, "msg" => $productstype["name"] . "产品每人仅限首次申请退款，您已申请过"];
                                            return json($response);
                                        }
                                    }
                                    $refundamount = $productsid["firstpaymentamount"];
                                    $newcredit = $clients["credit"] + $refundamount;
                                    $usagetime = $currentTimestamp - $productsid["regdate"];
                                    $hours = floor($usagetime / 3600);
                                    $minutes = floor($usagetime % 3600 / 60);
                                    $seconds = $usagetime % 60;
                                    $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                                    $dataaccounts = ["uid" => $user_id, "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $id . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【产品首次自动按全额退款】订单号：" . $orderid . ", 主机ID：" . $id . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $orderidsid["invoiceid"]];
                                    \Think\Db::name("accounts")->insert($dataaccounts);
                                    $datacredit = ["uid" => $user_id, "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $orderidsid["invoiceid"], "amount" => $refundamount, "notes" => "订单号：" . $orderidsid["invoiceid"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，产品首次自动按全额退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                                    \Think\Db::name("credit")->insert($datacredit);
                                    \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                                    $datainvoices = ["status" => "Refunded"];
                                    \Think\Db::name("invoices")->where("id", $orderidsid["invoiceid"])->update($datainvoices);
                                    $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $user_id . " - Invoice ID:" . $orderidsid["invoiceid"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，来源：产品首次自动按全额退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => $orderidsid["invoiceid"]];
                                    \Think\Db::name("activity_log")->insert($dataactivity_log);
                                    $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "audittime" => time(), "adminid" => "System", "reviewed" => "System", "status" => "2", "reason" => "自动审核通过"];
                                    \Think\Db::name("product_refund_list")->insert($datalist);
                                    $updatetime = time();
                                    \Think\Db::name("host")->where("id", $id)->update(["nextduedate" => $updatetime]);
                                    $dataupdatetime = ["create_time" => time(), "description" => "【自动退】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：产品首次自动按全额退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => ""];
                                    \Think\Db::name("activity_log")->insert($dataupdatetime);
                                    $producttype = "产品退款";
                                    if ($product["type"] == "1") {
                                        $producttype = "人工审核";
                                    } else {
                                        if ($product["type"] == "2") {
                                            $producttype = "自动退款";
                                        } else {
                                            $producttype = "未知类型";
                                        }
                                    }
                                    $productrequest = "退款要求";
                                    if ($product["request"] == "1") {
                                        $productrequest = "产品首次";
                                    } else {
                                        if ($product["request"] == "2") {
                                            $productrequest = "同类产品首次";
                                        } else {
                                            if ($product["request"] == "3") {
                                                $productrequest = "指定时间内";
                                            } else {
                                                $productrequest = "未知类型";
                                            }
                                        }
                                    }
                                    $productrules = "退款规则";
                                    if ($product["rules"] == "1") {
                                        $productrules = "按时长退";
                                    } else {
                                        if ($product["rules"] == "2") {
                                            $productrules = "按月退";
                                        } else {
                                            if ($product["rules"] == "3") {
                                                $productrules = "全额退";
                                            } else {
                                                $productrules = "未知退款规则";
                                            }
                                        }
                                    }
                                    $time = date("Y-m-d H:i:s", time());
                                    $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                    if ($sendToFeishu) {
                                        $feishuWebhookUrl = $Switch["feishuurl"];
                                        $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                        $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                    }
                                    if ($sendToDingTalk) {
                                        $dingtalkWebhookUrl = $Switch["dingurl"];
                                        $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                    }
                                    if ($sendToWeChat) {
                                        $wechatWebhookUrl = $Switch["wechaturl"];
                                        $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                    }
                                    if ($tgswitch) {
                                        $telegramBotToken = $Switch["tgtoken"];
                                        $telegramChatId = $Switch["tgchatid"];
                                        $telegramMessage = urlencode($message);
                                        $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                        $this->sendTelegramNotification($telegramUrl);
                                    }
                                    $originalData = \Think\Db::name("host")->where("id", $id)->find();
                                    $newNotes = "自动全额退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                                    $originalNotes = $originalData["notes"] ?? "";
                                    $updatedNotes = $originalNotes . "\n" . $newNotes;
                                    $datahost = ["notes" => $updatedNotes];
                                    \Think\Db::name("host")->where("id", $id)->update($datahost);
                                    $response = ["code" => 200, "msg" => "申请成功，系统审核中。"];
                                } else {
                                    $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                                }
                            }
                        }
                    } else {
                        if ($request == 2) {
                            if ($rules == 1) {
                                $regdate = $productsid["regdate"];
                                $withinHours = $product["within"];
                                $days = $Switch["day"];
                                $clientsGroup = $clients["groupid"];
                                if ($clientsGroup == 0) {
                                    $withinInSeconds = $withinHours * 3600;
                                } else {
                                    $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                }
                                $newTimestamp = $regdate + $withinInSeconds;
                                $currentTimestamp = time();
                                if ($newTimestamp < $currentTimestamp) {
                                    $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                    return json($response);
                                }
                                $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                                $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                                $usagetime = $currentTimestamp - $productsid["regdate"];
                                $paymentamount = $paymenttime * $usagetime;
                                $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                                $newcredit = $clients["credit"] + $refundamount;
                                if ($refundamount <= 0) {
                                    $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                    return json($response);
                                }
                                $hours = floor($usagetime / 3600);
                                $minutes = floor($usagetime % 3600 / 60);
                                $seconds = $usagetime % 60;
                                $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                                $dataaccounts = ["uid" => $user_id, "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $id . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【同类产品首次自动按时长退款】订单号：" . $orderid . ", 主机ID：" . $id . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $orderidsid["invoiceid"]];
                                \Think\Db::name("accounts")->insert($dataaccounts);
                                $datacredit = ["uid" => $user_id, "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $orderidsid["invoiceid"], "amount" => $refundamount, "notes" => "订单号：" . $orderidsid["invoiceid"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，同类产品首次自动按时长退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                                \Think\Db::name("credit")->insert($datacredit);
                                \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                                $datainvoices = ["status" => "Refunded"];
                                \Think\Db::name("invoices")->where("id", $orderidsid["invoiceid"])->update($datainvoices);
                                $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $user_id . " - Invoice ID:" . $orderidsid["invoiceid"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，来源：同类产品首次自动按时长退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => $orderidsid["invoiceid"]];
                                \Think\Db::name("activity_log")->insert($dataactivity_log);
                                $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "audittime" => time(), "adminid" => "System", "reviewed" => "System", "status" => "2", "reason" => "自动审核通过"];
                                \Think\Db::name("product_refund_list")->insert($datalist);
                                $updatetime = time();
                                \Think\Db::name("host")->where("id", $id)->update(["nextduedate" => $updatetime]);
                                $dataupdatetime = ["create_time" => time(), "description" => "【自动退】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：同类产品首次自动按时长退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => ""];
                                \Think\Db::name("activity_log")->insert($dataupdatetime);
                                $producttype = "产品退款";
                                if ($product["type"] == "1") {
                                    $producttype = "人工审核";
                                } else {
                                    if ($product["type"] == "2") {
                                        $producttype = "自动退款";
                                    } else {
                                        $producttype = "未知类型";
                                    }
                                }
                                $productrequest = "退款要求";
                                if ($product["request"] == "1") {
                                    $productrequest = "产品首次";
                                } else {
                                    if ($product["request"] == "2") {
                                        $productrequest = "同类产品首次";
                                    } else {
                                        if ($product["request"] == "3") {
                                            $productrequest = "指定时间内";
                                        } else {
                                            $productrequest = "未知类型";
                                        }
                                    }
                                }
                                $productrules = "退款规则";
                                if ($product["rules"] == "1") {
                                    $productrules = "按时长退";
                                } else {
                                    if ($product["rules"] == "2") {
                                        $productrules = "按月退";
                                    } else {
                                        if ($product["rules"] == "3") {
                                            $productrules = "全额退";
                                        } else {
                                            $productrules = "未知退款规则";
                                        }
                                    }
                                }
                                $time = date("Y-m-d H:i:s", time());
                                $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                if ($sendToFeishu) {
                                    $feishuWebhookUrl = $Switch["feishuurl"];
                                    $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                    $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                }
                                if ($sendToDingTalk) {
                                    $dingtalkWebhookUrl = $Switch["dingurl"];
                                    $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                }
                                if ($sendToWeChat) {
                                    $wechatWebhookUrl = $Switch["wechaturl"];
                                    $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                    $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                }
                                if ($tgswitch) {
                                    $telegramBotToken = $Switch["tgtoken"];
                                    $telegramChatId = $Switch["tgchatid"];
                                    $telegramMessage = urlencode($message);
                                    $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                    $this->sendTelegramNotification($telegramUrl);
                                }
                                $originalData = \Think\Db::name("host")->where("id", $id)->find();
                                $newNotes = "自动按时长退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                                $originalNotes = $originalData["notes"] ?? "";
                                $updatedNotes = $originalNotes . "\n" . $newNotes;
                                $datahost = ["notes" => $updatedNotes];
                                \Think\Db::name("host")->where("id", $id)->update($datahost);
                                $response = ["code" => 200, "msg" => "申请成功，系统审核中。"];
                            } else {
                                if ($rules == 2) {
                                    $regdate = $productsid["regdate"];
                                    $withinHours = $product["within"];
                                    $days = $Switch["day"];
                                    $clientsGroup = $clients["groupid"];
                                    if ($clientsGroup == 0) {
                                        $withinInSeconds = $withinHours * 3600;
                                    } else {
                                        $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                    }
                                    $newTimestamp = $regdate + $withinInSeconds;
                                    $currentTimestamp = time();
                                    if ($newTimestamp < $currentTimestamp) {
                                        $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                        return json($response);
                                    }
                                    $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                                    $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                                    $usagetime = $currentTimestamp - $productsid["regdate"];
                                    $monthpayment = $paymenttime * 2592000;
                                    $monthsUsed = ceil($usagetime / 2592000);
                                    $paymentamount = $monthpayment * $monthsUsed;
                                    $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                                    $newcredit = $clients["credit"] + $refundamount;
                                    if ($refundamount <= 0) {
                                        $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                        return json($response);
                                    }
                                    $hours = floor($usagetime / 3600);
                                    $minutes = floor($usagetime % 3600 / 60);
                                    $seconds = $usagetime % 60;
                                    $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                                    $dataaccounts = ["uid" => $user_id, "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $id . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【同类产品首次自动按月退款】订单号：" . $orderid . ", 主机ID：" . $id . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $orderidsid["invoiceid"]];
                                    \Think\Db::name("accounts")->insert($dataaccounts);
                                    $datacredit = ["uid" => $user_id, "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $orderidsid["invoiceid"], "amount" => $refundamount, "notes" => "订单号：" . $orderidsid["invoiceid"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，同类产品首次自动按月退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                                    \Think\Db::name("credit")->insert($datacredit);
                                    \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                                    $datainvoices = ["status" => "Refunded"];
                                    \Think\Db::name("invoices")->where("id", $orderidsid["invoiceid"])->update($datainvoices);
                                    $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $user_id . " - Invoice ID:" . $orderidsid["invoiceid"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，来源：同类产品首次自动按月退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => $orderidsid["invoiceid"]];
                                    \Think\Db::name("activity_log")->insert($dataactivity_log);
                                    $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "audittime" => time(), "adminid" => "System", "reviewed" => "System", "status" => "2", "reason" => "自动审核通过"];
                                    \Think\Db::name("product_refund_list")->insert($datalist);
                                    $updatetime = time();
                                    \Think\Db::name("host")->where("id", $id)->update(["nextduedate" => $updatetime]);
                                    $dataupdatetime = ["create_time" => time(), "description" => "【自动退】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：同类产品首次自动按月退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => ""];
                                    \Think\Db::name("activity_log")->insert($dataupdatetime);
                                    $producttype = "产品退款";
                                    if ($product["type"] == "1") {
                                        $producttype = "人工审核";
                                    } else {
                                        if ($product["type"] == "2") {
                                            $producttype = "自动退款";
                                        } else {
                                            $producttype = "未知类型";
                                        }
                                    }
                                    $productrequest = "退款要求";
                                    if ($product["request"] == "1") {
                                        $productrequest = "产品首次";
                                    } else {
                                        if ($product["request"] == "2") {
                                            $productrequest = "同类产品首次";
                                        } else {
                                            if ($product["request"] == "3") {
                                                $productrequest = "指定时间内";
                                            } else {
                                                $productrequest = "未知类型";
                                            }
                                        }
                                    }
                                    $productrules = "退款规则";
                                    if ($product["rules"] == "1") {
                                        $productrules = "按时长退";
                                    } else {
                                        if ($product["rules"] == "2") {
                                            $productrules = "按月退";
                                        } else {
                                            if ($product["rules"] == "3") {
                                                $productrules = "全额退";
                                            } else {
                                                $productrules = "未知退款规则";
                                            }
                                        }
                                    }
                                    $time = date("Y-m-d H:i:s", time());
                                    $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                    if ($sendToFeishu) {
                                        $feishuWebhookUrl = $Switch["feishuurl"];
                                        $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                        $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                    }
                                    if ($sendToDingTalk) {
                                        $dingtalkWebhookUrl = $Switch["dingurl"];
                                        $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                    }
                                    if ($sendToWeChat) {
                                        $wechatWebhookUrl = $Switch["wechaturl"];
                                        $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                    }
                                    if ($tgswitch) {
                                        $telegramBotToken = $Switch["tgtoken"];
                                        $telegramChatId = $Switch["tgchatid"];
                                        $telegramMessage = urlencode($message);
                                        $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                        $this->sendTelegramNotification($telegramUrl);
                                    }
                                    $originalData = \Think\Db::name("host")->where("id", $id)->find();
                                    $newNotes = "自动安月退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                                    $originalNotes = $originalData["notes"] ?? "";
                                    $updatedNotes = $originalNotes . "\n" . $newNotes;
                                    $datahost = ["notes" => $updatedNotes];
                                    \Think\Db::name("host")->where("id", $id)->update($datahost);
                                    $response = ["code" => 200, "msg" => "申请成功，系统审核中。"];
                                } else {
                                    if ($rules == 3) {
                                        $regdate = $productsid["regdate"];
                                        $withinHours = $product["within"];
                                        $days = $Switch["day"];
                                        $clientsGroup = $clients["groupid"];
                                        if ($clientsGroup == 0) {
                                            $withinInSeconds = $withinHours * 3600;
                                        } else {
                                            $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                        }
                                        $newTimestamp = $regdate + $withinInSeconds;
                                        $currentTimestamp = time();
                                        if ($newTimestamp < $currentTimestamp) {
                                            $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                            return json($response);
                                        }
                                        $refundamount = $productsid["firstpaymentamount"];
                                        $newcredit = $clients["credit"] + $refundamount;
                                        $usagetime = $currentTimestamp - $productsid["regdate"];
                                        $hours = floor($usagetime / 3600);
                                        $minutes = floor($usagetime % 3600 / 60);
                                        $seconds = $usagetime % 60;
                                        $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                                        $dataaccounts = ["uid" => $user_id, "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $id . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【同类产品首次自动按全额退款】订单号：" . $orderid . ", 主机ID：" . $id . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $orderidsid["invoiceid"]];
                                        \Think\Db::name("accounts")->insert($dataaccounts);
                                        $datacredit = ["uid" => $user_id, "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $orderidsid["invoiceid"], "amount" => $refundamount, "notes" => "订单号："  . $orderidsid["invoiceid"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，同类产品首次自动按全额退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                                        \Think\Db::name("credit")->insert($datacredit);
                                        \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                                        $datainvoices = ["status" => "Refunded"];
                                        \Think\Db::name("invoices")->where("id", $orderidsid["invoiceid"])->update($datainvoices);
                                        $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $user_id . " - Invoice ID:" . $orderidsid["invoiceid"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，来源：同类产品首次自动按全额退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => $orderidsid["invoiceid"]];
                                        \Think\Db::name("activity_log")->insert($dataactivity_log);
                                        $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "audittime" => time(), "adminid" => "System", "reviewed" => "System", "status" => "2", "reason" => "自动审核通过"];
                                        \Think\Db::name("product_refund_list")->insert($datalist);
                                        $updatetime = time();
                                        \Think\Db::name("host")->where("id", $id)->update(["nextduedate" => $updatetime]);
                                        $dataupdatetime = ["create_time" => time(), "description" => "【自动退】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：同类产品首次自动按全额退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => ""];
                                        \Think\Db::name("activity_log")->insert($dataupdatetime);
                                        $producttype = "产品退款";
                                        if ($product["type"] == "1") {
                                            $producttype = "人工审核";
                                        } else {
                                            if ($product["type"] == "2") {
                                                $producttype = "自动退款";
                                            } else {
                                                $producttype = "未知类型";
                                            }
                                        }
                                        $productrequest = "退款要求";
                                        if ($product["request"] == "1") {
                                            $productrequest = "产品首次";
                                        } else {
                                            if ($product["request"] == "2") {
                                                $productrequest = "同类产品首次";
                                            } else {
                                                if ($product["request"] == "3") {
                                                    $productrequest = "指定时间内";
                                                } else {
                                                    $productrequest = "未知类型";
                                                }
                                            }
                                        }
                                        $productrules = "退款规则";
                                        if ($product["rules"] == "1") {
                                            $productrules = "按时长退";
                                        } else {
                                            if ($product["rules"] == "2") {
                                                $productrules = "按月退";
                                            } else {
                                                if ($product["rules"] == "3") {
                                                    $productrules = "全额退";
                                                } else {
                                                    $productrules = "未知退款规则";
                                                }
                                            }
                                        }
                                        $time = date("Y-m-d H:i:s", time());
                                        $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                        if ($sendToFeishu) {
                                            $feishuWebhookUrl = $Switch["feishuurl"];
                                            $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                            $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                        }
                                        if ($sendToDingTalk) {
                                            $dingtalkWebhookUrl = $Switch["dingurl"];
                                            $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                            $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                        }
                                        if ($sendToWeChat) {
                                            $wechatWebhookUrl = $Switch["wechaturl"];
                                            $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                            $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                        }
                                        if ($tgswitch) {
                                            $telegramBotToken = $Switch["tgtoken"];
                                            $telegramChatId = $Switch["tgchatid"];
                                            $telegramMessage = urlencode($message);
                                            $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                            $this->sendTelegramNotification($telegramUrl);
                                        }
                                        $originalData = \Think\Db::name("host")->where("id", $id)->find();
                                        $newNotes = "自动全额退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                                        $originalNotes = $originalData["notes"] ?? "";
                                        $updatedNotes = $originalNotes . "\n" . $newNotes;
                                        $datahost = ["notes" => $updatedNotes];
                                        \Think\Db::name("host")->where("id", $id)->update($datahost);
                                        $response = ["code" => 200, "msg" => "申请成功，系统审核中。"];
                                    } else {
                                        $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                                    }
                                }
                            }
                        } else {
                            if ($request == 3) {
                                if ($rules == 1) {
                                    $regdate = $productsid["regdate"];
                                    $withinHours = $product["within"];
                                    $days = $Switch["day"];
                                    $clientsGroup = $clients["groupid"];
                                    if ($clientsGroup == 0) {
                                        $withinInSeconds = $withinHours * 3600;
                                    } else {
                                        $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                    }
                                    $newTimestamp = $regdate + $withinInSeconds;
                                    $currentTimestamp = time();
                                    if ($newTimestamp < $currentTimestamp) {
                                        $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                        return json($response);
                                    }
                                    $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                                    $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                                    $usagetime = $currentTimestamp - $productsid["regdate"];
                                    $paymentamount = $paymenttime * $usagetime;
                                    $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                                    $newcredit = $clients["credit"] + $refundamount;
                                    if ($refundamount <= 0) {
                                        $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                        return json($response);
                                    }
                                    $hours = floor($usagetime / 3600);
                                    $minutes = floor($usagetime % 3600 / 60);
                                    $seconds = $usagetime % 60;
                                    $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                                    $dataaccounts = ["uid" => $user_id, "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $id . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【" . $product["within"] . " 小时内自动按时长退款】订单号：" . $orderid . ", 主机ID：" . $id . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $orderidsid["invoiceid"]];
                                    \Think\Db::name("accounts")->insert($dataaccounts);
                                    $datacredit = ["uid" => $user_id, "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $orderidsid["invoiceid"], "amount" => $refundamount, "notes" => "订单号：" . $orderidsid["invoiceid"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，" . $product["within"] . " 小时内自动按时长退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                                    \Think\Db::name("credit")->insert($datacredit);
                                    \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                                    $datainvoices = ["status" => "Refunded"];
                                    \Think\Db::name("invoices")->where("id", $orderidsid["invoiceid"])->update($datainvoices);
                                    $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $user_id . " - Invoice ID:" . $orderidsid["invoiceid"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，来源：" . $product["within"] . " 小时内自动按时长退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => $orderidsid["invoiceid"]];
                                    \Think\Db::name("activity_log")->insert($dataactivity_log);
                                    $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "audittime" => time(), "adminid" => "System", "reviewed" => "System", "status" => "2", "reason" => "自动审核通过"];
                                    \Think\Db::name("product_refund_list")->insert($datalist);
                                    $updatetime = time();
                                    \Think\Db::name("host")->where("id", $id)->update(["nextduedate" => $updatetime]);
                                    $dataupdatetime = ["create_time" => time(), "description" => "【自动退】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：" . $product["within"] . " 小时内自动按时长退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => ""];
                                    \Think\Db::name("activity_log")->insert($dataupdatetime);
                                    $producttype = "产品退款";
                                    if ($product["type"] == "1") {
                                        $producttype = "人工审核";
                                    } else {
                                        if ($product["type"] == "2") {
                                            $producttype = "自动退款";
                                        } else {
                                            $producttype = "未知类型";
                                        }
                                    }
                                    $productrequest = "退款要求";
                                    if ($product["request"] == "1") {
                                        $productrequest = "产品首次";
                                    } else {
                                        if ($product["request"] == "2") {
                                            $productrequest = "同类产品首次";
                                        } else {
                                            if ($product["request"] == "3") {
                                                $productrequest = "指定时间内";
                                            } else {
                                                $productrequest = "未知类型";
                                            }
                                        }
                                    }
                                    $productrules = "退款规则";
                                    if ($product["rules"] == "1") {
                                        $productrules = "按时长退";
                                    } else {
                                        if ($product["rules"] == "2") {
                                            $productrules = "按月退";
                                        } else {
                                            if ($product["rules"] == "3") {
                                                $productrules = "全额退";
                                            } else {
                                                $productrules = "未知退款规则";
                                            }
                                        }
                                    }
                                    $time = date("Y-m-d H:i:s", time());
                                    $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                    if ($sendToFeishu) {
                                        $feishuWebhookUrl = $Switch["feishuurl"];
                                        $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                        $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                    }
                                    if ($sendToDingTalk) {
                                        $dingtalkWebhookUrl = $Switch["dingurl"];
                                        $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                    }
                                    if ($sendToWeChat) {
                                        $wechatWebhookUrl = $Switch["wechaturl"];
                                        $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                        $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                    }
                                    if ($tgswitch) {
                                        $telegramBotToken = $Switch["tgtoken"];
                                        $telegramChatId = $Switch["tgchatid"];
                                        $telegramMessage = urlencode($message);
                                        $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                        $this->sendTelegramNotification($telegramUrl);
                                    }
                                    $originalData = \Think\Db::name("host")->where("id", $id)->find();
                                    $newNotes = "自动按时长退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                                    $originalNotes = $originalData["notes"] ?? "";
                                    $updatedNotes = $originalNotes . "\n" . $newNotes;
                                    $datahost = ["notes" => $updatedNotes];
                                    \Think\Db::name("host")->where("id", $id)->update($datahost);
                                    $response = ["code" => 200, "msg" => "申请成功，系统审核中。"];
                                } else {
                                    if ($rules == 2) {
                                        $regdate = $productsid["regdate"];
                                        $withinHours = $product["within"];
                                        $days = $Switch["day"];
                                        $clientsGroup = $clients["groupid"];
                                        if ($clientsGroup == 0) {
                                            $withinInSeconds = $withinHours * 3600;
                                        } else {
                                            $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                        }
                                        $newTimestamp = $regdate + $withinInSeconds;
                                        $currentTimestamp = time();
                                        if ($newTimestamp < $currentTimestamp) {
                                            $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                            return json($response);
                                        }
                                        $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                                        $paymenttime = $productsid["firstpaymentamount"] / $productstime;
                                        $usagetime = $currentTimestamp - $productsid["regdate"];
                                        $monthpayment = $paymenttime * 2592000;
                                        $monthsUsed = ceil($usagetime / 2592000);
                                        $paymentamount = $monthpayment * $monthsUsed;
                                        $refundamount = round($productsid["firstpaymentamount"] - $paymentamount, 2);
                                        $newcredit = $clients["credit"] + $refundamount;
                                        if ($refundamount <= 0) {
                                            $response = ["code" => 400, "msg" => "退款金额不能小于0"];
                                            return json($response);
                                        }
                                        $hours = floor($usagetime / 3600);
                                        $minutes = floor($usagetime % 3600 / 60);
                                        $seconds = $usagetime % 60;
                                        $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                                        $dataaccounts = ["uid" => $user_id, "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $id . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【" . $product["within"] . " 小时内自动按月退款】订单号：" . $orderid . ", 主机ID：" . $id . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $orderidsid["invoiceid"]];
                                        \Think\Db::name("accounts")->insert($dataaccounts);
                                        $datacredit = ["uid" => $user_id, "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $orderidsid["invoiceid"], "amount" => $refundamount, "notes" => "订单号：" . $orderidsid["invoiceid"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，" . $product["within"] . " 小时内自动按月退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                                        \Think\Db::name("credit")->insert($datacredit);
                                        \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                                        $datainvoices = ["status" => "Refunded"];
                                        \Think\Db::name("invoices")->where("id", $orderidsid["invoiceid"])->update($datainvoices);
                                        $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $user_id . " - Invoice ID:" . $orderidsid["invoiceid"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，来源：" . $product["within"] . " 小时内自动按月退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => $orderidsid["invoiceid"]];
                                        \Think\Db::name("activity_log")->insert($dataactivity_log);
                                        $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "audittime" => time(), "adminid" => "System", "reviewed" => "System", "status" => "2", "reason" => "自动审核通过"];
                                        \Think\Db::name("product_refund_list")->insert($datalist);
                                        $updatetime = time();
                                        \Think\Db::name("host")->where("id", $id)->update(["nextduedate" => $updatetime]);
                                        $dataupdatetime = ["create_time" => time(), "description" => "【自动退】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：" . $product["within"] . " 小时内自动按月退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => ""];
                                        \Think\Db::name("activity_log")->insert($dataupdatetime);
                                        $producttype = "产品退款";
                                        if ($product["type"] == "1") {
                                            $producttype = "人工审核";
                                        } else {
                                            if ($product["type"] == "2") {
                                                $producttype = "自动退款";
                                            } else {
                                                $producttype = "未知类型";
                                            }
                                        }
                                        $productrequest = "退款要求";
                                        if ($product["request"] == "1") {
                                            $productrequest = "产品首次";
                                        } else {
                                            if ($product["request"] == "2") {
                                                $productrequest = "同类产品首次";
                                            } else {
                                                if ($product["request"] == "3") {
                                                    $productrequest = "指定时间内";
                                                } else {
                                                    $productrequest = "未知类型";
                                                }
                                            }
                                        }
                                        $productrules = "退款规则";
                                        if ($product["rules"] == "1") {
                                            $productrules = "按时长退";
                                        } else {
                                            if ($product["rules"] == "2") {
                                                $productrules = "按月退";
                                            } else {
                                                if ($product["rules"] == "3") {
                                                    $productrules = "全额退";
                                                } else {
                                                    $productrules = "未知退款规则";
                                                }
                                            }
                                        }
                                        $time = date("Y-m-d H:i:s", time());
                                        $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                        if ($sendToFeishu) {
                                            $feishuWebhookUrl = $Switch["feishuurl"];
                                            $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                            $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                        }
                                        if ($sendToDingTalk) {
                                            $dingtalkWebhookUrl = $Switch["dingurl"];
                                            $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                            $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                        }
                                        if ($sendToWeChat) {
                                            $wechatWebhookUrl = $Switch["wechaturl"];
                                            $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                            $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                        }
                                        if ($tgswitch) {
                                            $telegramBotToken = $Switch["tgtoken"];
                                            $telegramChatId = $Switch["tgchatid"];
                                            $telegramMessage = urlencode($message);
                                            $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                            $this->sendTelegramNotification($telegramUrl);
                                        }
                                        $originalData = \Think\Db::name("host")->where("id", $id)->find();
                                        $newNotes = "自动按月退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                                        $originalNotes = $originalData["notes"] ?? "";
                                        $updatedNotes = $originalNotes . "\n" . $newNotes;
                                        $datahost = ["notes" => $updatedNotes];
                                        \Think\Db::name("host")->where("id", $id)->update($datahost);
                                        $response = ["code" => 200, "msg" => "申请成功，系统审核中。"];
                                    } else {
                                        if ($rules == 3) {
                                            $regdate = $productsid["regdate"];
                                            $withinHours = $product["within"];
                                            $days = $Switch["day"];
                                            $clientsGroup = $clients["groupid"];
                                            if ($clientsGroup == 0) {
                                                $withinInSeconds = $withinHours * 3600;
                                            } else {
                                                $withinInSeconds = ($withinHours + $days * 24) * 3600;
                                            }
                                            $newTimestamp = $regdate + $withinInSeconds;
                                            $currentTimestamp = time();
                                            if ($newTimestamp < $currentTimestamp) {
                                                $response = ["code" => 400, "msg" => "当前产品支持开通后" . $product["within"] . "小时内退款，当前已经超过指定时间，不能执行操作。"];
                                                return json($response);
                                            }
                                            $refundamount = $productsid["firstpaymentamount"];
                                            $newcredit = $clients["credit"] + $refundamount;
                                            $usagetime = $currentTimestamp - $productsid["regdate"];
                                            $hours = floor($usagetime / 3600);
                                            $minutes = floor($usagetime % 3600 / 60);
                                            $seconds = $usagetime % 60;
                                            $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                                            $dataaccounts = ["uid" => $user_id, "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $id . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【" . $product["within"] . " 小时内自动按全额退款】订单号：" . $orderid . ", 主机ID：" . $id . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $orderidsid["invoiceid"]];
                                            \Think\Db::name("accounts")->insert($dataaccounts);
                                            $datacredit = ["uid" => $user_id, "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $orderidsid["invoiceid"], "amount" => $refundamount, "notes" => "订单号：" . $orderidsid["invoiceid"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，" . $product["within"] . " 小时内自动按全额退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                                            \Think\Db::name("credit")->insert($datacredit);
                                            \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                                            $datainvoices = ["status" => "Refunded"];
                                            \Think\Db::name("invoices")->where("id", $orderidsid["invoiceid"])->update($datainvoices);
                                            $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $user_id . " - Invoice ID:" . $orderidsid["invoiceid"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，来源：" . $product["within"] . " 小时内自动按全额退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => $orderidsid["invoiceid"]];
                                            \Think\Db::name("activity_log")->insert($dataactivity_log);
                                            $datalist = ["user_id" => $user_id, "username" => $clients["username"], "productid" => $productid, "productname" => $productstype["name"], "orderid" => $orderid, "producttype" => $productstype["type"], "hostid" => $id, "invoices" => $orderidsid["invoiceid"], "type" => $product["type"], "request" => $product["request"], "rules" => $product["rules"], "amount" => $refundamount, "created_time" => time(), "reasonrefund" => $reasonrefund, "audittime" => time(), "adminid" => "System", "reviewed" => "System", "status" => "2", "reason" => "自动审核通过"];
                                            \Think\Db::name("product_refund_list")->insert($datalist);
                                            $updatetime = time();
                                            \Think\Db::name("host")->where("id", $id)->update(["nextduedate" => $updatetime]);
                                            $dataupdatetime = ["create_time" => time(), "description" => "【自动退】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a>，订单号：" . $orderid . " ，<a href=\"#/customer-view/product-innerpage?hid=" . $id . "&id=" . $user_id . "\">Host ID:" . $id . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：" . $product["within"] . " 小时内自动按全额退款", "user" => "System", "uid" => $user_id, "ipaddr" => "0.0.0.0", "type" => "6", "activeid" => 0, "usertype" => "System", "port" => "", "type_data_id" => ""];
                                            \Think\Db::name("activity_log")->insert($dataupdatetime);
                                            $producttype = "产品退款";
                                            if ($product["type"] == "1") {
                                                $producttype = "人工审核";
                                            } else {
                                                if ($product["type"] == "2") {
                                                    $producttype = "自动退款";
                                                } else {
                                                    $producttype = "未知类型";
                                                }
                                            }
                                            $productrequest = "退款要求";
                                            if ($product["request"] == "1") {
                                                $productrequest = "产品首次";
                                            } else {
                                                if ($product["request"] == "2") {
                                                    $productrequest = "同类产品首次";
                                                } else {
                                                    if ($product["request"] == "3") {
                                                        $productrequest = "指定时间内";
                                                    } else {
                                                        $productrequest = "未知类型";
                                                    }
                                                }
                                            }
                                            $productrules = "退款规则";
                                            if ($product["rules"] == "1") {
                                                $productrules = "按时长退";
                                            } else {
                                                if ($product["rules"] == "2") {
                                                    $productrules = "按月退";
                                                } else {
                                                    if ($product["rules"] == "3") {
                                                        $productrules = "全额退";
                                                    } else {
                                                        $productrules = "未知退款规则";
                                                    }
                                                }
                                            }
                                            $time = date("Y-m-d H:i:s", time());
                                            $message = "【" . $producttype . " 】申请退款通知 \n用户编号：" . $user_id . " \n用户名称：" . $clients["username"] . " \n用户邮箱：" . $clients["email"] . "\n商品名称：" . $productstype["name"] . "  \n账单编号：" . $orderidsid["invoiceid"] . " \n订单编号：" . $orderid . " \n主机编号：" . $id . " \n退款类型：" . $producttype . " \n退款要求：" . $productrequest . " \n退款规则：" . $productrules . " \n首付金额：" . $firstpaymentamount . " 元 \n退款金额：" . $refundamount . " 元 \n退款原因：" . $reasonrefund . " \n\n通知时间：" . $time . " \n消息来源【" . $Switch["webname"] . " 】产品退款【机器人版】";
                                            if ($sendToFeishu) {
                                                $feishuWebhookUrl = $Switch["feishuurl"];
                                                $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                                                $this->sendToWebhook($feishuWebhookUrl, $feishuData);
                                            }
                                            if ($sendToDingTalk) {
                                                $dingtalkWebhookUrl = $Switch["dingurl"];
                                                $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                                                $this->sendToWebhook($dingtalkWebhookUrl, json_encode($dingtalkData));
                                            }
                                            if ($sendToWeChat) {
                                                $wechatWebhookUrl = $Switch["wechaturl"];
                                                $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                                                $this->sendToWebhook($wechatWebhookUrl, json_encode($wechatData));
                                            }
                                            if ($tgswitch) {
                                                $telegramBotToken = $Switch["tgtoken"];
                                                $telegramChatId = $Switch["tgchatid"];
                                                $telegramMessage = urlencode($message);
                                                $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                                                $this->sendTelegramNotification($telegramUrl);
                                            }
                                            $originalData = \Think\Db::name("host")->where("id", $id)->find();
                                            $newNotes = "自动全额退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                                            $originalNotes = $originalData["notes"] ?? "";
                                            $updatedNotes = $originalNotes . "\n" . $newNotes;
                                            $datahost = ["notes" => $updatedNotes];
                                            \Think\Db::name("host")->where("id", $id)->update($datahost);
                                            $response = ["code" => 200, "msg" => "申请成功，系统审核中。"];
                                        } else {
                                            $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                                        }
                                    }
                                }
                            } else {
                                $response = ["code" => 400, "msg" => "不支持的请求类型。"];
                            }
                        }
                    }
                } else {
                    $response = ["code" => 400, "msg" => "不支持的操作类型。"];
                }
            }
            return json($response);
        }
    }
    private function sendToWebhook($webhookUrl, $data)
    {
        $ch = curl_init($webhookUrl);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
        $response = curl_exec($ch);
        curl_close($ch);
    }
    private function sendTelegramNotification($telegramUrl)
    {
        $ch = curl_init($telegramUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        $response = curl_exec($ch);
        curl_close($ch);
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>