<?php
namespace addons\self_refund;

class SelfRefundPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "SelfRefund", "title" => "产品退款", "description" => "产品退款管理插件，支持自动退款，人工审核退款，支持按时长退款，按月退款，全额退款，支持自定义退款时间", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.0", "module" => "addons", "lang" => ["chinese" => "产品退款", "chinese_tw" => "產品退款", "english" => "Product Refund"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "productid", "type" => "VARCHAR(255)"], ["name" => "producttype", "type" => "VARCHAR(255)"], ["name" => "type", "type" => "VARCHAR(255)"], ["name" => "request", "type" => "VARCHAR(255)"], ["name" => "within", "type" => "INT"], ["name" => "rules", "type" => "VARCHAR(255)"], ["name" => "created_time", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "webname", "type" => "VARCHAR(255)"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "open", "type" => "VARCHAR(255)"], ["name" => "zzqq", "type" => "VARCHAR(255)"], ["name" => "zzemail", "type" => "VARCHAR(255)"], ["name" => "day", "type" => "VARCHAR(255)"], ["name" => "agent", "type" => "VARCHAR(255)"], ["name" => "displaytime", "type" => "VARCHAR(255)"], ["name" => "mfauth", "type" => "VARCHAR(255)"], ["name" => "feishuswitch", "type" => "VARCHAR(255)"], ["name" => "feishuurl", "type" => "VARCHAR(255)"], ["name" => "dingswitch", "type" => "VARCHAR(255)"], ["name" => "dingurl", "type" => "VARCHAR(255)"], ["name" => "wechatswitch", "type" => "VARCHAR(255)"], ["name" => "wechaturl", "type" => "VARCHAR(255)"], ["name" => "tgswitch", "type" => "VARCHAR(255)"], ["name" => "tgtoken", "type" => "VARCHAR(255)"], ["name" => "tgchatid", "type" => "VARCHAR(255)"]];
        $fieldsToAddTable3 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "user_id", "type" => "INT"], ["name" => "username", "type" => "VARCHAR(255)"], ["name" => "productid", "type" => "INT"], ["name" => "productname", "type" => "VARCHAR(255)"], ["name" => "orderid", "type" => "INT"], ["name" => "producttype", "type" => "VARCHAR(255)"], ["name" => "hostid", "type" => "INT"], ["name" => "invoices", "type" => "INT"], ["name" => "type", "type" => "VARCHAR(255)"], ["name" => "request", "type" => "VARCHAR(255)"], ["name" => "rules", "type" => "VARCHAR(255)"], ["name" => "amount", "type" => "VARCHAR(255)"], ["name" => "reasonrefund", "type" => "VARCHAR(255)"], ["name" => "created_time", "type" => "VARCHAR(255)"], ["name" => "audittime", "type" => "VARCHAR(255)"], ["name" => "adminid", "type" => "VARCHAR(255)"], ["name" => "reviewed", "type" => "VARCHAR(255)"], ["name" => "status", "type" => "VARCHAR(255)"], ["name" => "reason", "type" => "VARCHAR(255)"]];
        $tableName1 = "shd_product_refund";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_product_refund_setting";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n                    CREATE TABLE " . $tableName2 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n                    );\n                ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                            ALTER TABLE " . $tableName2 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        $tableName3 = "shd_product_refund_list";
        $tableExists3 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName3 . "'");
        if (empty($tableExists3)) {
            $sql3 = "\n                    CREATE TABLE " . $tableName3 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable3)) . "\n                    );\n                ";
            \Think\Db::execute($sql3);
        } else {
            foreach ($fieldsToAddTable3 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName3 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql3 = "\n                            ALTER TABLE " . $tableName3 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql3);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        $sql = [];
        foreach ($sql as $v) {
            \think\Db::execute($v);
        }
        return true;
    }
    public function afterCron()
    {
        $result = \Think\Db::name("product_refund_setting")->where("id", 1)->find();
        if ($result["open"] == 1) {
            $lists = \Think\Db::name("product_refund")->select();
            $count = 0;
            foreach ($lists as $list) {
                $hidden = \Think\Db::name("products")->where("id", $list["productid"])->value("hidden");
                if ($hidden == 1) {
                    $jie = \Think\Db::name("product_refund")->where("id", $list["id"])->delete();
                    if ($jie) {
                        $count++;
                    }
                }
            }
            echo "产品退款(插件)清理已下架产品：" . $count . "个:" . date("Y-m-d H:i:s") . PHP_EOL . "";
        }
    }
}

?>