<?php
namespace addons\self_refund\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function products()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $lists = \Think\Db::name("product_refund")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $resultWithNames = [];
        foreach ($lists as $record) {
            $productid = $record["productid"];
            $hostid = $record["id"];
            $name = \Think\Db::name("products")->where("id", $productid)->find();
            $name1 = \Think\Db::name("products")->where(["id" => $productid, "api_type" => "zjmf_api"])->find();
            $zjmf_finance_api = \Think\Db::name("zjmf_finance_api")->where(["id" => $name1["server_group"]])->find();
            if ($name !== NULL) {
                $record["name"] = $name["name"];
                $record["hosttype"] = $name["type"];
                $record["api_name"] = $zjmf_finance_api["name"];
                $record["hidden"] = $name["hidden"];
                $resultWithNames[] = $record;
            }
        }
        $this->assign("Title", "产品列表");
        $this->assign("fen", $lists);
        return $this->fetch("/products", ["data" => $resultWithNames]);
    }
    public function deletelists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $result = \Think\Db::name("product_refund")->where("id", $id)->delete();
            if ($result !== false) {
                return json(["code" => 200, "msg" => "活动删除成功"]);
            }
            return json(["code" => 500, "msg" => "活动删除失败"]);
        }
    }
    public function setting()
    {
        $configurationsModel = \Think\Db::name("product_refund_setting");
        $configData = $configurationsModel->find();
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/setting");
    }
    public function submit()
    {
        $data = $this->request->post();
        $zzemail = isset($data["zzemail"]) ? $data["zzemail"] : NULL;
        $zzqq = isset($data["zzqq"]) ? $data["zzqq"] : NULL;
        $mfauth = isset($data["mfauth"]) ? $data["mfauth"] : NULL;
        $dailiday = isset($data["day"]) ? $data["day"] : NULL;
        $displaytime = isset($data["displaytime"]) ? $data["displaytime"] : NULL;
        $feishuurl = isset($data["feishuurl"]) ? $data["feishuurl"] : NULL;
        $dingurl = isset($data["dingurl"]) ? $data["dingurl"] : NULL;
        $wechaturl = isset($data["wechaturl"]) ? $data["wechaturl"] : NULL;
        $webname = isset($data["webname"]) ? $data["webname"] : NULL;
        $feishuswitch = isset($data["feishuswitch"]) ? $data["feishuswitch"] : NULL;
        $dingswitch = isset($data["dingswitch"]) ? $data["dingswitch"] : NULL;
        $wechatswitch = isset($data["wechatswitch"]) ? $data["wechatswitch"] : NULL;
        $tgswitch = isset($data["tgswitch"]) ? $data["tgswitch"] : NULL;
        $tgtoken = isset($data["tgtoken"]) ? $data["tgtoken"] : NULL;
        $tgchatid = isset($data["tgchatid"]) ? $data["tgchatid"] : NULL;
        $agent = isset($data["agent"]) ? $data["agent"] : NULL;
        $open = isset($data["open"]) ? $data["open"] : NULL;
        if (!isset($data["day"]) || $data["day"] < 0) {
            if (empty($data["day"])) {
                $msg = "代理可退时间不能为空。";
            } else {
                $msg = "代理可退时间必须大于等于0。";
            }
            $response = ["code" => 400, "msg" => $msg];
            return json($response);
        }
        if (!isset($data["displaytime"]) || $data["displaytime"] < 1) {
            if (empty($data["displaytime"])) {
                $msg = "过期订单显示时间不能为空，单位为天。";
            } else {
                $msg = "过期订单显示时间必须大于1。";
            }
            $response = ["code" => 400, "msg" => $msg];
            return json($response);
        }
        $dbConfig = ["webname" => $webname, "zzemail" => $zzemail, "zzqq" => $zzqq, "day" => $dailiday, "displaytime" => $displaytime, "mfauth" => $mfauth, "feishuurl" => $feishuurl, "dingurl" => $dingurl, "wechaturl" => $wechaturl, "feishuswitch" => $feishuswitch, "dingswitch" => $dingswitch, "wechatswitch" => $wechatswitch, "tgswitch" => $tgswitch, "tgtoken" => $tgtoken, "tgchatid" => $tgchatid, "agent" => $agent, "open" => $open, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \Think\Db::name("product_refund_setting")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("product_refund_setting")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("product_refund_setting")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function index()
    {
        $products = \Think\Db::name("products")->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        $filteredProducts = [];
        foreach ($products as $key => $product) {
            $fanProducts = \Think\Db::name("product_refund")->where("productid", $product["id"])->find();
            $name = \Think\Db::name("products")->where("id", $product["id"])->find();
            $name1 = \Think\Db::name("products")->where(["id" => $product["id"], "api_type" => "zjmf_api"])->find();
            $zjmf_finance_api = \Think\Db::name("zjmf_finance_api")->where(["id" => $name1["server_group"]])->find();
            if (!$fanProducts) {
                $product["api_name"] = $zjmf_finance_api["name"];
                $product["hidden"] = $name["hidden"];
                $filteredProducts[] = $product;
            }
        }
        $this->assign("keproducts", $filteredProducts);
        $this->assign("Title", "添加产品");
        return $this->fetch("/index");
    }
    public function submitActivitys()
    {
        $data = $this->request->post();
        $productid = isset($data["selected_product"]) ? $data["selected_product"] : NULL;
        $type = isset($data["type"]) ? $data["type"] : NULL;
        $request = isset($data["request"]) ? $data["request"] : NULL;
        $within = isset($data["within"]) ? $data["within"] : NULL;
        $rules = isset($data["rules"]) ? $data["rules"] : NULL;
        $created_time = isset($data["created_time"]) ? $data["created_time"] : NULL;
        $producttype = \Think\Db::name("products")->where("id", $productid)->value("type");
        $productresult = \Think\Db::name("product_refund")->where(["productid" => $productid])->find();
        if (empty($data["within"]) || $data["within"] <= 1) {
            $response = ["code" => 400, "msg" => "请输入支持的退款时间，单位为小时，且必须大于1。"];
            return json($response);
        }
        if ($productresult) {
            $response = ["code" => 400, "msg" => "选择的产品已存在列表中，请重新选取"];
            return json($response);
        }
        $dbData = ["productid" => $productid, "producttype" => $producttype, "type" => $type, "request" => $request, "within" => $within, "rules" => $rules, "created_time" => time()];
        $dbData = array_filter($dbData, function ($value) {
            return $value !== NULL;
        });
        $result = \Think\Db::name("product_refund")->insert($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "活动配置添加成功。"];
        } else {
            $response = ["code" => 400, "msg" => "活动配置添加失败。"];
        }
        return json($response);
    }
    public function lists()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $lists = \Think\Db::name("product_refund_list")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("Title", "申请列表");
        $this->assign("domain", $domain);
        $this->assign("clients", $clients);
        return $this->fetch("/lists", ["data" => $lists]);
    }
    public function agreewith()
    {
        $data = $this->request->post();
        $id = isset($data["id"]) ? $data["id"] : NULL;
        $refundlist = \Think\Db::name("product_refund_list")->where("id", $id)->find();
        $clients = \Think\Db::name("clients")->where("id", $refundlist["user_id"])->find();
        $productsid = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
        $admin_id = cmf_get_current_admin_id();
        $adminuser = \Think\Db::name("user")->where("id", $admin_id)->value("user_nickname");
        $request = $refundlist["request"];
        $rules = $refundlist["rules"];
        $days = $product["within"] / 24;
        $currentTimestamp = time();
        $client_ip = $_SERVER["REMOTE_ADDR"];
        $client_port = $_SERVER["REMOTE_PORT"];
        if ($request == 1) {
            if ($rules == 1) {
                $refundamount = $refundlist["amount"];
                $newcredit = $clients["credit"] + $refundamount;
                $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                $usagetime = $currentTimestamp - $productsid["regdate"];
                $hours = floor($usagetime / 3600);
                $minutes = floor($usagetime % 3600 / 60);
                $seconds = $usagetime % 60;
                $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                $dataaccounts = ["uid" => $refundlist["user_id"], "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $refundlist["hostid"] . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【人工审核产品首次按时长退款】订单号：" . $refundlist["orderid"] . ", 主机ID：" . $refundlist["hostid"] . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $refundlist["invoices"]];
                \Think\Db::name("accounts")->insert($dataaccounts);
                $datacredit = ["uid" => $refundlist["user_id"], "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $refundlist["invoices"], "amount" => $refundamount, "notes" => "订单号：" . $refundlist["orderid"] . "，主机ID：" . $refundlist["hostid"] . "，账单号：" . $refundlist["invoices"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，人工审核产品首次按时长退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                \Think\Db::name("credit")->insert($datacredit);
                \Think\Db::name("clients")->where("id", $refundlist["user_id"])->update(["credit" => $newcredit]);
                $datainvoices = ["status" => "Refunded"];
                \Think\Db::name("invoices")->where("id", $refundlist["invoices"])->update($datainvoices);
                $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $refundlist["user_id"] . " - Invoice ID:" . $refundlist["invoices"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => $refundlist["invoices"]];
                \Think\Db::name("activity_log")->insert($dataactivity_log);
                $updatetime = time();
                \Think\Db::name("host")->where("id", $refundlist["hostid"])->update(["nextduedate" => $updatetime]);
                $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核通过】退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                \Think\Db::name("activity_log")->insert($dataupdatetime);
                $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "2", "reason" => "审核通过"];
                \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                $originalData = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
                $newNotes = "人工按时长退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                $originalNotes = $originalData["notes"] ?? "";
                $updatedNotes = $originalNotes . "\n" . $newNotes;
                $datahost = ["notes" => $updatedNotes];
                \Think\Db::name("host")->where("id", $refundlist["hostid"])->update($datahost);
                $response = ["code" => 200, "msg" => "【审核通过】，按天退款。"];
            } else {
                if ($rules == 2) {
                    $refundamount = $refundlist["amount"];
                    $newcredit = $clients["credit"] + $refundamount;
                    $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                    $usagetime = $currentTimestamp - $productsid["regdate"];
                    $hours = floor($usagetime / 3600);
                    $minutes = floor($usagetime % 3600 / 60);
                    $seconds = $usagetime % 60;
                    $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                    $dataaccounts = ["uid" => $refundlist["user_id"], "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $refundlist["hostid"] . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【人工审核产品首次按月退款】订单号：" . $refundlist["orderid"] . ", 主机ID：" . $refundlist["hostid"] . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $refundlist["invoices"]];
                    \Think\Db::name("accounts")->insert($dataaccounts);
                    $datacredit = ["uid" => $refundlist["user_id"], "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $refundlist["invoices"], "amount" => $refundamount, "notes" => "订单号：" . $refundlist["orderid"] . "，主机ID：" . $refundlist["hostid"] . "，账单号：" . $refundlist["invoices"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，人工审核产品首次按月退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                    \Think\Db::name("credit")->insert($datacredit);
                    \Think\Db::name("clients")->where("id", $refundlist["user_id"])->update(["credit" => $newcredit]);
                    $datainvoices = ["status" => "Refunded"];
                    \Think\Db::name("invoices")->where("id", $refundlist["invoices"])->update($datainvoices);
                    $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $refundlist["user_id"] . " - Invoice ID:" . $refundlist["invoices"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，来源：人工审核产品首次按月退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => $refundlist["invoices"]];
                    \Think\Db::name("activity_log")->insert($dataactivity_log);
                    $updatetime = time();
                    \Think\Db::name("host")->where("id", $refundlist["hostid"])->update(["nextduedate" => $updatetime]);
                    $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核通过】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：人工审核产品首次按月退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                    \Think\Db::name("activity_log")->insert($dataupdatetime);
                    $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "2", "reason" => "审核通过"];
                    \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                    $originalData = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
                    $newNotes = "人工按时月退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                    $originalNotes = $originalData["notes"] ?? "";
                    $updatedNotes = $originalNotes . "\n" . $newNotes;
                    $datahost = ["notes" => $updatedNotes];
                    \Think\Db::name("host")->where("id", $refundlist["hostid"])->update($datahost);
                    $response = ["code" => 200, "msg" => "【审核通过】，按月退款。"];
                } else {
                    if ($rules == 3) {
                        $refundamount = $refundlist["amount"];
                        $newcredit = $clients["credit"] + $refundamount;
                        $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                        $usagetime = $currentTimestamp - $productsid["regdate"];
                        $hours = floor($usagetime / 3600);
                        $minutes = floor($usagetime % 3600 / 60);
                        $seconds = $usagetime % 60;
                        $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                        $dataaccounts = ["uid" => $refundlist["user_id"], "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $refundlist["hostid"] . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【人工审核产品首次按全额退款】订单号：" . $refundlist["orderid"] . ", 主机ID：" . $refundlist["hostid"] . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $refundlist["invoices"]];
                        \Think\Db::name("accounts")->insert($dataaccounts);
                        $datacredit = ["uid" => $refundlist["user_id"], "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $refundlist["invoices"], "amount" => $refundamount, "notes" => "订单号：" . $refundlist["orderid"] . "，主机ID：" . $refundlist["hostid"] . "，账单号：" . $refundlist["invoices"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，人工审核产品首次按全额退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                        \Think\Db::name("credit")->insert($datacredit);
                        \Think\Db::name("clients")->where("id", $refundlist["user_id"])->update(["credit" => $newcredit]);
                        $datainvoices = ["status" => "Refunded"];
                        \Think\Db::name("invoices")->where("id", $refundlist["invoices"])->update($datainvoices);
                        $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $refundlist["user_id"] . " - Invoice ID:" . $refundlist["invoices"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，来源：人工审核产品首次按全额退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => $refundlist["invoices"]];
                        \Think\Db::name("activity_log")->insert($dataactivity_log);
                        $updatetime = time();
                        \Think\Db::name("host")->where("id", $refundlist["hostid"])->update(["nextduedate" => $updatetime]);
                        $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核通过】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：人工审核产品首次按全额退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($dataupdatetime);
                        $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "2", "reason" => "审核通过"];
                        \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                        $originalData = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
                        $newNotes = "人工按全额退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                        $originalNotes = $originalData["notes"] ?? "";
                        $updatedNotes = $originalNotes . "\n" . $newNotes;
                        $datahost = ["notes" => $updatedNotes];
                        \Think\Db::name("host")->where("id", $refundlist["hostid"])->update($datahost);
                        $response = ["code" => 200, "msg" => "【审核通过】，全额退款。"];
                    } else {
                        $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                    }
                }
            }
        } else {
            if ($request == 2) {
                if ($rules == 1) {
                    $refundamount = $refundlist["amount"];
                    $newcredit = $clients["credit"] + $refundamount;
                    $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                    $usagetime = $currentTimestamp - $productsid["regdate"];
                    $hours = floor($usagetime / 3600);
                    $minutes = floor($usagetime % 3600 / 60);
                    $seconds = $usagetime % 60;
                    $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                    $dataaccounts = ["uid" => $refundlist["user_id"], "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $refundlist["hostid"] . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【人工审核同类产品首次按时长退款】订单号：" . $refundlist["orderid"] . ", 主机ID：" . $refundlist["hostid"] . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $refundlist["invoices"]];
                    \Think\Db::name("accounts")->insert($dataaccounts);
                    $datacredit = ["uid" => $refundlist["user_id"], "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $refundlist["invoices"], "amount" => $refundamount, "notes" => "订单号：" . $refundlist["orderid"] . "，主机ID：" . $refundlist["hostid"] . "，账单号：" . $refundlist["invoices"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，人工审核同类产品首次按时长退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                    \Think\Db::name("credit")->insert($datacredit);
                    \Think\Db::name("clients")->where("id", $refundlist["user_id"])->update(["credit" => $newcredit]);
                    $datainvoices = ["status" => "Refunded"];
                    \Think\Db::name("invoices")->where("id", $refundlist["invoices"])->update($datainvoices);
                    $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $refundlist["user_id"] . " - Invoice ID:" . $refundlist["invoices"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，来源：人工审核同类产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => $refundlist["invoices"]];
                    \Think\Db::name("activity_log")->insert($dataactivity_log);
                    $updatetime = time();
                    \Think\Db::name("host")->where("id", $refundlist["hostid"])->update(["nextduedate" => $updatetime]);
                    $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核通过】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：人工审核同类产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                    \Think\Db::name("activity_log")->insert($dataupdatetime);
                    $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "2", "reason" => "审核通过"];
                    \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                    $originalData = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
                    $newNotes = "人工按时长退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                    $originalNotes = $originalData["notes"] ?? "";
                    $updatedNotes = $originalNotes . "\n" . $newNotes;
                    $datahost = ["notes" => $updatedNotes];
                    \Think\Db::name("host")->where("id", $refundlist["hostid"])->update($datahost);
                    $response = ["code" => 200, "msg" => "【审核通过】，按天退款。"];
                } else {
                    if ($rules == 2) {
                        $refundamount = $refundlist["amount"];
                        $newcredit = $clients["credit"] + $refundamount;
                        $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                        $usagetime = $currentTimestamp - $productsid["regdate"];
                        $hours = floor($usagetime / 3600);
                        $minutes = floor($usagetime % 3600 / 60);
                        $seconds = $usagetime % 60;
                        $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                        $dataaccounts = ["uid" => $refundlist["user_id"], "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $refundlist["hostid"] . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【人工审核同类产品首次按全月退款】订单号：" . $refundlist["orderid"] . ", 主机ID：" . $refundlist["hostid"] . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $refundlist["invoices"]];
                        \Think\Db::name("accounts")->insert($dataaccounts);
                        $datacredit = ["uid" => $refundlist["user_id"], "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $refundlist["invoices"], "amount" => $refundamount, "notes" => "订单号：" . $refundlist["orderid"] . "，主机ID：" . $refundlist["hostid"] . "，账单号：" . $refundlist["invoices"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，人工审核同类产品首次按全月退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                        \Think\Db::name("credit")->insert($datacredit);
                        \Think\Db::name("clients")->where("id", $refundlist["user_id"])->update(["credit" => $newcredit]);
                        $datainvoices = ["status" => "Refunded"];
                        \Think\Db::name("invoices")->where("id", $refundlist["invoices"])->update($datainvoices);
                        $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $refundlist["user_id"] . " - Invoice ID:" . $refundlist["invoices"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，来源：人工审核同类产品首次按全月退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => $refundlist["invoices"]];
                        \Think\Db::name("activity_log")->insert($dataactivity_log);
                        $updatetime = time();
                        \Think\Db::name("host")->where("id", $refundlist["hostid"])->update(["nextduedate" => $updatetime]);
                        $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核通过】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：人工审核同类产品首次按全月退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($dataupdatetime);
                        $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "2", "reason" => "审核通过"];
                        \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                        $originalData = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
                        $newNotes = "人工按月退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                        $originalNotes = $originalData["notes"] ?? "";
                        $updatedNotes = $originalNotes . "\n" . $newNotes;
                        $datahost = ["notes" => $updatedNotes];
                        \Think\Db::name("host")->where("id", $refundlist["hostid"])->update($datahost);
                        $response = ["code" => 200, "msg" => "【审核通过】，按月退款。"];
                    } else {
                        if ($rules == 3) {
                            $refundamount = $refundlist["amount"];
                            $newcredit = $clients["credit"] + $refundamount;
                            $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                            $usagetime = $currentTimestamp - $productsid["regdate"];
                            $hours = floor($usagetime / 3600);
                            $minutes = floor($usagetime % 3600 / 60);
                            $seconds = $usagetime % 60;
                            $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                            $dataaccounts = ["uid" => $refundlist["user_id"], "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $refundlist["hostid"] . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【人工审核同类产品首次按全额退款】订单号：" . $refundlist["orderid"] . ", 主机ID：" . $refundlist["hostid"] . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $refundlist["invoices"]];
                            \Think\Db::name("accounts")->insert($dataaccounts);
                            $datacredit = ["uid" => $refundlist["user_id"], "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $refundlist["invoices"], "amount" => $refundamount, "notes" => "订单号：" . $refundlist["orderid"] . "，主机ID：" . $refundlist["hostid"] . "，账单号：" . $refundlist["invoices"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，人工审核同类产品首次按全额退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                            \Think\Db::name("credit")->insert($datacredit);
                            \Think\Db::name("clients")->where("id", $refundlist["user_id"])->update(["credit" => $newcredit]);
                            $datainvoices = ["status" => "Refunded"];
                            \Think\Db::name("invoices")->where("id", $refundlist["invoices"])->update($datainvoices);
                            $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $refundlist["user_id"] . " - Invoice ID:" . $refundlist["invoices"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，来源：人工审核同类产品首次按全额退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => $refundlist["invoices"]];
                            \Think\Db::name("activity_log")->insert($dataactivity_log);
                            $updatetime = time();
                            \Think\Db::name("host")->where("id", $refundlist["hostid"])->update(["nextduedate" => $updatetime]);
                            $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核通过】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：人工审核同类产品首次按全额退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                            \Think\Db::name("activity_log")->insert($dataupdatetime);
                            $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "2", "reason" => "审核通过"];
                            \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                            $originalData = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
                            $newNotes = "人工按全额退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                            $originalNotes = $originalData["notes"] ?? "";
                            $updatedNotes = $originalNotes . "\n" . $newNotes;
                            $datahost = ["notes" => $updatedNotes];
                            \Think\Db::name("host")->where("id", $refundlist["hostid"])->update($datahost);
                            $response = ["code" => 200, "msg" => "【审核通过】，全额退款。"];
                        } else {
                            $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                        }
                    }
                }
            } else {
                if ($request == 3) {
                    if ($rules == 1) {
                        $refundamount = $refundlist["amount"];
                        $newcredit = $clients["credit"] + $refundamount;
                        $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                        $usagetime = $currentTimestamp - $productsid["regdate"];
                        $hours = floor($usagetime / 3600);
                        $minutes = floor($usagetime % 3600 / 60);
                        $seconds = $usagetime % 60;
                        $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                        $dataaccounts = ["uid" => $refundlist["user_id"], "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $refundlist["hostid"] . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【人工审核X小时内按时长退款】订单号：" . $refundlist["orderid"] . ", 主机ID：" . $refundlist["hostid"] . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $refundlist["invoices"]];
                        \Think\Db::name("accounts")->insert($dataaccounts);
                        $datacredit = ["uid" => $refundlist["user_id"], "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $refundlist["invoices"], "amount" => $refundamount, "notes" => "订单号：" . $refundlist["orderid"] . "，主机ID：" . $refundlist["hostid"] . "，账单号：" . $refundlist["invoices"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，人工审核X小时内按时长退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                        \Think\Db::name("credit")->insert($datacredit);
                        \Think\Db::name("clients")->where("id", $refundlist["user_id"])->update(["credit" => $newcredit]);
                        $datainvoices = ["status" => "Refunded"];
                        \Think\Db::name("invoices")->where("id", $refundlist["invoices"])->update($datainvoices);
                        $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $refundlist["user_id"] . " - Invoice ID:" . $refundlist["invoices"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，来源：人工审核X小时内按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => $refundlist["invoices"]];
                        \Think\Db::name("activity_log")->insert($dataactivity_log);
                        $updatetime = time();
                        \Think\Db::name("host")->where("id", $refundlist["hostid"])->update(["nextduedate" => $updatetime]);
                        $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核通过】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：人工审核X小时内按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($dataupdatetime);
                        $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "2", "reason" => "审核通过"];
                        \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                        $originalData = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
                        $newNotes = "人工按时长退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                        $originalNotes = $originalData["notes"] ?? "";
                        $updatedNotes = $originalNotes . "\n" . $newNotes;
                        $datahost = ["notes" => $updatedNotes];
                        \Think\Db::name("host")->where("id", $refundlist["hostid"])->update($datahost);
                        $response = ["code" => 200, "msg" => "【审核通过】，按天退款。"];
                    } else {
                        if ($rules == 2) {
                            $refundamount = $refundlist["amount"];
                            $newcredit = $clients["credit"] + $refundamount;
                            $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                            $usagetime = $currentTimestamp - $productsid["regdate"];
                            $hours = floor($usagetime / 3600);
                            $minutes = floor($usagetime % 3600 / 60);
                            $seconds = $usagetime % 60;
                            $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                            $dataaccounts = ["uid" => $refundlist["user_id"], "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $refundlist["hostid"] . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【人工审核X小时内按月退款】订单号：" . $refundlist["orderid"] . ", 主机ID：" . $refundlist["hostid"] . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $refundlist["invoices"]];
                            \Think\Db::name("accounts")->insert($dataaccounts);
                            $datacredit = ["uid" => $refundlist["user_id"], "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $refundlist["invoices"], "amount" => $refundamount, "notes" => "订单号：" . $refundlist["orderid"] . "，主机ID：" . $refundlist["hostid"] . "，账单号：" . $refundlist["invoices"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，人工审核X小时内按月退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                            \Think\Db::name("credit")->insert($datacredit);
                            \Think\Db::name("clients")->where("id", $refundlist["user_id"])->update(["credit" => $newcredit]);
                            $datainvoices = ["status" => "Refunded"];
                            \Think\Db::name("invoices")->where("id", $refundlist["invoices"])->update($datainvoices);
                            $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $refundlist["user_id"] . " - Invoice ID:" . $refundlist["invoices"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，来源：人工审核X小时内按月退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => $refundlist["invoices"]];
                            \Think\Db::name("activity_log")->insert($dataactivity_log);
                            $updatetime = time();
                            \Think\Db::name("host")->where("id", $refundlist["hostid"])->update(["nextduedate" => $updatetime]);
                            $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核通过】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：人工审核X小时内按月退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                            \Think\Db::name("activity_log")->insert($dataupdatetime);
                            $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "2", "reason" => "审核通过"];
                            \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                            $originalData = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
                            $newNotes = "人工按月退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                            $originalNotes = $originalData["notes"] ?? "";
                            $updatedNotes = $originalNotes . "\n" . $newNotes;
                            $datahost = ["notes" => $updatedNotes];
                            \Think\Db::name("host")->where("id", $refundlist["hostid"])->update($datahost);
                            $response = ["code" => 200, "msg" => "【审核通过】，按月退款。"];
                        } else {
                            if ($rules == 3) {
                                $refundamount = $refundlist["amount"];
                                $newcredit = $clients["credit"] + $refundamount;
                                $productstime = $productsid["nextduedate"] - $productsid["regdate"];
                                $usagetime = $currentTimestamp - $productsid["regdate"];
                                $hours = floor($usagetime / 3600);
                                $minutes = floor($usagetime % 3600 / 60);
                                $seconds = $usagetime % 60;
                                $timeFormat = sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
                                $dataaccounts = ["uid" => $refundlist["user_id"], "currency" => "CNY", "gateway" => "退款至余额【主机ID：" . $refundlist["hostid"] . " 】", "create_time" => time(), "pay_time" => time(), "description" => "【人工审核X小时内按全额退款】订单号：" . $refundlist["orderid"] . ", 主机ID：" . $refundlist["hostid"] . ", 开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "amount_out" => $refundamount, "rate" => "1.00000", "invoice_id" => $refundlist["invoices"]];
                                \Think\Db::name("accounts")->insert($dataaccounts);
                                $datacredit = ["uid" => $refundlist["user_id"], "create_time" => time(), "description" => "Credit from Refund of Invoice ID " . $refundlist["invoices"], "amount" => $refundamount, "notes" => "订单号：" . $refundlist["orderid"] . "，主机ID：" . $refundlist["hostid"] . "，账单号：" . $refundlist["invoices"] . "，首付金额：" . $productsid["firstpaymentamount"] . "元，人工审核X小时内按全额退款【退款金额：" . $refundamount . " 元】，开通时间：" . date("Y-m-d H:i:s", $productsid["regdate"]) . ", 到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " 使用时长：" . $timeFormat . " ", "balance" => $newcredit];
                                \Think\Db::name("credit")->insert($datacredit);
                                \Think\Db::name("clients")->where("id", $refundlist["user_id"])->update(["credit" => $newcredit]);
                                $datainvoices = ["status" => "Refunded"];
                                \Think\Db::name("invoices")->where("id", $refundlist["invoices"])->update($datainvoices);
                                $dataactivity_log = ["create_time" => time(), "description" => "账单退款 - User ID:" . $refundlist["user_id"] . " - Invoice ID:" . $refundlist["invoices"] . " - 首付金额：" . $productsid["firstpaymentamount"] . "元，退款金额: " . $refundamount . " 交易明细处，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，来源：人工审核X小时内按全额退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => $refundlist["invoices"]];
                                \Think\Db::name("activity_log")->insert($dataactivity_log);
                                $updatetime = time();
                                \Think\Db::name("host")->where("id", $refundlist["hostid"])->update(["nextduedate" => $updatetime]);
                                $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核通过】用户申请退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . " ，更新到期时间：" . date("Y-m-d H:i:s", $updatetime) . "  ，来源：人工审核X小时内按全额退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                                \Think\Db::name("activity_log")->insert($dataupdatetime);
                                $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "2", "reason" => "审核通过"];
                                \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                                $originalData = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
                                $newNotes = "人工按全额退款\n原到期时间：" . date("Y-m-d H:i:s", $productsid["nextduedate"]) . "\n" . "更新后到期时间：" . date("Y-m-d H:i:s", $updatetime);
                                $originalNotes = $originalData["notes"] ?? "";
                                $updatedNotes = $originalNotes . "\n" . $newNotes;
                                $datahost = ["notes" => $updatedNotes];
                                \Think\Db::name("host")->where("id", $refundlist["hostid"])->update($datahost);
                                $response = ["code" => 200, "msg" => "【审核通过】，全额退款。"];
                            } else {
                                $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                            }
                        }
                    }
                } else {
                    $response = ["code" => 400, "msg" => "不支持的请求类型。"];
                }
            }
        }
        return json($response);
    }
    public function refuse()
    {
        $data = $this->request->post();
        $id = isset($data["id"]) ? $data["id"] : NULL;
        $reason = isset($data["reason"]) ? $data["reason"] : NULL;
        $refundlist = \Think\Db::name("product_refund_list")->where("id", $id)->find();
        $clients = \Think\Db::name("clients")->where("id", $refundlist["user_id"])->find();
        $productsid = \Think\Db::name("host")->where("id", $refundlist["hostid"])->find();
        $admin_id = cmf_get_current_admin_id();
        $adminuser = \Think\Db::name("user")->where("id", $admin_id)->value("user_nickname");
        $request = $refundlist["request"];
        $rules = $refundlist["rules"];
        $days = $product["within"] / 24;
        $currentTimestamp = time();
        $client_ip = $_SERVER["REMOTE_ADDR"];
        $client_port = $_SERVER["REMOTE_PORT"];
        if ($request == 1) {
            if ($rules == 1) {
                $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核不通过】拒绝退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，拒绝原因：" . $reason . " ，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                \Think\Db::name("activity_log")->insert($dataupdatetime);
                $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "3", "reason" => $reason];
                \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                $response = ["code" => 200, "msg" => $adminuser . " 【审核已拒绝】"];
            } else {
                if ($rules == 2) {
                    $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核不通过】拒绝退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，拒绝原因：" . $reason . " ，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                    \Think\Db::name("activity_log")->insert($dataupdatetime);
                    $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "3", "reason" => $reason];
                    \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                    $response = ["code" => 200, "msg" => $adminuser . " 【审核已拒绝】"];
                } else {
                    if ($rules == 3) {
                        $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核不通过】拒绝退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，拒绝原因：" . $reason . " ，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($dataupdatetime);
                        $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "3", "reason" => $reason];
                        \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                        $response = ["code" => 200, "msg" => $adminuser . " 【审核已拒绝】"];
                    } else {
                        $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                    }
                }
            }
        } else {
            if ($request == 2) {
                if ($rules == 1) {
                    $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核不通过】拒绝退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，拒绝原因：" . $reason . " ，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                    \Think\Db::name("activity_log")->insert($dataupdatetime);
                    $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "3", "reason" => $reason];
                    \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                    $response = ["code" => 200, "msg" => $adminuser . " 【审核已拒绝】"];
                } else {
                    if ($rules == 2) {
                        $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核不通过】拒绝退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，拒绝原因：" . $reason . " ，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($dataupdatetime);
                        $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "3", "reason" => $reason];
                        \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                        $response = ["code" => 200, "msg" => $adminuser . " 【审核已拒绝】"];
                    } else {
                        if ($rules == 3) {
                            $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核不通过】拒绝退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，拒绝原因：" . $reason . " ，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                            \Think\Db::name("activity_log")->insert($dataupdatetime);
                            $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "3", "reason" => $reason];
                            \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                            $response = ["code" => 200, "msg" => $adminuser . " 【审核已拒绝】"];
                        } else {
                            $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                        }
                    }
                }
            } else {
                if ($request == 3) {
                    if ($rules == 1) {
                        $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核不通过】拒绝退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，拒绝原因：" . $reason . " ，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($dataupdatetime);
                        $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "3", "reason" => $reason];
                        \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                        $response = ["code" => 200, "msg" => $adminuser . " 【审核已拒绝】"];
                    } else {
                        if ($rules == 2) {
                            $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核不通过】拒绝退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，拒绝原因：" . $reason . " ，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                            \Think\Db::name("activity_log")->insert($dataupdatetime);
                            $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "3", "reason" => $reason];
                            \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                            $response = ["code" => 200, "msg" => $adminuser . " 【审核已拒绝】"];
                        } else {
                            if ($rules == 3) {
                                $dataupdatetime = ["create_time" => time(), "description" => "【管理 " . $adminuser . " (" . $admin_id . " )审核不通过】拒绝退款 <a href=\"#/customer-view/abstract?id=" . $refundlist["user_id"] . "\">User ID:" . $refundlist["user_id"] . "</a>，订单号：" . $refundlist["orderid"] . " ，<a href=\"#/customer-view/product-innerpage?hid={" . $refundlist["hostid"] . "}&id=" . $refundlist["user_id"] . "\">Host ID:" . $refundlist["hostid"] . "</a>，拒绝原因：" . $reason . " ，来源：人工审核产品首次按时长退款", "user" => $adminuser, "uid" => $refundlist["user_id"], "ipaddr" => $client_ip, "type" => "6", "activeid" => $admin_id, "usertype" => "Admin", "port" => $client_port, "type_data_id" => ""];
                                \Think\Db::name("activity_log")->insert($dataupdatetime);
                                $dbConfig = ["audittime" => time(), "adminid" => $admin_id, "reviewed" => $adminuser, "status" => "3", "reason" => $reason];
                                \Think\Db::name("product_refund_list")->where("id", $refundlist["id"])->update($dbConfig);
                                $response = ["code" => 200, "msg" => $adminuser . " 【审核已拒绝】"];
                            } else {
                                $response = ["code" => 400, "msg" => "不支持的退款规则。"];
                            }
                        }
                    }
                } else {
                    $response = ["code" => 400, "msg" => "不支持的请求类型。"];
                }
            }
        }
        return json($response);
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>