<?php
namespace addons\sign_in;

class SignInPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "SignIn", "title" => "用户签到兑奖Plus", "description" => "此插件可实现用户签到并赠送相应余额或者积分，积分可用于兑换奖品，奖品可自己设置", "status" => 1, "author" => "Think", "version" => "1.2.0", "module" => "addons", "lang" => ["chinese" => "用户签到Plus", "chinese_tw" => "用戶簽到Plus", "english" => "User check-in Plus"]];
    public function install()
    {
        $sql = ["DROP TABLE IF EXISTS `shd_sign`", "DROP TABLE IF EXISTS `shd_sign_log`", "DROP TABLE IF EXISTS `shd_sign_gift`", "DROP TABLE IF EXISTS `shd_gift_log`", "CREATE TABLE `shd_sign` (  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,  `uid` int(11) DEFAULT NULL COMMENT '签到者',  `total` int(11) DEFAULT NULL COMMENT '总共签到',  `last_time` int(11) NOT NULL DEFAULT '0' COMMENT '上次签到时间',  PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", "CREATE TABLE `shd_sign_log` (  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '签到者',  `type` varchar(255) DEFAULT 'point' COMMENT '签到类型',  `value` varchar(255) DEFAULT NULL COMMENT '奖励数额',  `time` int(11) NOT NULL DEFAULT '0' COMMENT '签到时间',  PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", "CREATE TABLE `shd_sign_gift` (  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,  `name` varchar(255) DEFAULT NULL COMMENT '奖品名称',  `type` varchar(255) DEFAULT 'money' COMMENT '奖品类型',  `value` varchar(255) DEFAULT '1.00' COMMENT '奖品',  `point` int(11) DEFAULT '10' COMMENT '兑换积分',  PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", "CREATE TABLE `shd_gift_log` (  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,  `uid` int(11) DEFAULT NULL COMMENT '兑换者',  `name` varchar(255) DEFAULT NULL COMMENT '奖品',  `time` int(11) NOT NULL DEFAULT '0' COMMENT '兑换时间',  `status` int(11) NOT NULL DEFAULT '0' COMMENT '状态',  PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", "INSERT INTO shd_configuration (setting, value) VALUES ('sign_type','money');", "INSERT INTO shd_configuration (setting, value) VALUES ('sign_is','1');", "INSERT INTO shd_configuration (setting, value) VALUES ('sign_value','1.00');", "INSERT INTO shd_configuration (setting, value) VALUES ('sign_gift','0');", "ALTER TABLE shd_clients ADD point INT(11) DEFAULT 0;"];
        foreach ($sql as $v) {
            \think\Db::query($v);
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
}

?>