<?php
namespace addons\sign_in\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function submit()
    {
        $data = $_POST;
        foreach ($data as $setting => $value) {
            \think\Db::name("configuration")->where("setting", $setting)->update(["value" => $value, "update_time" => time()]);
        }
        exit(json_encode(["code" => 200, "msg" => "修改成功"]));
    }
    public function config()
    {
        $data["sign_type"] = \think\Db::name("configuration")->where("setting", "sign_type")->value("value");
        $data["sign_is"] = \think\Db::name("configuration")->where("setting", "sign_is")->value("value");
        $data["sign_value"] = \think\Db::name("configuration")->where("setting", "sign_value")->value("value");
        $data["sign_gift"] = \think\Db::name("configuration")->where("setting", "sign_gift")->value("value");
        $this->assign("Data", $data);
        $this->assign("Title", "签到设置");
        return $this->fetch("/config");
    }
    public function log()
    {
        $list = \think\Db::name("sign_log")->order("id", "desc")->select()->toArray();
        foreach ($list as $key => $value) {
            $user = \think\Db::name("clients")->find($value["uid"]);
            $list[$key]["user"] = $user["username"];
        }
        $this->assign("Title", "签到日志");
        $this->assign("List", $list);
        return $this->fetch("/log");
    }
    public function exchange()
    {
        $list = \think\Db::name("gift_log")->order("id", "desc")->select()->toArray();
        foreach ($list as $key => $value) {
            $user = \think\Db::name("clients")->find($value["uid"]);
            $list[$key]["user"] = $user["username"];
        }
        $this->assign("Title", "兑换记录");
        $this->assign("List", $list);
        return $this->fetch("/exchange");
    }
    public function list()
    {
        $list = \think\Db::name("sign_gift")->select()->toArray();
        $this->assign("Title", "奖品列表");
        $this->assign("List", $list);
        return $this->fetch("/list");
    }
    public function gift()
    {
        $this->assign("Title", "奖品添加");
        return $this->fetch("/gift");
    }
    public function add()
    {
        $data = $_POST;
        if (empty($data["name"])) {
            exit(json_encode(["code" => 100, "msg" => "奖品名称不能为空！"]));
        }
        if (empty($data["point"])) {
            exit(json_encode(["code" => 100, "msg" => "兑换所需积分不能为空！"]));
        }
        if (empty($data["value"])) {
            exit(json_encode(["code" => 100, "msg" => "奖品详情不能为空！"]));
        }
        \think\Db::name("sign_gift")->insert($_POST);
        exit(json_encode(["code" => 200, "msg" => "奖品添加成功！", "data" => $_POST]));
    }
    public function clear()
    {
        $data = \think\Db::name("sign_log")->delete(true);
        if ($data) {
            exit(json_encode(["code" => 200, "msg" => "签到日志清空成功"]));
        }
        exit(json_encode(["code" => 100, "msg" => "签到日志清空失败！"]));
    }
    public function delete()
    {
        $id = $_POST["id"];
        $data = \think\Db::name("sign_gift")->where("id", $id)->delete();
        if ($data) {
            exit(json_encode(["code" => 200, "msg" => "奖品删除成功"]));
        }
        exit(json_encode(["code" => 100, "msg" => "奖品删除失败！"]));
    }
    public function ff()
    {
        $id = $_POST["id"];
        $data = \think\Db::name("gift_log")->where("id", $id)->update(["status" => 1]);
        if ($data) {
            exit(json_encode(["code" => 200, "msg" => "奖品发放成功"]));
        }
        exit(json_encode(["code" => 100, "msg" => "奖品发放失败！"]));
    }
}

?>