<section class="admin-main">

    <div class="card">
        <div class="card-body">
            <div class="ticket-top">
                <p>1、域名只需要提交顶级域名，系统会在提交后5分钟内审核完毕，多个IP的只要提交主IP即可；</p>
                <p>2、如果提交后5分钟还处于拦截状态，请查询域名是否备案号被取消；<a href="https://beian.miit.gov.cn/" target="_blank">点击查询备案号</a></p>
                <p>3、如果您的网站未备案，则有可能将您的网站域名拉入黑名单，请勿尝试。</p>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form id="addFireWallForm"  class="form">
                <div class="form-row ">
                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label class="require">填写 IP 地址</label>
                        <input type="text" class="form-control" id="IpSelect" placeholder="请输入IP">
                    </div>
                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label>白名单 域名</label>
                        <input type="text" class="form-control" id="web_domain" placeholder="请输入域名">
                    </div>

                    <div class="form-group col-lg-2 col-md-3 col-sm-4">
                        <label>&nbsp;</label>
                        <button class="btn btn-primary form-control" id="button" type="button">添加 域名 白名单</button>
                    </div>
                </div>
            </form>

        </div>
    </div>

    <script>
        $(function() {

            $("#button").click(function(){
                var elem = this;
                var ip = $("#IpSelect").val();
                var web_domain = $("#web_domain").val();
                if(ip == "" || $.trim(ip).length == 0){
                    toastr.error("请填写IP！");
                    return;
                }
                if(web_domain == "" || $.trim(web_domain).length == 0){
                    toastr.error("请填写白名单IP！");
                    return;
                }
                BtnLoading(elem);
                $.ajax({
                    url: '{:shd_addon_url('SkyWhite://Index/white',[],true)}',
                    type: 'POST',
                    data: {ip:ip,web_domain:web_domain},
                    success: function (data) {
                        if (data.status==1) {
                            toastr.success(data.msg);
                            BtnReset(elem);
                        }else {
                            toastr.error(data.msg);
                            BtnReset(elem);
                        }
                    }, error: function () {
                        toastr.error("系统错误！");
                        BtnReset(elem);
                    }
                })
            });

        });
        
        function BtnLoading(elem) {
            $(elem).attr("data-original-text", $(elem).html());
            $(elem).prop("disabled", true);
            $(elem).html('<i class="spinner-border spinner-border-sm"></i> 加载中...');
            $(elem).css("background-color","#6064ff");
        }

        function BtnReset(elem) {
            $(elem).prop("disabled", false);
            $(elem).html($(elem).attr("data-original-text"));
            $(elem).css("background-color",'');
        }
        
    </script>

</section>