<?php
namespace addons\sync_inventory;

class SyncInventoryPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "SyncInventory", "title" => "同步上游商品库存", "description" => "此插件可实现对接上游产品时，购物车同步显示库存", "status" => 1, "author" => "Think", "version" => "2.0", "module" => "addons", "lang" => ["chinese" => "同步上游商品库存", "chinese_tw" => "同步上游商品庫存", "english" => "Synchronize upstream commodity inventory"]];
    public function install()
    {
        $sql = ["DROP TABLE IF EXISTS `shd_sync_log`", "CREATE TABLE `shd_sync_log` (  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,  `name` varchar(255) DEFAULT NULL COMMENT '商品名称',  `qty` int(11) NOT NULL DEFAULT '0' COMMENT '本地库存',  `upstream_qty` int(11) NOT NULL DEFAULT '0' COMMENT '上游库存',  `type` int(11) NOT NULL DEFAULT '0' COMMENT '同步类型',  `time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',  PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8"];
        foreach ($sql as $v) {
            \think\Db::query($v);
        }
        return true;
    }
    public function uninstall()
    {
        \think\Db::name("products")->where("upstream_stock_control", 1)->where("stock_control", 1)->update(["stock_control" => 0, "qty" => 0]);
        return true;
    }
    public function afterCron()
    {
        $type = 0;
        $time = time();
        $protuct = \think\Db::name("products")->where("upstream_stock_control", 1)->select();
        foreach ($protuct as $k => $v) {
            if ($v["stock_control"] == 0) {
                if ($v["upstream_qty"] == $v["qty"]) {
                    \think\Db::name("products")->where("id", $v["id"])->update(["stock_control" => 1]);
                } else {
                    \think\Db::name("products")->where("id", $v["id"])->update(["stock_control" => 1, "qty" => $v["upstream_qty"]]);
                }
            } else {
                if ($v["upstream_qty"] != $v["qty"]) {
                    \think\Db::name("products")->where("id", $v["id"])->update(["qty" => $v["upstream_qty"]]);
                }
            }
            $data = ["name" => $v["name"], "qty" => $v["qty"], "upstream_qty" => $v["upstream_qty"], "type" => $type, "time" => $time];
            \think\Db::name("sync_log")->insert($data);
            $n++;
        }
    }
}

?>