<?php
namespace addons\sync_inventory\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function index()
    {
        $list = \think\Db::name("sync_log")->order("time", "desc")->select();
        $this->assign("List", $list);
        $this->assign("Title", "同步日志");
        return $this->fetch("/index");
    }
    public function submit()
    {
        $n = 0;
        $type = 1;
        $time = time();
        $protuct = \think\Db::name("products")->where("upstream_stock_control", 1)->select();
        foreach ($protuct as $k => $v) {
            if ($v["stock_control"] == 0) {
                if ($v["upstream_qty"] == $v["qty"]) {
                    \think\Db::name("products")->where("id", $v["id"])->update(["stock_control" => 1]);
                } else {
                    \think\Db::name("products")->where("id", $v["id"])->update(["stock_control" => 1, "qty" => $v["upstream_qty"]]);
                }
            } else {
                if ($v["upstream_qty"] != $v["qty"]) {
                    \think\Db::name("products")->where("id", $v["id"])->update(["qty" => $v["upstream_qty"]]);
                }
            }
            $data = ["name" => $v["name"], "qty" => $v["qty"], "upstream_qty" => $v["upstream_qty"], "type" => $type, "time" => $time];
            \think\Db::name("sync_log")->insert($data);
            $n++;
        }
        exit(json_encode(["code" => 200, "msg" => "成功更新（" . $n . "）条记录"]));
    }
    public function clear()
    {
        $data = \think\Db::name("sync_log")->delete(true);
        if ($data) {
            exit(json_encode(["code" => 200, "msg" => "清空成功"]));
        }
        exit(json_encode(["code" => 100, "msg" => "清空失败！"]));
    }
}

?>